/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.hints;

import com.intellij.codeInsight.hints.declarative.InlayActionHandler;
import com.intellij.codeInsight.hints.declarative.InlayActionPayload;
import com.intellij.codeInsight.hints.declarative.StringInlayActionPayload;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.codeInsight.hints.ResolveUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/hints/KotlinFqnDeclarativeInlayActionHandler;", "Lcom/intellij/codeInsight/hints/declarative/InlayActionHandler;", "<init>", "()V", "handleClick", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "payload", "Lcom/intellij/codeInsight/hints/declarative/InlayActionPayload;", "Companion", "kotlin.code-insight.impl-base"})
public final class KotlinFqnDeclarativeInlayActionHandler
implements InlayActionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String HANDLER_NAME = "kotlin.fqn.class";

    public void handleClick(@NotNull Editor editor, @NotNull InlayActionPayload payload) {
        block3: {
            Navigatable navigatable;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            Project project = editor.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            Object object = payload instanceof StringInlayActionPayload ? (StringInlayActionPayload)payload : null;
            if (object == null || (object = object.getText()) == null) {
                return;
            }
            Object fqName2 = object;
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
            PsiFile psiFile2 = psiFile;
            if (psiFile2 == null || (psiFile2 = GenericPsiUtils.getModule((PsiElement)psiFile2)) == null) {
                return;
            }
            PsiFile module = psiFile2;
            ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project2);
            Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
            ProjectFileIndex index2 = projectFileIndex;
            boolean includeTests = index2.isInTestSourceContent(psiFile.getVirtualFile());
            GlobalSearchScope globalSearchScope = module.getModuleWithDependenciesAndLibrariesScope(includeTests);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getModuleWithDependenciesAndLibrariesScope(...)");
            GlobalSearchScope scope = globalSearchScope;
            PsiElement psiElement = ResolveUtilsKt.resolveClass(project2, (String)fqName2, scope);
            PsiElement psiElement2 = psiElement != null ? psiElement.getNavigationElement() : null;
            Navigatable navigatable2 = navigatable = psiElement2 instanceof Navigatable ? (Navigatable)psiElement2 : null;
            if (navigatable2 == null) break block3;
            navigatable2.navigate(true);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/hints/KotlinFqnDeclarativeInlayActionHandler$Companion;", "", "<init>", "()V", "HANDLER_NAME", "", "kotlin.code-insight.impl-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

