/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinApplicableInspectionBase;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinModCommandQuickFix;
import org.jetbrains.kotlin.idea.codeinsight.utils.KotlinPsiUtilsKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0003H\u0014\u00a2\u0006\u0002\u0010\u000bJ \u0010\f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0014\u0010\u0012\u001a\u00020\u0003*\u00020\u00132\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u0002H\u0016J#\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00162\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0003H\u0014\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/RemoveSetterParameterTypeInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinApplicableInspectionBase$Simple;", "Lorg/jetbrains/kotlin/psi/KtParameter;", "", "<init>", "()V", "getProblemDescription", "", "Lcom/intellij/codeInspection/util/InspectionMessage;", "element", "context", "(Lorg/jetbrains/kotlin/psi/KtParameter;Lkotlin/Unit;)Ljava/lang/String;", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "isApplicableByPsi", "createQuickFix", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "(Lorg/jetbrains/kotlin/psi/KtParameter;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "kotlin.code-insight.inspections.shared"})
public final class RemoveSetterParameterTypeInspection
extends KotlinApplicableInspectionBase.Simple<KtParameter, Unit> {
    @Override
    @NotNull
    protected String getProblemDescription(@NotNull KtParameter element, @NotNull Unit context) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return KotlinBundle.message((String)"redundant.setter.parameter.type", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public KtVisitor<?, ?> buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return (KtVisitor)new KtVisitorVoid(this, holder2, isOnTheFly){
            final /* synthetic */ RemoveSetterParameterTypeInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $isOnTheFly;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
                this.$isOnTheFly = $isOnTheFly;
            }

            public void visitParameter(KtParameter parameter) {
                Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
                RemoveSetterParameterTypeInspection.access$visitTargetElement(this.this$0, parameter, this.$holder, this.$isOnTheFly);
            }
        };
    }

    @Override
    public void prepareContext(@NotNull KaSession $this$prepareContext, @NotNull KtParameter element) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtParameter element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!KotlinPsiUtilsKt.isSetterParameter(element)) {
            return false;
        }
        KtTypeReference ktTypeReference = element.getTypeReference();
        if (ktTypeReference == null) {
            return false;
        }
        KtTypeReference typeReference = ktTypeReference;
        return PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)typeReference)) > PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)typeReference));
    }

    @Override
    @NotNull
    protected KotlinModCommandQuickFix<KtParameter> createQuickFix(@NotNull KtParameter element, @NotNull Unit context) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new KotlinModCommandQuickFix<KtParameter>(){

            public String getFamilyName() {
                return KotlinBundle.message((String)"remove.explicit.type.specification", (Object[])new Object[0]);
            }

            protected void applyFix(Project project, KtParameter element, ModPsiUpdater updater2) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
                element.setTypeReference(null);
            }
        };
    }

    public static final /* synthetic */ void access$visitTargetElement(RemoveSetterParameterTypeInspection $this, KtParameter element, ProblemsHolder holder2, boolean isOnTheFly) {
        $this.visitTargetElement((KtElement)element, holder2, isOnTheFly);
    }
}

