/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.lineMarkers.dsl;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.highlighting.dsl.DslStyleUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.highlighter.markers.KotlinLineMarkerOptions;
import org.jetbrains.kotlin.idea.highlighting.analyzers.KotlinDslSemanticAnalyzerKt;
import org.jetbrains.kotlin.psi.KtClass;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\u001a$\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005H\u0000\u001a\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\"\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"collectHighlightingDslMarkers", "", "ktClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "result", "", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "navHandler", "Lcom/intellij/codeInsight/daemon/GutterIconNavigationHandler;", "Lcom/intellij/psi/PsiElement;", "dslStyleId", "", "toolTipHandler", "Lcom/intellij/util/Function;", "", "kotlin.code-insight.line-markers.k2"})
@SourceDebugExtension(value={"SMAP\nDslHighlightingMarker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DslHighlightingMarker.kt\norg/jetbrains/kotlin/idea/codeInsight/lineMarkers/dsl/DslHighlightingMarkerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,51:1\n1#2:52\n*E\n"})
public final class DslHighlightingMarkerKt {
    @NotNull
    private static final Function<PsiElement, String> toolTipHandler = DslHighlightingMarkerKt::toolTipHandler$lambda$3;

    public static final void collectHighlightingDslMarkers(@NotNull KtClass ktClass, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        Intrinsics.checkNotNullParameter((Object)ktClass, (String)"ktClass");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        if (!KotlinLineMarkerOptions.INSTANCE.getDslOption().isEnabled()) {
            return;
        }
        PsiElement psiElement = ktClass.getNameIdentifier();
        if (psiElement == null) {
            return;
        }
        PsiElement anchor = psiElement;
        Integer n = KotlinDslSemanticAnalyzerKt.getDslStyleId(ktClass);
        if (n == null) {
            return;
        }
        int styleId = n;
        result2.add(new LineMarkerInfo(anchor, anchor.getTextRange(), DslStyleUtils.INSTANCE.createDslStyleIcon(styleId), toolTipHandler, DslHighlightingMarkerKt.navHandler(styleId), GutterIconRenderer.Alignment.RIGHT, () -> DslHighlightingMarkerKt.collectHighlightingDslMarkers$lambda$0(KotlinBundle.lazyMessage((String)"highlighter.tool.tip.marker.annotation.for.dsl", (Object[])new Object[0]))));
    }

    private static final GutterIconNavigationHandler<PsiElement> navHandler(int dslStyleId) {
        return (arg_0, arg_1) -> DslHighlightingMarkerKt.navHandler$lambda$2(dslStyleId, arg_0, arg_1);
    }

    private static final String collectHighlightingDslMarkers$lambda$0(Function0 $tmp0) {
        return (String)$tmp0.invoke();
    }

    private static final void navHandler$lambda$2(int $dslStyleId, MouseEvent event, PsiElement psiElement) {
        JComponent jComponent;
        block3: {
            block2: {
                Component component = event.getComponent();
                jComponent = component instanceof JComponent ? (JComponent)component : null;
                if (jComponent == null) break block2;
                JComponent it = jComponent;
                boolean bl = false;
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)it);
                jComponent = dataContext;
                if (dataContext != null) break block3;
            }
            return;
        }
        JComponent dataContext = jComponent;
        ColorAndFontOptions.selectOrEditColor((DataContext)dataContext, (String)DslStyleUtils.INSTANCE.styleOptionDisplayName($dslStyleId), (String)"Kotlin");
    }

    private static final String toolTipHandler$lambda$3(PsiElement it) {
        return KotlinBundle.message((String)"highlighter.tool.tip.marker.annotation.for.dsl", (Object[])new Object[0]);
    }
}

