/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compilerPlugin.kotlinxSerialization.quickfixes;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.compilerPlugin.kotlinxSerialization.KotlinSerializationBundle;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.chooseContainer.ChooseContainerUtilKt;
import org.jetbrains.kotlin.idea.refactoring.introduce.IntroduceUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.introduce.introduceProperty.KotlinIntroducePropertyHandler;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.SerializationErrors;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J#\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0094\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J4\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00070\u0015H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/compilerPlugin/kotlinxSerialization/quickfixes/JsonRedundantQuickFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "expression", "<init>", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;)V", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "getFamilyName", "", "getText", "selectContainer", "element", "Lcom/intellij/psi/PsiElement;", "onSelect", "Lkotlin/Function1;", "Factory", "kotlin.compiler-plugins.kotlinx-serialization.common"})
@SourceDebugExtension(value={"SMAP\nJsonRedundantQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonRedundantQuickFix.kt\norg/jetbrains/kotlin/idea/compilerPlugin/kotlinxSerialization/quickfixes/JsonRedundantQuickFix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n774#2:80\n865#2,2:81\n*S KotlinDebug\n*F\n+ 1 JsonRedundantQuickFix.kt\norg/jetbrains/kotlin/idea/compilerPlugin/kotlinxSerialization/quickfixes/JsonRedundantQuickFix\n*L\n60#1:80\n60#1:81,2\n*E\n"})
public final class JsonRedundantQuickFix
extends KotlinQuickFixAction<KtCallExpression> {
    public JsonRedundantQuickFix(@NotNull KtCallExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super((PsiElement)expression);
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (editor == null) {
            return;
        }
        KtCallExpression ktCallExpression = (KtCallExpression)this.getElement();
        if (ktCallExpression == null) {
            return;
        }
        KtCallExpression element = ktCallExpression;
        this.selectContainer((PsiElement)element, project, editor, (Function1<? super PsiElement, Unit>)((Function1)arg_0 -> JsonRedundantQuickFix.invoke$lambda$0(editor, element, project, this, file, arg_0)));
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        return KotlinSerializationBundle.message("extract.json.to.property", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    private final void selectContainer(PsiElement element, Project project, Editor editor, Function1<? super PsiElement, Unit> onSelect) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        PsiElement psiElement = element.getParent();
        if (psiElement == null) {
            throw new AssertionError((Object)"Should have at least one parent");
        }
        PsiElement parent2 = psiElement;
        Iterable iterable = KotlinCommonRefactoringUtilKt.getExtractionContainers$default(parent2, true, true, false, 4, null);
        boolean $i$f$filter = false;
        void var9_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtElement it = (KtElement)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof KtClassBody || it instanceof KtFile && !((KtFile)it).isScript())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List containers = (List)destination$iv$iv;
        if (containers.isEmpty()) {
            IntroduceUtilsKt.showErrorHintByKey(project, editor, "cannot.refactor.no.container", this.getText());
            return;
        }
        ChooseContainerUtilKt.chooseContainerElementIfNecessary(containers, editor, KotlinBundle.message((String)"title.select.target.code.block", (Object[])new Object[0]), true, null, JsonRedundantQuickFix::selectContainer$lambda$2, arg_0 -> JsonRedundantQuickFix.selectContainer$lambda$3(onSelect, arg_0));
    }

    private static final Unit invoke$lambda$0(Editor $editor, KtCallExpression $element, Project $project, JsonRedundantQuickFix this$0, KtFile $file, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement outermostParent = PsiUtilsKt.getOutermostParentContainedIn((PsiElement)((PsiElement)$element), (PsiElement)it);
        if (outermostParent == null) {
            IntroduceUtilsKt.showErrorHintByKey($project, $editor, "cannot.refactor.no.container", this$0.getText());
            return Unit.INSTANCE;
        }
        new KotlinIntroducePropertyHandler(null, 1, null).doInvoke($project, $editor, $file, CollectionsKt.listOf((Object)$element), outermostParent);
        return Unit.INSTANCE;
    }

    private static final PsiElement selectContainer$lambda$2(KtElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (PsiElement)it;
    }

    private static final Unit selectContainer$lambda$3(Function1 $onSelect, KtElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $onSelect.invoke((Object)it);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/compilerPlugin/kotlinxSerialization/quickfixes/JsonRedundantQuickFix$Factory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "<init>", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.compiler-plugins.kotlinx-serialization.common"})
    public static final class Factory
    extends KotlinSingleIntentionActionFactory {
        @NotNull
        public static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            if (!Intrinsics.areEqual((Object)diagnostic.getFactory(), (Object)SerializationErrors.JSON_FORMAT_REDUNDANT)) {
                return null;
            }
            SimpleDiagnostic castedDiagnostic = (SimpleDiagnostic)SerializationErrors.JSON_FORMAT_REDUNDANT.cast((UnboundDiagnostic)diagnostic);
            PsiElement psiElement = castedDiagnostic.getPsiElement();
            KtCallExpression ktCallExpression = psiElement instanceof KtCallExpression ? (KtCallExpression)psiElement : null;
            if (ktCallExpression == null) {
                return null;
            }
            KtCallExpression element = ktCallExpression;
            return new JsonRedundantQuickFix(element);
        }
    }
}

