/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.checkers;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.components.KaUseSiteVisibilityChecker;
import org.jetbrains.kotlin.analysis.api.permissions.KaAnalysisPermissionRegistry;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbol;
import org.jetbrains.kotlin.idea.base.projectStructure.ApiKt;
import org.jetbrains.kotlin.idea.base.util.FqNameUtils;
import org.jetbrains.kotlin.idea.completion.KotlinFirCompletionParameters;
import org.jetbrains.kotlin.idea.util.positionContext.KDocNameReferencePositionContext;
import org.jetbrains.kotlin.idea.util.positionContext.KotlinRawPositionContext;
import org.jetbrains.kotlin.idea.util.positionContext.KotlinSimpleNameReferencePositionContext;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationInfo;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001f\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bR\u00020\u0012\u00a2\u0006\u0002\u0010\u0016J\u0019\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\bH\u0002R\u00020\u0012\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/completion/checkers/CompletionVisibilityChecker;", "", "parameters", "Lorg/jetbrains/kotlin/idea/completion/KotlinFirCompletionParameters;", "<init>", "(Lorg/jetbrains/kotlin/idea/completion/KotlinFirCompletionParameters;)V", "visibilityCheckerPerPositionContextCache", "", "Lorg/jetbrains/kotlin/idea/util/positionContext/KotlinRawPositionContext;", "Lorg/jetbrains/kotlin/analysis/api/components/KaUseSiteVisibilityChecker;", "canBeVisible", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "canAccessInternalDeclarationsFromFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isVisible", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol;", "positionContext", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol;Lorg/jetbrains/kotlin/idea/util/positionContext/KotlinRawPositionContext;)Z", "getCachedVisibilityChecker", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/idea/util/positionContext/KotlinRawPositionContext;)Lorg/jetbrains/kotlin/analysis/api/components/KaUseSiteVisibilityChecker;", "kotlin.completion.impl.k2"})
@SourceDebugExtension(value={"SMAP\nCompletionVisibilityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompletionVisibilityChecker.kt\norg/jetbrains/kotlin/idea/completion/checkers/CompletionVisibilityChecker\n+ 2 permissions.kt\norg/jetbrains/kotlin/analysis/api/permissions/PermissionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,105:1\n19#2,9:106\n381#3,7:115\n*S KotlinDebug\n*F\n+ 1 CompletionVisibilityChecker.kt\norg/jetbrains/kotlin/idea/completion/checkers/CompletionVisibilityChecker\n*L\n35#1:106,9\n97#1:115,7\n*E\n"})
public final class CompletionVisibilityChecker {
    @NotNull
    private final KotlinFirCompletionParameters parameters;
    @NotNull
    private final Map<KotlinRawPositionContext, KaUseSiteVisibilityChecker> visibilityCheckerPerPositionContextCache;

    public CompletionVisibilityChecker(@NotNull KotlinFirCompletionParameters parameters2) {
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        this.parameters = parameters2;
        this.visibilityCheckerPerPositionContextCache = new LinkedHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean canBeVisible(@NotNull KtDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        String description$iv = "canBeVisible";
        boolean $i$f$forbidAnalysis = false;
        KaAnalysisPermissionRegistry permissionRegistry$iv = KaAnalysisPermissionRegistry.Companion.getInstance();
        if (permissionRegistry$iv.getExplicitAnalysisRestriction() != null) {
            boolean bl = false;
            KtFile originalFile = this.parameters.getOriginalFile();
            if (originalFile instanceof KtCodeFragment) {
                return true;
            }
            if (this.parameters.getInvocationCount() >= 2) {
                return true;
            }
            KtFile ktFile2 = declaration.getContainingKtFile();
            Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
            KtFile declarationContainingFile = ktFile2;
            return KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)declaration)) && !Intrinsics.areEqual((Object)declarationContainingFile, (Object)originalFile) && !Intrinsics.areEqual((Object)declarationContainingFile, (Object)this.parameters.getCompletionFile()) ? false : (declaration.hasModifier(KtTokens.INTERNAL_KEYWORD) ? this.canAccessInternalDeclarationsFromFile(declarationContainingFile) : true);
        }
        permissionRegistry$iv.setExplicitAnalysisRestriction(new KaAnalysisPermissionRegistry.KaExplicitAnalysisRestriction(description$iv));
        try {
            boolean bl = false;
            KtFile originalFile = this.parameters.getOriginalFile();
            if (originalFile instanceof KtCodeFragment) {
                boolean bl2 = true;
                return bl2;
            }
            if (this.parameters.getInvocationCount() >= 2) {
                boolean bl3 = true;
                return bl3;
            }
            KtFile ktFile3 = declaration.getContainingKtFile();
            Intrinsics.checkNotNullExpressionValue((Object)ktFile3, (String)"getContainingKtFile(...)");
            KtFile declarationContainingFile = ktFile3;
            boolean bl4 = KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)declaration)) && !Intrinsics.areEqual((Object)declarationContainingFile, (Object)originalFile) && !Intrinsics.areEqual((Object)declarationContainingFile, (Object)this.parameters.getCompletionFile()) ? false : (declaration.hasModifier(KtTokens.INTERNAL_KEYWORD) ? this.canAccessInternalDeclarationsFromFile(declarationContainingFile) : true);
            return bl4;
        }
        finally {
            permissionRegistry$iv.setExplicitAnalysisRestriction(null);
        }
    }

    private final boolean canAccessInternalDeclarationsFromFile(KtFile file) {
        if (file.isCompiled()) {
            return false;
        }
        KaModule useSiteModule = KotlinFirCompletionParameters.Companion.getUseSiteModule(this.parameters);
        PsiElement psiElement = (PsiElement)file;
        Project project = this.parameters.getOriginalFile().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KaModule declarationModule = ApiKt.getKaModule(psiElement, project, useSiteModule);
        return Intrinsics.areEqual((Object)declarationModule, (Object)useSiteModule) || useSiteModule.getDirectFriendDependencies().contains(declarationModule);
    }

    public final boolean isVisible(@NotNull KaSession $context_receiver_0, @NotNull KaDeclarationSymbol symbol, @NotNull KotlinRawPositionContext positionContext) {
        FqName fqName2;
        ClassId classId;
        KaClassLikeSymbol kaClassLikeSymbol;
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)positionContext, (String)"positionContext");
        if (positionContext instanceof KDocNameReferencePositionContext) {
            return true;
        }
        DeprecationInfo deprecationInfo2 = $context_receiver_0.getDeprecationStatus(symbol);
        if ((deprecationInfo2 != null ? deprecationInfo2.getDeprecationLevel() : null) == DeprecationLevelValue.HIDDEN) {
            return false;
        }
        if (this.parameters.getInvocationCount() > 1) {
            return true;
        }
        KaClassLikeSymbol kaClassLikeSymbol2 = kaClassLikeSymbol = symbol instanceof KaClassLikeSymbol ? (KaClassLikeSymbol)symbol : null;
        boolean bl = kaClassLikeSymbol != null && (classId = kaClassLikeSymbol.getClassId()) != null && (fqName2 = classId.asSingleFqName()) != null ? FqNameUtils.isJavaClassNotToBeUsedInKotlin(fqName2) : false;
        if (bl) {
            return false;
        }
        KtFile originalFile = this.parameters.getOriginalFile();
        if (originalFile instanceof KtCodeFragment) {
            return true;
        }
        return this.getCachedVisibilityChecker($context_receiver_0, positionContext).isVisible(symbol);
    }

    private final KaUseSiteVisibilityChecker getCachedVisibilityChecker(KaSession $context_receiver_0, KotlinRawPositionContext positionContext) {
        KaUseSiteVisibilityChecker kaUseSiteVisibilityChecker;
        Map<KotlinRawPositionContext, KaUseSiteVisibilityChecker> $this$getOrPut$iv = this.visibilityCheckerPerPositionContextCache;
        boolean $i$f$getOrPut = false;
        KaUseSiteVisibilityChecker value$iv = $this$getOrPut$iv.get(positionContext);
        if (value$iv == null) {
            boolean bl = false;
            KotlinSimpleNameReferencePositionContext kotlinSimpleNameReferencePositionContext = positionContext instanceof KotlinSimpleNameReferencePositionContext ? (KotlinSimpleNameReferencePositionContext)positionContext : null;
            KaUseSiteVisibilityChecker answer$iv = $context_receiver_0.createUseSiteVisibilityChecker($context_receiver_0.getSymbol(this.parameters.getOriginalFile()), (KtExpression)(kotlinSimpleNameReferencePositionContext != null ? kotlinSimpleNameReferencePositionContext.getExplicitReceiver() : null), positionContext.getPosition());
            $this$getOrPut$iv.put(positionContext, answer$iv);
            kaUseSiteVisibilityChecker = answer$iv;
        } else {
            kaUseSiteVisibilityChecker = value$iv;
        }
        return kaUseSiteVisibilityChecker;
    }
}

