/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.ucache;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.ScriptUtilsKt;
import org.jetbrains.kotlin.idea.core.script.configuration.utils.ScriptClassRootsStorage;
import org.jetbrains.kotlin.idea.core.script.ucache.ScriptSdks;
import org.jetbrains.kotlin.idea.core.script.ucache.SdkId;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0000H\u0007J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0015J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001a\u001a\u00020\u0006J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\n\u0010\u001e\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!H\u0002J\n\u0010\"\u001a\u0004\u0018\u00010\u0007H\u0002J\f\u0010#\u001a\u00020$*\u00020\u0007H\u0002J\f\u0010%\u001a\u00020$*\u00020\u0007H\u0002J\u000e\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020\u00172\u0006\u0010'\u001a\u00020(R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\"\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000f\u001a\u0004\u0018\u00010\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptSdksBuilder;", "", "project", "Lcom/intellij/openapi/project/Project;", "sdks", "", "Lorg/jetbrains/kotlin/idea/core/script/ucache/SdkId;", "Lcom/intellij/openapi/projectRoots/Sdk;", "remove", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Map;Lcom/intellij/openapi/projectRoots/Sdk;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSdks$kotlin_base_scripting", "()Ljava/util/Map;", "defaultSdk", "getDefaultSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "defaultSdk$delegate", "Lkotlin/Lazy;", "build", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptSdks;", "addAll", "", "other", "addSdk", "sdkId", "javaHome", "Ljava/nio/file/Path;", "getScriptSdkByJavaHome", "addDefaultSdk", "addSdkByName", "sdkName", "", "getScriptDefaultSdk", "canBeUsedForScript", "", "hasValidClassPathRoots", "toStorage", "storage", "Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/ScriptClassRootsStorage;", "fromStorage", "kotlin.base.scripting"})
@SourceDebugExtension(value={"SMAP\nScriptSdksBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptSdksBuilder.kt\norg/jetbrains/kotlin/idea/core/script/ucache/ScriptSdksBuilder\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,139:1\n381#2,7:140\n381#2,7:149\n1310#3,2:147\n12364#3,2:157\n3829#3:166\n4344#3,2:167\n1#4:156\n1#4:161\n1619#5:159\n1863#5:160\n1864#5:162\n1620#5:163\n1863#5,2:164\n1863#5,2:169\n*S KotlinDebug\n*F\n+ 1 ScriptSdksBuilder.kt\norg/jetbrains/kotlin/idea/core/script/ucache/ScriptSdksBuilder\n*L\n67#1:140,7\n85#1:149,7\n81#1:147,2\n122#1:157,2\n34#1:166\n34#1:167,2\n126#1:161\n126#1:159\n126#1:160\n126#1:162\n126#1:163\n131#1:164,2\n40#1:169,2\n*E\n"})
public final class ScriptSdksBuilder {
    @NotNull
    private final Project project;
    @NotNull
    private final Map<SdkId, Sdk> sdks;
    @Nullable
    private final Sdk remove;
    @NotNull
    private final Lazy defaultSdk$delegate;

    public ScriptSdksBuilder(@NotNull Project project, @NotNull Map<SdkId, Sdk> sdks, @Nullable Sdk remove) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(sdks, (String)"sdks");
        this.project = project;
        this.sdks = sdks;
        this.remove = remove;
        this.defaultSdk$delegate = LazyKt.lazy(() -> ScriptSdksBuilder.defaultSdk_delegate$lambda$0(this));
    }

    public /* synthetic */ ScriptSdksBuilder(Project project, Map map2, Sdk sdk, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map2 = new LinkedHashMap();
        }
        if ((n & 4) != 0) {
            sdk = null;
        }
        this(project, map2, sdk);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Map<SdkId, Sdk> getSdks$kotlin_base_scripting() {
        return this.sdks;
    }

    private final Sdk getDefaultSdk() {
        Lazy lazy = this.defaultSdk$delegate;
        return (Sdk)lazy.getValue();
    }

    @NotNull
    public final ScriptSdks build() {
        Set nonIndexedSdks = (Set)CollectionsKt.filterNotNullTo((Iterable)this.sdks.values(), (Collection)new LinkedHashSet());
        Set nonIndexedClassRoots = new LinkedHashSet();
        Set nonIndexedSourceRoots = new LinkedHashSet();
        ActionsKt.runReadAction(() -> ScriptSdksBuilder.build$lambda$3(this, nonIndexedSdks, nonIndexedClassRoots, nonIndexedSourceRoots));
        return new ScriptSdks(this.sdks, nonIndexedClassRoots, nonIndexedSourceRoots);
    }

    @Deprecated(message="Don't use, used only from DefaultScriptingSupport for saving to storage")
    public final void addAll(@NotNull ScriptSdksBuilder other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.sdks.putAll(other.sdks);
    }

    public final void addAll(@NotNull ScriptSdks other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.sdks.putAll(other.getSdks());
    }

    @Nullable
    public final Sdk addSdk(@NotNull SdkId sdkId) {
        Intrinsics.checkNotNullParameter((Object)sdkId, (String)"sdkId");
        String string = sdkId.getHomeDirectory();
        if (string == null) {
            return this.addDefaultSdk();
        }
        String canonicalPath = string;
        return this.addSdk(Path.of(canonicalPath, new String[0]));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Sdk addSdk(@Nullable Path javaHome) {
        Object object;
        void $this$getOrPut$iv;
        if (javaHome == null) {
            return this.addDefaultSdk();
        }
        Map<SdkId, Sdk> map2 = this.sdks;
        SdkId key$iv = SdkId.Companion.invoke(javaHome);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Sdk sdk = this.getScriptSdkByJavaHome(javaHome);
            if (sdk == null) {
                sdk = this.getDefaultSdk();
            }
            Sdk answer$iv = sdk;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Sdk)object;
    }

    /*
     * Unable to fully structure code
     */
    private final Sdk getScriptSdkByJavaHome(Path javaHome) {
        block6: {
            try {
                var4_2 = VfsUtil.findFile((Path)javaHome, (boolean)true);
            }
            catch (Throwable e) {
                var4_2 = null;
            }
            v0 = var4_2;
            if (v0 == null) {
                return null;
            }
            javaHomeVF = v0;
            v1 = ProjectJdkTable.getInstance().getAllJdks();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getAllJdks(...)");
            $this$firstOrNull$iv = v1;
            $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (Sdk)element$iv;
                $i$a$-firstOrNull-ScriptSdksBuilder$getScriptSdkByJavaHome$1 = false;
                if (!Intrinsics.areEqual((Object)it.getHomeDirectory(), (Object)javaHomeVF)) ** GOTO lbl-1000
                Intrinsics.checkNotNull((Object)it);
                if (this.canBeUsedForScript(it)) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                if (!v2) continue;
                v3 = element$iv;
                break block6;
            }
            v3 = null;
        }
        return (Sdk)v3;
    }

    /*
     * WARNING - void declaration
     */
    private final Sdk addDefaultSdk() {
        Object object;
        void $this$getOrPut$iv;
        Map<SdkId, Sdk> map2 = this.sdks;
        SdkId key$iv = SdkId.Companion.getDefault();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Sdk answer$iv = this.getDefaultSdk();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Sdk)object;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void addSdkByName(String sdkName) {
        block5: {
            v0 = ProjectJdkTable.getInstance().getAllJdks();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getAllJdks(...)");
            var5_2 = (Sdk)v0;
            var7_5 = ((Object[])var5_2).length;
            for (var6_3 = 0; var6_3 < var7_5; ++var6_3) {
                var8_6 = var5_2[var6_3];
                it = (Sdk)var8_6;
                $i$a$-find-ScriptSdksBuilder$addSdkByName$sdk$1 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)sdkName)) continue;
                v1 = var8_6;
                break block5;
            }
            v1 = null;
        }
        var3_9 = (Sdk)v1;
        if (var3_9 == null) ** GOTO lbl-1000
        it = var5_2 = var3_9;
        $i$a$-takeIf-ScriptSdksBuilder$addSdkByName$sdk$2 = false;
        v2 /* !! */  = var4_10 = this.canBeUsedForScript(it) != false ? var5_2 : null;
        if (var4_10 != null) {
            v3 = var4_10;
        } else if ((v3 = this.getDefaultSdk()) == null) {
            return;
        }
        sdk = v3;
        v4 = sdk.getHomePath();
        if (v4 == null) {
            return;
        }
        homePath = v4;
        this.sdks.put(SdkId.Companion.invoke(homePath), sdk);
    }

    private final Sdk getScriptDefaultSdk() {
        Sdk anyJavaSdk;
        Object[] allJdks;
        block5: {
            Sdk sdk;
            Sdk projectSdk;
            Object object;
            Sdk sdk2 = ProjectRootManager.getInstance((Project)this.project).getProjectSdk();
            if (sdk2 != null) {
                Sdk sdk3;
                Sdk it = sdk3 = sdk2;
                boolean bl = false;
                object = this.canBeUsedForScript(it) ? sdk3 : null;
            } else {
                object = null;
            }
            Sdk sdk4 = projectSdk = object;
            if (sdk4 != null) {
                return sdk4;
            }
            Object[] objectArray = ProjectJdkTable.getInstance().getAllJdks();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getAllJdks(...)");
            Object[] objectArray2 = allJdks = objectArray;
            int n = objectArray2.length;
            for (int j = 0; j < n; ++j) {
                Sdk sdk5;
                Sdk it = sdk5 = objectArray2[j];
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!this.canBeUsedForScript(it)) continue;
                sdk = sdk5;
                break block5;
            }
            sdk = anyJavaSdk = null;
        }
        if (anyJavaSdk != null) {
            return anyJavaSdk;
        }
        ScriptUtilsKt.scriptingWarnLog("Default Script SDK is null: projectSdk = " + ProjectRootManager.getInstance((Project)this.project).getProjectSdk() + ", all sdks = " + ArraysKt.joinToString$default((Object[])allJdks, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        return null;
    }

    private final boolean canBeUsedForScript(Sdk $this$canBeUsedForScript) {
        return !Intrinsics.areEqual((Object)$this$canBeUsedForScript, (Object)this.remove) && $this$canBeUsedForScript.getSdkType() instanceof JavaSdkType && this.hasValidClassPathRoots($this$canBeUsedForScript);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasValidClassPathRoots(Sdk $this$hasValidClassPathRoots) {
        VirtualFile[] virtualFileArray = $this$hasValidClassPathRoots.getRootProvider().getFiles(OrderRootType.CLASSES);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getFiles(...)");
        VirtualFile[] rootClasses = virtualFileArray;
        if (rootClasses.length == 0) {
            return false;
        }
        boolean bl = false;
        if (bl) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        VirtualFile[] $this$all$iv = rootClasses;
        boolean $i$f$all = false;
        int n = 0;
        int n2 = $this$all$iv.length;
        while (n < n2) {
            VirtualFile element$iv;
            VirtualFile it = element$iv = $this$all$iv[n];
            boolean bl3 = false;
            if (!it.isValid()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void toStorage(@NotNull ScriptClassRootsStorage storage) {
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Iterable iterable = this.sdks.values();
        Collection collection = new LinkedHashSet();
        ScriptClassRootsStorage scriptClassRootsStorage = storage;
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            void destination$iv;
            String it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            Sdk it = (Sdk)element$iv;
            boolean bl2 = false;
            Sdk sdk = it;
            if ((sdk != null ? sdk.getName() : null) == null) continue;
            it$iv = it$iv;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        scriptClassRootsStorage.setSdks((Set)collection);
        storage.setDefaultSdkUsed(this.sdks.containsKey(SdkId.Companion.getDefault()));
    }

    public final void fromStorage(@NotNull ScriptClassRootsStorage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Iterable $this$forEach$iv = storage.getSdks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.addSdkByName(it);
        }
        if (storage.getDefaultSdkUsed()) {
            this.addDefaultSdk();
        }
    }

    private static final Sdk defaultSdk_delegate$lambda$0(ScriptSdksBuilder this$0) {
        return this$0.getScriptDefaultSdk();
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit build$lambda$3(ScriptSdksBuilder this$0, Set $nonIndexedSdks, Set $nonIndexedClassRoots, Set $nonIndexedSourceRoots) {
        Sdk $this$filterTo$iv$iv;
        Module[] $this$filter$iv = ModuleManager.Companion.getInstance(this$0.project).getModules();
        boolean $i$f$filter = false;
        Module[] moduleArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[j];
            boolean bl = false;
            if (!(!it.isDisposed())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (Module module : (List)destination$iv$iv) {
            ProgressManager.checkCanceled();
            if ($nonIndexedSdks.isEmpty()) break;
            Collection collection = $nonIndexedSdks;
            $this$filterTo$iv$iv = ModuleRootManager.getInstance((Module)module).getSdk();
            TypeIntrinsics.asMutableCollection((Object)collection).remove($this$filterTo$iv$iv);
        }
        Iterable $this$forEach$iv = $nonIndexedSdks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Sdk sdk = (Sdk)element$iv;
            boolean bl = false;
            Collection collection = $nonIndexedClassRoots;
            VirtualFile[] virtualFileArray = sdk.getRootProvider().getFiles(OrderRootType.CLASSES);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getFiles(...)");
            CollectionsKt.addAll((Collection)collection, (Object[])virtualFileArray);
            collection = $nonIndexedSourceRoots;
            VirtualFile[] virtualFileArray2 = sdk.getRootProvider().getFiles(OrderRootType.SOURCES);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray2, (String)"getFiles(...)");
            CollectionsKt.addAll((Collection)collection, (Object[])virtualFileArray2);
        }
        return Unit.INSTANCE;
    }
}

