/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core;

import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.resolution.KaAnnotationCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCompoundVariableAccessCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaPartiallyAppliedSymbolKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaSuccessCallInfo;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaEnumEntrySymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaJavaFieldSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaLocalVariableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaPropertySymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaValueParameterSymbol;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.debugger.base.util.AnalyseUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.KotlinEditorTextProvider;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationModifierList;
import org.jetbrains.kotlin.psi.KtDoubleColonExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStatementExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtValueArgumentName;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J&\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001b\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0096\u0010J\u001d\u0010\u000f\u001a\u0004\u0018\u00010\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0082\u0010J\u0018\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u0007H\u0002J\u0010\u0010!\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u0007H\u0016J\"\u0010\"\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u00072\u0010\u0010#\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b0\u001aH\u0002R\\\u0010\u0019\u001aP\u0012L\u0012J\u0012F\b\u0001\u0012B\u0012>\b\u0001\u0012:\u0012\u0016\b\u0001\u0012\u0012\u0012\u0002\b\u0003 \u001e*\b\u0012\u0002\b\u0003\u0018\u00010\u001c0\u001c \u001e*\u001c\u0012\u0016\b\u0001\u0012\u0012\u0012\u0002\b\u0003 \u001e*\b\u0012\u0002\b\u0003\u0018\u00010\u001c0\u001c\u0018\u00010\u001d0\u001d0\u001c0\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/AnalysisApiBasedKotlinEditorTextProvider;", "Lorg/jetbrains/kotlin/idea/debugger/core/KotlinEditorTextProvider;", "<init>", "()V", "getEditorText", "Lcom/intellij/debugger/engine/evaluation/TextWithImports;", "elementAtCaret", "Lcom/intellij/psi/PsiElement;", "findExpression", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/openapi/util/TextRange;", "allowMethodCalls", "", "findEvaluationTarget", "originalElement", "calculateCandidate", "isReferenceAllowed", "reference", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "isSymbolAllowed", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "isStringTemplateAllowed", "candidate", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "FORBIDDEN_PARENT_TYPES", "", "Ljava/lang/Class;", "Lorg/jetbrains/kotlin/psi/KtElementImplStub;", "Lcom/intellij/psi/stubs/StubElement;", "kotlin.jvm.PlatformType", "isAcceptedAsCandidate", "element", "isAcceptedAsCodeFragmentContext", "isAccepted", "forbiddenTypes", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinEditorTextProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinEditorTextProvider.kt\norg/jetbrains/kotlin/idea/debugger/core/AnalysisApiBasedKotlinEditorTextProvider\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,221:1\n196#2:222\n*S KotlinDebug\n*F\n+ 1 KotlinEditorTextProvider.kt\norg/jetbrains/kotlin/idea/debugger/core/AnalysisApiBasedKotlinEditorTextProvider\n*L\n116#1:222\n*E\n"})
final class AnalysisApiBasedKotlinEditorTextProvider
implements KotlinEditorTextProvider {
    @NotNull
    public static final AnalysisApiBasedKotlinEditorTextProvider INSTANCE = new AnalysisApiBasedKotlinEditorTextProvider();
    @NotNull
    private static final Set<Class<? extends KtElementImplStub<? extends StubElement<? extends KtElementImplStub<?>>>>> FORBIDDEN_PARENT_TYPES;

    private AnalysisApiBasedKotlinEditorTextProvider() {
    }

    @Nullable
    public TextWithImports getEditorText(@NotNull PsiElement elementAtCaret) {
        Intrinsics.checkNotNullParameter((Object)elementAtCaret, (String)"elementAtCaret");
        PsiElement psiElement = this.findEvaluationTarget(elementAtCaret, true);
        if (psiElement == null) {
            return null;
        }
        PsiElement expression = psiElement;
        return (TextWithImports)new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, expression.getText(), "", (FileType)KotlinFileType.INSTANCE);
    }

    @Nullable
    public Pair<PsiElement, TextRange> findExpression(@NotNull PsiElement elementAtCaret, boolean allowMethodCalls) {
        Intrinsics.checkNotNullParameter((Object)elementAtCaret, (String)"elementAtCaret");
        PsiElement psiElement = this.findEvaluationTarget(elementAtCaret, allowMethodCalls);
        if (psiElement == null) {
            return null;
        }
        PsiElement expression = psiElement;
        return new Pair((Object)expression, (Object)expression.getTextRange());
    }

    @Override
    @Nullable
    public PsiElement findEvaluationTarget(@NotNull PsiElement originalElement, boolean allowMethodCalls) {
        PsiElement target;
        Intrinsics.checkNotNullParameter((Object)originalElement, (String)"originalElement");
        AnalysisApiBasedKotlinEditorTextProvider analysisApiBasedKotlinEditorTextProvider = this;
        while (true) {
            PsiElement psiElement;
            boolean isAllowed;
            PsiElement candidate;
            if (analysisApiBasedKotlinEditorTextProvider.calculateCandidate(originalElement, allowMethodCalls) == null) {
                return null;
            }
            PsiElement psiElement2 = candidate;
            target = psiElement2 instanceof KtParameter || psiElement2 instanceof KtVariableDeclaration ? originalElement : candidate;
            Object object = target;
            if (object instanceof KtBinaryExpressionWithTypeRHS || object instanceof KtIsExpression || object instanceof KtDoubleColonExpression || object instanceof KtThisExpression) {
                v0 = true;
            } else if (object instanceof LeafPsiElement) {
                v0 = Intrinsics.areEqual((Object)((LeafPsiElement)target).getElementType(), (Object)KtTokens.IDENTIFIER);
            } else if (object instanceof KtReferenceExpression) {
                v0 = analysisApiBasedKotlinEditorTextProvider.isReferenceAllowed((KtReferenceExpression)target, allowMethodCalls);
            } else if (object instanceof KtOperationExpression) {
                KtSimpleNameExpression ktSimpleNameExpression = ((KtOperationExpression)target).getOperationReference();
                Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"getOperationReference(...)");
                v0 = analysisApiBasedKotlinEditorTextProvider.isReferenceAllowed((KtReferenceExpression)ktSimpleNameExpression, allowMethodCalls) && allowMethodCalls;
            } else {
                KtExpression selector2;
                v0 = object instanceof KtQualifiedExpression ? (selector2 = ((KtQualifiedExpression)target).getSelectorExpression()) instanceof KtReferenceExpression && analysisApiBasedKotlinEditorTextProvider.isReferenceAllowed((KtReferenceExpression)selector2, allowMethodCalls) : (isAllowed = allowMethodCalls);
            }
            if (isAllowed) break;
            object = analysisApiBasedKotlinEditorTextProvider;
            Intrinsics.checkNotNullExpressionValue((Object)target.getParent(), (String)"getParent(...)");
            boolean bl = allowMethodCalls;
            analysisApiBasedKotlinEditorTextProvider = object;
            originalElement = psiElement;
            allowMethodCalls = bl;
        }
        return target;
    }

    /*
     * WARNING - void declaration
     */
    private final PsiElement calculateCandidate(PsiElement originalElement, boolean allowMethodCalls) {
        Object object;
        block20: {
            PsiElement parent2;
            PsiElement candidate;
            AnalysisApiBasedKotlinEditorTextProvider analysisApiBasedKotlinEditorTextProvider = this;
            while (true) {
                boolean bl;
                boolean bl2;
                Object object2;
                PsiElement psiElement;
                block22: {
                    block21: {
                        void $this$getParentOfType$iv;
                        if ((psiElement = originalElement) == null) break block21;
                        object2 = psiElement;
                        boolean strict$iv = false;
                        boolean $i$f$getParentOfType = false;
                        psiElement = (KtExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtExpression.class, (boolean)strict$iv);
                        if (psiElement != null) break block22;
                    }
                    return null;
                }
                candidate = psiElement;
                if (!analysisApiBasedKotlinEditorTextProvider.isAcceptedAsCandidate(candidate)) {
                    return null;
                }
                PsiElement psiElement2 = candidate;
                if (psiElement2 instanceof KtParameter) {
                    object = Intrinsics.areEqual((Object)originalElement, (Object)((KtParameter)candidate).getNameIdentifier()) ? ((KtParameter)candidate).getNameIdentifier() : null;
                    break block20;
                }
                if (psiElement2 instanceof KtVariableDeclaration) {
                    object = Intrinsics.areEqual((Object)originalElement, (Object)((KtVariableDeclaration)candidate).getNameIdentifier()) ? ((KtVariableDeclaration)candidate).getNameIdentifier() : null;
                    break block20;
                }
                if (psiElement2 instanceof KtObjectDeclaration) {
                    object = (PsiElement)(((KtObjectDeclaration)candidate).isObjectLiteral() ? (KtObjectDeclaration)candidate : null);
                    break block20;
                }
                if (psiElement2 instanceof KtDeclaration || psiElement2 instanceof KtFile) {
                    object = null;
                    break block20;
                }
                if (psiElement2 instanceof KtIfExpression) {
                    object = (PsiElement)(((KtIfExpression)candidate).getElse() != null ? (KtIfExpression)candidate : null);
                    break block20;
                }
                if (psiElement2 instanceof KtStatementExpression || psiElement2 instanceof KtLabeledExpression) {
                    object = null;
                    break block20;
                }
                if (psiElement2 instanceof KtStringTemplateExpression) {
                    object = (PsiElement)(analysisApiBasedKotlinEditorTextProvider.isStringTemplateAllowed((KtStringTemplateExpression)candidate, allowMethodCalls) ? (KtStringTemplateExpression)candidate : null);
                    break block20;
                }
                if (psiElement2 instanceof KtConstantExpression) {
                    AnalysisApiBasedKotlinEditorTextProvider analysisApiBasedKotlinEditorTextProvider2 = analysisApiBasedKotlinEditorTextProvider;
                    object2 = ((KtConstantExpression)candidate).getParent();
                    boolean bl3 = allowMethodCalls;
                    analysisApiBasedKotlinEditorTextProvider = analysisApiBasedKotlinEditorTextProvider2;
                    originalElement = object2;
                    allowMethodCalls = bl3;
                    continue;
                }
                parent2 = candidate.getParent();
                if (parent2 instanceof KtThisExpression) {
                    object = parent2;
                    break block20;
                }
                if (parent2 instanceof KtSuperExpression) {
                    object2 = analysisApiBasedKotlinEditorTextProvider;
                    PsiElement psiElement3 = ((KtSuperExpression)parent2).getParent();
                    bl2 = allowMethodCalls;
                    analysisApiBasedKotlinEditorTextProvider = object2;
                    originalElement = psiElement3;
                    allowMethodCalls = bl2;
                    continue;
                }
                if (parent2 instanceof KtCallExpression) {
                    object2 = analysisApiBasedKotlinEditorTextProvider;
                    KtCallExpression ktCallExpression = (KtCallExpression)parent2;
                    bl2 = allowMethodCalls;
                    analysisApiBasedKotlinEditorTextProvider = object2;
                    originalElement = (PsiElement)ktCallExpression;
                    allowMethodCalls = bl2;
                    continue;
                }
                if (parent2 instanceof KtArrayAccessExpression) {
                    if (Intrinsics.areEqual((Object)((KtArrayAccessExpression)parent2).getArrayExpression(), (Object)candidate)) {
                        object = candidate;
                        break block20;
                    }
                    AnalysisApiBasedKotlinEditorTextProvider analysisApiBasedKotlinEditorTextProvider3 = analysisApiBasedKotlinEditorTextProvider;
                    KtArrayAccessExpression ktArrayAccessExpression = (KtArrayAccessExpression)parent2;
                    bl = allowMethodCalls;
                    analysisApiBasedKotlinEditorTextProvider = analysisApiBasedKotlinEditorTextProvider3;
                    originalElement = (PsiElement)ktArrayAccessExpression;
                    allowMethodCalls = bl;
                    continue;
                }
                if (!(parent2 instanceof KtQualifiedExpression)) break;
                if (Intrinsics.areEqual((Object)((KtQualifiedExpression)parent2).getReceiverExpression(), (Object)candidate)) {
                    object = candidate;
                    break block20;
                }
                AnalysisApiBasedKotlinEditorTextProvider analysisApiBasedKotlinEditorTextProvider4 = analysisApiBasedKotlinEditorTextProvider;
                KtQualifiedExpression ktQualifiedExpression = (KtQualifiedExpression)parent2;
                bl = allowMethodCalls;
                analysisApiBasedKotlinEditorTextProvider = analysisApiBasedKotlinEditorTextProvider4;
                originalElement = (PsiElement)ktQualifiedExpression;
                allowMethodCalls = bl;
            }
            object = parent2 instanceof KtOperationExpression ? (Intrinsics.areEqual((Object)((KtOperationExpression)parent2).getOperationReference(), (Object)candidate) ? (KtExpression)parent2 : candidate) : (parent2 instanceof KtCallableReferenceExpression ? (Intrinsics.areEqual((Object)((KtCallableReferenceExpression)parent2).getCallableReference(), (Object)candidate) ? (KtExpression)parent2 : candidate) : candidate);
        }
        return object;
    }

    private final boolean isReferenceAllowed(KtReferenceExpression reference2, boolean allowMethodCalls) {
        return AnalyseUtilsKt.runDumbAnalyze((KtElement)reference2, false, arg_0 -> AnalysisApiBasedKotlinEditorTextProvider.isReferenceAllowed$lambda$0(reference2, allowMethodCalls, arg_0));
    }

    private final boolean isSymbolAllowed(KaSymbol symbol, boolean allowMethodCalls) {
        KaSymbol kaSymbol = symbol;
        return kaSymbol instanceof KaClassSymbol ? ((KaClassSymbol)symbol).getClassKind().isObject() : (kaSymbol instanceof KaFunctionSymbol ? allowMethodCalls : kaSymbol instanceof KaPropertySymbol || kaSymbol instanceof KaJavaFieldSymbol || kaSymbol instanceof KaLocalVariableSymbol || kaSymbol instanceof KaValueParameterSymbol || kaSymbol instanceof KaEnumEntrySymbol);
    }

    private final boolean isStringTemplateAllowed(KtStringTemplateExpression candidate, boolean allowMethodCalls) {
        String string = candidate.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return !StringsKt.startsWith$default((String)string, (String)"\"\"\"", (boolean)false, (int)2, null) || allowMethodCalls;
    }

    private final boolean isAcceptedAsCandidate(PsiElement element) {
        return this.isAccepted(element, FORBIDDEN_PARENT_TYPES);
    }

    @Override
    public boolean isAcceptedAsCodeFragmentContext(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.isAccepted(element, FORBIDDEN_PARENT_TYPES);
    }

    private final boolean isAccepted(PsiElement element, Set<? extends Class<?>> forbiddenTypes) {
        for (PsiElement parent2 : PsiTreeUtilKt.parents((PsiElement)element, (boolean)true)) {
            if (!forbiddenTypes.contains(parent2.getClass())) continue;
            return false;
        }
        return true;
    }

    private static final boolean isReferenceAllowed$lambda$0(KtReferenceExpression $reference, boolean $allowMethodCalls, KaSession $this$f) {
        Intrinsics.checkNotNullParameter((Object)$this$f, (String)"$this$f");
        if ($reference instanceof KtBinaryExpressionWithTypeRHS) {
            return true;
        }
        if ($reference instanceof KtOperationReferenceExpression && Intrinsics.areEqual((Object)((KtOperationReferenceExpression)$reference).getOperationSignTokenType(), (Object)KtTokens.ELVIS)) {
            return true;
        }
        if ($reference instanceof KtCollectionLiteralExpression) {
            return false;
        }
        if ($reference instanceof KtCallExpression) {
            boolean bl;
            KaCallInfo kaCallInfo = $this$f.resolveToCall((KtElement)$reference);
            KaSuccessCallInfo kaSuccessCallInfo = kaCallInfo instanceof KaSuccessCallInfo ? (KaSuccessCallInfo)kaCallInfo : null;
            if (kaSuccessCallInfo == null) {
                return false;
            }
            KaSuccessCallInfo callInfo = kaSuccessCallInfo;
            KaCall call2 = callInfo.getCall();
            if (call2 instanceof KaAnnotationCall) {
                LanguageVersionSettings languageVersionSettings = LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)$reference);
                bl = languageVersionSettings.supportsFeature(LanguageFeature.InstantiationOfAnnotationClasses);
            } else if (call2 instanceof KaFunctionCall) {
                functionSymbol = (KaFunctionSymbol)KaPartiallyAppliedSymbolKt.getSymbol(((KaFunctionCall)call2).getPartiallyAppliedSymbol());
                bl = INSTANCE.isSymbolAllowed(functionSymbol, $allowMethodCalls);
            } else if (call2 instanceof KaCompoundVariableAccessCall) {
                functionSymbol = KaPartiallyAppliedSymbolKt.getSymbol(((KaCompoundVariableAccessCall)call2).getCompoundOperation().getOperationPartiallyAppliedSymbol());
                bl = INSTANCE.isSymbolAllowed(functionSymbol, $allowMethodCalls);
            } else {
                bl = false;
            }
            return bl;
        }
        KaSymbol symbol = $this$f.resolveToSymbol(ReferenceUtilsKt.getMainReference((KtReferenceExpression)$reference));
        return symbol == null || INSTANCE.isSymbolAllowed(symbol, $allowMethodCalls);
    }

    static {
        Object[] objectArray = new Class[]{KtUserType.class, KtImportDirective.class, KtPackageDirective.class, KtValueArgumentName.class, KtTypeAlias.class, KtAnnotationEntry.class, KtDeclarationModifierList.class};
        FORBIDDEN_PARENT_TYPES = SetsKt.setOf((Object[])objectArray);
    }
}

