/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core;

import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.base.indices.KotlinPackageIndexUtils;
import org.jetbrains.kotlin.idea.debugger.base.util.KotlinAllFilesScopeProvider;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.platform.JsPlatformKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.platform.konan.NativePlatformKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0014\u0010\b\u001a\u00020\t*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"findAlternativeKtFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "ktFile", "project", "Lcom/intellij/openapi/project/Project;", "javaSession", "Lcom/intellij/debugger/impl/DebuggerSession;", "platformMatches", "", "otherPlatform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinAlternativeSourceNotificationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinAlternativeSourceNotificationProvider.kt\norg/jetbrains/kotlin/idea/debugger/core/KotlinAlternativeSourceNotificationProviderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n865#2,2:106\n865#2,2:108\n*S KotlinDebug\n*F\n+ 1 KotlinAlternativeSourceNotificationProvider.kt\norg/jetbrains/kotlin/idea/debugger/core/KotlinAlternativeSourceNotificationProviderKt\n*L\n91#1:106,2\n92#1:108,2\n*E\n"})
public final class KotlinAlternativeSourceNotificationProviderKt {
    private static final Set<KtFile> findAlternativeKtFiles(KtFile ktFile2, Project project, DebuggerSession javaSession) {
        KtFile p0;
        FqName packageFqName = ktFile2.getPackageFqName();
        String string = ktFile2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String fileName = string;
        TargetPlatform platform = TargetPlatformDetectorUtils.getPlatform((KtElement)ktFile2);
        GlobalSearchScope allFilesSearchScope = KotlinAllFilesScopeProvider.Companion.getInstance(project).getAllKotlinFilesScope();
        HashSet result2 = new HashSet();
        GlobalSearchScope globalSearchScope = javaSession.getSearchScope();
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getSearchScope(...)");
        Iterable $this$filterTo$iv = KotlinPackageIndexUtils.INSTANCE.findFilesWithExactPackage(packageFqName, globalSearchScope, project);
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            p0 = (KtFile)element$iv;
            boolean bl = false;
            if (!KotlinAlternativeSourceNotificationProviderKt.findAlternativeKtFiles$matches(fileName, platform, p0)) continue;
            ((Collection)result2).add(element$iv);
        }
        $this$filterTo$iv = KotlinPackageIndexUtils.INSTANCE.findFilesWithExactPackage(packageFqName, allFilesSearchScope, project);
        $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            p0 = (KtFile)element$iv;
            boolean bl = false;
            if (!KotlinAlternativeSourceNotificationProviderKt.findAlternativeKtFiles$matches(fileName, platform, p0)) continue;
            ((Collection)result2).add(element$iv);
        }
        return result2;
    }

    private static final boolean platformMatches(KtFile $this$platformMatches, TargetPlatform otherPlatform) {
        return JvmPlatformKt.isJvm((TargetPlatform)TargetPlatformDetectorUtils.getPlatform((KtElement)$this$platformMatches)) ? JvmPlatformKt.isJvm((TargetPlatform)otherPlatform) : (JsPlatformKt.isJs((TargetPlatform)TargetPlatformDetectorUtils.getPlatform((KtElement)$this$platformMatches)) ? JsPlatformKt.isJs((TargetPlatform)otherPlatform) : (NativePlatformKt.isNative((TargetPlatform)TargetPlatformDetectorUtils.getPlatform((KtElement)$this$platformMatches)) ? NativePlatformKt.isNative((TargetPlatform)otherPlatform) : (TargetPlatformKt.isCommon((TargetPlatform)TargetPlatformDetectorUtils.getPlatform((KtElement)$this$platformMatches)) ? TargetPlatformKt.isCommon((TargetPlatform)otherPlatform) : true)));
    }

    private static final boolean findAlternativeKtFiles$matches(String fileName, TargetPlatform platform, KtFile file) {
        return Intrinsics.areEqual((Object)file.getName(), (Object)fileName) && KotlinAlternativeSourceNotificationProviderKt.platformMatches(file, platform);
    }

    public static final /* synthetic */ Set access$findAlternativeKtFiles(KtFile ktFile2, Project project, DebuggerSession javaSession) {
        return KotlinAlternativeSourceNotificationProviderKt.findAlternativeKtFiles(ktFile2, project, javaSession);
    }
}

