/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stepping;

import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.Location;
import com.sun.jdi.VMDisconnectedException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.core.stepping.CoroutineBreakpointFacility;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinRequestHint;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinRequestHintKt;
import org.jetbrains.kotlin.idea.debugger.core.stepping.StopOnReachedMethodFilter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinStepIntoRequestHint;", "Lorg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinRequestHint;", "stepThread", "Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "filter", "Lcom/intellij/debugger/engine/MethodFilter;", "parentHint", "Lcom/intellij/debugger/engine/RequestHint;", "<init>", "(Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;Lcom/intellij/debugger/engine/SuspendContextImpl;Lcom/intellij/debugger/engine/MethodFilter;Lcom/intellij/debugger/engine/RequestHint;)V", "lastWasKotlinFakeLineNumber", "", "getNextStepDepth", "", "context", "Companion", "kotlin.jvm-debugger.core"})
public final class KotlinStepIntoRequestHint
extends KotlinRequestHint {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private boolean lastWasKotlinFakeLineNumber;
    @NotNull
    private static final Logger LOG;

    public KotlinStepIntoRequestHint(@NotNull ThreadReferenceProxyImpl stepThread, @NotNull SuspendContextImpl suspendContext, @Nullable MethodFilter filter2, @Nullable RequestHint parentHint) {
        Intrinsics.checkNotNullParameter((Object)stepThread, (String)"stepThread");
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        super(stepThread, suspendContext, -2, 1, filter2, parentHint);
    }

    @Override
    public int getNextStepDepth(@NotNull SuspendContextImpl context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            StackFrameProxyImpl stackFrameProxyImpl = context.getFrameProxy();
            if (stackFrameProxyImpl == null) {
                return 0;
            }
            StackFrameProxyImpl frameProxy = stackFrameProxyImpl;
            if (this.isTheSameFrame(context) && DebuggerUtil.isOnSuspensionPoint(frameProxy)) {
                return !CoroutineBreakpointFacility.INSTANCE.installResumeBreakpointInCurrentMethod(context) ? 0 : -100;
            }
            Location location = SafeUtilKt.safeLocation((StackFrameProxy)frameProxy);
            if (location != null && DebuggerUtil.isKotlinFakeLineNumber(location)) {
                this.lastWasKotlinFakeLineNumber = true;
                return 1;
            }
            if (this.lastWasKotlinFakeLineNumber && this.getMethodFilter() == null) {
                this.lastWasKotlinFakeLineNumber = false;
                return 0;
            }
            MethodFilter filter2 = this.getMethodFilter();
            if (filter2 instanceof StopOnReachedMethodFilter && filter2.locationMatches(context.getDebugProcess(), location)) {
                return 0;
            }
            if (KotlinRequestHintKt.access$addBreakpointAtFirstDeclaredLocationInLambda(this, context)) {
                return 2;
            }
            return super.getNextStepDepth(context);
        }
        catch (VMDisconnectedException frameProxy) {
        }
        catch (EvaluateException e) {
            LOG.error((Throwable)e);
        }
        return 0;
    }

    static {
        Logger logger = Logger.getInstance(KotlinStepIntoRequestHint.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinStepIntoRequestHint$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.jvm-debugger.core"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

