/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stepping.filter;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.util.Range;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.stepping.filter.KotlinStepOverParamDefaultImplsMethodFilterKt;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001c\u0010\r\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stepping/filter/KotlinStepOverParamDefaultImplsMethodFilter;", "Lcom/intellij/debugger/engine/MethodFilter;", "name", "", "defaultSignature", "containingTypeName", "possiblyConvertedToStatic", "", "expressionLines", "Lcom/intellij/util/Range;", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLcom/intellij/util/Range;)V", "locationMatches", "process", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "location", "Lcom/sun/jdi/Location;", "matchesDefaultMethod", "method", "Lcom/sun/jdi/Method;", "getCallingExpressionLines", "Companion", "kotlin.jvm-debugger.core"})
public final class KotlinStepOverParamDefaultImplsMethodFilter
implements MethodFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final String defaultSignature;
    @NotNull
    private final String containingTypeName;
    private final boolean possiblyConvertedToStatic;
    @NotNull
    private final Range<Integer> expressionLines;

    public KotlinStepOverParamDefaultImplsMethodFilter(@NotNull String name2, @NotNull String defaultSignature, @NotNull String containingTypeName, boolean possiblyConvertedToStatic, @NotNull Range<Integer> expressionLines) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)defaultSignature, (String)"defaultSignature");
        Intrinsics.checkNotNullParameter((Object)containingTypeName, (String)"containingTypeName");
        Intrinsics.checkNotNullParameter(expressionLines, (String)"expressionLines");
        this.name = name2;
        this.defaultSignature = defaultSignature;
        this.containingTypeName = containingTypeName;
        this.possiblyConvertedToStatic = possiblyConvertedToStatic;
        this.expressionLines = expressionLines;
    }

    public boolean locationMatches(@Nullable DebugProcessImpl process2, @Nullable Location location) {
        Comparable<Location> comparable = location;
        if (comparable == null || (comparable = SafeUtilKt.safeMethod((Location)comparable)) == null) {
            return true;
        }
        Comparable<Location> method = comparable;
        String containingTypeName = location.declaringType().name();
        return Intrinsics.areEqual((Object)method.name(), (Object)this.name) && Intrinsics.areEqual((Object)containingTypeName, (Object)this.containingTypeName) && this.matchesDefaultMethod((Method)method);
    }

    private final boolean matchesDefaultMethod(Method method) {
        Type type2 = Type.getMethodType((String)this.defaultSignature);
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"getMethodType(...)");
        Type type3 = Type.getMethodType((String)method.signature());
        Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"getMethodType(...)");
        return KotlinStepOverParamDefaultImplsMethodFilterKt.matchesDefaultMethodSignature(type2, type3, this.possiblyConvertedToStatic, Intrinsics.areEqual((Object)this.name, (Object)"<init>"));
    }

    @NotNull
    public Range<Integer> getCallingExpressionLines() {
        return this.expressionLines;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stepping/filter/KotlinStepOverParamDefaultImplsMethodFilter$Companion;", "", "<init>", "()V", "create", "Lorg/jetbrains/kotlin/idea/debugger/core/stepping/filter/KotlinStepOverParamDefaultImplsMethodFilter;", "location", "Lcom/sun/jdi/Location;", "expressionLines", "Lcom/intellij/util/Range;", "", "kotlin.jvm-debugger.core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final KotlinStepOverParamDefaultImplsMethodFilter create(@NotNull Location location, @NotNull Range<Integer> expressionLines) {
            String string;
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter(expressionLines, (String)"expressionLines");
            if (location.lineNumber() < 0) {
                return null;
            }
            Method method = SafeUtilKt.safeMethod(location);
            if (method == null) {
                return null;
            }
            Method method2 = method;
            String name2 = method2.name();
            Intrinsics.checkNotNull((Object)name2);
            if (StringsKt.endsWith$default((String)name2, (String)"$default", (boolean)false, (int)2, null)) {
                string = StringsKt.removeSuffix((String)name2, (CharSequence)"$default");
            } else if (Intrinsics.areEqual((Object)name2, (Object)"<init>")) {
                string = name2;
            } else {
                throw new IllegalStateException(("Unexpected default impls method: " + name2).toString());
            }
            String originalName = string;
            String signature = method2.signature();
            String containingTypeName = location.declaringType().name();
            boolean possiblyConvertedToStatic = KotlinStepOverParamDefaultImplsMethodFilterKt.isSyntheticDefaultMethodPossiblyConvertedToStatic(location);
            Intrinsics.checkNotNull((Object)signature);
            Intrinsics.checkNotNull((Object)containingTypeName);
            return new KotlinStepOverParamDefaultImplsMethodFilter(originalName, signature, containingTypeName, possiblyConvertedToStatic, expressionLines);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

