/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.view;

import com.intellij.debugger.actions.ThreadDumpAction;
import com.intellij.icons.AllIcons;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.unscramble.DumpItem;
import com.intellij.unscramble.MergeableToken;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.Locale;
import java.util.Objects;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoData;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.State;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0001!B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineDumpItem;", "Lcom/intellij/unscramble/DumpItem;", "info", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;)V", "name", "", "getName", "()Ljava/lang/String;", "stateDesc", "getStateDesc", "stackTrace", "getStackTrace", "interestLevel", "", "getInterestLevel", "()I", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "attributes", "Lcom/intellij/ui/SimpleTextAttributes;", "getAttributes", "()Lcom/intellij/ui/SimpleTextAttributes;", "getBackgroundColor", "Ljava/awt/Color;", "selectedItem", "mergeableToken", "Lcom/intellij/unscramble/MergeableToken;", "getMergeableToken", "()Lcom/intellij/unscramble/MergeableToken;", "CoroutinesMergeableToken", "kotlin.jvm-debugger.coroutines"})
@SourceDebugExtension(value={"SMAP\nCoroutinesDumpAsyncProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutinesDumpAsyncProvider.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineDumpItem\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,105:1\n1104#2,3:106\n*S KotlinDebug\n*F\n+ 1 CoroutinesDumpAsyncProvider.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineDumpItem\n*L\n60#1:106,3\n*E\n"})
final class CoroutineDumpItem
implements DumpItem {
    @NotNull
    private final CoroutineInfoData info;
    @NotNull
    private final String name;
    @NotNull
    private final String stateDesc;
    @NotNull
    private final String stackTrace;
    private final int interestLevel;
    @NotNull
    private final Icon icon;
    @NotNull
    private final SimpleTextAttributes attributes;

    /*
     * WARNING - void declaration
     */
    public CoroutineDumpItem(@NotNull CoroutineInfoData info2) {
        Icon icon2;
        int n;
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        this.info = info2;
        this.name = this.info.getName() + ":" + this.info.getId();
        String string = this.info.getState().name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        this.stateDesc = " (" + string + ")";
        this.stackTrace = this.info.getCoroutineDescriptor() + "\n" + CollectionsKt.joinToString$default((Iterable)this.info.getContinuationStackFrames(), (CharSequence)"\n", (CharSequence)"\t", null, (int)0, null, CoroutineDumpItem::stackTrace$lambda$0, (int)28, null);
        CoroutineDumpItem coroutineDumpItem = this;
        if (this.info.getContinuationStackFrames().isEmpty()) {
            n = -10;
        } else {
            void $this$count$iv;
            CharSequence charSequence = this.getStackTrace();
            CoroutineDumpItem coroutineDumpItem2 = coroutineDumpItem;
            boolean $i$f$count = false;
            int count$iv = 0;
            for (int j = 0; j < $this$count$iv.length(); ++j) {
                char element$iv;
                char it = element$iv = $this$count$iv.charAt(j);
                boolean bl = false;
                if (!(it == '\n')) continue;
                ++count$iv;
            }
            int n2 = count$iv;
            coroutineDumpItem = coroutineDumpItem2;
            n = n2;
        }
        coroutineDumpItem.interestLevel = n;
        switch (WhenMappings.$EnumSwitchMapping$0[this.info.getState().ordinal()]) {
            case 1: {
                Icon icon3 = AllIcons.Debugger.ThreadFrozen;
                icon2 = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"ThreadFrozen");
                break;
            }
            case 2: {
                Icon icon4 = AllIcons.Debugger.ThreadRunning;
                icon2 = icon4;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"ThreadRunning");
                break;
            }
            case 3: 
            case 4: {
                Icon icon5 = AllIcons.Debugger.ThreadGroup;
                icon2 = icon5;
                Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"ThreadGroup");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.icon = icon2;
        this.attributes = switch (WhenMappings.$EnumSwitchMapping$0[this.info.getState().ordinal()]) {
            case 1 -> DumpItem.SLEEPING_ATTRIBUTES;
            case 2 -> DumpItem.RUNNING_ATTRIBUTES;
            case 3, 4 -> DumpItem.UNINTERESTING_ATTRIBUTES;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getStateDesc() {
        return this.stateDesc;
    }

    @NotNull
    public String getStackTrace() {
        return this.stackTrace;
    }

    public int getInterestLevel() {
        return this.interestLevel;
    }

    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @NotNull
    public SimpleTextAttributes getAttributes() {
        return this.attributes;
    }

    @Nullable
    public Color getBackgroundColor(@Nullable DumpItem selectedItem) {
        return UIUtil.getListBackground();
    }

    @NotNull
    public MergeableToken getMergeableToken() {
        return new CoroutinesMergeableToken();
    }

    private static final CharSequence stackTrace$lambda$0(CoroutineStackFrameItem it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return ThreadDumpAction.Companion.renderLocation(it.getLocation());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineDumpItem$CoroutinesMergeableToken;", "Lcom/intellij/unscramble/MergeableToken;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineDumpItem;)V", "comparableStackTrace", "", "item", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineDumpItem;", "getItem", "()Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineDumpItem;", "equals", "", "other", "", "hashCode", "", "kotlin.jvm-debugger.coroutines"})
    private final class CoroutinesMergeableToken
    implements MergeableToken {
        @NotNull
        private final String comparableStackTrace;

        public CoroutinesMergeableToken() {
            this.comparableStackTrace = StringsKt.substringAfter$default((String)CoroutineDumpItem.this.getStackTrace(), (String)"\n", null, (int)2, null);
        }

        @NotNull
        public CoroutineDumpItem getItem() {
            return CoroutineDumpItem.this;
        }

        public boolean equals(@Nullable Object other) {
            if (!(other instanceof CoroutinesMergeableToken)) {
                return false;
            }
            CoroutineInfoData otherInfo = ((CoroutinesMergeableToken)other).getItem().info;
            if (CoroutineDumpItem.this.info.getState() != otherInfo.getState()) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)CoroutineDumpItem.this.info.getDispatcher(), (Object)otherInfo.getDispatcher())) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.comparableStackTrace, (Object)((CoroutinesMergeableToken)other).comparableStackTrace);
        }

        public int hashCode() {
            Object[] objectArray = new Object[]{CoroutineDumpItem.this.info.getState(), CoroutineDumpItem.this.info.getDispatcher(), this.comparableStackTrace};
            return Objects.hash(objectArray);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[State.values().length];
            try {
                nArray[State.SUSPENDED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.RUNNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.CREATED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.UNKNOWN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

