/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.dfaassist;

import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.lang.UnsatisfiedConditionProblem;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.dfaassist.DebuggerDfaListener;
import com.intellij.debugger.engine.dfaassist.DfaAssistProvider;
import com.intellij.debugger.engine.jdi.LocalVariableProxy;
import com.intellij.debugger.jdi.StackFrameProxyEx;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.impl.dfaassist.DfaHint;
import com.sun.jdi.Field;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiHeuristics;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.debugger.base.util.ClassNameCalculator;
import org.jetbrains.kotlin.idea.debugger.dfaassist.KotlinDfaAssistProvider;
import org.jetbrains.kotlin.idea.debugger.evaluate.variables.EvaluatorValueConverter;
import org.jetbrains.kotlin.idea.inspections.dfa.KotlinAnchor;
import org.jetbrains.kotlin.idea.inspections.dfa.KotlinConstantConditionsInspection;
import org.jetbrains.kotlin.idea.inspections.dfa.KotlinProblem;
import org.jetbrains.kotlin.idea.inspections.dfa.KtClassDef;
import org.jetbrains.kotlin.idea.inspections.dfa.KtThisDescriptor;
import org.jetbrains.kotlin.idea.inspections.dfa.KtVariableDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u0007H\u0016J\"\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u0007H\u0016J\u0012\u0010\u0014\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000fH\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/dfaassist/KotlinDfaAssistProvider;", "Lcom/intellij/debugger/engine/dfaassist/DfaAssistProvider;", "<init>", "()V", "locationMatches", "", "element", "Lcom/intellij/psi/PsiElement;", "location", "Lcom/sun/jdi/Location;", "getAnchor", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getCodeBlock", "anchor", "getJdiValueForDfaVariable", "Lcom/sun/jdi/Value;", "proxy", "Lcom/intellij/debugger/jdi/StackFrameProxyEx;", "dfaVar", "Lcom/intellij/codeInspection/dataFlow/value/DfaVariableValue;", "postprocess", "value", "createListener", "Lcom/intellij/debugger/engine/dfaassist/DebuggerDfaListener;", "constraintFromJvmClassName", "Lcom/intellij/codeInspection/dataFlow/TypeConstraint;", "jvmClassName", "", "KotlinDebuggerDfaListener", "kotlin.jvm-debugger.evaluation.k1"})
@SourceDebugExtension(value={"SMAP\nKotlinDfaAssistProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinDfaAssistProvider.kt\norg/jetbrains/kotlin/idea/debugger/dfaassist/KotlinDfaAssistProvider\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,205:1\n1251#2,2:206\n1#3:208\n*S KotlinDebug\n*F\n+ 1 KotlinDfaAssistProvider.kt\norg/jetbrains/kotlin/idea/debugger/dfaassist/KotlinDfaAssistProvider\n*L\n45#1:206,2\n*E\n"})
public final class KotlinDfaAssistProvider
implements DfaAssistProvider {
    public boolean locationMatches(@NotNull PsiElement element, @NotNull Location location) {
        boolean bl;
        block2: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            String jdiClassName = location.method().declaringType().name();
            PsiFile file = element.getContainingFile();
            if (!(file instanceof KtFile)) {
                return false;
            }
            Map<KtElement, String> classNames = ClassNameCalculator.Companion.getClassNames((KtFile)file);
            Sequence $this$any$iv = PsiUtilsKt.getParentsWithSelf((PsiElement)element);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                PsiElement e = (PsiElement)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)classNames.get(e), (Object)jdiClassName)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    @Nullable
    public KtExpression getAnchor(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement cur = element;
        while (cur instanceof PsiWhiteSpace || cur instanceof PsiComment) {
            if (cur.getNextSibling() != null) continue;
            return null;
        }
        while (true) {
            PsiElement parent2;
            if ((parent2 = cur.getParent()) instanceof KtBlockExpression || parent2 instanceof KtFunction) {
                PsiElement psiElement = cur;
                return psiElement instanceof KtExpression ? (KtExpression)psiElement : null;
            }
            if (parent2 == null || cur.getStartOffsetInParent() > 0) {
                return null;
            }
            cur = parent2;
        }
    }

    @Nullable
    public KtExpression getCodeBlock(@NotNull PsiElement anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        if (!(anchor instanceof KtExpression)) {
            return null;
        }
        PsiElement parent2 = ((KtExpression)anchor).getParent();
        if (parent2 instanceof KtBlockExpression) {
            return (KtExpression)parent2;
        }
        if (parent2 instanceof KtFunction) {
            return (KtExpression)anchor;
        }
        return null;
    }

    @Nullable
    public Value getJdiValueForDfaVariable(@NotNull StackFrameProxyEx proxy, @NotNull DfaVariableValue dfaVar, @NotNull PsiElement anchor) {
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        Intrinsics.checkNotNullParameter((Object)dfaVar, (String)"dfaVar");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        DfaVariableValue qualifier2 = dfaVar.getQualifier();
        PsiElement psiVariable = dfaVar.getPsiVariable();
        if (qualifier2 == null) {
            LocalVariableProxy variable;
            VariableDescriptor variableDescriptor = dfaVar.getDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)variableDescriptor, (String)"getDescriptor(...)");
            VariableDescriptor descriptor2 = variableDescriptor;
            if (descriptor2 instanceof KtThisDescriptor) {
                String jvmName;
                String signature;
                DeclarationDescriptor declarationDescriptor = ((KtThisDescriptor)descriptor2).getDescriptor();
                if (declarationDescriptor instanceof FunctionDescriptor) {
                    String thisName = "$this$" + ((FunctionDescriptor)declarationDescriptor).getName();
                    LocalVariableProxy thisVar = proxy.visibleVariableByName(thisName);
                    if (thisVar != null) {
                        return this.postprocess(proxy.getVariableValue(thisVar));
                    }
                    return null;
                }
                ObjectReference thisObject = proxy.thisObject();
                if (thisObject != null && Intrinsics.areEqual((Object)(signature = Type.getType((String)thisObject.referenceType().signature()).getClassName()), (Object)(jvmName = KotlinPsiHeuristics.getJvmName(DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)declarationDescriptor))))) {
                    return thisObject;
                }
                return null;
            }
            if (descriptor2 instanceof KtVariableDescriptor && psiVariable instanceof KtCallableDeclaration && (variable = proxy.visibleVariableByName(((KtNamedDeclaration)psiVariable).getName())) != null) {
                return this.postprocess(proxy.getVariableValue(variable));
            }
        } else {
            Value jdiQualifier = this.getJdiValueForDfaVariable(proxy, qualifier2, anchor);
            if (jdiQualifier instanceof ObjectReference && psiVariable instanceof KtCallableDeclaration) {
                Field field2;
                String string = ((KtCallableDeclaration)psiVariable).getName();
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    v2 = DebuggerUtils.findField((ReferenceType)((ObjectReference)jdiQualifier).referenceType(), (String)it);
                } else {
                    v2 = field2 = null;
                }
                if (field2 != null) {
                    return this.postprocess(((ObjectReference)jdiQualifier).getValue(field2));
                }
            }
        }
        return null;
    }

    private final Value postprocess(Value value) {
        Value value2 = DfaAssistProvider.wrap((Value)EvaluatorValueConverter.Companion.unref(value));
        Intrinsics.checkNotNullExpressionValue((Object)value2, (String)"wrap(...)");
        return value2;
    }

    @NotNull
    public DebuggerDfaListener createListener() {
        return new KotlinDebuggerDfaListener();
    }

    @NotNull
    public TypeConstraint constraintFromJvmClassName(@NotNull PsiElement anchor, @NotNull String jvmClassName) {
        TypeConstraint typeConstraint;
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Intrinsics.checkNotNullParameter((Object)jvmClassName, (String)"jvmClassName");
        KtClassDef ktClassDef = KtClassDef.Companion.fromJvmClassName((KtElement)anchor, jvmClassName);
        if (ktClassDef == null) {
            TypeConstraint typeConstraint2 = TypeConstraints.TOP;
            Intrinsics.checkNotNullExpressionValue((Object)typeConstraint2, (String)"TOP");
            return typeConstraint2;
        }
        KtClassDef classDef = ktClassDef;
        if (classDef.getCls().getKind() == ClassKind.OBJECT) {
            TypeConstraint.Exact exact = TypeConstraints.singleton((TypeConstraints.ClassDef)classDef);
            Intrinsics.checkNotNullExpressionValue((Object)exact, (String)"singleton(...)");
            typeConstraint = (TypeConstraint)exact;
        } else {
            TypeConstraint.Exact exact = TypeConstraints.exactClass((TypeConstraints.ClassDef)classDef);
            Intrinsics.checkNotNullExpressionValue((Object)exact, (String)"exactClass(...)");
            typeConstraint = (TypeConstraint)exact;
        }
        return typeConstraint;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J5\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J(\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0014\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070 H\u0016R-\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/dfaassist/KotlinDfaAssistProvider$KotlinDebuggerDfaListener;", "Lcom/intellij/debugger/engine/dfaassist/DebuggerDfaListener;", "<init>", "()V", "hints", "Ljava/util/HashMap;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/xdebugger/impl/dfaassist/DfaHint;", "Lkotlin/collections/HashMap;", "getHints", "()Ljava/util/HashMap;", "beforePush", "", "args", "", "Lcom/intellij/codeInspection/dataFlow/value/DfaValue;", "value", "anchor", "Lcom/intellij/codeInspection/dataFlow/lang/DfaAnchor;", "state", "Lcom/intellij/codeInspection/dataFlow/memory/DfaMemoryState;", "([Lcom/intellij/codeInspection/dataFlow/value/DfaValue;Lcom/intellij/codeInspection/dataFlow/value/DfaValue;Lcom/intellij/codeInspection/dataFlow/lang/DfaAnchor;Lcom/intellij/codeInspection/dataFlow/memory/DfaMemoryState;)V", "onCondition", "problem", "Lcom/intellij/codeInspection/dataFlow/lang/UnsatisfiedConditionProblem;", "failed", "Lcom/intellij/util/ThreeState;", "shouldTrackExpressionValue", "", "expr", "Lorg/jetbrains/kotlin/psi/KtExpression;", "computeHints", "", "kotlin.jvm-debugger.evaluation.k1"})
    @SourceDebugExtension(value={"SMAP\nKotlinDfaAssistProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinDfaAssistProvider.kt\norg/jetbrains/kotlin/idea/debugger/dfaassist/KotlinDfaAssistProvider$KotlinDebuggerDfaListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,205:1\n1#2:206\n*E\n"})
    public static final class KotlinDebuggerDfaListener
    implements DebuggerDfaListener {
        @NotNull
        private final HashMap<PsiElement, DfaHint> hints = new HashMap();

        @NotNull
        public final HashMap<PsiElement, DfaHint> getHints() {
            return this.hints;
        }

        public void beforePush(@NotNull DfaValue[] args, @NotNull DfaValue value, @NotNull DfaAnchor anchor, @NotNull DfaMemoryState state) {
            KtElement ktElement;
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            DfType dfType = state.getDfType(value);
            Intrinsics.checkNotNullExpressionValue((Object)dfType, (String)"getDfType(...)");
            DfType dfType2 = dfType;
            DfaAnchor dfaAnchor = anchor;
            if (dfaAnchor instanceof KotlinAnchor.KotlinExpressionAnchor) {
                if (!this.shouldTrackExpressionValue(((KotlinAnchor.KotlinExpressionAnchor)anchor).getExpression())) {
                    return;
                }
                if (KotlinConstantConditionsInspection.Companion.shouldSuppress(dfType2, ((KotlinAnchor.KotlinExpressionAnchor)anchor).getExpression())) {
                    boolean bl;
                    DfType dfType3 = dfType2.tryNegate();
                    if (dfType3 != null) {
                        DfType negated = dfType3;
                        boolean bl2 = false;
                        bl = !KotlinConstantConditionsInspection.Companion.shouldSuppress(negated, ((KotlinAnchor.KotlinExpressionAnchor)anchor).getExpression());
                    } else {
                        bl = false;
                    }
                    if (!bl) {
                        return;
                    }
                }
                ktElement = (KtElement)((KotlinAnchor.KotlinExpressionAnchor)anchor).getExpression();
            } else if (dfaAnchor instanceof KotlinAnchor.KotlinWhenConditionAnchor) {
                ktElement = (KtElement)((KotlinAnchor.KotlinWhenConditionAnchor)anchor).getCondition();
            } else {
                return;
            }
            KtElement psi = ktElement;
            DfaHint hint2 = DfaHint.ANY_VALUE;
            if (dfType2 == DfTypes.TRUE) {
                hint2 = DfaHint.TRUE;
            } else if (dfType2 == DfTypes.FALSE) {
                hint2 = DfaHint.FALSE;
            } else if (dfType2 == DfTypes.NULL) {
                PsiElement parent2 = psi.getParent();
                if (parent2 instanceof KtPostfixExpression && Intrinsics.areEqual((Object)((KtPostfixExpression)parent2).getOperationToken(), (Object)KtTokens.EXCLEXCL)) {
                    hint2 = DfaHint.NPE;
                } else if (parent2 instanceof KtBinaryExpressionWithTypeRHS && ((KtBinaryExpressionWithTypeRHS)parent2).getOperationReference().textMatches((CharSequence)"as")) {
                    KotlinType type2;
                    KtTypeReference typeReference;
                    KtTypeReference ktTypeReference = typeReference = ((KtBinaryExpressionWithTypeRHS)parent2).getRight();
                    KotlinType kotlinType = type2 = ktTypeReference != null ? BindingContextUtilsKt.getAbbreviatedTypeOrType((KtTypeReference)ktTypeReference, (BindingContext)ExtendedResolutionApiKt.safeAnalyzeNonSourceRootCode((KtElement)typeReference, BodyResolveMode.FULL)) : null;
                    if (type2 != null && !type2.isMarkedNullable()) {
                        hint2 = DfaHint.NPE;
                        psi = (KtElement)((KtBinaryExpressionWithTypeRHS)parent2).getOperationReference();
                    }
                } else if (parent2 instanceof KtBinaryExpression && Intrinsics.areEqual((Object)((KtBinaryExpression)parent2).getOperationToken(), (Object)KtTokens.ELVIS)) {
                    hint2 = DfaHint.NULL;
                } else if (psi instanceof KtBinaryExpressionWithTypeRHS && ((KtBinaryExpressionWithTypeRHS)psi).getOperationReference().textMatches((CharSequence)"as?")) {
                    hint2 = DfaHint.NULL;
                }
            }
            this.hints.merge((PsiElement)psi, hint2, (arg_0, arg_1) -> KotlinDebuggerDfaListener.beforePush$lambda$1(beforePush.1.INSTANCE, arg_0, arg_1));
        }

        public void onCondition(@NotNull UnsatisfiedConditionProblem problem, @NotNull DfaValue value, @NotNull ThreeState failed, @NotNull DfaMemoryState state) {
            Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)failed, (String)"failed");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            if (problem instanceof KotlinProblem.KotlinCastProblem) {
                this.hints.merge((PsiElement)((KotlinProblem.KotlinCastProblem)problem).getCast().getOperationReference(), failed == ThreeState.YES ? DfaHint.CCE : DfaHint.NONE, (arg_0, arg_1) -> KotlinDebuggerDfaListener.onCondition$lambda$2(onCondition.1.INSTANCE, arg_0, arg_1));
            }
        }

        private final boolean shouldTrackExpressionValue(KtExpression expr) {
            if (expr instanceof KtBinaryExpression) {
                IElementType iElementType = ((KtBinaryExpression)expr).getOperationToken();
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getOperationToken(...)");
                IElementType token = iElementType;
                if (Intrinsics.areEqual((Object)token, (Object)KtTokens.EQ)) {
                    return false;
                }
                if (Intrinsics.areEqual((Object)token, (Object)KtTokens.ANDAND) || Intrinsics.areEqual((Object)token, (Object)KtTokens.OROR)) {
                    return false;
                }
            }
            PsiElement parent2 = expr.getParent();
            while (parent2 instanceof KtParenthesizedExpression) {
                parent2 = ((KtParenthesizedExpression)parent2).getParent();
            }
            PsiElement psiElement = parent2;
            KtPrefixExpression ktPrefixExpression = psiElement instanceof KtPrefixExpression ? (KtPrefixExpression)psiElement : null;
            return !Intrinsics.areEqual((Object)(ktPrefixExpression != null ? ktPrefixExpression.getOperationToken() : null), (Object)KtTokens.EXCL);
        }

        @NotNull
        public Map<PsiElement, DfaHint> computeHints() {
            this.hints.values().removeIf(arg_0 -> KotlinDebuggerDfaListener.computeHints$lambda$4(KotlinDebuggerDfaListener::computeHints$lambda$3, arg_0));
            return this.hints;
        }

        private static final DfaHint beforePush$lambda$1(Function2 $tmp0, Object p0, Object p1) {
            return (DfaHint)$tmp0.invoke(p0, p1);
        }

        private static final DfaHint onCondition$lambda$2(Function2 $tmp0, Object p0, Object p1) {
            return (DfaHint)$tmp0.invoke(p0, p1);
        }

        private static final boolean computeHints$lambda$3(DfaHint h) {
            Intrinsics.checkNotNullParameter((Object)h, (String)"h");
            return h.getTitle() == null;
        }

        private static final boolean computeHints$lambda$4(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }
    }
}

