/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaExperimentalApi;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.compile.CodeFragmentCapturedValue;
import org.jetbrains.kotlin.analysis.api.components.KaCompilationResult;
import org.jetbrains.kotlin.analysis.api.components.KaCompiledFile;
import org.jetbrains.kotlin.analysis.api.components.KaCompilerFacility;
import org.jetbrains.kotlin.analysis.api.components.KaCompilerFacilityKt;
import org.jetbrains.kotlin.analysis.api.components.KaCompilerTarget;
import org.jetbrains.kotlin.analysis.api.diagnostics.KaDiagnostic;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.idea.base.codeInsight.compiler.KotlinCompilerIdeAllowedErrorFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.ExecutionContext;
import org.jetbrains.kotlin.idea.debugger.evaluate.CompilerType;
import org.jetbrains.kotlin.idea.debugger.evaluate.EvaluationCompilerResult;
import org.jetbrains.kotlin.idea.debugger.evaluate.IncorrectCodeFragmentException;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinCodeFragmentCompiler;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinCodeFragmentCompilerKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinCodeFragmentPatcherKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerEvaluatorStatisticsCollector;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerEvaluatorStatisticsCollectorKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluatorBuilderKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassToLoad;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCodegenExceptionKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCompilationStats;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentParameter;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CompilationResult;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CompiledCodeFragmentData;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CompilerUtilsKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.K2CodeFragmentParameterInfo;
import org.jetbrains.kotlin.name.NameUtils;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0003J\u000e\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u0015H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/K2KotlinCodeFragmentCompiler;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinCodeFragmentCompiler;", "<init>", "()V", "compilerType", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/CompilerType;", "getCompilerType", "()Lorg/jetbrains/kotlin/idea/debugger/evaluate/CompilerType;", "compileCodeFragment", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CompiledCodeFragmentData;", "context", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "compiledCodeFragmentDataK2Impl", "computeCodeFragmentParameterInfo", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/K2CodeFragmentParameterInfo;", "result", "Lorg/jetbrains/kotlin/analysis/api/components/KaCompilationResult$Success;", "toDumbCodeFragmentParameter", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameter$Dumb;", "Lorg/jetbrains/kotlin/analysis/api/compile/CodeFragmentCapturedValue;", "kotlin.jvm-debugger.evaluation"})
@SourceDebugExtension(value={"SMAP\nKotlinCodeFragmentCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinCodeFragmentCompiler.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/K2KotlinCodeFragmentCompiler\n+ 2 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 3 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,196:1\n30#2,2:197\n35#3,9:199\n46#3,2:227\n774#4:208\n865#4,2:209\n1557#4:211\n1628#4,3:212\n626#4,12:215\n*S KotlinDebug\n*F\n+ 1 KotlinCodeFragmentCompiler.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/K2KotlinCodeFragmentCompiler\n*L\n90#1:197,2\n90#1:199,9\n90#1:227,2\n100#1:208\n100#1:209,2\n101#1:211\n101#1:212,3\n103#1:215,12\n*E\n"})
public final class K2KotlinCodeFragmentCompiler
implements KotlinCodeFragmentCompiler {
    @NotNull
    private final CompilerType compilerType = CompilerType.K2;

    @Override
    @NotNull
    public CompilerType getCompilerType() {
        return this.compilerType;
    }

    @Override
    @NotNull
    public CompiledCodeFragmentData compileCodeFragment(@NotNull ExecutionContext context, @NotNull KtCodeFragment codeFragment) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        CodeFragmentCompilationStats stats = new CodeFragmentCompilationStats();
        stats.setOrigin(KotlinDebuggerEvaluatorStatisticsCollectorKt.getOrigin(context.getEvaluationContext()));
        try {
            KotlinCodeFragmentPatcherKt.patchCodeFragment(context, codeFragment, stats);
            Object object = stats.startAndMeasureAnalysisUnderReadAction-IoAF18A(() -> K2KotlinCodeFragmentCompiler.compileCodeFragment$lambda$0(this, context, codeFragment));
            ResultKt.throwOnFailure((Object)object);
            CompiledCodeFragmentData result2 = (CompiledCodeFragmentData)object;
            K2KotlinCodeFragmentCompiler.compileCodeFragment$onFinish(codeFragment, stats, EvaluationCompilerResult.SUCCESS);
            return result2;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            Throwable throwable = e instanceof ExecutionException ? (ExecutionException)e : null;
            if (throwable == null || (throwable = throwable.getCause()) == null) {
                throwable = e;
            }
            Throwable cause = throwable;
            stats.setCompilerFailExceptionClass(KotlinDebuggerEvaluatorStatisticsCollectorKt.extractExceptionCauseClass(e));
            boolean isJustInvalidUserCode = cause instanceof IncorrectCodeFragmentException;
            K2KotlinCodeFragmentCompiler.compileCodeFragment$onFinish(codeFragment, stats, isJustInvalidUserCode ? EvaluationCompilerResult.COMPILATION_FAILURE : EvaluationCompilerResult.COMPILER_INTERNAL_ERROR);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final CompiledCodeFragmentData compiledCodeFragmentDataK2Impl(ExecutionContext context, KtCodeFragment codeFragment) {
        CompiledCodeFragmentData compiledCodeFragmentData;
        void this_$iv$iv;
        CompilerConfiguration compilerConfiguration;
        Module module = GenericPsiUtils.getModule((PsiElement)codeFragment);
        Object $this$compiledCodeFragmentDataK2Impl_u24lambda_u241 = compilerConfiguration = new CompilerConfiguration();
        boolean bl = false;
        if (module != null) {
            $this$compiledCodeFragmentDataK2Impl_u24lambda_u241.put(CommonConfigurationKeys.MODULE_NAME, (Object)module.getName());
        }
        $this$compiledCodeFragmentDataK2Impl_u24lambda_u241.put(CommonConfigurationKeys.LANGUAGE_VERSION_SETTINGS, (Object)LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)codeFragment));
        $this$compiledCodeFragmentDataK2Impl_u24lambda_u241.put(KaCompilerFacility.Companion.getCODE_FRAGMENT_CLASS_NAME(), (Object)"Generated_for_debugger_class");
        $this$compiledCodeFragmentDataK2Impl_u24lambda_u241.put(KaCompilerFacility.Companion.getCODE_FRAGMENT_METHOD_NAME(), (Object)"generated_for_debugger_fun");
        CompilerConfiguration compilerConfiguration2 = compilerConfiguration;
        boolean $i$f$analyze = false;
        Project project = ((KtElement)codeFragment).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        $this$compiledCodeFragmentDataK2Impl_u24lambda_u241 = KaSessionProvider.Companion.getInstance(project);
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)codeFragment);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)codeFragment);
        try {
            CompiledCodeFragmentData compiledCodeFragmentData2;
            Object lock$iv$iv;
            Object object = lock$iv$iv = new Object();
            synchronized (object) {
                CompiledCodeFragmentData compiledCodeFragmentData3;
                boolean bl2 = false;
                KaSession $this$compiledCodeFragmentDataK2Impl_u24lambda_u245 = analysisSession$iv$iv;
                boolean bl3 = false;
                try {
                    Object single$iv;
                    List classes;
                    KaCompilerTarget.Jvm compilerTarget = new KaCompilerTarget.Jvm(false, null, 2, null);
                    KotlinCompilerIdeAllowedErrorFilter allowedErrorFilter = KotlinCompilerIdeAllowedErrorFilter.Companion.getInstance();
                    KaCompilationResult result2 = $this$compiledCodeFragmentDataK2Impl_u24lambda_u245.compile((KtFile)codeFragment, compilerConfiguration2, compilerTarget, (Function1<? super KaDiagnostic, Boolean>)((Function1)allowedErrorFilter));
                    if (result2 instanceof KaCompilationResult.Success) {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Object it;
                        void $this$filterTo$iv$iv;
                        Iterable $this$filter$iv;
                        KotlinEvaluator.Companion.logCompilation(codeFragment);
                        Iterable iterable = ((KaCompilationResult.Success)result2).getOutput();
                        boolean $i$f$filter = false;
                        void var19_27 = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            it = (KaCompiledFile)element$iv$iv;
                            boolean bl4 = false;
                            if (!(KaCompilerFacilityKt.isClassFile((KaCompiledFile)it) && KotlinCodeFragmentCompilerKt.isCodeFragmentClassFile((KaCompiledFile)it))) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv;
                        boolean $i$f$map = false;
                        $this$filterTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            it = (KaCompiledFile)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl5 = false;
                            collection.add(new ClassToLoad(CompilerUtilsKt.getInternalClassName((KaCompiledFile)it), it.getPath(), it.getContent()));
                        }
                        classes = (List)destination$iv$iv;
                        Iterable $this$single$iv = classes;
                        boolean $i$f$single = false;
                        single$iv = null;
                        boolean found$iv = false;
                        for (Object element$iv : $this$single$iv) {
                            it = (ClassToLoad)element$iv;
                            boolean bl6 = false;
                            if (!Intrinsics.areEqual((Object)((ClassToLoad)it).getClassName(), (Object)"Generated_for_debugger_class")) continue;
                            if (found$iv) {
                                throw new IllegalArgumentException("Collection contains more than one matching element.");
                            }
                            single$iv = element$iv;
                            found$iv = true;
                        }
                        if (!found$iv) {
                            throw new NoSuchElementException("Collection contains no element matching the predicate.");
                        }
                    } else {
                        if (result2 instanceof KaCompilationResult.Failure) {
                            KaDiagnostic firstError = (KaDiagnostic)CollectionsKt.first(((KaCompilationResult.Failure)result2).getErrors());
                            throw new IncorrectCodeFragmentException(firstError.getDefaultMessage());
                        }
                        throw new NoWhenBranchMatchedException();
                    }
                    ClassToLoad fragmentClass = single$iv;
                    CompiledCodeFragmentData.MethodSignature methodSignature = CompilerUtilsKt.getMethodSignature(fragmentClass);
                    K2CodeFragmentParameterInfo parameterInfo = this.computeCodeFragmentParameterInfo((KaCompilationResult.Success)result2);
                    CompilationResult ideCompilationResult = new CompilationResult(classes, parameterInfo, MapsKt.emptyMap(), methodSignature, CompilerType.K2);
                    compiledCodeFragmentData3 = KotlinEvaluatorBuilderKt.createCompiledDataDescriptor(ideCompilationResult);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (IndexNotReadyException e) {
                    throw e;
                }
                catch (EvaluateException e) {
                    throw e;
                }
                catch (Throwable e) {
                    CodeFragmentCodegenExceptionKt.reportErrorWithAttachments$default(context, codeFragment, e, null, "K2 compiler internal error", 8, null);
                    throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
                }
                compiledCodeFragmentData2 = compiledCodeFragmentData3;
            }
            compiledCodeFragmentData = compiledCodeFragmentData2;
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)codeFragment);
        }
        return compiledCodeFragmentData;
    }

    @KaExperimentalApi
    private final K2CodeFragmentParameterInfo computeCodeFragmentParameterInfo(KaCompilationResult.Success result2) {
        ArrayList<CodeFragmentParameter.Dumb> parameters2 = new ArrayList<CodeFragmentParameter.Dumb>(result2.getCapturedValues().size());
        HashSet<CodeFragmentParameter.Dumb> crossingBounds = new HashSet<CodeFragmentParameter.Dumb>();
        for (CodeFragmentCapturedValue capturedValue : result2.getCapturedValues()) {
            CodeFragmentParameter.Dumb parameter;
            if (this.toDumbCodeFragmentParameter(capturedValue) == null) continue;
            parameters2.add(parameter);
            if (!capturedValue.isCrossingInlineBounds()) continue;
            crossingBounds.add(parameter);
        }
        return new K2CodeFragmentParameterInfo((List<CodeFragmentParameter.Dumb>)parameters2, (Set<CodeFragmentParameter.Dumb>)crossingBounds);
    }

    private final CodeFragmentParameter.Dumb toDumbCodeFragmentParameter(CodeFragmentCapturedValue $this$toDumbCodeFragmentParameter) {
        CodeFragmentParameter.Dumb dumb;
        CodeFragmentCapturedValue codeFragmentCapturedValue = $this$toDumbCodeFragmentParameter;
        if (codeFragmentCapturedValue instanceof CodeFragmentCapturedValue.Local) {
            dumb = new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.ORDINARY, $this$toDumbCodeFragmentParameter.getName(), null, 4, null);
        } else if (codeFragmentCapturedValue instanceof CodeFragmentCapturedValue.LocalDelegate) {
            dumb = new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.DELEGATED, ((CodeFragmentCapturedValue.LocalDelegate)$this$toDumbCodeFragmentParameter).getDisplayText(), null, 4, null);
        } else if (codeFragmentCapturedValue instanceof CodeFragmentCapturedValue.ContainingClass) {
            dumb = new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.DISPATCH_RECEIVER, "", ((CodeFragmentCapturedValue.ContainingClass)$this$toDumbCodeFragmentParameter).getDisplayText());
        } else if (codeFragmentCapturedValue instanceof CodeFragmentCapturedValue.SuperClass) {
            dumb = new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.DISPATCH_RECEIVER, "", ((CodeFragmentCapturedValue.SuperClass)$this$toDumbCodeFragmentParameter).getDisplayText());
        } else if (codeFragmentCapturedValue instanceof CodeFragmentCapturedValue.ExtensionReceiver) {
            dumb = new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.EXTENSION_RECEIVER, $this$toDumbCodeFragmentParameter.getName(), ((CodeFragmentCapturedValue.ExtensionReceiver)$this$toDumbCodeFragmentParameter).getDisplayText());
        } else if (codeFragmentCapturedValue instanceof CodeFragmentCapturedValue.ContextReceiver) {
            String string = NameUtils.contextReceiverName((int)((CodeFragmentCapturedValue.ContextReceiver)$this$toDumbCodeFragmentParameter).getIndex()).asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String name2 = string;
            dumb = new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.CONTEXT_RECEIVER, name2, ((CodeFragmentCapturedValue.ContextReceiver)$this$toDumbCodeFragmentParameter).getDisplayText());
        } else {
            dumb = codeFragmentCapturedValue instanceof CodeFragmentCapturedValue.ForeignValue ? new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.FOREIGN_VALUE, $this$toDumbCodeFragmentParameter.getName(), null, 4, null) : (codeFragmentCapturedValue instanceof CodeFragmentCapturedValue.BackingField ? new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.FIELD_VAR, $this$toDumbCodeFragmentParameter.getName(), ((CodeFragmentCapturedValue.BackingField)$this$toDumbCodeFragmentParameter).getDisplayText()) : (codeFragmentCapturedValue instanceof CodeFragmentCapturedValue.CoroutineContext ? new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.COROUTINE_CONTEXT, "", null, 4, null) : null));
        }
        return dumb;
    }

    private static final void compileCodeFragment$onFinish(KtCodeFragment $codeFragment, CodeFragmentCompilationStats stats, EvaluationCompilerResult status) {
        KotlinDebuggerEvaluatorStatisticsCollector.logAnalysisAndCompilationResult($codeFragment.getProject(), CompilerType.K2, status, stats);
    }

    private static final CompiledCodeFragmentData compileCodeFragment$lambda$0(K2KotlinCodeFragmentCompiler this$0, ExecutionContext $context, KtCodeFragment $codeFragment) {
        return this$0.compiledCodeFragmentDataK2Impl($context, $codeFragment);
    }
}

