/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.variables;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.evaluation.AdditionalContextElement;
import com.intellij.debugger.engine.evaluation.AdditionalContextProvider;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.inline.InlineScopeInfo;
import org.jetbrains.kotlin.codegen.inline.InlineScopeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.CoroutineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.InlineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.JdiTypeUtils;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.BaseExecutionContext;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.ExecutionContext;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.InlineStackFrameProxyImpl;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.CoroutineStackFrameProxyImpl;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentParameter;
import org.jetbrains.kotlin.idea.debugger.evaluate.variables.EvaluatorValueConverter;
import org.jetbrains.kotlin.idea.debugger.evaluate.variables.EvaluatorValueConverterKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.NameUtils;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00e4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 _2\u00020\u0001:\u0005_`abcB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001e\u001a\u00020!H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001e\u001a\u00020#H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001e\u001a\u00020%H\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001e\u001a\u00020'H\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001e\u001a\u00020)H\u0002J\u0012\u0010*\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001e\u001a\u00020+H\u0002J\u001a\u0010,\u001a\u0004\u0018\u00010\u00162\u0006\u0010-\u001a\u00020.2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0012\u0010/\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001e\u001a\u000200H\u0002J(\u00101\u001a\u0004\u0018\u00010\u00162\f\u00102\u001a\b\u0012\u0004\u0012\u0002030\u000f2\u0006\u0010\u001e\u001a\u00020%2\u0006\u00104\u001a\u00020.H\u0002J4\u00101\u001a\u0004\u0018\u00010\u00162\f\u00102\u001a\b\u0012\u0004\u0012\u0002030\u000f2\u0006\u0010\u001e\u001a\u00020%2\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020706H\u0002J$\u00108\u001a\b\u0012\u0004\u0012\u00020:092\f\u00102\u001a\b\u0012\u0004\u0012\u0002030\u000f2\u0006\u0010;\u001a\u00020:H\u0002JB\u0010<\u001a\u0004\u0018\u00010\u00162\f\u00102\u001a\b\u0012\u0004\u0012\u0002030\u000f2\u0006\u0010\u001e\u001a\u00020%2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020:092\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020706H\u0002J<\u00101\u001a\u0004\u0018\u00010\u00162\f\u00102\u001a\b\u0012\u0004\u0012\u0002030\u000f2\u0006\u0010\u001e\u001a\u00020%2\u0006\u0010>\u001a\u00020:2\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020706H\u0002J4\u00101\u001a\u0004\u0018\u00010\u00162\f\u0010?\u001a\b\u0012\u0004\u0012\u00020A0@2\u0006\u0010\u001e\u001a\u00020%2\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020706H\u0002J\u000e\u0010B\u001a\b\u0012\u0004\u0012\u00020A0@H\u0002J\b\u0010C\u001a\u000207H\u0002J\n\u0010D\u001a\u0004\u0018\u00010\u0016H\u0002J\u0012\u0010E\u001a\u0004\u0018\u00010F2\u0006\u0010G\u001a\u00020HH\u0002J\u0012\u0010I\u001a\u0004\u0018\u00010F2\u0006\u0010G\u001a\u00020HH\u0002J\u0012\u0010J\u001a\u0004\u0018\u00010F2\u0006\u0010K\u001a\u00020FH\u0002J \u0010L\u001a\u0004\u0018\u00010\u00162\f\u00102\u001a\b\u0012\u0004\u0012\u0002030\u000f2\u0006\u0010\u001e\u001a\u00020%H\u0002J\"\u0010M\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001e\u001a\u00020%2\u000e\u0010N\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010P0OH\u0002J\u001c\u0010M\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001e\u001a\u00020%2\b\u0010Q\u001a\u0004\u0018\u00010PH\u0002J\u001c\u0010R\u001a\u0004\u0018\u00010P2\u0006\u0010\u001e\u001a\u00020%2\b\u0010S\u001a\u0004\u0018\u00010PH\u0002J\u0010\u0010T\u001a\u0002072\u0006\u00104\u001a\u00020.H\u0002J\u0016\u0010U\u001a\u000207*\u00020%2\b\u0010V\u001a\u0004\u0018\u00010WH\u0002J\u0016\u0010X\u001a\u0004\u0018\u00010\u0016*\u00020A2\u0006\u0010\u001e\u001a\u00020%H\u0002J \u0010Y\u001a\b\u0012\u0004\u0012\u00020A0@*\b\u0012\u0004\u0012\u00020Z0\u000f2\u0006\u0010[\u001a\u00020FH\u0002J\u0018\u0010Y\u001a\b\u0012\u0004\u0012\u00020A0@*\b\u0012\u0004\u0012\u0002030\u000fH\u0002J \u0010Y\u001a\b\u0012\u0004\u0012\u00020A0@*\b\u0012\u0004\u0012\u00020\\0\u000f2\u0006\u0010\u0002\u001a\u00020]H\u0002J\n\u0010^\u001a\u0004\u0018\u00010FH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006d"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder;", "", "context", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;)V", "getContext", "()Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;", "frameProxy", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "evaluatorValueConverter", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/EvaluatorValueConverter;", "getEvaluatorValueConverter", "()Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/EvaluatorValueConverter;", "refWrappers", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$RefWrapper;", "getRefWrappers", "()Ljava/util/List;", "mutableRefWrappers", "", "find", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$Result;", "parameter", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameter;", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "findOrdinary", "kind", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$Ordinary;", "findFieldVariable", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$FieldVar;", "findLocalFunction", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$LocalFunction;", "findCapturedVariableInContainingThis", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind;", "findExtensionThis", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$ExtensionThis;", "findContextReceiver", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$ContextReceiver;", "findDispatchThis", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$OuterClassThis;", "findForeignValue", "foreignValueName", "", "findUnlabeledThis", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$UnlabeledThis;", "findLocalVariable", "variables", "Lcom/intellij/debugger/jdi/LocalVariableProxyImpl;", "name", "namePredicate", "Lkotlin/Function1;", "", "collectParentScopeNumbers", "", "", "scopeNumber", "findLocalVariableByScopeNumber", "scopeNumbers", "inlineDepth", "namedEntities", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$NamedEntity;", "getCoroutineStackFrameNamedEntities", "isInsideDefaultImpls", "findCoroutineContext", "findCoroutineContextForLambda", "Lcom/sun/jdi/ObjectReference;", "method", "Lcom/sun/jdi/Method;", "findCoroutineContextForMethod", "findCoroutineContextForContinuation", "continuation", "findCapturedVariableInReceiver", "findCapturedVariable", "parentFactory", "Lkotlin/Function0;", "Lcom/sun/jdi/Value;", "parent", "getUnwrapDelegate", "rawValue", "isCapturedReceiverFieldName", "typeMatches", "actualType", "Lcom/sun/jdi/Type;", "unwrapAndCheck", "namedEntitySequence", "Lcom/sun/jdi/Field;", "owner", "Lcom/intellij/debugger/engine/JavaValue;", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "thisObject", "Companion", "RefWrapper", "VariableKind", "Result", "NamedEntity", "kotlin.jvm-debugger.evaluation"})
@SourceDebugExtension(value={"SMAP\nVariableFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VariableFinder.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,608:1\n1#2:609\n1557#3:610\n1628#3,3:611\n295#3,2:614\n2632#3,3:617\n295#3,2:620\n618#4:616\n*S KotlinDebug\n*F\n+ 1 VariableFinder.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder\n*L\n229#1:610\n229#1:611,3\n289#1:614,2\n459#1:617,3\n481#1:620,2\n361#1:616\n*E\n"})
public final class VariableFinder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExecutionContext context;
    @NotNull
    private final StackFrameProxyImpl frameProxy;
    @NotNull
    private final EvaluatorValueConverter evaluatorValueConverter;
    @NotNull
    private final List<RefWrapper> mutableRefWrappers;

    public VariableFinder(@NotNull ExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.frameProxy = this.context.getFrameProxy();
        this.evaluatorValueConverter = new EvaluatorValueConverter(this.context);
        this.mutableRefWrappers = new ArrayList();
    }

    @NotNull
    public final ExecutionContext getContext() {
        return this.context;
    }

    @NotNull
    public final EvaluatorValueConverter getEvaluatorValueConverter() {
        return this.evaluatorValueConverter;
    }

    @NotNull
    public final List<RefWrapper> getRefWrappers() {
        return this.mutableRefWrappers;
    }

    @Nullable
    public final Result find(@NotNull CodeFragmentParameter parameter, @NotNull Type asmType, @NotNull KtCodeFragment codeFragment) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)asmType, (String)"asmType");
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        return switch (WhenMappings.$EnumSwitchMapping$0[parameter.getKind().ordinal()]) {
            case 1 -> this.findOrdinary(new VariableKind.Ordinary(parameter.getName(), asmType, false));
            case 2 -> this.findOrdinary(new VariableKind.Ordinary(parameter.getName(), asmType, true));
            case 3 -> {
                ObjectReference v1 = this.thisObject();
                if (v1 != null) {
                    ObjectReference it = v1;
                    boolean $i$a$-let-VariableFinder$find$1 = false;
                    yield new Result(it);
                }
                yield null;
            }
            case 4 -> this.findExtensionThis(new VariableKind.ExtensionThis(parameter.getName(), asmType));
            case 5 -> this.findContextReceiver(new VariableKind.ContextReceiver(asmType));
            case 6 -> this.findLocalFunction(new VariableKind.LocalFunction(parameter.getName(), asmType));
            case 7 -> this.findDispatchThis(new VariableKind.OuterClassThis(asmType));
            case 8 -> this.findCoroutineContext();
            case 9 -> this.findFieldVariable(new VariableKind.FieldVar(parameter.getName(), asmType));
            case 10 -> this.findForeignValue(parameter.getName(), codeFragment);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final Result findOrdinary(VariableKind.Ordinary kind2) {
        List<LocalVariableProxyImpl> variables = SafeUtilKt.safeVisibleVariables(this.frameProxy);
        Result result2 = this.findLocalVariable(variables, (VariableKind)kind2, kind2.getName());
        if (result2 != null) {
            Result it = result2;
            boolean bl = false;
            return it;
        }
        Result result3 = this.findLocalVariable(variables, (VariableKind)kind2, "$" + kind2.getName());
        if (result3 != null) {
            Result it = result3;
            boolean bl = false;
            return it;
        }
        Result result4 = this.findCapturedVariableInReceiver(variables, kind2);
        if (result4 != null) {
            Result it = result4;
            boolean bl = false;
            return it;
        }
        return this.findCapturedVariableInContainingThis(kind2);
    }

    private final Result findFieldVariable(VariableKind.FieldVar kind2) {
        ObjectReference thisObject = this.thisObject();
        if (thisObject != null) {
            Field field2 = DebuggerUtils.findField((ReferenceType)thisObject.referenceType(), (String)kind2.getFieldName());
            if (field2 == null) {
                return null;
            }
            Field field3 = field2;
            return new Result(thisObject.getValue(field3));
        }
        Comparable<Location> comparable = SafeUtilKt.safeLocation((StackFrameProxy)this.frameProxy);
        if (comparable == null || (comparable = comparable.declaringType()) == null) {
            return null;
        }
        Comparable<Location> containingType = comparable;
        Field field4 = DebuggerUtils.findField((ReferenceType)containingType, (String)kind2.getFieldName());
        if (field4 == null) {
            return null;
        }
        Field field5 = field4;
        return new Result(containingType.getValue(field5));
    }

    private final Result findLocalFunction(VariableKind.LocalFunction kind2) {
        List<LocalVariableProxyImpl> variables = SafeUtilKt.safeVisibleVariables(this.frameProxy);
        String newConventionName = "$fun$" + kind2.getName();
        Result result2 = this.findLocalVariable(variables, (VariableKind)kind2, newConventionName);
        if (result2 != null) {
            Result it = result2;
            boolean bl = false;
            return it;
        }
        Result result3 = this.findLocalVariable(variables, (VariableKind)kind2, kind2.getName() + "$");
        if (result3 != null) {
            Result it = result3;
            boolean bl = false;
            return it;
        }
        Result result4 = this.findCapturedVariableInReceiver(variables, kind2);
        if (result4 != null) {
            Result it = result4;
            boolean bl = false;
            return it;
        }
        return this.findCapturedVariableInContainingThis(kind2);
    }

    private final Result findCapturedVariableInContainingThis(VariableKind kind2) {
        if (this.frameProxy instanceof CoroutineStackFrameProxyImpl && ((CoroutineStackFrameProxyImpl)this.frameProxy).isCoroutineScopeAvailable()) {
            Result result2 = this.findCapturedVariable(kind2, ((CoroutineStackFrameProxyImpl)this.frameProxy).thisObject());
            if (result2 != null) {
                Result it = result2;
                boolean bl = false;
                return it;
            }
            return this.findCapturedVariable(kind2, ((CoroutineStackFrameProxyImpl)this.frameProxy).getContinuation());
        }
        ObjectReference objectReference = this.thisObject();
        if (objectReference == null) {
            return null;
        }
        ObjectReference containingThis = objectReference;
        return this.findCapturedVariable(kind2, containingThis);
    }

    private final Result findExtensionThis(VariableKind.ExtensionThis kind2) {
        Function1 namePredicate;
        List<LocalVariableProxyImpl> variables = SafeUtilKt.safeVisibleVariables(this.frameProxy);
        Result result2 = this.findLocalVariable(variables, (VariableKind)kind2, (Function1<? super String, Boolean>)(namePredicate = arg_0 -> VariableFinder.findExtensionThis$lambda$8(kind2, arg_0)));
        if (result2 != null) {
            Result it = result2;
            boolean bl = false;
            return it;
        }
        result2 = this.findCapturedVariableInReceiver(variables, kind2);
        if (result2 != null) {
            Result it = result2;
            boolean bl = false;
            return it;
        }
        result2 = this.findCapturedVariableInContainingThis(kind2);
        if (result2 != null) {
            Result it = result2;
            boolean bl = false;
            return it;
        }
        if (VariableFinder.Companion.getUSE_UNSAFE_FALLBACK() && (result2 = this.findUnlabeledThis(new VariableKind.UnlabeledThis(kind2.getAsmType()))) != null) {
            Result it = result2;
            boolean bl = false;
            return it;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final Result findContextReceiver(VariableKind.ContextReceiver kind2) {
        void $this$mapTo$iv$iv;
        List list2 = this.frameProxy.visibleVariables();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"visibleVariables(...)");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LocalVariableProxyImpl localVariableProxyImpl = (LocalVariableProxyImpl)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new LocalVariableProxyImpl(this.frameProxy, it.getVariable()));
        }
        List variableProxies = (List)destination$iv$iv;
        Result result2 = this.findLocalVariable((List<? extends LocalVariableProxyImpl>)variableProxies, (VariableKind)kind2, (Function1<? super String, Boolean>)((Function1)arg_0 -> VariableFinder.findContextReceiver$lambda$14(kind2, arg_0)));
        if (result2 != null) {
            Result it = result2;
            boolean bl = false;
            return it;
        }
        return this.findCapturedVariableInContainingThis(kind2);
    }

    private final Result findDispatchThis(VariableKind.OuterClassThis kind2) {
        int inlineDepth;
        Result result2;
        Object parentScopeNumbers;
        int scopeNumber;
        Result result3;
        Result result4 = this.findCapturedVariableInContainingThis(kind2);
        if (result4 != null) {
            Result it = result4;
            boolean bl = false;
            return it;
        }
        List<LocalVariableProxyImpl> variables = SafeUtilKt.safeVisibleVariables(this.frameProxy);
        if (this.isInsideDefaultImpls() && (result3 = this.findLocalVariable(variables, (VariableKind)kind2, "$this")) != null) {
            Result it = result3;
            boolean bl = false;
            return it;
        }
        if (this.frameProxy instanceof InlineStackFrameProxyImpl && (scopeNumber = ((InlineStackFrameProxyImpl)this.frameProxy).getInlineScopeNumber()) >= 0) {
            parentScopeNumbers = this.collectParentScopeNumbers(variables, scopeNumber);
            result2 = (Result)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter(this.namedEntitySequence(variables), arg_0 -> VariableFinder.findDispatchThis$lambda$18(parentScopeNumbers, this, kind2, arg_0)), arg_0 -> VariableFinder.findDispatchThis$lambda$19(this, kind2, arg_0)));
            if (result2 != null) {
                Result it = result2;
                boolean bl = false;
                return it;
            }
        }
        if ((inlineDepth = InlineUtilsKt.getInlineDepth(variables)) > 0 && (parentScopeNumbers = (Result)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter(this.namedEntitySequence(variables), arg_0 -> VariableFinder.findDispatchThis$lambda$21(inlineDepth, this, kind2, arg_0)), arg_0 -> VariableFinder.findDispatchThis$lambda$22(this, kind2, arg_0)))) != null) {
            Object it = parentScopeNumbers;
            boolean bl = false;
            return it;
        }
        if (VariableFinder.Companion.getUSE_UNSAFE_FALLBACK()) {
            block9: {
                Object object;
                VariableKind.UnlabeledThis unlabeledThisKind = new VariableKind.UnlabeledThis(kind2.getAsmType());
                result2 = this.findUnlabeledThis(unlabeledThisKind);
                if (result2 != null) {
                    Result it = result2;
                    boolean bl = false;
                    return it;
                }
                for (Object it : (Iterable)SafeUtilKt.safeVisibleVariables(this.frameProxy)) {
                    boolean bl = false;
                    if ((it = this.findCapturedVariable((VariableKind)unlabeledThisKind, this.frameProxy.getValue(it))) == null) continue;
                    object = it;
                    break block9;
                }
                object = result2 = null;
            }
            if (result2 != null) {
                Result it = result2;
                boolean bl = false;
                return it;
            }
        }
        return null;
    }

    private final Result findForeignValue(String foreignValueName, KtCodeFragment codeFragment) {
        Object v1;
        block2: {
            Project project = codeFragment.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            List contextElements = AdditionalContextProvider.Companion.getAllAdditionalContextElements(project, codeFragment.getContext());
            Iterable $this$firstOrNull$iv = contextElements;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AdditionalContextElement it = (AdditionalContextElement)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)foreignValueName)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        AdditionalContextElement additionalContextElement = v1;
        if (additionalContextElement == null) {
            return null;
        }
        AdditionalContextElement element = additionalContextElement;
        return new Result((Value)element.getValue().invoke((Object)this.context.getEvaluationContext()));
    }

    private final Result findUnlabeledThis(VariableKind.UnlabeledThis kind2) {
        List<LocalVariableProxyImpl> variables = SafeUtilKt.safeVisibleVariables(this.frameProxy);
        Result result2 = this.findCapturedVariableInReceiver(variables, kind2);
        if (result2 != null) {
            Result it = result2;
            boolean bl = false;
            return it;
        }
        return this.findCapturedVariableInContainingThis(kind2);
    }

    private final Result findLocalVariable(List<? extends LocalVariableProxyImpl> variables, VariableKind kind2, String name2) {
        return this.findLocalVariable(variables, kind2, (Function1<? super String, Boolean>)((Function1)arg_0 -> VariableFinder.findLocalVariable$lambda$29(name2, arg_0)));
    }

    private final Result findLocalVariable(List<? extends LocalVariableProxyImpl> variables, VariableKind kind2, Function1<? super String, Boolean> namePredicate) {
        Set<Integer> parentScopeNumbers;
        Object object;
        int scopeNumber;
        if (this.frameProxy instanceof InlineStackFrameProxyImpl && (scopeNumber = ((InlineStackFrameProxyImpl)this.frameProxy).getInlineScopeNumber()) >= 0 && (object = this.findLocalVariableByScopeNumber(variables, kind2, parentScopeNumbers = this.collectParentScopeNumbers(variables, scopeNumber), namePredicate)) != null) {
            Object it = object;
            boolean bl = false;
            return it;
        }
        object = this.frameProxy;
        InlineStackFrameProxyImpl inlineStackFrameProxyImpl = object instanceof InlineStackFrameProxyImpl ? (InlineStackFrameProxyImpl)((Object)object) : null;
        int inlineDepth = inlineStackFrameProxyImpl != null ? inlineStackFrameProxyImpl.getInlineDepth() : InlineUtilsKt.getInlineDepth(variables);
        Result result2 = this.findLocalVariable(variables, kind2, inlineDepth, namePredicate);
        if (result2 != null) {
            Result it = result2;
            boolean bl = false;
            return it;
        }
        if (inlineDepth > 0 && VariableFinder.Companion.getUSE_UNSAFE_FALLBACK() && (result2 = this.findLocalVariable(variables, kind2, 0, namePredicate)) != null) {
            Result it = result2;
            boolean bl = false;
            return it;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Integer> collectParentScopeNumbers(List<? extends LocalVariableProxyImpl> variables, int scopeNumber) {
        void var5_7;
        Map scopeNumberToSurroundingScopeNumber = new LinkedHashMap();
        for (LocalVariableProxyImpl localVariableProxyImpl : variables) {
            InlineScopeInfo inlineScopeInfo;
            String name2 = localVariableProxyImpl.name();
            Intrinsics.checkNotNull((Object)name2);
            if (!JvmAbi.isFakeLocalVariableForInline((String)name2) || InlineScopeUtilsKt.getInlineScopeInfo((String)name2) == null) continue;
            int scope = inlineScopeInfo.component1();
            Integer surroundingScope = inlineScopeInfo.component3();
            if (surroundingScope == null || scope < 0 || surroundingScope < 0) continue;
            Integer n = scope;
            scopeNumberToSurroundingScopeNumber.put(n, surroundingScope);
        }
        Set result2 = new LinkedHashSet();
        Integer n = scopeNumber;
        while (var5_7 != null) {
            ((Collection)result2).add(var5_7);
            Integer n2 = (Integer)scopeNumberToSurroundingScopeNumber.get(var5_7);
        }
        return result2;
    }

    private final Result findLocalVariableByScopeNumber(List<? extends LocalVariableProxyImpl> variables, VariableKind kind2, Set<Integer> scopeNumbers, Function1<? super String, Boolean> namePredicate) {
        Sequence namedEntities;
        Sequence $this$sortedByDescending$iv = namedEntities = SequencesKt.plus(this.namedEntitySequence(variables), this.getCoroutineStackFrameNamedEntities());
        boolean $i$f$sortedByDescending = false;
        Sequence sortedEntities = SequencesKt.sortedWith((Sequence)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                NamedEntity it = (NamedEntity)b;
                boolean bl = false;
                InlineScopeInfo inlineScopeInfo = InlineScopeUtilsKt.getInlineScopeInfo((String)it.getName());
                it = (NamedEntity)a;
                Comparable comparable = Integer.valueOf(inlineScopeInfo != null ? inlineScopeInfo.getScopeNumber() : 0);
                bl = false;
                InlineScopeInfo inlineScopeInfo2 = InlineScopeUtilsKt.getInlineScopeInfo((String)it.getName());
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(inlineScopeInfo2 != null ? inlineScopeInfo2.getScopeNumber() : 0));
            }
        });
        return this.findLocalVariable((Sequence<NamedEntity>)sortedEntities, kind2, (Function1<? super String, Boolean>)((Function1)arg_0 -> VariableFinder.findLocalVariableByScopeNumber$lambda$34(namePredicate, scopeNumbers, arg_0)));
    }

    private final Result findLocalVariable(List<? extends LocalVariableProxyImpl> variables, VariableKind kind2, int inlineDepth, Function1<? super String, Boolean> namePredicate) {
        Function1 actualPredicate = null;
        actualPredicate = inlineDepth > 0 ? arg_0 -> VariableFinder.findLocalVariable$lambda$35(namePredicate, inlineDepth, arg_0) : namePredicate;
        Sequence namedEntities = SequencesKt.plus(this.namedEntitySequence(variables), this.getCoroutineStackFrameNamedEntities());
        return this.findLocalVariable((Sequence<NamedEntity>)namedEntities, kind2, (Function1<? super String, Boolean>)actualPredicate);
    }

    private final Result findLocalVariable(Sequence<NamedEntity> namedEntities, VariableKind kind2, Function1<? super String, Boolean> namePredicate) {
        for (NamedEntity item : namedEntities) {
            if (!((Boolean)namePredicate.invoke((Object)item.getName())).booleanValue() || !this.typeMatches(kind2, item.getType())) continue;
            Value rawValue = item.getValue();
            Result result2 = this.evaluatorValueConverter.coerce(this.getUnwrapDelegate(kind2, rawValue), kind2.getAsmType());
            if (result2 == null) continue;
            Result result3 = result2;
            if (!EvaluatorValueConverterKt.isRefType(rawValue) && EvaluatorValueConverterKt.isRefType(result3.getValue())) {
                ((Collection)this.mutableRefWrappers).add(new RefWrapper(item.getName(), result3.getValue()));
            }
            return result3;
        }
        return null;
    }

    private final Sequence<NamedEntity> getCoroutineStackFrameNamedEntities() {
        return this.frameProxy instanceof CoroutineStackFrameProxyImpl ? this.namedEntitySequence(((CoroutineStackFrameProxyImpl)this.frameProxy).getSpilledVariables(), this.context.getEvaluationContext()) : SequencesKt.emptySequence();
    }

    private final boolean isInsideDefaultImpls() {
        Comparable<Location> comparable = SafeUtilKt.safeLocation((StackFrameProxy)this.frameProxy);
        if (comparable == null || (comparable = comparable.declaringType()) == null) {
            return false;
        }
        Comparable<Location> declaringType = comparable;
        String string = declaringType.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        return StringsKt.endsWith$default((String)string, (String)"$DefaultImpls", (boolean)false, (int)2, null);
    }

    private final Result findCoroutineContext() {
        Comparable<Location> comparable = SafeUtilKt.safeLocation((StackFrameProxy)this.frameProxy);
        if (comparable == null || (comparable = SafeUtilKt.safeMethod(comparable)) == null) {
            return null;
        }
        Comparable<Location> method = comparable;
        ObjectReference objectReference = this.findCoroutineContextForLambda((Method)method);
        if (objectReference == null && (objectReference = this.findCoroutineContextForMethod((Method)method)) == null) {
            return null;
        }
        ObjectReference result2 = objectReference;
        return new Result(result2);
    }

    private final ObjectReference findCoroutineContextForLambda(Method method) {
        boolean bl;
        ObjectReference continuation2;
        block6: {
            if (!(Intrinsics.areEqual((Object)method.name(), (Object)"invokeSuspend") && Intrinsics.areEqual((Object)method.signature(), (Object)"(Ljava/lang/Object;)Ljava/lang/Object;") && this.frameProxy instanceof CoroutineStackFrameProxyImpl)) {
                return null;
            }
            ObjectReference objectReference = ((CoroutineStackFrameProxyImpl)this.frameProxy).getContinuation();
            if (objectReference == null) {
                return null;
            }
            continuation2 = objectReference;
            ReferenceType continuationType = continuation2.referenceType();
            Iterable $this$none$iv = CoroutineUtilsKt.getSUSPEND_LAMBDA_CLASSES();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)continuationType);
                    if (!JdiTypeUtils.isSubtype((com.sun.jdi.Type)continuationType, it)) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        if (bl) {
            return null;
        }
        return this.findCoroutineContextForContinuation(continuation2);
    }

    private final ObjectReference findCoroutineContextForMethod(Method method) {
        String string = method.signature();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"signature(...)");
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)(CoroutineUtilsKt.getCONTINUATION_TYPE().getDescriptor() + ")"), (boolean)false, (int)2, null)) {
            return null;
        }
        LocalVariableProxyImpl localVariableProxyImpl = SafeUtilKt.safeVisibleVariableByName(this.frameProxy, "$continuation");
        if (localVariableProxyImpl == null && (localVariableProxyImpl = SafeUtilKt.safeVisibleVariableByName(this.frameProxy, "$completion")) == null) {
            return null;
        }
        LocalVariableProxyImpl continuationVariable = localVariableProxyImpl;
        Value value = this.frameProxy.getValue(continuationVariable);
        ObjectReference objectReference = value instanceof ObjectReference ? (ObjectReference)value : null;
        if (objectReference == null) {
            return null;
        }
        ObjectReference continuation2 = objectReference;
        return this.findCoroutineContextForContinuation(continuation2);
    }

    /*
     * WARNING - void declaration
     */
    private final ObjectReference findCoroutineContextForContinuation(ObjectReference continuation2) {
        InterfaceType interfaceType;
        Object object;
        block7: {
            block6: {
                Object v1;
                block5: {
                    void $this$firstOrNull$iv;
                    ClassType classType;
                    object = continuation2.referenceType();
                    ClassType classType2 = classType = object instanceof ClassType ? (ClassType)object : null;
                    if (classType == null || (object = classType.allInterfaces()) == null) break block6;
                    Iterable iterable = (Iterable)object;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        InterfaceType it = (InterfaceType)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.name(), (Object)Continuation.class.getName())) continue;
                        v1 = element$iv;
                        break block5;
                    }
                    v1 = null;
                }
                interfaceType = v1;
                if (interfaceType != null) break block7;
            }
            return null;
        }
        InterfaceType continuationType = interfaceType;
        Method method = DebuggerUtils.findMethod((ReferenceType)continuationType, (String)"getContext", (String)"()Lkotlin/coroutines/CoroutineContext;");
        if (method == null) {
            return null;
        }
        Method getContextMethod = method;
        object = BaseExecutionContext.invokeMethod$default(this.context, continuation2, getContextMethod, CollectionsKt.emptyList(), 0, false, 24, null);
        return object instanceof ObjectReference ? (ObjectReference)object : null;
    }

    private final Result findCapturedVariableInReceiver(List<? extends LocalVariableProxyImpl> variables, VariableKind kind2) {
        Result result2;
        if (kind2 instanceof VariableKind.ExtensionThis && (result2 = (Result)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter(this.namedEntitySequence(variables), arg_0 -> VariableFinder.findCapturedVariableInReceiver$lambda$38(kind2, this, arg_0)), arg_0 -> VariableFinder.findCapturedVariableInReceiver$lambda$39(this, kind2, arg_0)))) != null) {
            Result it = result2;
            boolean bl = false;
            return it;
        }
        return (Result)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter(this.namedEntitySequence(variables), VariableFinder::findCapturedVariableInReceiver$lambda$41), arg_0 -> VariableFinder.findCapturedVariableInReceiver$lambda$42(this, kind2, arg_0)));
    }

    private final Result findCapturedVariable(VariableKind kind2, Function0<? extends Value> parentFactory) {
        Value parent2 = this.getUnwrapDelegate(kind2, (Value)parentFactory.invoke());
        return this.findCapturedVariable(kind2, parent2);
    }

    private final Result findCapturedVariable(VariableKind kind2, Value parent2) {
        Result result2;
        boolean acceptsParentValue;
        boolean bl = acceptsParentValue = kind2 instanceof VariableKind.UnlabeledThis || kind2 instanceof VariableKind.OuterClassThis;
        if (parent2 != null && acceptsParentValue && this.typeMatches(kind2, parent2.type())) {
            return new Result(parent2);
        }
        Object object = parent2 instanceof ObjectReference ? (ObjectReference)parent2 : null;
        if (object == null || (object = object.referenceType()) == null || (object = object.fields()) == null) {
            return null;
        }
        Object fields = object;
        if (!(kind2 instanceof VariableKind.OuterClassThis)) {
            result2 = (Result)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter(this.namedEntitySequence((List<? extends Field>)fields, (ObjectReference)parent2), arg_0 -> VariableFinder.findCapturedVariable$lambda$43(kind2, this, arg_0)), arg_0 -> VariableFinder.findCapturedVariable$lambda$44(this, kind2, arg_0)));
            if (result2 != null) {
                Result it = result2;
                boolean bl2 = false;
                return it;
            }
            result2 = (Result)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter(this.namedEntitySequence((List<? extends Field>)fields, (ObjectReference)parent2), arg_0 -> VariableFinder.findCapturedVariable$lambda$46(this, arg_0)), arg_0 -> VariableFinder.findCapturedVariable$lambda$47(this, kind2, arg_0)));
            if (result2 != null) {
                Result it = result2;
                boolean bl3 = false;
                return it;
            }
        }
        if ((result2 = (Result)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter(this.namedEntitySequence((List<? extends Field>)fields, (ObjectReference)parent2), VariableFinder::findCapturedVariable$lambda$49), arg_0 -> VariableFinder.findCapturedVariable$lambda$50(this, kind2, arg_0)))) != null) {
            Result it = result2;
            boolean bl4 = false;
            return it;
        }
        return null;
    }

    private final Value getUnwrapDelegate(VariableKind kind2, Value rawValue) {
        if (!(kind2 instanceof VariableKind.Ordinary) || !((VariableKind.Ordinary)kind2).isDelegated()) {
            return rawValue;
        }
        ObjectReference objectReference = rawValue instanceof ObjectReference ? (ObjectReference)rawValue : null;
        if (objectReference == null) {
            return rawValue;
        }
        ObjectReference delegateValue = objectReference;
        Method method = DebuggerUtils.findMethod((ReferenceType)delegateValue.referenceType(), (String)"getValue", (String)"()Ljava/lang/Object;");
        if (method == null) {
            return rawValue;
        }
        Method getValueMethod = method;
        return BaseExecutionContext.invokeMethod$default(this.context, delegateValue, getValueMethod, CollectionsKt.emptyList(), 0, false, 24, null);
    }

    private final boolean isCapturedReceiverFieldName(String name2) {
        String string = AsmUtil.getCapturedFieldName((String)"this_");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCapturedFieldName(...)");
        return StringsKt.startsWith$default((String)name2, (String)string, (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)name2, (Object)"receiver$0");
    }

    private final boolean typeMatches(VariableKind $this$typeMatches, com.sun.jdi.Type actualType) {
        if ($this$typeMatches instanceof VariableKind.Ordinary && ((VariableKind.Ordinary)$this$typeMatches).isDelegated()) {
            return true;
        }
        if ($this$typeMatches instanceof VariableKind.Ordinary) {
            return true;
        }
        return this.evaluatorValueConverter.typeMatches($this$typeMatches.getAsmType(), actualType);
    }

    private final Result unwrapAndCheck(NamedEntity $this$unwrapAndCheck, VariableKind kind2) {
        return this.evaluatorValueConverter.coerce(this.getUnwrapDelegate(kind2, $this$unwrapAndCheck.getValue()), kind2.getAsmType());
    }

    private final Sequence<NamedEntity> namedEntitySequence(List<? extends Field> $this$namedEntitySequence, ObjectReference owner) {
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)$this$namedEntitySequence), arg_0 -> VariableFinder.namedEntitySequence$lambda$52(owner, arg_0));
    }

    private final Sequence<NamedEntity> namedEntitySequence(List<? extends LocalVariableProxyImpl> $this$namedEntitySequence) {
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)$this$namedEntitySequence), arg_0 -> VariableFinder.namedEntitySequence$lambda$53(this, arg_0));
    }

    private final Sequence<NamedEntity> namedEntitySequence(List<? extends JavaValue> $this$namedEntitySequence, EvaluationContextImpl context) {
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)$this$namedEntitySequence), arg_0 -> VariableFinder.namedEntitySequence$lambda$54(context, arg_0));
    }

    private final ObjectReference thisObject() {
        ObjectReference thisObjectFromEvaluation;
        Value value = this.context.getEvaluationContext().computeThisObject();
        ObjectReference objectReference = thisObjectFromEvaluation = value instanceof ObjectReference ? (ObjectReference)value : null;
        if (thisObjectFromEvaluation != null) {
            return thisObjectFromEvaluation;
        }
        return this.frameProxy.thisObject();
    }

    private static final boolean findExtensionThis$lambda$8(VariableKind.ExtensionThis $kind, String name2) {
        return Intrinsics.areEqual((Object)name2, (Object)$kind.getParameterName()) || StringsKt.startsWith$default((String)name2, (String)($kind.getParameterName() + "$"), (boolean)false, (int)2, null);
    }

    private static final boolean findContextReceiver$lambda$14(VariableKind.ContextReceiver $kind, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $kind.capturedNameMatches(it) || StringsKt.startsWith$default((String)it, (String)"$this", (boolean)false, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean findDispatchThis$lambda$18(Set $parentScopeNumbers, VariableFinder this$0, VariableKind.OuterClassThis $kind, NamedEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String name2 = it.getName();
        InlineScopeInfo inlineScopeInfo = InlineScopeUtilsKt.getInlineScopeInfo((String)name2);
        if (inlineScopeInfo == null) return false;
        int variableScopeNumber = inlineScopeInfo.getScopeNumber();
        if (!$parentScopeNumbers.contains(variableScopeNumber)) return false;
        CharSequence charSequence = InlineScopeUtilsKt.dropInlineScopeInfo((String)name2);
        if (!InlineUtilsKt.getINLINED_THIS_REGEX().matches(charSequence)) return false;
        if (!this$0.typeMatches($kind, it.getType())) return false;
        return true;
    }

    private static final Result findDispatchThis$lambda$19(VariableFinder this$0, VariableKind.OuterClassThis $kind, NamedEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.unwrapAndCheck(it, $kind);
    }

    private static final boolean findDispatchThis$lambda$21(int $inlineDepth, VariableFinder this$0, VariableKind.OuterClassThis $kind, NamedEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CharSequence charSequence = it.getName();
        return InlineUtilsKt.getINLINED_THIS_REGEX().matches(charSequence) && InlineUtilsKt.getInlineDepth(it.getName()) == $inlineDepth && this$0.typeMatches($kind, it.getType());
    }

    private static final Result findDispatchThis$lambda$22(VariableFinder this$0, VariableKind.OuterClassThis $kind, NamedEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.unwrapAndCheck(it, $kind);
    }

    private static final boolean findLocalVariable$lambda$29(String $name, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it, (Object)$name);
    }

    private static final boolean findLocalVariableByScopeNumber$lambda$34(Function1 $namePredicate, Set $scopeNumbers, String name2) {
        Integer scope;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        InlineScopeInfo inlineScopeInfo = InlineScopeUtilsKt.getInlineScopeInfo((String)name2);
        Integer n = scope = inlineScopeInfo != null ? Integer.valueOf(inlineScopeInfo.getScopeNumber()) : null;
        return n == null ? (Boolean)$namePredicate.invoke((Object)name2) : ($scopeNumbers.contains(n) ? (Boolean)$namePredicate.invoke((Object)InlineScopeUtilsKt.dropInlineScopeInfo((String)name2)) : false);
    }

    private static final boolean findLocalVariable$lambda$35(Function1<? super String, Boolean> $namePredicate, int $inlineDepth, String name2) {
        int endIndex;
        int depth = 0;
        int suffixLen = 3;
        for (endIndex = name2.length(); endIndex >= suffixLen; endIndex -= suffixLen) {
            String string = name2.substring(endIndex - suffixLen, endIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            if (!Intrinsics.areEqual((Object)string, (Object)"$iv")) break;
            ++depth;
        }
        return (Boolean)$namePredicate.invoke((Object)StringsKt.take((String)name2, (int)endIndex)) != false && InlineUtilsKt.getInlineDepth(name2) == $inlineDepth;
    }

    private static final boolean findCapturedVariableInReceiver$isReceiverOrPassedThis(String name2) {
        return StringsKt.startsWith$default((String)name2, (String)"$this$", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)name2, (Object)"$receiver") || Intrinsics.areEqual((Object)name2, (Object)"$this") || InlineUtilsKt.getINLINED_THIS_REGEX().matches((CharSequence)name2) || Intrinsics.areEqual((Object)name2, (Object)SpecialNames.THIS.asString());
    }

    private static final boolean findCapturedVariableInReceiver$lambda$38(VariableKind $kind, VariableFinder this$0, NamedEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((VariableKind.ExtensionThis)$kind).capturedNameMatches(it.getName()) && this$0.typeMatches($kind, it.getType());
    }

    private static final Result findCapturedVariableInReceiver$lambda$39(VariableFinder this$0, VariableKind $kind, NamedEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.unwrapAndCheck(it, $kind);
    }

    private static final boolean findCapturedVariableInReceiver$lambda$41(NamedEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return VariableFinder.findCapturedVariableInReceiver$isReceiverOrPassedThis(it.getName());
    }

    private static final Result findCapturedVariableInReceiver$lambda$42(VariableFinder this$0, VariableKind $kind, NamedEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.findCapturedVariable($kind, it.getValue());
    }

    private static final boolean findCapturedVariable$lambda$43(VariableKind $kind, VariableFinder this$0, NamedEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $kind.capturedNameMatches(it.getName()) && this$0.typeMatches($kind, it.getType());
    }

    private static final Result findCapturedVariable$lambda$44(VariableFinder this$0, VariableKind $kind, NamedEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.unwrapAndCheck(it, $kind);
    }

    private static final boolean findCapturedVariable$lambda$46(VariableFinder this$0, NamedEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isCapturedReceiverFieldName(it.getName());
    }

    private static final Result findCapturedVariable$lambda$47(VariableFinder this$0, VariableKind $kind, NamedEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.findCapturedVariable($kind, it.getValue());
    }

    private static final boolean findCapturedVariable$lambda$49(NamedEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getName(), (Object)"$this") || Intrinsics.areEqual((Object)it.getName(), (Object)"this$0");
    }

    private static final Result findCapturedVariable$lambda$50(VariableFinder this$0, VariableKind $kind, NamedEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.findCapturedVariable($kind, it.getValue());
    }

    private static final NamedEntity namedEntitySequence$lambda$52(ObjectReference $owner, Field it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return NamedEntity.Companion.of(it, $owner);
    }

    private static final NamedEntity namedEntitySequence$lambda$53(VariableFinder this$0, LocalVariableProxyImpl it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return NamedEntity.Companion.of(it, this$0.frameProxy);
    }

    private static final NamedEntity namedEntitySequence$lambda$54(EvaluationContextImpl $context, JavaValue it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return NamedEntity.Companion.of(it, $context);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$Companion;", "", "<init>", "()V", "USE_UNSAFE_FALLBACK", "", "getUSE_UNSAFE_FALLBACK", "()Z", "getCapturedVariableNameRegex", "Lkotlin/text/Regex;", "capturedName", "", "kotlin.jvm-debugger.evaluation"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean getUSE_UNSAFE_FALLBACK() {
            return true;
        }

        private final Regex getCapturedVariableNameRegex(String capturedName) {
            String escapedName = Regex.Companion.escape(capturedName);
            String escapedSuffix = Regex.Companion.escape("$inlined");
            return new Regex("^" + escapedName + "(?:" + escapedSuffix + ")?$");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0005\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$NamedEntity;", "", "name", "", "lazyType", "Lkotlin/Lazy;", "Lcom/sun/jdi/Type;", "lazyValue", "Lcom/sun/jdi/Value;", "<init>", "(Ljava/lang/String;Lkotlin/Lazy;Lkotlin/Lazy;)V", "getName", "()Ljava/lang/String;", "getLazyType", "()Lkotlin/Lazy;", "getLazyValue", "type", "getType", "()Lcom/sun/jdi/Type;", "value", "getValue", "()Lcom/sun/jdi/Value;", "Companion", "kotlin.jvm-debugger.evaluation"})
    private static final class NamedEntity {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String name;
        @NotNull
        private final Lazy<com.sun.jdi.Type> lazyType;
        @NotNull
        private final Lazy<Value> lazyValue;

        public NamedEntity(@NotNull String name2, @NotNull Lazy<? extends com.sun.jdi.Type> lazyType, @NotNull Lazy<? extends Value> lazyValue) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter(lazyType, (String)"lazyType");
            Intrinsics.checkNotNullParameter(lazyValue, (String)"lazyValue");
            this.name = name2;
            this.lazyType = lazyType;
            this.lazyValue = lazyValue;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final Lazy<com.sun.jdi.Type> getLazyType() {
            return this.lazyType;
        }

        @NotNull
        public final Lazy<Value> getLazyValue() {
            return this.lazyValue;
        }

        @Nullable
        public final com.sun.jdi.Type getType() {
            return (com.sun.jdi.Type)this.lazyType.getValue();
        }

        @Nullable
        public final Value getValue() {
            return (Value)this.lazyValue.getValue();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$NamedEntity$Companion;", "", "<init>", "()V", "of", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$NamedEntity;", "field", "Lcom/sun/jdi/Field;", "owner", "Lcom/sun/jdi/ObjectReference;", "variable", "Lcom/intellij/debugger/jdi/LocalVariableProxyImpl;", "frameProxy", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "Lcom/intellij/debugger/engine/JavaValue;", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "kotlin.jvm-debugger.evaluation"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final NamedEntity of(@NotNull Field field2, @NotNull ObjectReference owner) {
                Intrinsics.checkNotNullParameter((Object)field2, (String)"field");
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                Lazy type2 = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> Companion.of$lambda$0(field2));
                Lazy value = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> Companion.of$lambda$1(owner, field2));
                String string = field2.name();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
                return new NamedEntity(string, (Lazy<? extends com.sun.jdi.Type>)type2, (Lazy<? extends Value>)value);
            }

            @NotNull
            public final NamedEntity of(@NotNull LocalVariableProxyImpl variable, @NotNull StackFrameProxyImpl frameProxy) {
                Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
                Intrinsics.checkNotNullParameter((Object)frameProxy, (String)"frameProxy");
                Lazy type2 = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> Companion.of$lambda$2(variable));
                Lazy value = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> Companion.of$lambda$3(frameProxy, variable));
                String string = variable.name();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
                return new NamedEntity(string, (Lazy<? extends com.sun.jdi.Type>)type2, (Lazy<? extends Value>)value);
            }

            @NotNull
            public final NamedEntity of(@NotNull JavaValue variable, @NotNull EvaluationContextImpl context) {
                Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Lazy type2 = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> Companion.of$lambda$4(variable));
                Lazy value = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> Companion.of$lambda$5(variable, context));
                String string = variable.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                return new NamedEntity(string, (Lazy<? extends com.sun.jdi.Type>)type2, (Lazy<? extends Value>)value);
            }

            private static final com.sun.jdi.Type of$lambda$0(Field $field) {
                return SafeUtilKt.safeType($field);
            }

            private static final Value of$lambda$1(ObjectReference $owner, Field $field) {
                return $owner.getValue($field);
            }

            private static final com.sun.jdi.Type of$lambda$2(LocalVariableProxyImpl $variable) {
                return SafeUtilKt.safeType($variable);
            }

            private static final Value of$lambda$3(StackFrameProxyImpl $frameProxy, LocalVariableProxyImpl $variable) {
                return $frameProxy.getValue($variable);
            }

            private static final com.sun.jdi.Type of$lambda$4(JavaValue $variable) {
                return $variable.getDescriptor().getType();
            }

            private static final Value of$lambda$5(JavaValue $variable, EvaluationContextImpl $context) {
                ValueDescriptorImpl valueDescriptorImpl = $variable.getDescriptor();
                Intrinsics.checkNotNullExpressionValue((Object)valueDescriptorImpl, (String)"getDescriptor(...)");
                return SafeUtilKt.safeCalcValue(valueDescriptorImpl, $context);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$RefWrapper;", "", "localVariableName", "", "wrapper", "Lcom/sun/jdi/Value;", "<init>", "(Ljava/lang/String;Lcom/sun/jdi/Value;)V", "getLocalVariableName", "()Ljava/lang/String;", "getWrapper", "()Lcom/sun/jdi/Value;", "kotlin.jvm-debugger.evaluation"})
    public static final class RefWrapper {
        @NotNull
        private final String localVariableName;
        @Nullable
        private final Value wrapper;

        public RefWrapper(@NotNull String localVariableName, @Nullable Value wrapper) {
            Intrinsics.checkNotNullParameter((Object)localVariableName, (String)"localVariableName");
            this.localVariableName = localVariableName;
            this.wrapper = wrapper;
        }

        @NotNull
        public final String getLocalVariableName() {
            return this.localVariableName;
        }

        @Nullable
        public final Value getWrapper() {
            return this.wrapper;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$Result;", "", "value", "Lcom/sun/jdi/Value;", "<init>", "(Lcom/sun/jdi/Value;)V", "getValue", "()Lcom/sun/jdi/Value;", "kotlin.jvm-debugger.evaluation"})
    public static final class Result {
        @Nullable
        private final Value value;

        public Result(@Nullable Value value) {
            this.value = value;
        }

        @Nullable
        public final Value getValue() {
            return this.value;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0007\f\r\u000e\u000f\u0010\u0011\u0012B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0007\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind;", "", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "<init>", "(Lorg/jetbrains/org/objectweb/asm/Type;)V", "getAsmType", "()Lorg/jetbrains/org/objectweb/asm/Type;", "capturedNameMatches", "", "name", "", "Ordinary", "LocalFunction", "UnlabeledThis", "OuterClassThis", "FieldVar", "ExtensionThis", "ContextReceiver", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$ContextReceiver;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$ExtensionThis;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$FieldVar;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$LocalFunction;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$Ordinary;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$OuterClassThis;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$UnlabeledThis;", "kotlin.jvm-debugger.evaluation"})
    public static abstract class VariableKind {
        @NotNull
        private final Type asmType;

        private VariableKind(Type asmType) {
            this.asmType = asmType;
        }

        @NotNull
        public final Type getAsmType() {
            return this.asmType;
        }

        public abstract boolean capturedNameMatches(@NotNull String var1);

        public /* synthetic */ VariableKind(Type asmType, DefaultConstructorMarker $constructor_marker) {
            this(asmType);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$ContextReceiver;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind;", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "<init>", "(Lorg/jetbrains/org/objectweb/asm/Type;)V", "capturedNameMatches", "", "name", "", "kotlin.jvm-debugger.evaluation"})
        public static final class ContextReceiver
        extends VariableKind {
            public ContextReceiver(@NotNull Type asmType) {
                Intrinsics.checkNotNullParameter((Object)asmType, (String)"asmType");
                super(asmType, null);
            }

            @Override
            public boolean capturedNameMatches(@NotNull String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return StringsKt.startsWith$default((String)name2, (String)NameUtils.getCONTEXT_RECEIVER_PREFIX(), (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name2, (String)("$" + NameUtils.getCONTEXT_RECEIVER_PREFIX()), (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name2, (String)"_context_receiver", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name2, (String)"$_context_receiver", (boolean)false, (int)2, null);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$ExtensionThis;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind;", "label", "", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "<init>", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/Type;)V", "getLabel", "()Ljava/lang/String;", "parameterName", "getParameterName", "fieldName", "getFieldName", "capturedNameRegex", "Lkotlin/text/Regex;", "capturedNameMatches", "", "name", "kotlin.jvm-debugger.evaluation"})
        public static final class ExtensionThis
        extends VariableKind {
            @NotNull
            private final String label;
            @NotNull
            private final String parameterName;
            @NotNull
            private final String fieldName;
            @NotNull
            private final Regex capturedNameRegex;

            public ExtensionThis(@NotNull String label2, @NotNull Type asmType) {
                Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
                Intrinsics.checkNotNullParameter((Object)asmType, (String)"asmType");
                super(asmType, null);
                this.label = label2;
                String string = AsmUtil.getLabeledThisName((String)this.label, (String)"$this$", (String)"$receiver");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLabeledThisName(...)");
                this.parameterName = string;
                String string2 = AsmUtil.getLabeledThisName((String)this.label, (String)AsmUtil.getCapturedFieldName((String)"this_"), (String)"receiver$0");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLabeledThisName(...)");
                this.fieldName = string2;
                this.capturedNameRegex = Companion.getCapturedVariableNameRegex(this.fieldName);
            }

            @NotNull
            public final String getLabel() {
                return this.label;
            }

            @NotNull
            public final String getParameterName() {
                return this.parameterName;
            }

            @NotNull
            public final String getFieldName() {
                return this.fieldName;
            }

            @Override
            public boolean capturedNameMatches(@NotNull String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return this.capturedNameRegex.matches((CharSequence)name2);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$FieldVar;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind;", "fieldName", "", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "<init>", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/Type;)V", "getFieldName", "()Ljava/lang/String;", "capturedNameMatches", "", "name", "kotlin.jvm-debugger.evaluation"})
        public static final class FieldVar
        extends VariableKind {
            @NotNull
            private final String fieldName;

            public FieldVar(@NotNull String fieldName, @NotNull Type asmType) {
                Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
                Intrinsics.checkNotNullParameter((Object)asmType, (String)"asmType");
                super(asmType, null);
                this.fieldName = fieldName;
            }

            @NotNull
            public final String getFieldName() {
                return this.fieldName;
            }

            @Override
            public boolean capturedNameMatches(@NotNull String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return false;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$LocalFunction;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind;", "name", "", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "<init>", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/Type;)V", "getName", "()Ljava/lang/String;", "capturedNameMatches", "", "kotlin.jvm-debugger.evaluation"})
        public static final class LocalFunction
        extends VariableKind {
            @NotNull
            private final String name;

            public LocalFunction(@NotNull String name2, @NotNull Type asmType) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter((Object)asmType, (String)"asmType");
                super(asmType, null);
                this.name = name2;
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            @Override
            public boolean capturedNameMatches(@NotNull String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return Intrinsics.areEqual((Object)name2, (Object)("$" + name2));
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$Ordinary;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind;", "name", "", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "isDelegated", "", "<init>", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/Type;Z)V", "getName", "()Ljava/lang/String;", "()Z", "capturedNameRegex", "Lkotlin/text/Regex;", "capturedNameMatches", "kotlin.jvm-debugger.evaluation"})
        public static final class Ordinary
        extends VariableKind {
            @NotNull
            private final String name;
            private final boolean isDelegated;
            @NotNull
            private final Regex capturedNameRegex;

            public Ordinary(@NotNull String name2, @NotNull Type asmType, boolean isDelegated) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter((Object)asmType, (String)"asmType");
                super(asmType, null);
                this.name = name2;
                this.isDelegated = isDelegated;
                String string = AsmUtil.getCapturedFieldName((String)this.name);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCapturedFieldName(...)");
                this.capturedNameRegex = Companion.getCapturedVariableNameRegex(string);
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            public final boolean isDelegated() {
                return this.isDelegated;
            }

            @Override
            public boolean capturedNameMatches(@NotNull String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return this.capturedNameRegex.matches((CharSequence)name2);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$OuterClassThis;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind;", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "<init>", "(Lorg/jetbrains/org/objectweb/asm/Type;)V", "capturedNameMatches", "", "name", "", "kotlin.jvm-debugger.evaluation"})
        public static final class OuterClassThis
        extends VariableKind {
            public OuterClassThis(@NotNull Type asmType) {
                Intrinsics.checkNotNullParameter((Object)asmType, (String)"asmType");
                super(asmType, null);
            }

            @Override
            public boolean capturedNameMatches(@NotNull String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return false;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$UnlabeledThis;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind;", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "<init>", "(Lorg/jetbrains/org/objectweb/asm/Type;)V", "capturedNameMatches", "", "name", "", "kotlin.jvm-debugger.evaluation"})
        public static final class UnlabeledThis
        extends VariableKind {
            public UnlabeledThis(@NotNull Type asmType) {
                Intrinsics.checkNotNullParameter((Object)asmType, (String)"asmType");
                super(asmType, null);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean capturedNameMatches(@NotNull String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                if (Intrinsics.areEqual((Object)name2, (Object)"receiver$0")) return true;
                String string = AsmUtil.getCapturedFieldName((String)"this_");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCapturedFieldName(...)");
                if (!StringsKt.startsWith$default((String)name2, (String)string, (boolean)false, (int)2, null)) return false;
                return true;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CodeFragmentParameter.Kind.values().length];
            try {
                nArray[CodeFragmentParameter.Kind.ORDINARY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodeFragmentParameter.Kind.DELEGATED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodeFragmentParameter.Kind.FAKE_JAVA_OUTER_CLASS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodeFragmentParameter.Kind.EXTENSION_RECEIVER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodeFragmentParameter.Kind.CONTEXT_RECEIVER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodeFragmentParameter.Kind.LOCAL_FUNCTION.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodeFragmentParameter.Kind.DISPATCH_RECEIVER.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodeFragmentParameter.Kind.COROUTINE_CONTEXT.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodeFragmentParameter.Kind.FIELD_VAR.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodeFragmentParameter.Kind.FOREIGN_VALUE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

