/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.sequence.resolve;

import com.intellij.debugger.streams.core.resolve.ValuesOrderResolver;
import com.intellij.debugger.streams.core.trace.TraceElement;
import com.intellij.debugger.streams.core.trace.TraceInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u001c\u0010\r\u001a\u00020\u00052\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00100\u000fH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/sequence/resolve/WindowedResolver;", "Lcom/intellij/debugger/streams/core/resolve/ValuesOrderResolver;", "<init>", "()V", "resolve", "Lcom/intellij/debugger/streams/core/resolve/ValuesOrderResolver$Result;", "info", "Lcom/intellij/debugger/streams/core/trace/TraceInfo;", "calcWindowSize", "", "before", "", "after", "emptyTransitions", "indexBefore", "", "Lcom/intellij/debugger/streams/core/trace/TraceElement;", "kotlin.jvm-debugger.sequence.k1"})
@SourceDebugExtension(value={"SMAP\nWindowedResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowedResolver.kt\norg/jetbrains/kotlin/idea/debugger/sequence/resolve/WindowedResolver\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,58:1\n607#2:59\n662#2:60\n743#2,4:61\n*S KotlinDebug\n*F\n+ 1 WindowedResolver.kt\norg/jetbrains/kotlin/idea/debugger/sequence/resolve/WindowedResolver\n*L\n55#1:59\n55#1:60\n55#1:61,4\n*E\n"})
public final class WindowedResolver
implements ValuesOrderResolver {
    @NotNull
    public ValuesOrderResolver.Result resolve(@NotNull TraceInfo info2) {
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        Map map2 = info2.getValuesOrderBefore();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getValuesOrderBefore(...)");
        Map indexBefore = map2;
        Map map3 = info2.getValuesOrderAfter();
        Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"getValuesOrderAfter(...)");
        Map indexAfter = map3;
        int[] timesBefore = CollectionsKt.toIntArray((Collection)CollectionsKt.sorted((Iterable)indexBefore.keySet()));
        int[] timesAfter = CollectionsKt.toIntArray((Collection)CollectionsKt.sorted((Iterable)indexAfter.keySet()));
        if (timesAfter.length == 0) {
            return this.emptyTransitions(indexBefore);
        }
        Map direct = new LinkedHashMap();
        Map reverse = new LinkedHashMap();
        int windowStartIndex = 0;
        int windowEndIndex = this.calcWindowSize(timesBefore, timesAfter);
        int n = timesAfter.length;
        for (int j = 0; j < n; ++j) {
            int timeAfter = timesAfter[j];
            if (windowEndIndex == timesAfter.length) {
                ++windowStartIndex;
            } else {
                while (windowEndIndex < timesBefore.length && timesBefore[windowEndIndex] < timeAfter) {
                    ++windowStartIndex;
                    ++windowEndIndex;
                }
            }
            List window = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)RangesKt.until((int)windowStartIndex, (int)windowEndIndex))), arg_0 -> WindowedResolver.resolve$lambda$0(indexBefore, timesBefore, arg_0)));
            Object v = indexAfter.get(timeAfter);
            Intrinsics.checkNotNull(v);
            TraceElement mappedElement = (TraceElement)v;
            for (TraceElement item : window) {
                direct.computeIfAbsent(item, arg_0 -> WindowedResolver.resolve$lambda$2(WindowedResolver::resolve$lambda$1, arg_0)).add(mappedElement);
            }
            reverse.put(mappedElement, window);
        }
        ValuesOrderResolver.Result result2 = ValuesOrderResolver.Result.of((Map)direct, (Map)reverse);
        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"of(...)");
        return result2;
    }

    private final int calcWindowSize(int[] before, int[] after) {
        int size;
        for (size = 0; size < before.length && before[size] < after[0]; ++size) {
        }
        return size;
    }

    /*
     * WARNING - void declaration
     */
    private final ValuesOrderResolver.Result emptyTransitions(Map<Integer, TraceElement> indexBefore) {
        void $this$associateTo$iv$iv;
        Sequence $this$sortedBy$iv = MapsKt.asSequence(indexBefore);
        boolean $i$f$sortedBy = false;
        Sequence $this$associate$iv = SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Integer)it.getKey();
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getKey()));
            }
        });
        boolean $i$f$associate = false;
        Sequence sequence = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to(it.getValue(), (Object)CollectionsKt.emptyList());
            map2.put(pair.getFirst(), pair.getSecond());
        }
        Map direct = destination$iv$iv;
        ValuesOrderResolver.Result result2 = ValuesOrderResolver.Result.of((Map)direct, (Map)MapsKt.emptyMap());
        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"of(...)");
        return result2;
    }

    private static final TraceElement resolve$lambda$0(Map $indexBefore, int[] $timesBefore, int it) {
        Object v = $indexBefore.get($timesBefore[it]);
        Intrinsics.checkNotNull(v);
        return (TraceElement)v;
    }

    private static final List resolve$lambda$1(TraceElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List resolve$lambda$2(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }
}

