/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.sequence.trace.impl.interpret;

import com.intellij.debugger.streams.core.trace.ArrayReference;
import com.intellij.debugger.streams.core.trace.TraceElement;
import com.intellij.debugger.streams.core.trace.Value;
import com.intellij.debugger.streams.core.trace.impl.interpret.ex.UnexpectedValueException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/sequence/trace/impl/interpret/InterpreterUtil;", "", "<init>", "()V", "extractMap", "Lorg/jetbrains/kotlin/idea/debugger/sequence/trace/impl/interpret/InterpreterUtil$MapRepresentation;", "value", "Lcom/intellij/debugger/streams/core/trace/Value;", "createIndexByTime", "", "", "Lcom/intellij/debugger/streams/core/trace/TraceElement;", "elements", "", "MapRepresentation", "kotlin.jvm-debugger.sequence.k1"})
@SourceDebugExtension(value={"SMAP\nInterpreterUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InterpreterUtil.kt\norg/jetbrains/kotlin/idea/debugger/sequence/trace/impl/interpret/InterpreterUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,33:1\n1202#2,2:34\n1230#2,4:36\n*S KotlinDebug\n*F\n+ 1 InterpreterUtil.kt\norg/jetbrains/kotlin/idea/debugger/sequence/trace/impl/interpret/InterpreterUtil\n*L\n28#1:34,2\n28#1:36,4\n*E\n"})
public final class InterpreterUtil {
    @NotNull
    public static final InterpreterUtil INSTANCE = new InterpreterUtil();

    private InterpreterUtil() {
    }

    @NotNull
    public final MapRepresentation extractMap(@NotNull Value value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!(value instanceof ArrayReference) || ((ArrayReference)value).length() != 2) {
            throw new UnexpectedValueException("Map should be represented by array with two nested arrays: keys and values");
        }
        Value keys = ((ArrayReference)value).getValue(0);
        Value values2 = ((ArrayReference)value).getValue(1);
        if (!(keys instanceof ArrayReference) || !(values2 instanceof ArrayReference) || ((ArrayReference)keys).length() != ((ArrayReference)values2).length()) {
            throw new UnexpectedValueException("Keys and values should be arrays with equal counts of elements");
        }
        return new MapRepresentation((ArrayReference)keys, (ArrayReference)values2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Integer, TraceElement> createIndexByTime(@NotNull List<? extends TraceElement> elements) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Iterable $this$associateBy$iv = elements;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void elem;
            TraceElement traceElement = (TraceElement)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(elem.getTime(), element$iv$iv);
        }
        return destination$iv$iv;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/sequence/trace/impl/interpret/InterpreterUtil$MapRepresentation;", "", "keys", "Lcom/intellij/debugger/streams/core/trace/ArrayReference;", "values", "<init>", "(Lcom/intellij/debugger/streams/core/trace/ArrayReference;Lcom/intellij/debugger/streams/core/trace/ArrayReference;)V", "getKeys", "()Lcom/intellij/debugger/streams/core/trace/ArrayReference;", "getValues", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.jvm-debugger.sequence.k1"})
    public static final class MapRepresentation {
        @NotNull
        private final ArrayReference keys;
        @NotNull
        private final ArrayReference values;

        public MapRepresentation(@NotNull ArrayReference keys, @NotNull ArrayReference values2) {
            Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
            Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
            this.keys = keys;
            this.values = values2;
        }

        @NotNull
        public final ArrayReference getKeys() {
            return this.keys;
        }

        @NotNull
        public final ArrayReference getValues() {
            return this.values;
        }

        @NotNull
        public final ArrayReference component1() {
            return this.keys;
        }

        @NotNull
        public final ArrayReference component2() {
            return this.values;
        }

        @NotNull
        public final MapRepresentation copy(@NotNull ArrayReference keys, @NotNull ArrayReference values2) {
            Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
            Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
            return new MapRepresentation(keys, values2);
        }

        public static /* synthetic */ MapRepresentation copy$default(MapRepresentation mapRepresentation, ArrayReference arrayReference, ArrayReference arrayReference2, int n, Object object) {
            if ((n & 1) != 0) {
                arrayReference = mapRepresentation.keys;
            }
            if ((n & 2) != 0) {
                arrayReference2 = mapRepresentation.values;
            }
            return mapRepresentation.copy(arrayReference, arrayReference2);
        }

        @NotNull
        public String toString() {
            return "MapRepresentation(keys=" + this.keys + ", values=" + this.values + ")";
        }

        public int hashCode() {
            int result2 = this.keys.hashCode();
            result2 = result2 * 31 + this.values.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MapRepresentation)) {
                return false;
            }
            MapRepresentation mapRepresentation = (MapRepresentation)other;
            if (!Intrinsics.areEqual((Object)this.keys, (Object)mapRepresentation.keys)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.values, (Object)mapRepresentation.values);
        }
    }
}

