/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.text.CharArrayUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kdoc.psi.api.KDoc;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J2\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KDocCopyPastePreProcessor;", "Lcom/intellij/codeInsight/editorActions/CopyPastePreProcessor;", "<init>", "()V", "preprocessOnCopy", "", "file", "Lcom/intellij/psi/PsiFile;", "startOffsets", "", "endOffsets", "text", "", "preprocessOnPaste", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "rawText", "Lcom/intellij/openapi/editor/RawText;", "kotlin.ide"})
@SourceDebugExtension(value={"SMAP\nKDocCopyPastePreProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KDocCopyPastePreProcessor.kt\norg/jetbrains/kotlin/idea/editor/KDocCopyPastePreProcessor\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,39:1\n66#2,2:40\n130#3,2:42\n*S KotlinDebug\n*F\n+ 1 KDocCopyPastePreProcessor.kt\norg/jetbrains/kotlin/idea/editor/KDocCopyPastePreProcessor\n*L\n23#1:40,2\n26#1:42,2\n*E\n"})
public final class KDocCopyPastePreProcessor
implements CopyPastePreProcessor {
    @Nullable
    public Void preprocessOnCopy(@NotNull PsiFile file, @NotNull int[] startOffsets, @NotNull int[] endOffsets, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startOffsets, (String)"startOffsets");
        Intrinsics.checkNotNullParameter((Object)endOffsets, (String)"endOffsets");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return null;
    }

    @NotNull
    public String preprocessOnPaste(@NotNull Project project, @NotNull PsiFile file, @NotNull Editor editor, @NotNull String text, @Nullable RawText rawText) {
        int withSelf$iv;
        int offset;
        block11: {
            block10: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                if (!(file instanceof KtFile)) {
                    return text;
                }
                offset = editor.getSelectionModel().getSelectionStart();
                PsiElement element = ((KtFile)file).findElementAt(offset);
                PsiElement psiElement = element;
                if (psiElement == null) break block10;
                PsiElement $this$parentOfType_u24default$iv = psiElement;
                withSelf$iv = 0;
                boolean $i$f$parentOfType = false;
                psiElement = (KDoc)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KDoc.class, (boolean)true);
                if (psiElement != null) break block11;
            }
            return text;
        }
        if (DocumentUtil.isAtLineEnd((int)offset, (Document)editor.getDocument()) && StringsKt.startsWith$default((String)text, (String)"\n", (boolean)false, (int)2, null)) {
            Character c;
            block9: {
                CharSequence $this$firstOrNull$iv = text;
                boolean $i$f$firstOrNull = false;
                for (withSelf$iv = 0; withSelf$iv < $this$firstOrNull$iv.length(); ++withSelf$iv) {
                    char element$iv;
                    char it = element$iv = $this$firstOrNull$iv.charAt(withSelf$iv);
                    boolean bl = false;
                    if (!(!StringsKt.contains$default((CharSequence)" \n\t", (char)it, (boolean)false, (int)2, null))) continue;
                    c = Character.valueOf(element$iv);
                    break block9;
                }
                c = null;
            }
            char $this$firstOrNull$iv = '*';
            if (c != null && c.charValue() == $this$firstOrNull$iv) {
                return text;
            }
        }
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        int lineStartOffset = DocumentUtil.getLineStartOffset((int)offset, (Document)document2);
        CharSequence charSequence = document2.getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
        CharSequence chars = charSequence;
        int firstNonWsLineOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)lineStartOffset, (String)" \t");
        if (firstNonWsLineOffset >= offset || chars.charAt(firstNonWsLineOffset) != '*') {
            return text;
        }
        String lineStartReplacement = "\n" + chars.subSequence(lineStartOffset, firstNonWsLineOffset + 1) + " ";
        return StringsKt.replace$default((String)text, (String)"\n", (String)lineStartReplacement, (boolean)false, (int)4, null);
    }
}

