/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradle.configuration.klib;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FileTreeWalk;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.gradle.configuration.klib.KlibInfo;
import org.jetbrains.kotlin.idea.gradle.configuration.klib.KlibInfoProvider;
import org.jetbrains.kotlin.idea.gradle.configuration.klib.KlibManifestProvider;
import org.jetbrains.kotlin.konan.properties.PropertiesKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u00172\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/gradle/configuration/klib/DefaultKlibInfoProvider;", "Lorg/jetbrains/kotlin/idea/gradle/configuration/klib/KlibInfoProvider;", "kotlinNativeHome", "Ljava/io/File;", "manifestProvider", "Lorg/jetbrains/kotlin/idea/gradle/configuration/klib/KlibManifestProvider;", "<init>", "(Ljava/io/File;Lorg/jetbrains/kotlin/idea/gradle/configuration/klib/KlibManifestProvider;)V", "nativeDistributionLibrarySourceFiles", "", "getNativeDistributionLibrarySourceFiles", "()Ljava/util/List;", "nativeDistributionLibrarySourceFiles$delegate", "Lkotlin/Lazy;", "getKlibInfo", "Lorg/jetbrains/kotlin/idea/gradle/configuration/klib/KlibInfo;", "libraryFile", "getCommonizedKlibInfo", "manifest", "Ljava/util/Properties;", "getLibraryNameFromManifest", "", "findLibrarySources", "", "kotlin.gradle.gradle"})
@SourceDebugExtension(value={"SMAP\nCommonizedKlibInfoProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonizedKlibInfoProvider.kt\norg/jetbrains/kotlin/idea/gradle/configuration/klib/DefaultKlibInfoProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n1#2:95\n865#3,2:96\n*S KotlinDebug\n*F\n+ 1 CommonizedKlibInfoProvider.kt\norg/jetbrains/kotlin/idea/gradle/configuration/klib/DefaultKlibInfoProvider\n*L\n91#1:96,2\n*E\n"})
public final class DefaultKlibInfoProvider
implements KlibInfoProvider {
    @NotNull
    private final File kotlinNativeHome;
    @NotNull
    private final KlibManifestProvider manifestProvider;
    @NotNull
    private final Lazy nativeDistributionLibrarySourceFiles$delegate;

    public DefaultKlibInfoProvider(@NotNull File kotlinNativeHome, @NotNull KlibManifestProvider manifestProvider) {
        Intrinsics.checkNotNullParameter((Object)kotlinNativeHome, (String)"kotlinNativeHome");
        Intrinsics.checkNotNullParameter((Object)manifestProvider, (String)"manifestProvider");
        this.kotlinNativeHome = kotlinNativeHome;
        this.manifestProvider = manifestProvider;
        this.nativeDistributionLibrarySourceFiles$delegate = LazyKt.lazy(() -> DefaultKlibInfoProvider.nativeDistributionLibrarySourceFiles_delegate$lambda$2(this));
    }

    public /* synthetic */ DefaultKlibInfoProvider(File file, KlibManifestProvider klibManifestProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            klibManifestProvider = KlibManifestProvider.Companion.default();
        }
        this(file, klibManifestProvider);
    }

    private final List<File> getNativeDistributionLibrarySourceFiles() {
        Lazy lazy = this.nativeDistributionLibrarySourceFiles$delegate;
        return (List)lazy.getValue();
    }

    @Override
    @Nullable
    public KlibInfo getKlibInfo(@NotNull File libraryFile) {
        Intrinsics.checkNotNullParameter((Object)libraryFile, (String)"libraryFile");
        Path path2 = libraryFile.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
        Properties properties = this.manifestProvider.getManifest(path2);
        if (properties == null) {
            return null;
        }
        Properties manifest = properties;
        if (PropertiesKt.hasProperty$default((Properties)manifest, (String)"commonizer_target", null, (int)2, null)) {
            return this.getCommonizedKlibInfo(libraryFile, manifest);
        }
        return this.getKlibInfo(libraryFile, manifest);
    }

    private final KlibInfo getCommonizedKlibInfo(File libraryFile, Properties manifest) {
        String string = this.getLibraryNameFromManifest(manifest);
        if (string == null) {
            return null;
        }
        String string2 = manifest.getProperty("commonizer_target");
        if (string2 == null) {
            return null;
        }
        return new KlibInfo(libraryFile, CollectionsKt.emptyList(), string, false, true, FilesKt.startsWith((File)libraryFile, (File)this.kotlinNativeHome), new KlibInfo.NativeTargets.CommonizerIdentity(string2));
    }

    /*
     * WARNING - void declaration
     */
    private final KlibInfo getKlibInfo(File libraryFile, Properties manifest) {
        KlibInfo.NativeTargets.NativeTargetsList nativeTargetsList;
        String string = this.getLibraryNameFromManifest(manifest);
        if (string == null) {
            return null;
        }
        String libraryName = string;
        boolean isFromNativeDistribution = FilesKt.startsWith((File)libraryFile, (File)this.kotlinNativeHome);
        boolean isStdlib = isFromNativeDistribution && Intrinsics.areEqual((Object)libraryName, (Object)"stdlib");
        File file = libraryFile;
        Collection collection = this.findLibrarySources(libraryFile, manifest);
        String string2 = libraryName;
        boolean bl = isStdlib;
        boolean bl2 = false;
        boolean bl3 = isFromNativeDistribution;
        String string3 = manifest.getProperty("native_targets");
        if (string3 != null) {
            void p0;
            String string4 = string3;
            boolean bl4 = bl3;
            boolean bl5 = bl2;
            boolean bl6 = bl;
            String string5 = string2;
            Collection collection2 = collection;
            File file2 = file;
            boolean bl7 = false;
            KlibInfo.NativeTargets.NativeTargetsList nativeTargetsList2 = new KlibInfo.NativeTargets.NativeTargetsList((String)p0);
            file = file2;
            collection = collection2;
            string2 = string5;
            bl = bl6;
            bl2 = bl5;
            bl3 = bl4;
            nativeTargetsList = nativeTargetsList2;
        } else {
            nativeTargetsList = null;
        }
        KlibInfo.NativeTargets nativeTargets = nativeTargetsList;
        boolean bl8 = bl3;
        boolean bl9 = bl2;
        boolean bl10 = bl;
        String string6 = string2;
        Collection collection3 = collection;
        File file3 = file;
        return new KlibInfo(file3, collection3, string6, bl10, bl9, bl8, nativeTargets);
    }

    private final String getLibraryNameFromManifest(Properties manifest) {
        String string = manifest.getProperty("short_name");
        if (string == null) {
            string = manifest.getProperty("unique_name");
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<File> findLibrarySources(File libraryFile, Properties manifest) {
        void destination$iv;
        void $this$filterTo$iv;
        if (!FilesKt.startsWith((File)libraryFile, (File)this.kotlinNativeHome)) {
            return SetsKt.emptySet();
        }
        String string = this.getLibraryNameFromManifest(manifest);
        if (string == null) {
            return SetsKt.emptySet();
        }
        String libraryName = string;
        Function1 nameFilter2 = Intrinsics.areEqual((Object)libraryName, (Object)"stdlib") ? DefaultKlibInfoProvider::findLibrarySources$lambda$3 : arg_0 -> DefaultKlibInfoProvider.findLibrarySources$lambda$4(libraryName, arg_0);
        Iterable iterable = this.getNativeDistributionLibrarySourceFiles();
        Collection collection = new LinkedHashSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            String string2 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            if (!((Boolean)nameFilter2.invoke((Object)string2)).booleanValue()) continue;
            destination$iv.add(element$iv);
        }
        return (Set)destination$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean nativeDistributionLibrarySourceFiles_delegate$lambda$2$lambda$1(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!it.isFile()) return false;
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!StringsKt.endsWith$default((String)string, (String)".zip", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private static final List nativeDistributionLibrarySourceFiles_delegate$lambda$2(DefaultKlibInfoProvider this$0) {
        List list2;
        Sequence sequence;
        FileTreeWalk fileTreeWalk;
        File file;
        File it = file = FilesKt.resolve((File)this$0.kotlinNativeHome, (String)"sources");
        boolean bl = false;
        File file2 = it.isDirectory() ? file : null;
        return file2 != null && (file = FilesKt.walkTopDown((File)file2)) != null && (fileTreeWalk = file.maxDepth(1)) != null && (sequence = SequencesKt.filter((Sequence)((Sequence)fileTreeWalk), DefaultKlibInfoProvider::nativeDistributionLibrarySourceFiles_delegate$lambda$2$lambda$1)) != null && (list2 = SequencesKt.toList((Sequence)sequence)) != null ? list2 : CollectionsKt.emptyList();
    }

    private static final boolean findLibrarySources$lambda$3(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.startsWith$default((String)it, (String)"kotlin-stdlib", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"kotlin-test", (boolean)false, (int)2, null);
    }

    private static final boolean findLibrarySources$lambda$4(String $libraryName, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.startsWith$default((String)it, (String)$libraryName, (boolean)false, (int)2, null);
    }
}

