/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.toolchain;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.gradleJava.toolchain.GradleDaemonJvmCriteriaMigrationHelper;
import org.jetbrains.plugins.gradle.service.execution.GradleDaemonJvmHelper;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/toolchain/GradleDaemonJvmCriteriaMigrationAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "kotlin.gradle.gradle-java"})
public final class GradleDaemonJvmCriteriaMigrationAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(Registry.Companion.is("gradle.daemon.jvm.criteria.suggest.migration") && e.getProject() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!Registry.Companion.is("gradle.daemon.jvm.criteria.suggest.migration")) {
            return;
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        GradleSettings gradleSettings = GradleSettings.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)gradleSettings, (String)"getInstance(...)");
        GradleSettings settings2 = gradleSettings;
        for (GradleProjectSettings projectSettings : settings2.getLinkedProjectsSettings()) {
            GradleVersion gradleVersion;
            String projectPath = projectSettings.getExternalProjectPath();
            Intrinsics.checkNotNullExpressionValue((Object)projectSettings.resolveGradleVersion(), (String)"resolveGradleVersion(...)");
            if (!GradleDaemonJvmHelper.isDaemonJvmCriteriaSupported((GradleVersion)gradleVersion)) continue;
            Path path2 = Path.of(projectPath, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
            if (GradleDaemonJvmHelper.isProjectUsingDaemonJvmCriteria((Path)path2, (GradleVersion)gradleVersion)) continue;
            Intrinsics.checkNotNull((Object)projectPath);
            GradleDaemonJvmCriteriaMigrationHelper.INSTANCE.migrateToDaemonJvmCriteria(project2, projectPath);
        }
    }
}

