/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.UtilsKt;
import org.jetbrains.kotlin.idea.inspections.AbstractReplaceRangeToWithRangeUntilInspection;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001-B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0002J\f\u0010\u0016\u001a\u00020\f*\u00020\u0017H\u0002J:\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\fH\u0002J2\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\fH\u0002J\"\u0010#\u001a\u0004\u0018\u00010\u00062\u0006\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\f\u0010)\u001a\u00020\f*\u00020&H\u0002J\f\u0010*\u001a\u00020\f*\u00020&H\u0002J\f\u0010+\u001a\u00020\f*\u00020&H\u0002J\u000e\u0010,\u001a\u00020\f*\u0004\u0018\u00010&H\u0002R\u0014\u0010\b\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConvertTwoComparisonsToRangeCheckInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "<init>", "()V", "inspectionText", "", "element", "defaultFixText", "getDefaultFixText", "()Ljava/lang/String;", "isApplicable", "", "applyTo", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "generateRangeExpressionData", "Lorg/jetbrains/kotlin/idea/inspections/ConvertTwoComparisonsToRangeCheckInspection$RangeExpressionData;", "condition", "isSimple", "Lorg/jetbrains/kotlin/psi/KtExpression;", "firstLess", "firstGreater", "firstStrict", "secondLess", "secondGreater", "secondStrict", "value", "min", "max", "incrementMinByOne", "decrementMaxByOne", "getDoubleConstant", "intExpr", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isComparable", "isFloatingPoint", "isInteger", "isValidTypeForIncrementDecrementByOne", "RangeExpressionData", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nConvertTwoComparisonsToRangeCheckInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertTwoComparisonsToRangeCheckInspection.kt\norg/jetbrains/kotlin/idea/inspections/ConvertTwoComparisonsToRangeCheckInspection\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,221:1\n213#2:222\n1#3:223\n*S KotlinDebug\n*F\n+ 1 ConvertTwoComparisonsToRangeCheckInspection.kt\norg/jetbrains/kotlin/idea/inspections/ConvertTwoComparisonsToRangeCheckInspection\n*L\n37#1:222\n*E\n"})
public final class ConvertTwoComparisonsToRangeCheckInspection
extends AbstractApplicabilityBasedInspection<KtBinaryExpression> {
    public ConvertTwoComparisonsToRangeCheckInspection() {
        super(KtBinaryExpression.class);
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull KtBinaryExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return KotlinBundle.message((String)"two.comparisons.should.be.converted.to.a.range.check", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return KotlinBundle.message((String)"convert.to.a.range.check", (Object[])new Object[0]);
    }

    @Override
    public boolean isApplicable(@NotNull KtBinaryExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        RangeExpressionData rangeExpressionData = this.generateRangeExpressionData(element);
        if (rangeExpressionData == null) {
            return false;
        }
        RangeExpressionData rangeData = rangeExpressionData;
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)element;
        boolean $i$f$getStrictParentOfType = false;
        KtNamedFunction function = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtNamedFunction.class, (boolean)true);
        if (function != null && function.hasModifier(KtTokens.OPERATOR_KEYWORD) && Intrinsics.areEqual((Object)function.getNameAsName(), (Object)OperatorNameConventions.CONTAINS)) {
            BindingContext context = ResolutionUtils.analyze((KtElement)element, BodyResolveMode.PARTIAL);
            DeclarationDescriptor functionDescriptor = (DeclarationDescriptor)context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)function);
            KtBinaryExpression newExpression = rangeData.createExpression();
            BindingContext newContext = ExtendedResolutionApiKt.analyzeAsReplacement$default((KtExpression)newExpression, (KtExpression)element, context, null, null, null, 28, null);
            ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)newExpression.getOperationReference()), (BindingContext)newContext);
            if (Intrinsics.areEqual((Object)(resolvedCall != null ? resolvedCall.getResultingDescriptor() : null), (Object)functionDescriptor)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void applyTo(@NotNull KtBinaryExpression element, @NotNull Project project, @Nullable Editor editor) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            RangeExpressionData rangeExpressionData = this.generateRangeExpressionData(element);
            if (rangeExpressionData == null) {
                return;
            }
            RangeExpressionData rangeData = rangeExpressionData;
            PsiElement replaced = element.replace((PsiElement)rangeData.createExpression());
            KtBinaryExpression ktBinaryExpression = replaced instanceof KtBinaryExpression ? (KtBinaryExpression)replaced : null;
            if (ktBinaryExpression == null || (ktBinaryExpression = ktBinaryExpression.getRight()) == null) break block1;
            KtBinaryExpression it = ktBinaryExpression;
            boolean bl = false;
            AbstractReplaceRangeToWithRangeUntilInspection.Companion.applyFixIfApplicable((KtExpression)it);
        }
    }

    private final RangeExpressionData generateRangeExpressionData(KtBinaryExpression condition2) {
        if (!Intrinsics.areEqual((Object)condition2.getOperationToken(), (Object)KtTokens.ANDAND)) {
            return null;
        }
        KtExpression ktExpression = condition2.getLeft();
        KtBinaryExpression ktBinaryExpression = ktExpression instanceof KtBinaryExpression ? (KtBinaryExpression)ktExpression : null;
        if (ktBinaryExpression == null) {
            return null;
        }
        KtBinaryExpression firstCondition = ktBinaryExpression;
        KtExpression ktExpression2 = condition2.getRight();
        KtBinaryExpression ktBinaryExpression2 = ktExpression2 instanceof KtBinaryExpression ? (KtBinaryExpression)ktExpression2 : null;
        if (ktBinaryExpression2 == null) {
            return null;
        }
        KtBinaryExpression secondCondition = ktBinaryExpression2;
        IElementType iElementType = firstCondition.getOperationToken();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getOperationToken(...)");
        IElementType firstOpToken = iElementType;
        IElementType iElementType2 = secondCondition.getOperationToken();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"getOperationToken(...)");
        IElementType secondOpToken = iElementType2;
        KtExpression ktExpression3 = firstCondition.getLeft();
        if (ktExpression3 == null) {
            return null;
        }
        KtExpression firstLeft = ktExpression3;
        KtExpression ktExpression4 = firstCondition.getRight();
        if (ktExpression4 == null) {
            return null;
        }
        KtExpression firstRight = ktExpression4;
        KtExpression ktExpression5 = secondCondition.getLeft();
        if (ktExpression5 == null) {
            return null;
        }
        KtExpression secondLeft = ktExpression5;
        KtExpression ktExpression6 = secondCondition.getRight();
        if (ktExpression6 == null) {
            return null;
        }
        KtExpression secondRight = ktExpression6;
        boolean firstStrict = ConvertTwoComparisonsToRangeCheckInspection.generateRangeExpressionData$isStrictComparison(firstOpToken);
        boolean secondStrict = ConvertTwoComparisonsToRangeCheckInspection.generateRangeExpressionData$isStrictComparison(secondOpToken);
        Pair<KtExpression, KtExpression> pair = ConvertTwoComparisonsToRangeCheckInspection.generateRangeExpressionData$orderLessAndGreater(firstOpToken, firstLeft, firstRight);
        if (pair == null) {
            return null;
        }
        Pair<KtExpression, KtExpression> pair2 = pair;
        KtExpression firstLess = (KtExpression)pair2.component1();
        KtExpression firstGreater = (KtExpression)pair2.component2();
        Pair<KtExpression, KtExpression> pair3 = ConvertTwoComparisonsToRangeCheckInspection.generateRangeExpressionData$orderLessAndGreater(secondOpToken, secondLeft, secondRight);
        if (pair3 == null) {
            return null;
        }
        Pair<KtExpression, KtExpression> pair4 = pair3;
        KtExpression secondLess = (KtExpression)pair4.component1();
        KtExpression secondGreater = (KtExpression)pair4.component2();
        return this.generateRangeExpressionData(firstLess, firstGreater, firstStrict, secondLess, secondGreater, secondStrict);
    }

    private final boolean isSimple(KtExpression $this$isSimple) {
        return $this$isSimple instanceof KtConstantExpression || $this$isSimple instanceof KtNameReferenceExpression;
    }

    private final RangeExpressionData generateRangeExpressionData(KtExpression firstLess, KtExpression firstGreater, boolean firstStrict, KtExpression secondLess, KtExpression secondGreater, boolean secondStrict) {
        return !(firstGreater instanceof KtConstantExpression) && UtilsKt.isSimplifiableTo(firstGreater, secondLess) ? this.generateRangeExpressionData(firstGreater, firstLess, secondGreater, firstStrict, secondStrict) : (!(firstLess instanceof KtConstantExpression) && UtilsKt.isSimplifiableTo(firstLess, secondGreater) ? this.generateRangeExpressionData(firstLess, secondLess, firstGreater, secondStrict, firstStrict) : null);
    }

    private final RangeExpressionData generateRangeExpressionData(KtExpression value, KtExpression min, KtExpression max, boolean incrementMinByOne, boolean decrementMaxByOne) {
        if (!this.isSimple(min) || !this.isSimple(max)) {
            return null;
        }
        BindingContext context = ResolutionUtils.analyze$default((KtElement)value, null, 1, null);
        KotlinType valType = ConvertTwoComparisonsToRangeCheckInspection.generateRangeExpressionData$type(value, context);
        KotlinType minType = ConvertTwoComparisonsToRangeCheckInspection.generateRangeExpressionData$type(min, context);
        KotlinType maxType = ConvertTwoComparisonsToRangeCheckInspection.generateRangeExpressionData$type(max, context);
        if (valType == null || minType == null || maxType == null) {
            return null;
        }
        if (!this.isComparable(valType)) {
            return null;
        }
        KtExpression minVal = min;
        KtExpression maxVal = max;
        if (!Intrinsics.areEqual((Object)minType, (Object)valType) || !Intrinsics.areEqual((Object)maxType, (Object)valType)) {
            if (TypeUtilsKt.isPrimitiveNumberType((KotlinType)valType) && TypeUtilsKt.isPrimitiveNumberType((KotlinType)minType) && TypeUtilsKt.isPrimitiveNumberType((KotlinType)maxType)) {
                if (KotlinBuiltIns.isChar((KotlinType)valType) || KotlinBuiltIns.isChar((KotlinType)minType) || KotlinBuiltIns.isChar((KotlinType)maxType)) {
                    return null;
                }
                if (this.isInteger(valType) && (this.isFloatingPoint(minType) || this.isFloatingPoint(maxType))) {
                    return null;
                }
                if (this.isFloatingPoint(valType)) {
                    if (this.isInteger(minType)) {
                        Project project = minVal.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        String string = this.getDoubleConstant(min, minType, context);
                        if (string == null) {
                            return null;
                        }
                        minVal = new KtPsiFactory(project, false, 2, null).createExpression(string);
                    }
                    if (this.isInteger(maxType)) {
                        Project project = maxVal.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        String string = this.getDoubleConstant(max, maxType, context);
                        if (string == null) {
                            return null;
                        }
                        maxVal = new KtPsiFactory(project, false, 2, null).createExpression(string);
                    }
                }
            } else {
                return null;
            }
        }
        if ((incrementMinByOne || decrementMaxByOne) && !this.isValidTypeForIncrementDecrementByOne(valType)) {
            return null;
        }
        String minText = incrementMinByOne ? ConvertTwoComparisonsToRangeCheckInspection.generateRangeExpressionData$getChangeBy(minVal, this, context, 1) : minVal.getText();
        String maxText = decrementMaxByOne ? ConvertTwoComparisonsToRangeCheckInspection.generateRangeExpressionData$getChangeBy(maxVal, this, context, -1) : maxVal.getText();
        String string = minText;
        if (string == null) {
            return null;
        }
        String string2 = maxText;
        if (string2 == null) {
            return null;
        }
        return new RangeExpressionData(value, string, string2);
    }

    private final String getDoubleConstant(KtExpression intExpr, KotlinType type2, BindingContext context) {
        Object object = ConstantExpressionEvaluator.Companion.getConstant(intExpr, context);
        if (object == null || (object = object.getValue(type2)) == null) {
            return null;
        }
        Object intConst = object;
        Number number = intConst instanceof Number ? (Number)((Number)intConst) : (Number)null;
        return number != null ? Double.valueOf(number.doubleValue()).toString() : null;
    }

    private final boolean isComparable(KotlinType $this$isComparable) {
        return DescriptorUtils.isSubtypeOfClass((KotlinType)$this$isComparable, (DeclarationDescriptor)((DeclarationDescriptor)TypeUtilsKt.getBuiltIns((KotlinType)$this$isComparable).getComparable()));
    }

    private final boolean isFloatingPoint(KotlinType $this$isFloatingPoint) {
        return KotlinBuiltIns.isFloat((KotlinType)$this$isFloatingPoint) || KotlinBuiltIns.isDouble((KotlinType)$this$isFloatingPoint);
    }

    private final boolean isInteger(KotlinType $this$isInteger) {
        return KotlinBuiltIns.isInt((KotlinType)$this$isInteger) || KotlinBuiltIns.isLong((KotlinType)$this$isInteger) || KotlinBuiltIns.isShort((KotlinType)$this$isInteger) || KotlinBuiltIns.isByte((KotlinType)$this$isInteger);
    }

    private final boolean isValidTypeForIncrementDecrementByOne(KotlinType $this$isValidTypeForIncrementDecrementByOne) {
        if ($this$isValidTypeForIncrementDecrementByOne == null) {
            return false;
        }
        return this.isInteger($this$isValidTypeForIncrementDecrementByOne) || KotlinBuiltIns.isChar((KotlinType)$this$isValidTypeForIncrementDecrementByOne);
    }

    private static final boolean generateRangeExpressionData$isStrictComparison(IElementType $this$generateRangeExpressionData_u24isStrictComparison) {
        return Intrinsics.areEqual((Object)$this$generateRangeExpressionData_u24isStrictComparison, (Object)KtTokens.GT) || Intrinsics.areEqual((Object)$this$generateRangeExpressionData_u24isStrictComparison, (Object)KtTokens.LT);
    }

    private static final Pair<KtExpression, KtExpression> generateRangeExpressionData$orderLessAndGreater(IElementType $this$generateRangeExpressionData_u24orderLessAndGreater, KtExpression left, KtExpression right) {
        IElementType iElementType = $this$generateRangeExpressionData_u24orderLessAndGreater;
        return Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GTEQ) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GT) ? TuplesKt.to((Object)right, (Object)left) : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LTEQ) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LT) ? TuplesKt.to((Object)left, (Object)right) : null);
    }

    private static final String generateRangeExpressionData$getChangeBy(KtExpression $this$generateRangeExpressionData_u24getChangeBy, ConvertTwoComparisonsToRangeCheckInspection this$0, BindingContext context, int number) {
        KotlinType kotlinType = CallUtilKt.getType((KtExpression)$this$generateRangeExpressionData_u24getChangeBy, (BindingContext)context);
        if (kotlinType == null) {
            return null;
        }
        KotlinType type2 = kotlinType;
        if (!this$0.isValidTypeForIncrementDecrementByOne(type2)) {
            return null;
        }
        if ($this$generateRangeExpressionData_u24getChangeBy instanceof KtConstantExpression) {
            Object object;
            Object object2 = ConstantExpressionEvaluator.Companion.getConstant($this$generateRangeExpressionData_u24getChangeBy, context);
            if (object2 == null || (object2 = object2.getValue(type2)) == null) {
                return null;
            }
            Object constantValue = object2;
            if (KotlinBuiltIns.isInt((KotlinType)type2)) {
                int it = (Integer)constantValue + number;
                boolean bl = false;
                String text = ((KtConstantExpression)$this$generateRangeExpressionData_u24getChangeBy).getText();
                Intrinsics.checkNotNull((Object)text);
                if (StringsKt.startsWith$default((String)text, (String)"0x", (boolean)false, (int)2, null)) {
                    String string = Integer.toString(it, CharsKt.checkRadix((int)16));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    object = "0x" + string;
                } else if (StringsKt.startsWith$default((String)text, (String)"0b", (boolean)false, (int)2, null)) {
                    String string = Integer.toString(it, CharsKt.checkRadix((int)2));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    object = "0b" + string;
                } else {
                    object = String.valueOf(it);
                }
            } else if (KotlinBuiltIns.isLong((KotlinType)type2)) {
                long it = (Long)constantValue + (long)number;
                boolean bl = false;
                String text = ((KtConstantExpression)$this$generateRangeExpressionData_u24getChangeBy).getText();
                Intrinsics.checkNotNull((Object)text);
                if (StringsKt.startsWith$default((String)text, (String)"0x", (boolean)false, (int)2, null)) {
                    String string = Long.toString(it, CharsKt.checkRadix((int)16));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    object = "0x" + string;
                } else if (StringsKt.startsWith$default((String)text, (String)"0b", (boolean)false, (int)2, null)) {
                    String string = Long.toString(it, CharsKt.checkRadix((int)2));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    object = "0b" + string;
                } else {
                    object = String.valueOf(it);
                }
            } else {
                object = KotlinBuiltIns.isChar((KotlinType)type2) ? "'" + (char)(((Character)constantValue).charValue() + number) + "'" : null;
            }
            return object;
        }
        return number >= 0 ? "(" + $this$generateRangeExpressionData_u24getChangeBy.getText() + " + " + number + ")" : "(" + $this$generateRangeExpressionData_u24getChangeBy.getText() + " - " + -number + ")";
    }

    /*
     * WARNING - void declaration
     */
    private static final KotlinType generateRangeExpressionData$type(KtExpression $this$generateRangeExpressionData_u24type, BindingContext context) {
        Object object;
        KotlinType kotlinType = CallUtilKt.getType((KtExpression)$this$generateRangeExpressionData_u24type, (BindingContext)context);
        if (kotlinType != null) {
            void var2_2;
            KotlinType it = kotlinType;
            boolean bl = false;
            object = it instanceof FlexibleType ? (KotlinType)((FlexibleType)it).getLowerBound() : var2_2;
        } else {
            object = null;
        }
        return object;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u000e\u001a\u00020\u000fJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConvertTwoComparisonsToRangeCheckInspection$RangeExpressionData;", "", "value", "Lorg/jetbrains/kotlin/psi/KtExpression;", "min", "", "max", "<init>", "(Lorg/jetbrains/kotlin/psi/KtExpression;Ljava/lang/String;Ljava/lang/String;)V", "getValue", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "getMin", "()Ljava/lang/String;", "getMax", "createExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "kotlin.idea"})
    private static final class RangeExpressionData {
        @NotNull
        private final KtExpression value;
        @NotNull
        private final String min;
        @NotNull
        private final String max;

        public RangeExpressionData(@NotNull KtExpression value, @NotNull String min, @NotNull String max) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)min, (String)"min");
            Intrinsics.checkNotNullParameter((Object)max, (String)"max");
            this.value = value;
            this.min = min;
            this.max = max;
        }

        @NotNull
        public final KtExpression getValue() {
            return this.value;
        }

        @NotNull
        public final String getMin() {
            return this.min;
        }

        @NotNull
        public final String getMax() {
            return this.max;
        }

        @NotNull
        public final KtBinaryExpression createExpression() {
            Project project = this.value.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
            KtExpression minExpression = psiFactory.createExpression(this.min);
            KtExpression maxExpression = psiFactory.createExpression(this.max);
            Object[] objectArray = new Object[]{this.value, minExpression, maxExpression};
            KtExpression ktExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"$0 in $1..$2", (Object[])objectArray, (boolean)false, (int)4, null);
            Intrinsics.checkNotNull((Object)ktExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
            return (KtBinaryExpression)ktExpression;
        }

        @NotNull
        public final KtExpression component1() {
            return this.value;
        }

        @NotNull
        public final String component2() {
            return this.min;
        }

        @NotNull
        public final String component3() {
            return this.max;
        }

        @NotNull
        public final RangeExpressionData copy(@NotNull KtExpression value, @NotNull String min, @NotNull String max) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)min, (String)"min");
            Intrinsics.checkNotNullParameter((Object)max, (String)"max");
            return new RangeExpressionData(value, min, max);
        }

        public static /* synthetic */ RangeExpressionData copy$default(RangeExpressionData rangeExpressionData, KtExpression ktExpression, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                ktExpression = rangeExpressionData.value;
            }
            if ((n & 2) != 0) {
                string = rangeExpressionData.min;
            }
            if ((n & 4) != 0) {
                string2 = rangeExpressionData.max;
            }
            return rangeExpressionData.copy(ktExpression, string, string2);
        }

        @NotNull
        public String toString() {
            return "RangeExpressionData(value=" + this.value + ", min=" + this.min + ", max=" + this.max + ")";
        }

        public int hashCode() {
            int result2 = this.value.hashCode();
            result2 = result2 * 31 + this.min.hashCode();
            result2 = result2 * 31 + this.max.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RangeExpressionData)) {
                return false;
            }
            RangeExpressionData rangeExpressionData = (RangeExpressionData)other;
            if (!Intrinsics.areEqual((Object)this.value, (Object)rangeExpressionData.value)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.min, (Object)rangeExpressionData.min)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.max, (Object)rangeExpressionData.max);
        }
    }
}

