/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016R\u0014\u0010\u0010\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceArrayEqualityOpWithArraysEqualsInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "<init>", "()V", "applyTo", "", "element", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicable", "", "inspectionText", "", "defaultFixText", "getDefaultFixText", "()Ljava/lang/String;", "fixText", "kotlin.idea"})
public final class ReplaceArrayEqualityOpWithArraysEqualsInspection
extends AbstractApplicabilityBasedInspection<KtBinaryExpression> {
    public ReplaceArrayEqualityOpWithArraysEqualsInspection() {
        super(KtBinaryExpression.class);
    }

    @Override
    public void applyTo(@NotNull KtBinaryExpression element, @NotNull Project project, @Nullable Editor editor) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        KtExpression ktExpression = element.getRight();
        if (ktExpression == null) {
            return;
        }
        KtExpression right = ktExpression;
        KtExpression ktExpression2 = element.getLeft();
        if (ktExpression2 == null) {
            return;
        }
        KtExpression left = ktExpression2;
        KtPsiFactory factory2 = new KtPsiFactory(project, false, 2, null);
        Object[] $this$applyTo_u24lambda_u240 = objectArray = new StringBuilder();
        boolean bl = false;
        if (Intrinsics.areEqual((Object)element.getOperationToken(), (Object)KtTokens.EXCLEQ)) {
            $this$applyTo_u24lambda_u240.append("!");
        }
        $this$applyTo_u24lambda_u240.append("$0.contentEquals($1)");
        String template2 = objectArray.toString();
        objectArray = new Object[]{left, right};
        element.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)factory2, (String)template2, (Object[])objectArray, (boolean)false, (int)4, null));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicable(@NotNull KtBinaryExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        IElementType iElementType = element.getOperationToken();
        if (!Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQ)) {
            if (!Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQ)) return false;
        }
        KtExpression right = element.getRight();
        KtExpression left = element.getLeft();
        if (right == null) return false;
        if (left == null) {
            return false;
        }
        BindingContext context = ExtendedResolutionApiKt.safeAnalyzeNonSourceRootCode$default((KtElement)element, null, 1, null);
        ResolvedCall rightResolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)right), (BindingContext)context);
        ResolvedCall leftResolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)left), (BindingContext)context);
        ResolvedCall resolvedCall = rightResolvedCall;
        if (resolvedCall == null) return false;
        if (!UtilsKt.resolvedToArrayType((ResolvedCall<? extends CallableDescriptor>)resolvedCall)) return false;
        boolean bl = true;
        if (!bl) return false;
        ResolvedCall resolvedCall2 = leftResolvedCall;
        if (resolvedCall2 == null) return false;
        if (!UtilsKt.resolvedToArrayType((ResolvedCall<? extends CallableDescriptor>)resolvedCall2)) return false;
        return true;
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull KtBinaryExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return KotlinBundle.message((String)"dangerous.array.comparison", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return KotlinBundle.message((String)"replace.with.content.equals", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String fixText(@NotNull KtBinaryExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        IElementType iElementType = element.getOperationToken();
        return Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQ) ? KotlinBundle.message((String)"replace.equal.with.content.equals", (Object[])new Object[0]) : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQ) ? KotlinBundle.message((String)"replace.not.equal.with.content.equals", (Object[])new Object[0]) : "");
    }
}

