/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.hints.RangeKtExpressionType;
import org.jetbrains.kotlin.idea.inspections.AbstractRangeInspection;
import org.jetbrains.kotlin.idea.inspections.ReplaceUntilWithRangeUntilInspectionKt;
import org.jetbrains.kotlin.idea.intentions.ReplaceUntilWithRangeToIntentionKt;
import org.jetbrains.kotlin.idea.statistics.KotlinLanguageFeaturesFUSCollector;
import org.jetbrains.kotlin.idea.statistics.NewAndDeprecatedFeaturesInspectionData;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceUntilWithRangeUntilInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractRangeInspection;", "<init>", "()V", "visitRange", "", "range", "Lorg/jetbrains/kotlin/psi/KtExpression;", "context", "Lkotlin/Lazy;", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "type", "Lorg/jetbrains/kotlin/idea/codeInsight/hints/RangeKtExpressionType;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "ReplaceFix", "Util", "kotlin.idea"})
public final class ReplaceUntilWithRangeUntilInspection
extends AbstractRangeInspection {
    public ReplaceUntilWithRangeUntilInspection() {
        super(KotlinLanguageFeaturesFUSCollector.INSTANCE.getRangeUntilCollector(), new NewAndDeprecatedFeaturesInspectionData(false, false, 3, null));
    }

    @Override
    public void visitRange(@NotNull KtExpression range2, @NotNull Lazy<? extends BindingContext> context, @NotNull RangeKtExpressionType type2, @NotNull ProblemsHolder holder2, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)range2, (String)"range");
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (Util.INSTANCE.isPossibleToUseRangeUntil((KtElement)range2, context)) {
            this.updateDeprecationData(session, arg_0 -> ReplaceUntilWithRangeUntilInspection.visitRange$lambda$0(type2, arg_0));
            if (type2 != RangeKtExpressionType.UNTIL) {
                return;
            }
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new ReplaceFix()};
            holder2.registerProblem((PsiElement)range2, KotlinBundle.message((String)"until.can.be.replaced.with.rangeUntil.operator", (Object[])new Object[0]), localQuickFixArray);
        }
    }

    private static final NewAndDeprecatedFeaturesInspectionData visitRange$lambda$0(RangeKtExpressionType $type, NewAndDeprecatedFeaturesInspectionData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return switch (WhenMappings.$EnumSwitchMapping$0[$type.ordinal()]) {
            case 1 -> it.withDeprecatedFeature();
            case 2 -> it.withNewFeature();
            default -> it;
        };
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceUntilWithRangeUntilInspection$ReplaceFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "()V", "getFamilyName", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "kotlin.idea"})
    private static final class ReplaceFix
    implements LocalQuickFix {
        @NotNull
        public String getFamilyName() {
            Object[] objectArray = new Object[]{"..<"};
            return KotlinBundle.message((String)"replace.with.0.operator", (Object[])objectArray);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement = descriptor2.getPsiElement();
            KtExpression ktExpression = psiElement instanceof KtExpression ? (KtExpression)psiElement : null;
            if (ktExpression == null) {
                return;
            }
            KtExpression element = ktExpression;
            Pair<KtExpression, KtExpression> pair = ReplaceUntilWithRangeToIntentionKt.getArguments(element);
            if (pair == null) {
                return;
            }
            Pair<KtExpression, KtExpression> pair2 = pair;
            KtExpression left = (KtExpression)pair2.component1();
            KtExpression right = (KtExpression)pair2.component2();
            if (left == null || right == null) {
                return;
            }
            KotlinLanguageFeaturesFUSCollector.INSTANCE.getRangeUntilCollector().logQuickFixApplied(element.getContainingFile());
            Object[] objectArray = new Object[]{left, right};
            element.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)new KtPsiFactory(project, false, 2, null), (String)"$0..<$1", (Object[])objectArray, (boolean)false, (int)4, null));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bH\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceUntilWithRangeUntilInspection$Util;", "", "<init>", "()V", "isPossibleToUseRangeUntil", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "context", "Lkotlin/Lazy;", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nReplaceUntilWithRangeUntilInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplaceUntilWithRangeUntilInspection.kt\norg/jetbrains/kotlin/idea/inspections/ReplaceUntilWithRangeUntilInspection$Util\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1#2:137\n*E\n"})
    public static final class Util {
        @NotNull
        public static final Util INSTANCE = new Util();

        private Util() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @ApiStatus.Internal
        public final boolean isPossibleToUseRangeUntil(@NotNull KtElement $this$isPossibleToUseRangeUntil, @Nullable Lazy<? extends BindingContext> context) {
            Intrinsics.checkNotNullParameter((Object)$this$isPossibleToUseRangeUntil, (String)"<this>");
            FqName annotationFqName = new FqName("kotlin.ExperimentalStdlibApi");
            LanguageVersionSettings languageVersionSettings = LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)$this$isPossibleToUseRangeUntil);
            Module module = ProjectStructureUtilKt.getModule((PsiElement)$this$isPossibleToUseRangeUntil);
            if (module == null) return false;
            Module it = module;
            boolean bl = false;
            Project project = $this$isPossibleToUseRangeUntil.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            if (!ReplaceUntilWithRangeUntilInspectionKt.access$areKotlinVersionsSufficientToUseRangeUntil(languageVersionSettings, it, project)) return false;
            boolean bl2 = true;
            if (!bl2) return false;
            Lazy<? extends BindingContext> lazy = context;
            if (lazy == null) return false;
            Lazy<? extends BindingContext> it2 = lazy;
            boolean bl3 = false;
            if (!ReplaceUntilWithRangeUntilInspectionKt.access$isOtpInRequiredForRangeUntil($this$isPossibleToUseRangeUntil, annotationFqName, (BindingContext)it2.getValue())) return true;
            if (!OptInUsageChecker.Companion.isOptInAllowed((PsiElement)$this$isPossibleToUseRangeUntil, annotationFqName, languageVersionSettings, (BindingContext)it2.getValue())) return false;
            return true;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RangeKtExpressionType.values().length];
            try {
                nArray[RangeKtExpressionType.UNTIL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RangeKtExpressionType.RANGE_UNTIL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

