/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.collections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.collections.CallChain;
import org.jetbrains.kotlin.idea.inspections.collections.ConvertCallChainIntoSequenceFix;
import org.jetbrains.kotlin.idea.inspections.collections.ConvertCallChainIntoSequenceInspectionKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\n\u0010\u0003\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/collections/ConvertCallChainIntoSequenceInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "<init>", "()V", "defaultCallChainLength", "", "callChainLength", "value", "", "callChainLengthText", "getCallChainLengthText$annotations", "getCallChainLengthText", "()Ljava/lang/String;", "setCallChainLengthText", "(Ljava/lang/String;)V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "kotlin.idea"})
public final class ConvertCallChainIntoSequenceInspection
extends AbstractKotlinInspection {
    private final int defaultCallChainLength;
    private int callChainLength;
    @NotNull
    private String callChainLengthText;

    public ConvertCallChainIntoSequenceInspection() {
        this.callChainLength = this.defaultCallChainLength = 5;
        this.callChainLengthText = String.valueOf(this.callChainLength);
    }

    @NotNull
    public final String getCallChainLengthText() {
        return String.valueOf(this.callChainLength);
    }

    public final void setCallChainLengthText(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.callChainLengthText = value;
        Integer n = StringsKt.toIntOrNull((String)value);
        this.callChainLength = n != null ? n : this.defaultCallChainLength;
    }

    public static /* synthetic */ void getCallChainLengthText$annotations() {
    }

    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return VisitorWrappersKt.qualifiedExpressionVisitor(arg_0 -> ConvertCallChainIntoSequenceInspection.buildVisitor$lambda$0(this, holder2, isOnTheFly, arg_0));
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[]{OptPane.number((String)"callChainLength", (String)KotlinBundle.message((String)"call.chain.length.to.transform", (Object[])new Object[0]), (int)1, (int)100)};
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }

    private static final Unit buildVisitor$lambda$0(ConvertCallChainIntoSequenceInspection this$0, ProblemsHolder $holder, boolean $isOnTheFly, KtQualifiedExpression expression) {
        CallChain callChain = ConvertCallChainIntoSequenceInspectionKt.access$findCallChain(expression);
        if (callChain == null) {
            return Unit.INSTANCE;
        }
        CallChain callChain2 = callChain;
        KtQualifiedExpression qualified = callChain2.component1();
        KtCallExpression firstCall = callChain2.component2();
        int callChainLength = callChain2.component3();
        KtExpression ktExpression = firstCall.getCalleeExpression();
        if (ktExpression == null || (ktExpression = ktExpression.getTextRange()) == null || (ktExpression = ktExpression.shiftRight(-PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)qualified)))) == null) {
            return Unit.INSTANCE;
        }
        KtExpression rangeInElement = ktExpression;
        ProblemHighlightType highlightType = callChainLength >= this$0.callChainLength ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.INFORMATION;
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new ConvertCallChainIntoSequenceFix()};
        this$0.registerProblemWithoutOfflineInformation($holder, (PsiElement)qualified, KotlinBundle.message((String)"call.chain.on.collection.could.be.converted.into.sequence.to.improve.performance", (Object[])new Object[0]), $isOnTheFly, highlightType, (TextRange)rangeInElement, localQuickFixArray);
        return Unit.INSTANCE;
    }
}

