/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.collections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.descriptors.DescriptorUtilsKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.ReplaceAssociateFunctionFix;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.quickFix.AssociateFunction;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.quickFix.AssociateFunctionUtil;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.quickFix.CallChainConversion;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.quickFix.CallChainConversions;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.quickFix.CallChainExpressions;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.quickFix.SimplifyCallChainFix;
import org.jetbrains.kotlin.idea.inspections.collections.AbstractCallChainChecker;
import org.jetbrains.kotlin.idea.inspections.collections.FunctionUtilsKt;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.js.resolve.JsPlatformAnalyzerServices;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b*\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001c\u0010\u000f\u001a\u00020\t2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J&\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/collections/SimplifiableCallChainInspection;", "Lorg/jetbrains/kotlin/idea/inspections/collections/AbstractCallChainChecker;", "<init>", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "lastFunctionalArgument", "Lorg/jetbrains/kotlin/idea/inspections/collections/SimplifiableCallChainInspection$FunctionalArgument;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "containsSuspendFunctionCall", "resolvedCall", "getAssociateFunction", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/quickFix/AssociateFunction;", "", "conversion", "Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/quickFix/CallChainConversion;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "FunctionalArgument", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nSimplifiableCallChainInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimplifiableCallChainInspection.kt\norg/jetbrains/kotlin/idea/inspections/collections/SimplifiableCallChainInspection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,177:1\n1#2:178\n384#3:179\n395#3,10:180\n417#3:190\n*S KotlinDebug\n*F\n+ 1 SimplifiableCallChainInspection.kt\norg/jetbrains/kotlin/idea/inspections/collections/SimplifiableCallChainInspection\n*L\n161#1:179\n161#1:180,10\n161#1:190\n*E\n"})
public final class SimplifiableCallChainInspection
extends AbstractCallChainChecker {
    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return VisitorWrappersKt.qualifiedExpressionVisitor(arg_0 -> SimplifiableCallChainInspection.buildVisitor$lambda$4(this, holder2, isOnTheFly, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final FunctionalArgument lastFunctionalArgument(ResolvedCall<?> $this$lastFunctionalArgument, BindingContext context) {
        FunctionalArgument functionalArgument;
        KtExpression argumentExpression;
        ValueArgument argument2;
        Object object = (Map.Entry)CollectionsKt.lastOrNull((Iterable)$this$lastFunctionalArgument.getValueArguments().entrySet());
        ValueArgument valueArgument = argument2 = object != null && (object = (ResolvedValueArgument)object.getValue()) != null && (object = object.getArguments()) != null ? (ValueArgument)CollectionsKt.firstOrNull((List)object) : null;
        Object object2 = argumentExpression = valueArgument != null ? valueArgument.getArgumentExpression() : null;
        if (argumentExpression instanceof KtLambdaExpression) {
            KtExpression lastStatement;
            KtBlockExpression ktBlockExpression = ((KtLambdaExpression)argumentExpression).getBodyExpression();
            KtExpression ktExpression = lastStatement = ktBlockExpression != null ? KtPsiUtilKt.lastBlockStatementOrThis((KtExpression)((KtExpression)ktBlockExpression)) : null;
            functionalArgument = new FunctionalArgument(true, (KotlinType)(ktExpression != null ? CallUtilKt.getType((KtExpression)ktExpression, (BindingContext)context) : null), lastStatement);
        } else if (argumentExpression instanceof KtNamedFunction) {
            KotlinType kotlinType;
            boolean bl = false;
            KtTypeReference ktTypeReference = ((KtNamedFunction)argumentExpression).getTypeReference();
            if (ktTypeReference != null) {
                void it;
                KtTypeReference ktTypeReference2 = ktTypeReference;
                boolean bl2 = bl;
                boolean bl3 = false;
                KotlinType kotlinType2 = (KotlinType)context.get((ReadOnlySlice)BindingContext.TYPE, (Object)it);
                bl = bl2;
                kotlinType = kotlinType2;
            } else {
                kotlinType = null;
            }
            KtExpression ktExpression = KtPsiUtilKt.lastBlockStatementOrThis((KtExpression)argumentExpression);
            KotlinType kotlinType3 = kotlinType;
            boolean bl4 = bl;
            functionalArgument = new FunctionalArgument(bl4, kotlinType3, ktExpression);
        } else {
            functionalArgument = null;
        }
        return functionalArgument;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean containsSuspendFunctionCall(ResolvedCall<?> resolvedCall, BindingContext context) {
        void $this$anyDescendantOfType$iv;
        KtElement ktElement = resolvedCall.getCall().getCallElement();
        Intrinsics.checkNotNullExpressionValue((Object)ktElement, (String)"getCallElement(...)");
        PsiElement psiElement = (PsiElement)ktElement;
        Function1 predicate$iv = arg_0 -> SimplifiableCallChainInspection.containsSuspendFunctionCall$lambda$6(context, arg_0);
        boolean $i$f$anyDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
        boolean $i$f$findDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtCallExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        return (PsiElement)result$iv$iv$iv.element != null;
    }

    private final Pair<AssociateFunction, String> getAssociateFunction(CallChainConversion conversion, KtExpression expression) {
        boolean isAssociateTo = Intrinsics.areEqual((Object)conversion.getReplacement(), (Object)"associateTo");
        if (!Intrinsics.areEqual((Object)conversion.getReplacement(), (Object)"associate") && !isAssociateTo) {
            return null;
        }
        if (!(expression instanceof KtDotQualifiedExpression)) {
            return null;
        }
        Pair<AssociateFunction, ProblemHighlightType> pair = AssociateFunctionUtil.INSTANCE.getAssociateFunctionAndProblemHighlightType((KtDotQualifiedExpression)expression);
        if (pair == null) {
            return null;
        }
        Pair<AssociateFunction, ProblemHighlightType> pair2 = pair;
        AssociateFunction associateFunction = (AssociateFunction)((Object)pair2.component1());
        ProblemHighlightType problemHighlightType = (ProblemHighlightType)pair2.component2();
        if (problemHighlightType == ProblemHighlightType.INFORMATION) {
            return null;
        }
        if (associateFunction != AssociateFunction.ASSOCIATE_WITH && associateFunction != AssociateFunction.ASSOCIATE_BY) {
            return null;
        }
        return TuplesKt.to((Object)((Object)associateFunction), (Object)associateFunction.name(isAssociateTo));
    }

    private static final boolean buildVisitor$lambda$4$lambda$1$lambda$0(KotlinType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        SimpleType simpleType = JsPlatformAnalyzerServices.INSTANCE.getBuiltIns().getCharSequence().getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getDefaultType(...)");
        return TypeUtilsKt.isSubtypeOf((KotlinType)it, (KotlinType)((KotlinType)simpleType));
    }

    private static final boolean buildVisitor$lambda$4$lambda$1(KtQualifiedExpression $expression, SimplifiableCallChainInspection this$0, CallChainConversion conversion, ResolvedCall firstResolvedCall, ResolvedCall resolvedCall, BindingContext context) {
        PsiElement parent2;
        Object[] functionalArgumentReturnType;
        KotlinTypeInfo builtIns;
        KotlinType firstReceiverType;
        Intrinsics.checkNotNullParameter((Object)conversion, (String)"conversion");
        Intrinsics.checkNotNullParameter((Object)firstResolvedCall, (String)"firstResolvedCall");
        Intrinsics.checkNotNullParameter((Object)resolvedCall, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CallableDescriptor callableDescriptor = firstResolvedCall.getResultingDescriptor();
        KotlinType kotlinType = callableDescriptor != null && (callableDescriptor = callableDescriptor.getExtensionReceiverParameter()) != null ? callableDescriptor.getType() : (firstReceiverType = null);
        if (firstReceiverType != null) {
            SimpleType firstReceiverRawType;
            if (Intrinsics.areEqual((Object)conversion.getReplacement(), (Object)"mapNotNull") && KotlinBuiltIns.isPrimitiveArray((KotlinType)firstReceiverType)) {
                return false;
            }
            KotlinTypeInfo kotlinTypeInfo = (KotlinTypeInfo)context.get((ReadOnlySlice)BindingContext.EXPRESSION_TYPE_INFO, (Object)$expression);
            if (kotlinTypeInfo == null || (kotlinTypeInfo = kotlinTypeInfo.getType()) == null || (kotlinTypeInfo = TypeUtilsKt.getBuiltIns((KotlinType)kotlinTypeInfo)) == null) {
                return false;
            }
            builtIns = kotlinTypeInfo;
            ClassifierDescriptor classifierDescriptor = firstReceiverType.getConstructor().getDeclarationDescriptor();
            Object object = firstReceiverRawType = classifierDescriptor != null ? classifierDescriptor.getDefaultType() : null;
            if (FunctionUtilsKt.isMap((KotlinType)firstReceiverRawType, (KotlinBuiltIns)builtIns)) {
                return false;
            }
        }
        if (StringsKt.startsWith$default((String)conversion.getReplacement(), (String)"joinTo", (boolean)false, (int)2, null) && !FunctionUtilsKt.hasLastFunctionalParameterWithResult(firstResolvedCall, context, (Function1<? super KotlinType, Boolean>)((Function1)SimplifiableCallChainInspection::buildVisitor$lambda$4$lambda$1$lambda$0))) {
            return false;
        }
        builtIns = new KotlinTypeInfo[]{"maxBy", "minBy", "minByOrNull", "maxByOrNull"};
        if (CollectionsKt.listOf((Object[])builtIns).contains(conversion.getReplacement())) {
            Object[] objectArray = this$0.lastFunctionalArgument(firstResolvedCall, context);
            if (objectArray == null || (objectArray = objectArray.getReturnType()) == null) {
                return false;
            }
            functionalArgumentReturnType = objectArray;
            if (KotlinTypeKt.isNullable((KotlinType)functionalArgumentReturnType)) {
                return false;
            }
        }
        if (conversion.getRemoveNotNullAssertion() && Intrinsics.areEqual((Object)conversion.getFirstName(), (Object)"map") && CollectionsKt.listOf((Object[])(functionalArgumentReturnType = new String[]{"max", "maxOrNull", "min", "minOrNull"})).contains(conversion.getSecondName()) && (!((parent2 = $expression.getParent()) instanceof KtPostfixExpression) || !Intrinsics.areEqual((Object)((KtPostfixExpression)parent2).getOperationToken(), (Object)KtTokens.EXCLEXCL))) {
            return false;
        }
        if (Intrinsics.areEqual((Object)conversion.getFirstName(), (Object)"map") && Intrinsics.areEqual((Object)conversion.getSecondName(), (Object)"sum") && Intrinsics.areEqual((Object)conversion.getReplacement(), (Object)"sumOf")) {
            FunctionalArgument functionalArgument = this$0.lastFunctionalArgument(firstResolvedCall, context);
            if (functionalArgument == null) {
                return false;
            }
            FunctionalArgument lastFunctionalArgument = functionalArgument;
            KotlinType kotlinType2 = lastFunctionalArgument.getReturnType();
            if (kotlinType2 == null) {
                return false;
            }
            KotlinType type2 = kotlinType2;
            boolean isInt = KotlinBuiltIns.isInt((KotlinType)type2);
            if (!(isInt || KotlinBuiltIns.isLong((KotlinType)type2) || KotlinBuiltIns.isUInt((KotlinType)type2) || KotlinBuiltIns.isULong((KotlinType)type2) || KotlinBuiltIns.isDouble((KotlinType)type2))) {
                return false;
            }
            if (isInt && lastFunctionalArgument.isLambda() && CallChainExpressions.Companion.isLiteralValue(lastFunctionalArgument.getLastStatement())) {
                return false;
            }
        }
        if (Intrinsics.areEqual((Object)conversion.getFirstName(), (Object)"map") && Intrinsics.areEqual((Object)conversion.getSecondName(), (Object)"toMap")) {
            Object object = UtilsKt.getCallExpression($expression);
            if (object == null || (object = object.getValueArguments()) == null) {
                return false;
            }
            int argumentSize = object.size();
            if (Intrinsics.areEqual((Object)conversion.getReplacement(), (Object)"associate") && argumentSize != 0 || Intrinsics.areEqual((Object)conversion.getReplacement(), (Object)"associateTo") && argumentSize != 1) {
                return false;
            }
        }
        return conversion.getEnableSuspendFunctionCall() || !this$0.containsSuspendFunctionCall(firstResolvedCall, context);
    }

    private static final Unit buildVisitor$lambda$4$lambda$3(String $replacement, AssociateFunction $associateFunction, KtPsiFactory $this$SimplifyCallChainFix, KtCallExpression callExpression) {
        Name lastArgumentName;
        Intrinsics.checkNotNullParameter((Object)$this$SimplifyCallChainFix, (String)"$this$SimplifyCallChainFix");
        Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
        Name name2 = lastArgumentName = StringsKt.startsWith$default((String)$replacement, (String)"joinTo", (boolean)false, (int)2, null) ? Name.identifier((String)"transform") : null;
        if (lastArgumentName != null) {
            KtExpression argumentExpression;
            KtValueArgument lastArgument;
            Object object = callExpression.getValueArgumentList();
            KtValueArgument ktValueArgument = lastArgument = object != null && (object = object.getArguments()) != null ? (KtValueArgument)CollectionsKt.singleOrNull((List)object) : null;
            Object object2 = argumentExpression = ktValueArgument != null ? ktValueArgument.getArgumentExpression() : null;
            if (argumentExpression != null) {
                lastArgument.replace((PsiElement)KtPsiFactory.createArgument$default((KtPsiFactory)$this$SimplifyCallChainFix, (KtExpression)argumentExpression, (Name)lastArgumentName, (boolean)false, (boolean)false, (int)12, null));
            }
        }
        if ($associateFunction != null) {
            ReplaceAssociateFunctionFix.Companion.replaceLastStatementForAssociateFunction(callExpression, $associateFunction);
        }
        return Unit.INSTANCE;
    }

    private static final Unit buildVisitor$lambda$4(SimplifiableCallChainInspection this$0, ProblemsHolder $holder, boolean $isOnTheFly, KtQualifiedExpression expression) {
        AssociateFunction associateFunction;
        CallChainExpressions callChainExpressions = CallChainExpressions.Companion.from(expression);
        if (callChainExpressions == null) {
            return Unit.INSTANCE;
        }
        CallChainExpressions callChainExpressions2 = callChainExpressions;
        CallChainConversion conversion = null;
        CallChainConversion callChainConversion = this$0.findQualifiedConversion(callChainExpressions2, CallChainConversions.INSTANCE.getConversionGroups(), (arg_0, arg_1, arg_2, arg_3) -> SimplifiableCallChainInspection.buildVisitor$lambda$4$lambda$1(expression, this$0, arg_0, arg_1, arg_2, arg_3));
        if (callChainConversion == null) {
            return Unit.INSTANCE;
        }
        conversion = callChainConversion;
        Pair<AssociateFunction, String> pair = this$0.getAssociateFunction(conversion, expression.getReceiverExpression());
        if (pair != null) {
            Pair<AssociateFunction, String> pair2 = pair;
            boolean bl = false;
            AssociateFunction associateFunction2 = (AssociateFunction)((Object)pair2.component1());
            String associateFunctionName = (String)pair2.component2();
            conversion = CallChainConversion.copy$default(conversion, null, null, associateFunctionName, null, false, false, false, null, 251, null);
            associateFunction = associateFunction2;
        } else {
            associateFunction = null;
        }
        AssociateFunction associateFunction3 = associateFunction;
        String replacement = conversion.getReplacement();
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new SimplifyCallChainFix(conversion, (Function2<? super KtPsiFactory, ? super KtCallExpression, Unit>)((Function2)(arg_0, arg_1) -> SimplifiableCallChainInspection.buildVisitor$lambda$4$lambda$3(replacement, associateFunction3, arg_0, arg_1)))};
        ProblemDescriptor problemDescriptor = $holder.getManager().createProblemDescriptor((PsiElement)expression, callChainExpressions2.getFirstCalleeExpression().getTextRange().shiftRight(-PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)expression))), KotlinBundle.message((String)"call.chain.on.collection.type.may.be.simplified", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, $isOnTheFly, localQuickFixArray);
        Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"createProblemDescriptor(...)");
        ProblemDescriptor descriptor2 = problemDescriptor;
        $holder.registerProblem(descriptor2);
        return Unit.INSTANCE;
    }

    private static final boolean containsSuspendFunctionCall$lambda$6(BindingContext $context, KtCallExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)it), (BindingContext)$context);
        return resolvedCall != null && (resolvedCall = resolvedCall.getResultingDescriptor()) != null ? DescriptorUtilsKt.isSuspend((CallableDescriptor)resolvedCall) : false;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/collections/SimplifiableCallChainInspection$FunctionalArgument;", "", "isLambda", "", "returnType", "Lorg/jetbrains/kotlin/types/KotlinType;", "lastStatement", "Lorg/jetbrains/kotlin/psi/KtExpression;", "<init>", "(ZLorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/psi/KtExpression;)V", "()Z", "getReturnType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "getLastStatement", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "kotlin.idea"})
    private static final class FunctionalArgument {
        private final boolean isLambda;
        @Nullable
        private final KotlinType returnType;
        @Nullable
        private final KtExpression lastStatement;

        public FunctionalArgument(boolean isLambda, @Nullable KotlinType returnType, @Nullable KtExpression lastStatement) {
            this.isLambda = isLambda;
            this.returnType = returnType;
            this.lastStatement = lastStatement;
        }

        public final boolean isLambda() {
            return this.isLambda;
        }

        @Nullable
        public final KotlinType getReturnType() {
            return this.returnType;
        }

        @Nullable
        public final KtExpression getLastStatement() {
            return this.lastStatement;
        }
    }
}

