/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.migration;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.inspections.migration.ObsoleteCodeFix;
import org.jetbrains.kotlin.idea.inspections.migration.ObsoleteCodeProblemReporter;
import org.jetbrains.kotlin.idea.inspections.migration.ObsoleteExperimentalCoroutinesInspectionKt;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001:\u0002!\"B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0014\u001a\u00020\u0005H%J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H$J\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eJ\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0011X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteImportsUsageReporter;", "Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteCodeProblemReporter;", "<init>", "()V", "textMarker", "", "getTextMarker", "()Ljava/lang/String;", "packageBindings", "", "getPackageBindings", "()Ljava/util/Map;", "importsToRemove", "", "getImportsToRemove", "()Ljava/util/Set;", "wholeProjectFix", "Lcom/intellij/codeInspection/LocalQuickFix;", "getWholeProjectFix", "()Lcom/intellij/codeInspection/LocalQuickFix;", "problemMessage", "wrapFix", "fix", "Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteCodeFix;", "report", "", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "simpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "findBinding", "Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteImportsUsageReporter$Binding;", "ObsoleteImportFix", "Binding", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nObsoleteCodeMigrationInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObsoleteCodeMigrationInspection.kt\norg/jetbrains/kotlin/idea/inspections/migration/ObsoleteImportsUsageReporter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,200:1\n1#2:201\n*E\n"})
public abstract class ObsoleteImportsUsageReporter
implements ObsoleteCodeProblemReporter {
    @NotNull
    private final Set<String> importsToRemove = SetsKt.emptySet();

    @NotNull
    protected abstract String getTextMarker();

    @NotNull
    protected abstract Map<String, String> getPackageBindings();

    @NotNull
    protected Set<String> getImportsToRemove() {
        return this.importsToRemove;
    }

    @NotNull
    protected abstract LocalQuickFix getWholeProjectFix();

    @Nls
    @NotNull
    protected abstract String problemMessage();

    @NotNull
    protected abstract LocalQuickFix wrapFix(@NotNull ObsoleteCodeFix var1);

    @Override
    public final boolean report(@NotNull ProblemsHolder holder2, boolean isOnTheFly, @NotNull KtSimpleNameExpression simpleNameExpression) {
        KtExpression reportExpression;
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)simpleNameExpression, (String)"simpleNameExpression");
        if (!Intrinsics.areEqual((Object)simpleNameExpression.getText(), (Object)this.getTextMarker())) {
            return false;
        }
        LocalQuickFix[] localQuickFixArray = simpleNameExpression.getParent();
        KtExpression ktExpression = localQuickFixArray instanceof KtExpression ? (KtExpression)localQuickFixArray : null;
        if (ktExpression == null) {
            return false;
        }
        KtExpression parent2 = ktExpression;
        KtDotQualifiedExpression ktDotQualifiedExpression = parent2 instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)parent2 : null;
        KtExpression ktExpression2 = reportExpression = ktDotQualifiedExpression != null ? (KtExpression)ktDotQualifiedExpression : (KtExpression)simpleNameExpression;
        if (this.findBinding(simpleNameExpression) == null) {
            return false;
        }
        localQuickFixArray = ObsoleteExperimentalCoroutinesInspectionKt.fixesWithWholeProject(isOnTheFly, this.wrapFix(new ObsoleteImportFix()), this.getWholeProjectFix());
        holder2.registerProblem((PsiElement)reportExpression, this.problemMessage(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
        return true;
    }

    private final Binding findBinding(KtSimpleNameExpression simpleNameExpression) {
        Object v2;
        Object fqNameStr;
        KtImportDirective importDirective;
        block5: {
            if (!Intrinsics.areEqual((Object)simpleNameExpression.getText(), (Object)this.getTextMarker())) {
                return null;
            }
            Object object = SequencesKt.lastOrNull((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.getParents((PsiElement)((PsiElement)simpleNameExpression)), ObsoleteImportsUsageReporter::findBinding$lambda$0));
            KtImportDirective ktImportDirective = object instanceof KtImportDirective ? (KtImportDirective)object : null;
            if (ktImportDirective == null) {
                return null;
            }
            importDirective = ktImportDirective;
            Object object2 = importDirective.getImportedFqName();
            if (object2 == null || (object2 = object2.asString()) == null) {
                return null;
            }
            fqNameStr = object2;
            Iterable iterable = this.getPackageBindings().entrySet();
            for (Object t : iterable) {
                Map.Entry entry = (Map.Entry)t;
                boolean bl = false;
                String affectedImportPrefix = (String)entry.getKey();
                if (!StringsKt.startsWith$default((String)fqNameStr, (String)affectedImportPrefix, (boolean)false, (int)2, null)) continue;
                v2 = t;
                break block5;
            }
            v2 = null;
        }
        Map.Entry entry = v2;
        if (entry == null) {
            return null;
        }
        Map.Entry bindEntry = entry;
        return new Binding(new FqName((String)bindEntry.getValue()), this.getImportsToRemove().contains(fqNameStr), importDirective);
    }

    private static final boolean findBinding$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof KtDotQualifiedExpression || it instanceof KtImportDirective;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteImportsUsageReporter$Binding;", "", "bindTo", "Lorg/jetbrains/kotlin/name/FqName;", "shouldRemove", "", "importDirective", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "<init>", "(Lorg/jetbrains/kotlin/name/FqName;ZLorg/jetbrains/kotlin/psi/KtImportDirective;)V", "getBindTo", "()Lorg/jetbrains/kotlin/name/FqName;", "getShouldRemove", "()Z", "getImportDirective", "()Lorg/jetbrains/kotlin/psi/KtImportDirective;", "kotlin.idea"})
    private static final class Binding {
        @NotNull
        private final FqName bindTo;
        private final boolean shouldRemove;
        @NotNull
        private final KtImportDirective importDirective;

        public Binding(@NotNull FqName bindTo, boolean shouldRemove, @NotNull KtImportDirective importDirective) {
            Intrinsics.checkNotNullParameter((Object)bindTo, (String)"bindTo");
            Intrinsics.checkNotNullParameter((Object)importDirective, (String)"importDirective");
            this.bindTo = bindTo;
            this.shouldRemove = shouldRemove;
            this.importDirective = importDirective;
        }

        @NotNull
        public final FqName getBindTo() {
            return this.bindTo;
        }

        public final boolean getShouldRemove() {
            return this.shouldRemove;
        }

        @NotNull
        public final KtImportDirective getImportDirective() {
            return this.importDirective;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteImportsUsageReporter$ObsoleteImportFix;", "Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteCodeFix;", "<init>", "(Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteImportsUsageReporter;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "kotlin.idea"})
    private final class ObsoleteImportFix
    implements ObsoleteCodeFix {
        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            KtExpression ktExpression;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement element = descriptor2.getPsiElement();
            Object object = element instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)element : (element instanceof KtDotQualifiedExpression ? ((ktExpression = ((KtDotQualifiedExpression)element).getSelectorExpression()) instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)ktExpression : null) : null);
            if (object == null) {
                return;
            }
            KtSimpleNameExpression simpleNameExpression = object;
            Binding binding = ObsoleteImportsUsageReporter.this.findBinding(simpleNameExpression);
            if (binding == null) {
                return;
            }
            Binding binding2 = binding;
            if (binding2.getShouldRemove()) {
                binding2.getImportDirective().delete();
            } else {
                KtSimpleNameReference.bindToFqName$default((KtSimpleNameReference)ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)simpleNameExpression), (FqName)binding2.getBindTo(), (KtSimpleNameReference.ShorteningMode)KtSimpleNameReference.ShorteningMode.NO_SHORTENING, null, (int)4, null);
            }
        }
    }
}

