/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.codeinsight.utils.InvertIfConditionUtils;
import org.jetbrains.kotlin.idea.core.GenerateUtilsKt;
import org.jetbrains.kotlin.idea.inspections.ReplaceNegatedIsEmptyWithIsNotEmptyInspection;
import org.jetbrains.kotlin.idea.intentions.ConvertBinaryExpressionWithDemorgansLawIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.util.CommentSaver;
import org.jetbrains.kotlin.idea.util.psi.patternMatching.KotlinPsiUnifierKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiChildRange;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/InvertIfConditionIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "<init>", "()V", "isApplicableTo", "", "element", "caretOffset", "", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "handleSpecialCases", "ifExpression", "newCondition", "Lorg/jetbrains/kotlin/psi/KtExpression;", "exitStatementExecutedAfter", "expression", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nInvertIfConditionIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InvertIfConditionIntention.kt\norg/jetbrains/kotlin/idea/intentions/InvertIfConditionIntention\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,185:1\n57#2,11:186\n21#2,2:197\n31#2,2:199\n*S KotlinDebug\n*F\n+ 1 InvertIfConditionIntention.kt\norg/jetbrains/kotlin/idea/intentions/InvertIfConditionIntention\n*L\n91#1:186,11\n91#1:197,2\n150#1:199,2\n*E\n"})
public final class InvertIfConditionIntention
extends SelfTargetingIntention<KtIfExpression> {
    public InvertIfConditionIntention() {
        super(KtIfExpression.class, KotlinBundle.lazyMessage((String)"invert.if.condition", (Object[])new Object[0]), null, 4, null);
    }

    @Override
    public boolean isApplicableTo(@NotNull KtIfExpression element, int caretOffset) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!element.getIfKeyword().getTextRange().containsOffset(caretOffset)) {
            return false;
        }
        return element.getCondition() != null && element.getThen() != null;
    }

    @Override
    public void applyTo(@NotNull KtIfExpression element, @Nullable Editor editor) {
        block9: {
            Editor editor2;
            PsiChildRange psiChildRange;
            KtIfExpression newIf;
            KtExpression newCondition;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            PsiElement rBrace = InvertIfConditionUtils.INSTANCE.parentBlockRBrace(element);
            PsiChildRange commentSavingRange = rBrace != null ? new PsiChildRange((PsiElement)element, rBrace) : PsiChildRange.Companion.singleElement((PsiElement)element);
            CommentSaver commentSaver = new CommentSaver(commentSavingRange, false, 2, null);
            if (rBrace != null) {
                PsiElement psiElement = InvertIfConditionUtils.INSTANCE.nextEolCommentOnSameLine(element);
                if (psiElement != null) {
                    psiElement.delete();
                }
            }
            KtExpression ktExpression = element.getCondition();
            Intrinsics.checkNotNull((Object)ktExpression);
            KtExpression condition2 = ktExpression;
            KtQualifiedExpression ktQualifiedExpression = condition2 instanceof KtQualifiedExpression ? (KtQualifiedExpression)condition2 : null;
            KtExpression ktExpression2 = newCondition = ktQualifiedExpression != null && (ktQualifiedExpression = ReplaceNegatedIsEmptyWithIsNotEmptyInspection.Util.invertSelectorFunction$default(ReplaceNegatedIsEmptyWithIsNotEmptyInspection.Util.INSTANCE, ktQualifiedExpression, null, 1, null)) != null ? (KtExpression)ktQualifiedExpression : UtilsKt.negate$default(condition2, false, 1, null);
            KtIfExpression ktIfExpression = this.handleSpecialCases(element, newCondition);
            if (ktIfExpression == null) {
                ktIfExpression = newIf = InvertIfConditionUtils.INSTANCE.handleStandardCase(element, newCondition);
            }
            if (rBrace != null) {
                psiChildRange = new PsiChildRange((PsiElement)newIf, rBrace);
            } else {
                PsiElement psiElement = (PsiElement)newIf;
                PsiElement psiElement2 = InvertIfConditionUtils.INSTANCE.parentBlockRBrace(newIf);
                if (psiElement2 == null) {
                    psiElement2 = (PsiElement)newIf;
                }
                psiChildRange = new PsiChildRange(psiElement, psiElement2);
            }
            PsiChildRange commentRestoreRange = psiChildRange;
            CommentSaver.restore$default(commentSaver, commentRestoreRange, false, false, false, 14, null);
            KtExpression newIfCondition = newIf.getCondition();
            KtPrefixExpression ktPrefixExpression = newIfCondition instanceof KtPrefixExpression ? (KtPrefixExpression)newIfCondition : null;
            if (ktPrefixExpression != null) {
                KtPrefixExpression it = ktPrefixExpression;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getOperationReference().getReferencedNameElementType(), (Object)KtTokens.EXCL)) {
                    KtBinaryExpression binaryExpr;
                    KtExpression ktExpression3 = it.getBaseExpression();
                    KtParenthesizedExpression ktParenthesizedExpression = ktExpression3 instanceof KtParenthesizedExpression ? (KtParenthesizedExpression)ktExpression3 : null;
                    KtExpression ktExpression4 = ktParenthesizedExpression != null ? ktParenthesizedExpression.getExpression() : null;
                    KtBinaryExpression ktBinaryExpression = binaryExpr = ktExpression4 instanceof KtBinaryExpression ? (KtBinaryExpression)ktExpression4 : null;
                    if (binaryExpr != null) {
                        ConvertBinaryExpressionWithDemorgansLawIntention.Holder.INSTANCE.convertIfPossible(binaryExpr);
                    }
                }
            }
            Editor editor3 = editor;
            if (editor3 == null) break block9;
            Editor $this$applyTo_u24lambda_u241 = editor2 = editor3;
            boolean bl = false;
            GenerateUtilsKt.unblockDocument($this$applyTo_u24lambda_u241);
            GenerateUtilsKt.moveCaret$default($this$applyTo_u24lambda_u241, newIf.getTextOffset(), null, 2, null);
        }
    }

    private final KtIfExpression handleSpecialCases(KtIfExpression ifExpression2, KtExpression newCondition) {
        KtExpression elseBranch2 = ifExpression2.getElse();
        if (elseBranch2 != null) {
            return null;
        }
        Project project = ifExpression2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        KtExpression ktExpression = ifExpression2.getThen();
        Intrinsics.checkNotNull((Object)ktExpression);
        KtExpression thenBranch = ktExpression;
        KtExpression lastThenStatement = KtPsiUtilKt.lastBlockStatementOrThis((KtExpression)thenBranch);
        if (org.jetbrains.kotlin.idea.codeinsights.impl.base.UtilsKt.isExitStatement(lastThenStatement)) {
            KtBlockExpression block;
            PsiElement psiElement = ifExpression2.getParent();
            KtBlockExpression ktBlockExpression = block = psiElement instanceof KtBlockExpression ? (KtBlockExpression)psiElement : null;
            if (block != null) {
                Iterator<Object> iterator;
                List afterIfInBlock;
                block13: {
                    PsiElement rBrace = block.getRBrace();
                    afterIfInBlock = SequencesKt.toList((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.siblings$default((PsiElement)((PsiElement)ifExpression2), (boolean)false, (boolean)false, (int)1, null), arg_0 -> InvertIfConditionIntention.handleSpecialCases$lambda$2(rBrace, arg_0)));
                    Iterable $this$lastIsInstanceOrNull$iv = afterIfInBlock;
                    boolean $i$f$lastIsInstanceOrNull = false;
                    if ($this$lastIsInstanceOrNull$iv instanceof List) {
                        int n = ((Collection)$this$lastIsInstanceOrNull$iv).size() + -1;
                        if (0 <= n) {
                            do {
                                int i$iv;
                                Iterator<Object> element$iv;
                                if (!((element$iv = ((List)$this$lastIsInstanceOrNull$iv).get(i$iv = n--)) instanceof KtExpression)) continue;
                                iterator = element$iv;
                                break block13;
                            } while (0 <= n);
                        }
                        iterator = null;
                    } else {
                        Iterable $this$firstIsInstanceOrNull$iv$iv = CollectionsKt.reversed((Iterable)$this$lastIsInstanceOrNull$iv);
                        boolean $i$f$firstIsInstanceOrNull = false;
                        for (Object element$iv$iv : $this$firstIsInstanceOrNull$iv$iv) {
                            if (!(element$iv$iv instanceof KtExpression)) continue;
                            iterator = (Iterator<Object>)element$iv$iv;
                            break block13;
                        }
                        iterator = null;
                    }
                }
                KtExpression lastStatementInBlock = (KtExpression)iterator;
                if (lastStatementInBlock != null) {
                    KtExpression exitStatementAfterIf;
                    KtExpression ktExpression2 = exitStatementAfterIf = org.jetbrains.kotlin.idea.codeinsights.impl.base.UtilsKt.isExitStatement(lastStatementInBlock) ? lastStatementInBlock : this.exitStatementExecutedAfter(lastStatementInBlock);
                    if (exitStatementAfterIf != null) {
                        KtExpression exitAfterNewIf;
                        PsiElement first2 = (PsiElement)CollectionsKt.first((List)afterIfInBlock);
                        PsiElement last = (PsiElement)CollectionsKt.last((List)afterIfInBlock);
                        PsiChildRange newThenRange = InvertIfConditionUtils.INSTANCE.isEmptyReturn(lastThenStatement) && InvertIfConditionUtils.INSTANCE.isEmptyReturn(lastStatementInBlock) ? PsiUtilsKt.trimWhiteSpaces((PsiChildRange)new PsiChildRange(first2, lastStatementInBlock.getPrevSibling())) : PsiUtilsKt.trimWhiteSpaces((PsiChildRange)new PsiChildRange(first2, last));
                        Object[] objectArray = new Object[]{newCondition, newThenRange};
                        KtExpression ktExpression3 = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"if ($0) { $1 }", (Object[])objectArray, (boolean)false, (int)4, null);
                        Intrinsics.checkNotNull((Object)ktExpression3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
                        KtIfExpression newIf = (KtIfExpression)ktExpression3;
                        block.deleteChildRange(first2, last);
                        if (InvertIfConditionUtils.INSTANCE.isEmptyReturn(lastThenStatement) && block.getParent() instanceof KtDeclarationWithBody && !(block.getParent() instanceof KtFunctionLiteral)) {
                            lastThenStatement.delete();
                        }
                        KtIfExpression updatedIf = InvertIfConditionUtils.INSTANCE.copyThenBranchAfter(ifExpression2);
                        if (!(Intrinsics.areEqual((Object)exitStatementAfterIf, (Object)lastStatementInBlock) || (exitAfterNewIf = this.exitStatementExecutedAfter((KtExpression)updatedIf)) != null && KotlinPsiUnifierKt.matches((PsiElement)exitAfterNewIf, (PsiElement)exitStatementAfterIf))) {
                            KtExpression ktExpression4 = newIf.getThen();
                            Intrinsics.checkNotNull((Object)ktExpression4, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockExpression");
                            KtBlockExpression newThen = (KtBlockExpression)ktExpression4;
                            newThen.addBefore((PsiElement)exitStatementAfterIf, newThen.getRBrace());
                        }
                        PsiElement psiElement2 = updatedIf.replace((PsiElement)newIf);
                        Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
                        return (KtIfExpression)psiElement2;
                    }
                }
            }
        }
        KtExpression ktExpression5 = this.exitStatementExecutedAfter((KtExpression)ifExpression2);
        if (ktExpression5 == null) {
            return null;
        }
        KtExpression exitStatement = ktExpression5;
        KtIfExpression updatedIf = InvertIfConditionUtils.INSTANCE.copyThenBranchAfter(ifExpression2);
        Object[] objectArray = new Object[]{newCondition, exitStatement};
        KtExpression newIf = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"if ($0) $1", (Object[])objectArray, (boolean)false, (int)4, null);
        PsiElement psiElement = updatedIf.replace((PsiElement)newIf);
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
        return (KtIfExpression)psiElement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final KtExpression exitStatementExecutedAfter(KtExpression expression) {
        PsiElement parent2 = expression.getParent();
        if (parent2 instanceof KtBlockExpression) {
            KtExpression ktExpression;
            List list2 = ((KtBlockExpression)parent2).getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStatements(...)");
            KtExpression lastStatement = (KtExpression)CollectionsKt.last((List)list2);
            if (Intrinsics.areEqual((Object)expression, (Object)lastStatement)) {
                ktExpression = this.exitStatementExecutedAfter((KtExpression)parent2);
                return ktExpression;
            } else {
                Object element$iv;
                Intrinsics.checkNotNull((Object)lastStatement);
                if (!org.jetbrains.kotlin.idea.codeinsights.impl.base.UtilsKt.isExitStatement(lastStatement)) return null;
                Sequence $this$firstIsInstance$iv = PsiUtilsKt.siblings$default((PsiElement)((PsiElement)expression), (boolean)false, (boolean)false, (int)1, null);
                boolean $i$f$firstIsInstance = false;
                Iterator iterator = $this$firstIsInstance$iv.iterator();
                do {
                    if (!iterator.hasNext()) throw new NoSuchElementException("No element of given type found");
                } while (!((element$iv = iterator.next()) instanceof KtExpression));
                if (!Intrinsics.areEqual(element$iv, (Object)lastStatement)) return null;
                ktExpression = lastStatement;
            }
            return ktExpression;
        }
        PsiElement psiElement = parent2;
        if (psiElement instanceof KtNamedFunction) {
            if (!Intrinsics.areEqual((Object)((KtNamedFunction)parent2).getBodyExpression(), (Object)expression)) return null;
            if (!((KtNamedFunction)parent2).hasBlockBody()) {
                return null;
            }
            FunctionDescriptor functionDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default((KtNamedFunction)parent2, null, 1, null);
            if (functionDescriptor == null) return null;
            KotlinType kotlinType = functionDescriptor.getReturnType();
            KotlinType returnType = kotlinType;
            if (returnType == null) return null;
            if (!TypeUtilsKt.isUnit((KotlinType)returnType)) {
                return null;
            }
            Project project = expression.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return new KtPsiFactory(project, false, 2, null).createExpression("return");
        }
        if (!(psiElement instanceof KtContainerNode)) return null;
        PsiElement pparent = ((KtContainerNode)parent2).getParent();
        if (pparent instanceof KtLoopExpression) {
            if (!Intrinsics.areEqual((Object)expression, (Object)((KtLoopExpression)pparent).getBody())) return null;
            Project project = expression.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return new KtPsiFactory(project, false, 2, null).createExpression("continue");
        }
        if (!(pparent instanceof KtIfExpression)) return null;
        if (Intrinsics.areEqual((Object)expression, (Object)((KtIfExpression)pparent).getThen())) return this.exitStatementExecutedAfter((KtExpression)pparent);
        if (!Intrinsics.areEqual((Object)expression, (Object)((KtIfExpression)pparent).getElse())) return null;
        return this.exitStatementExecutedAfter((KtExpression)pparent);
    }

    private static final boolean handleSpecialCases$lambda$2(PsiElement $rBrace, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !Intrinsics.areEqual((Object)it, (Object)$rBrace);
    }
}

