/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.fixes;

import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.analysis.api.utils.ShortenUtilsKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.codeinsight.utils.EditorUtilsKt;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.k2.codeinsight.fixes.ActualWithoutExpectFactoryKt;
import org.jetbrains.kotlin.idea.quickfix.createFromUsage.CreateClassUtil;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.introduce.IntroduceUtilsKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtClassOrObjectKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B-\b\u0004\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0017\u001a\u00020\u0012H\u0016J#\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\nH\u0084\u0002J)\u0010\u001f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0004\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010 J$\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#2\b\b\u0001\u0010$\u001a\u00020\u00122\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u001a\u0010%\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010&\u001a\u00020\u0014H\u0004J\n\u0010'\u001a\u0004\u0018\u00010\nH\u0002R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002()\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/CreateExpectedFix;", "D", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "declaration", "targetExpectedClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "module", "Lcom/intellij/openapi/module/Module;", "targetFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lcom/intellij/openapi/module/Module;Lorg/jetbrains/kotlin/psi/KtFile;)V", "getModule", "()Lcom/intellij/openapi/module/Module;", "getTargetFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "getFamilyName", "", "startInWriteAction", "", "targetExpectedClassPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "generate", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;)Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "showInaccessibleDeclarationError", "element", "Lcom/intellij/psi/PsiElement;", "message", "isCorrectAndHaveAccessibleModifiers", "showErrorHint", "getOrCreateImplementationFile", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/CreateExpectedCallableMemberFix;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/CreateExpectedClassFix;", "kotlin.code-insight.fixes.k2"})
@SourceDebugExtension(value={"SMAP\nActualWithoutExpectFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActualWithoutExpectFactory.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/fixes/CreateExpectedFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtClassOrObject.kt\norg/jetbrains/kotlin/psi/KtClassOrObject\n*L\n1#1,272:1\n1#2:273\n68#3,6:274\n*S KotlinDebug\n*F\n+ 1 ActualWithoutExpectFactory.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/fixes/CreateExpectedFix\n*L\n150#1:274,6\n*E\n"})
public abstract class CreateExpectedFix<D extends KtNamedDeclaration>
extends KotlinQuickFixAction<D> {
    @NotNull
    private final Module module;
    @Nullable
    private final KtFile targetFile;
    @Nullable
    private final SmartPsiElementPointer<KtClassOrObject> targetExpectedClassPointer;

    private CreateExpectedFix(D declaration, KtClassOrObject targetExpectedClass, Module module, KtFile targetFile) {
        super((PsiElement)declaration);
        this.module = module;
        this.targetFile = targetFile;
        KtClassOrObject ktClassOrObject = targetExpectedClass;
        this.targetExpectedClassPointer = ktClassOrObject != null ? SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)ktClassOrObject)) : null;
    }

    @NotNull
    public final Module getModule() {
        return this.module;
    }

    @Nullable
    public final KtFile getTargetFile() {
        return this.targetFile;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"fix.create.expect.actual", (Object[])new Object[0]);
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{CreateClassUtil.INSTANCE.getTypeDescription((KtNamedDeclaration)this.getElement()), this.module.getName()};
        return KotlinBundle.message((String)"create.expected.0.in.common.module.1", (Object[])objectArray);
    }

    @Override
    protected final void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            SmartPsiElementPointer<KtClassOrObject> smartPsiElementPointer = this.targetExpectedClassPointer;
            Object targetExpectedClass = smartPsiElementPointer != null ? (KtClassOrObject)smartPsiElementPointer.getElement() : null;
            KtClassOrObject ktClassOrObject = targetExpectedClass;
            if ((ktClassOrObject == null || (ktClassOrObject = ktClassOrObject.getContainingKtFile()) == null) && (ktClassOrObject = this.getOrCreateImplementationFile()) == null) {
                return;
            }
            KtClassOrObject expectedFile = ktClassOrObject;
            KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)this.getElement();
            if (ktNamedDeclaration == null) {
                return;
            }
            KtNamedDeclaration declaration = ktNamedDeclaration;
            KtNamedDeclaration ktNamedDeclaration2 = this.generate(project, (KtClassOrObject)targetExpectedClass, (D)declaration);
            if (ktNamedDeclaration2 == null) {
                return;
            }
            KtNamedDeclaration expectPrototype = ktNamedDeclaration2;
            PsiElement target = (PsiElement)ApplicationUtilsKt.executeWriteCommand(project, this.getFamilyName(), null, () -> CreateExpectedFix.invoke$lambda$1((KtClassOrObject)targetExpectedClass, expectPrototype, (KtFile)expectedFile));
            Editor editor2 = EditorHelper.openInEditor((PsiElement)target);
            if (editor2 == null || (editor2 = editor2.getCaretModel()) == null) break block3;
            KtNamedDeclaration ktNamedDeclaration3 = target instanceof KtNamedDeclaration ? (KtNamedDeclaration)target : null;
            editor2.moveToOffset(ktNamedDeclaration3 != null && (ktNamedDeclaration3 = ktNamedDeclaration3.getNameIdentifier()) != null ? PsiUtilsKt.getStartOffset((PsiElement)ktNamedDeclaration3) : PsiUtilsKt.getStartOffset((PsiElement)target), true);
        }
    }

    @Nullable
    public abstract D generate(@NotNull Project var1, @Nullable KtClassOrObject var2, @NotNull D var3);

    public final void showInaccessibleDeclarationError(@NotNull PsiElement element, @NlsContexts.DialogMessage @NotNull String message2, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        if (editor != null) {
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            String string = StringUtil.escapeXmlEntities((String)message2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeXmlEntities(...)");
            IntroduceUtilsKt.showErrorHint(project, editor, string, KotlinBundle.message((String)"inaccessible.declaration", (Object[])new Object[0]));
        }
    }

    public static /* synthetic */ void showInaccessibleDeclarationError$default(CreateExpectedFix createExpectedFix, PsiElement psiElement, String string, Editor editor, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: showInaccessibleDeclarationError");
        }
        if ((n & 4) != 0) {
            editor = EditorUtilsKt.findExistingEditor(psiElement);
        }
        createExpectedFix.showInaccessibleDeclarationError(psiElement, string, editor);
    }

    protected final boolean isCorrectAndHaveAccessibleModifiers(@NotNull KtNamedDeclaration declaration, boolean showErrorHint) {
        Object v0;
        block6: {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Iterable iterable = ActualWithoutExpectFactoryKt.access$getINACCESSIBLE_MODIFIERS$p();
            for (Object t : iterable) {
                KtModifierKeywordToken it = (KtModifierKeywordToken)t;
                boolean bl = false;
                if (!declaration.hasModifier(it)) continue;
                v0 = t;
                break block6;
            }
            v0 = null;
        }
        KtModifierKeywordToken inaccessibleModifier = v0;
        if (inaccessibleModifier != null) {
            if (showErrorHint) {
                Object[] objectArray = new Object[]{inaccessibleModifier};
                CreateExpectedFix.showInaccessibleDeclarationError$default(this, (PsiElement)declaration, KotlinBundle.message((String)"the.declaration.has.0.modifier", (Object[])objectArray), null, 4, null);
            }
            return false;
        }
        if (declaration instanceof KtFunction && ((KtFunction)declaration).hasBody()) {
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)declaration));
            boolean bl = ktClassOrObject != null ? KotlinCommonRefactoringUtilKt.isInterfaceClass((PsiElement)ktClassOrObject) : false;
            if (bl) {
                if (showErrorHint) {
                    CreateExpectedFix.showInaccessibleDeclarationError$default(this, (PsiElement)declaration, KotlinBundle.message((String)"the.function.declaration.shouldn.t.have.a.default.implementation", (Object[])new Object[0]), null, 4, null);
                }
                return false;
            }
        }
        return true;
    }

    public static /* synthetic */ boolean isCorrectAndHaveAccessibleModifiers$default(CreateExpectedFix createExpectedFix, KtNamedDeclaration ktNamedDeclaration, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: isCorrectAndHaveAccessibleModifiers");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return createExpectedFix.isCorrectAndHaveAccessibleModifiers(ktNamedDeclaration, bl);
    }

    private final KtFile getOrCreateImplementationFile() {
        Object t = this.getElement();
        KtNamedDeclaration ktNamedDeclaration = t instanceof KtNamedDeclaration ? (KtNamedDeclaration)t : null;
        if (ktNamedDeclaration == null) {
            return null;
        }
        KtNamedDeclaration declaration = ktNamedDeclaration;
        KtFile ktFile2 = this.targetFile;
        if (ktFile2 == null) {
            ktFile2 = PackageUtilsKt.createFileForDeclaration$default(this.module, declaration, null, 4, null);
        }
        return ktFile2;
    }

    private static final PsiElement invoke$lambda$1(KtClassOrObject $targetExpectedClass, KtNamedDeclaration $expectPrototype, KtFile $expectedFile) {
        PsiElement psiElement;
        KtElement ktElement;
        PsiElement psiElement2;
        if ($targetExpectedClass != null && $expectPrototype instanceof KtPrimaryConstructor) {
            psiElement2 = $targetExpectedClass.add((PsiElement)$expectPrototype);
        } else {
            KtClassOrObject ktClassOrObject = $targetExpectedClass;
            if (ktClassOrObject != null) {
                PsiElement anchor$iv;
                KtClassOrObject this_$iv = ktClassOrObject;
                boolean $i$f$addDeclaration = false;
                KtClassBody body$iv = KtClassOrObjectKt.getOrCreateBody((KtClassOrObject)this_$iv);
                PsiElement psiElement3 = body$iv.getRBrace();
                if (psiElement3 == null) {
                    PsiElement psiElement4 = body$iv.getLastChild();
                    psiElement3 = psiElement4;
                    Intrinsics.checkNotNull((Object)psiElement4);
                }
                Class[] classArray = new Class[]{PsiWhiteSpace.class};
                PsiElement psiElement5 = anchor$iv = PsiTreeUtil.skipSiblingsBackward((PsiElement)psiElement3, (Class[])classArray);
                PsiElement psiElement6 = (psiElement5 != null ? psiElement5.getNextSibling() : null) instanceof PsiErrorElement ? body$iv.addBefore((PsiElement)((KtDeclaration)$expectPrototype), anchor$iv) : body$iv.addAfter((PsiElement)((KtDeclaration)$expectPrototype), anchor$iv);
                if (psiElement6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDeclaration");
                }
                psiElement2 = (PsiElement)((KtDeclaration)psiElement6);
            } else {
                psiElement2 = $expectedFile.add((PsiElement)$expectPrototype);
            }
        }
        PsiElement psiElement7 = psiElement2;
        Intrinsics.checkNotNull((Object)psiElement7, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
        KtElement initial = (KtElement)psiElement7;
        PsiElement shortened = ShortenUtilsKt.shortenReferences$default(initial, null, null, null, 14, null);
        KtElement it = ktElement = initial;
        boolean bl = false;
        Object object = initial.isValid() ? ktElement : null;
        if (object != null) {
            psiElement = (PsiElement)object;
        } else {
            psiElement = shortened;
            if (psiElement == null) {
                psiElement = (PsiElement)initial;
            }
        }
        return psiElement;
    }

    public /* synthetic */ CreateExpectedFix(KtNamedDeclaration declaration, KtClassOrObject targetExpectedClass, Module module, KtFile targetFile, DefaultConstructorMarker $constructor_marker) {
        this(declaration, targetExpectedClass, module, targetFile);
    }
}

