/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.fixes.imprt.factories;

import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.diagnostics.KaDiagnosticWithPsi;
import org.jetbrains.kotlin.analysis.api.fir.diagnostics.KaFirDiagnostic;
import org.jetbrains.kotlin.idea.base.analysis.api.utils.KtSymbolFromIndexProvider;
import org.jetbrains.kotlin.idea.highlighter.UnresolvedReferenceDiagnosticsRestorationKt;
import org.jetbrains.kotlin.idea.k2.codeinsight.fixes.imprt.AbstractImportCandidatesProvider;
import org.jetbrains.kotlin.idea.k2.codeinsight.fixes.imprt.AnnotationImportCandidatesProvider;
import org.jetbrains.kotlin.idea.k2.codeinsight.fixes.imprt.CallableImportCandidatesProvider;
import org.jetbrains.kotlin.idea.k2.codeinsight.fixes.imprt.ClassifierImportCandidatesProvider;
import org.jetbrains.kotlin.idea.k2.codeinsight.fixes.imprt.ConstructorReferenceImportCandidatesProvider;
import org.jetbrains.kotlin.idea.k2.codeinsight.fixes.imprt.DefaultImportContext;
import org.jetbrains.kotlin.idea.k2.codeinsight.fixes.imprt.EnumEntryImportCandidatesProvider;
import org.jetbrains.kotlin.idea.k2.codeinsight.fixes.imprt.ImportCandidate;
import org.jetbrains.kotlin.idea.k2.codeinsight.fixes.imprt.ImportContext;
import org.jetbrains.kotlin.idea.k2.codeinsight.fixes.imprt.ImportPositionType;
import org.jetbrains.kotlin.idea.k2.codeinsight.fixes.imprt.ImportPositionTypeAndReceiver;
import org.jetbrains.kotlin.idea.k2.codeinsight.fixes.imprt.factories.AbstractImportQuickFixFactory;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0014J\"\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\f\u001a\u00020\u0005H\u0014J*\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u001f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\f\u001a\u00020\u0005H\u0002R\u00020\u0006\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/imprt/factories/UnresolvedNameReferenceImportQuickFixFactory;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/imprt/factories/AbstractImportQuickFixFactory;", "<init>", "()V", "detectPositionContext", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/imprt/ImportContext;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "diagnostic", "Lorg/jetbrains/kotlin/analysis/api/diagnostics/KaDiagnosticWithPsi;", "provideUnresolvedNames", "", "Lorg/jetbrains/kotlin/name/Name;", "importContext", "provideImportCandidates", "", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/imprt/ImportCandidate;", "unresolvedName", "indexProvider", "Lorg/jetbrains/kotlin/idea/base/analysis/api/utils/KtSymbolFromIndexProvider;", "getCandidateProvidersForUnresolvedNameReference", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/imprt/AbstractImportCandidatesProvider;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/imprt/ImportContext;)Lkotlin/sequences/Sequence;", "kotlin.code-insight.fixes.k2"})
public final class UnresolvedNameReferenceImportQuickFixFactory
extends AbstractImportQuickFixFactory {
    @NotNull
    public static final UnresolvedNameReferenceImportQuickFixFactory INSTANCE = new UnresolvedNameReferenceImportQuickFixFactory();

    private UnresolvedNameReferenceImportQuickFixFactory() {
    }

    @Override
    @Nullable
    protected ImportContext detectPositionContext(@NotNull KaSession $this$detectPositionContext, @NotNull KaDiagnosticWithPsi<?> diagnostic) {
        ImportContext importContext;
        Intrinsics.checkNotNullParameter((Object)$this$detectPositionContext, (String)"<this>");
        Intrinsics.checkNotNullParameter(diagnostic, (String)"diagnostic");
        KaDiagnosticWithPsi<?> kaDiagnosticWithPsi = diagnostic;
        if (kaDiagnosticWithPsi instanceof KaFirDiagnostic.UnresolvedImport || kaDiagnosticWithPsi instanceof KaFirDiagnostic.UnresolvedReference || kaDiagnosticWithPsi instanceof KaFirDiagnostic.UnresolvedReferenceWrongReceiver || kaDiagnosticWithPsi instanceof KaFirDiagnostic.InvisibleReference) {
            PsiElement psiElement = UnresolvedReferenceDiagnosticsRestorationKt.getOperationReferenceForBinaryExpressionOrThis(((KaFirDiagnostic)diagnostic).getPsi());
            KtElement ktElement = psiElement instanceof KtElement ? (KtElement)psiElement : null;
            if (ktElement == null) {
                return null;
            }
            KtElement diagnosticPsi = ktElement;
            importContext = new DefaultImportContext(diagnosticPsi, ImportPositionTypeAndReceiver.Companion.detect(diagnosticPsi));
        } else {
            importContext = null;
        }
        return importContext;
    }

    @Override
    @NotNull
    protected Set<Name> provideUnresolvedNames(@NotNull KaDiagnosticWithPsi<?> diagnostic, @NotNull ImportContext importContext) {
        Set set;
        Intrinsics.checkNotNullParameter(diagnostic, (String)"diagnostic");
        Intrinsics.checkNotNullParameter((Object)importContext, (String)"importContext");
        KtElement ktElement = importContext.getPosition();
        Object object = ktElement instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)ktElement : null;
        if ((object != null && (object = ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)object)) != null && (object = object.getResolvesByNames()) != null ? CollectionsKt.toSet((Iterable)((Iterable)object)) : (set = null)) == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    @Override
    @NotNull
    protected List<ImportCandidate> provideImportCandidates(@NotNull KaSession $this$provideImportCandidates, @NotNull Name unresolvedName, @NotNull ImportContext importContext, @NotNull KtSymbolFromIndexProvider indexProvider) {
        Intrinsics.checkNotNullParameter((Object)$this$provideImportCandidates, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unresolvedName, (String)"unresolvedName");
        Intrinsics.checkNotNullParameter((Object)importContext, (String)"importContext");
        Intrinsics.checkNotNullParameter((Object)indexProvider, (String)"indexProvider");
        Sequence<AbstractImportCandidatesProvider> providers = this.getCandidateProvidersForUnresolvedNameReference($this$provideImportCandidates, importContext);
        return SequencesKt.toList((Sequence)SequencesKt.flatMapIterable(providers, arg_0 -> UnresolvedNameReferenceImportQuickFixFactory.provideImportCandidates$lambda$0($this$provideImportCandidates, unresolvedName, indexProvider, arg_0)));
    }

    private final Sequence<AbstractImportCandidatesProvider> getCandidateProvidersForUnresolvedNameReference(KaSession $context_receiver_0, ImportContext importContext) {
        Sequence sequence;
        ImportPositionType importPositionType = importContext.getPositionType();
        if (importPositionType instanceof ImportPositionType.TypeReference) {
            Object[] objectArray = new ClassifierImportCandidatesProvider[]{new ClassifierImportCandidatesProvider(importContext)};
            sequence = SequencesKt.sequenceOf((Object[])objectArray);
        } else if (importPositionType instanceof ImportPositionType.Annotation) {
            Object[] objectArray = new AnnotationImportCandidatesProvider[]{new AnnotationImportCandidatesProvider(importContext)};
            sequence = SequencesKt.sequenceOf((Object[])objectArray);
        } else if (importPositionType instanceof ImportPositionType.DefaultCall) {
            Object[] objectArray = new AbstractImportCandidatesProvider[]{new CallableImportCandidatesProvider(importContext, false, 2, null), new ClassifierImportCandidatesProvider(importContext), new EnumEntryImportCandidatesProvider(importContext)};
            sequence = SequencesKt.sequenceOf((Object[])objectArray);
        } else if (importPositionType instanceof ImportPositionType.DotCall || importPositionType instanceof ImportPositionType.SafeCall || importPositionType instanceof ImportPositionType.InfixCall || importPositionType instanceof ImportPositionType.OperatorCall) {
            Object[] objectArray = new CallableImportCandidatesProvider[]{new CallableImportCandidatesProvider(importContext, false, 2, null)};
            sequence = SequencesKt.sequenceOf((Object[])objectArray);
        } else if (importPositionType instanceof ImportPositionType.KDocNameReference) {
            sequence = SequencesKt.sequenceOf((Object[])new AbstractImportCandidatesProvider[0]);
        } else if (importPositionType instanceof ImportPositionType.CallableReference) {
            Object[] objectArray = new AbstractImportCandidatesProvider[]{new CallableImportCandidatesProvider(importContext, false, 2, null), new ConstructorReferenceImportCandidatesProvider(importContext)};
            sequence = SequencesKt.sequenceOf((Object[])objectArray);
        } else {
            sequence = SequencesKt.sequenceOf((Object[])new AbstractImportCandidatesProvider[0]);
        }
        return sequence;
    }

    private static final Iterable provideImportCandidates$lambda$0(KaSession $this_provideImportCandidates, Name $unresolvedName, KtSymbolFromIndexProvider $indexProvider, AbstractImportCandidatesProvider it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.collectCandidates($this_provideImportCandidates, $unresolvedName, $indexProvider);
    }
}

