/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.inspections.jdk2k;

import com.intellij.codeInsight.intention.FileModifier;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.k2.codeinsight.inspections.jdk2k.Transformation;
import org.jetbrains.kotlin.idea.k2.codeinsight.inspections.jdk2k.WithoutAdditionalTransformation;
import org.jetbrains.kotlin.psi.KtCallExpression;

@FileModifier.SafeTypeForPreview
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\u0004\b\f\u0010\rJ\f\u0010\u0016\u001a\u00020\u0003*\u00020\u0003H\u0002J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0006H\u00c6\u0003J\t\u0010 \u001a\u00020\bH\u00c6\u0003J\u0015\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\b0\nH\u00c6\u0003JG\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\b0\nH\u00c6\u0001J\u0013\u0010#\u001a\u00020\b2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001J\t\u0010'\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0015R\u0011\u0010\u0017\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000fR\u0011\u0010\u0019\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000fR\u0011\u0010\u001b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0014\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/jdk2k/Replacement;", "", "javaMethodFqName", "", "kotlinFunctionFqName", "transformation", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/jdk2k/Transformation;", "mayChangeSemantics", "", "isApplicable", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/jdk2k/Transformation;ZLkotlin/jvm/functions/Function1;)V", "getJavaMethodFqName", "()Ljava/lang/String;", "getKotlinFunctionFqName", "getTransformation", "()Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/jdk2k/Transformation;", "getMayChangeSemantics", "()Z", "()Lkotlin/jvm/functions/Function1;", "shortName", "javaMethodShortName", "getJavaMethodShortName", "kotlinFunctionShortName", "getKotlinFunctionShortName", "shouldAddImport", "getShouldAddImport", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "kotlin.code-insight.inspections.k2"})
@SourceDebugExtension(value={"SMAP\nReplaceJavaStaticMethodWithKotlinAnalogInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplaceJavaStaticMethodWithKotlinAnalogInspection.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/inspections/jdk2k/Replacement\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,274:1\n621#2,6:275\n*S KotlinDebug\n*F\n+ 1 ReplaceJavaStaticMethodWithKotlinAnalogInspection.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/inspections/jdk2k/Replacement\n*L\n267#1:275,6\n*E\n"})
public final class Replacement {
    @NotNull
    private final String javaMethodFqName;
    @NotNull
    private final String kotlinFunctionFqName;
    @NotNull
    private final Transformation transformation;
    private final boolean mayChangeSemantics;
    @NotNull
    private final Function1<KtCallExpression, Boolean> isApplicable;
    @NotNull
    private final String javaMethodShortName;
    @NotNull
    private final String kotlinFunctionShortName;
    private final boolean shouldAddImport;

    public Replacement(@NotNull String javaMethodFqName, @NotNull String kotlinFunctionFqName, @NotNull Transformation transformation, boolean mayChangeSemantics, @NotNull Function1<? super KtCallExpression, Boolean> isApplicable2) {
        Intrinsics.checkNotNullParameter((Object)javaMethodFqName, (String)"javaMethodFqName");
        Intrinsics.checkNotNullParameter((Object)kotlinFunctionFqName, (String)"kotlinFunctionFqName");
        Intrinsics.checkNotNullParameter((Object)transformation, (String)"transformation");
        Intrinsics.checkNotNullParameter(isApplicable2, (String)"isApplicable");
        this.javaMethodFqName = javaMethodFqName;
        this.kotlinFunctionFqName = kotlinFunctionFqName;
        this.transformation = transformation;
        this.mayChangeSemantics = mayChangeSemantics;
        this.isApplicable = isApplicable2;
        this.javaMethodShortName = this.shortName(this.javaMethodFqName);
        this.kotlinFunctionShortName = this.shortName(this.kotlinFunctionFqName);
        this.shouldAddImport = StringsKt.startsWith$default((String)this.kotlinFunctionFqName, (String)"kotlin.math", (boolean)false, (int)2, null);
    }

    public /* synthetic */ Replacement(String string, String string2, Transformation transformation, boolean bl, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            transformation = WithoutAdditionalTransformation.INSTANCE;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            function1 = Replacement::_init_$lambda$0;
        }
        this(string, string2, transformation, bl, (Function1<? super KtCallExpression, Boolean>)function1);
    }

    @NotNull
    public final String getJavaMethodFqName() {
        return this.javaMethodFqName;
    }

    @NotNull
    public final String getKotlinFunctionFqName() {
        return this.kotlinFunctionFqName;
    }

    @NotNull
    public final Transformation getTransformation() {
        return this.transformation;
    }

    public final boolean getMayChangeSemantics() {
        return this.mayChangeSemantics;
    }

    @NotNull
    public final Function1<KtCallExpression, Boolean> isApplicable() {
        return this.isApplicable;
    }

    /*
     * WARNING - void declaration
     */
    private final String shortName(String $this$shortName) {
        String string;
        block1: {
            void var2_2;
            String $this$takeLastWhile$iv = $this$shortName;
            boolean $i$f$takeLastWhile = false;
            for (int index$iv = StringsKt.getLastIndex((CharSequence)$this$takeLastWhile$iv); -1 < index$iv; --index$iv) {
                char it = $this$takeLastWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (it != '.') continue;
                String string2 = $this$takeLastWhile$iv;
                int n = index$iv + 1;
                String string3 = string2.substring(n);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                break block1;
            }
            string = var2_2;
        }
        return string;
    }

    @NotNull
    public final String getJavaMethodShortName() {
        return this.javaMethodShortName;
    }

    @NotNull
    public final String getKotlinFunctionShortName() {
        return this.kotlinFunctionShortName;
    }

    public final boolean getShouldAddImport() {
        return this.shouldAddImport;
    }

    @NotNull
    public final String component1() {
        return this.javaMethodFqName;
    }

    @NotNull
    public final String component2() {
        return this.kotlinFunctionFqName;
    }

    @NotNull
    public final Transformation component3() {
        return this.transformation;
    }

    public final boolean component4() {
        return this.mayChangeSemantics;
    }

    @NotNull
    public final Function1<KtCallExpression, Boolean> component5() {
        return this.isApplicable;
    }

    @NotNull
    public final Replacement copy(@NotNull String javaMethodFqName, @NotNull String kotlinFunctionFqName, @NotNull Transformation transformation, boolean mayChangeSemantics, @NotNull Function1<? super KtCallExpression, Boolean> isApplicable2) {
        Intrinsics.checkNotNullParameter((Object)javaMethodFqName, (String)"javaMethodFqName");
        Intrinsics.checkNotNullParameter((Object)kotlinFunctionFqName, (String)"kotlinFunctionFqName");
        Intrinsics.checkNotNullParameter((Object)transformation, (String)"transformation");
        Intrinsics.checkNotNullParameter(isApplicable2, (String)"isApplicable");
        return new Replacement(javaMethodFqName, kotlinFunctionFqName, transformation, mayChangeSemantics, isApplicable2);
    }

    public static /* synthetic */ Replacement copy$default(Replacement replacement, String string, String string2, Transformation transformation, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            string = replacement.javaMethodFqName;
        }
        if ((n & 2) != 0) {
            string2 = replacement.kotlinFunctionFqName;
        }
        if ((n & 4) != 0) {
            transformation = replacement.transformation;
        }
        if ((n & 8) != 0) {
            bl = replacement.mayChangeSemantics;
        }
        if ((n & 0x10) != 0) {
            function1 = replacement.isApplicable;
        }
        return replacement.copy(string, string2, transformation, bl, function1);
    }

    @NotNull
    public String toString() {
        return "Replacement(javaMethodFqName=" + this.javaMethodFqName + ", kotlinFunctionFqName=" + this.kotlinFunctionFqName + ", transformation=" + this.transformation + ", mayChangeSemantics=" + this.mayChangeSemantics + ", isApplicable=" + this.isApplicable + ")";
    }

    public int hashCode() {
        int result2 = this.javaMethodFqName.hashCode();
        result2 = result2 * 31 + this.kotlinFunctionFqName.hashCode();
        result2 = result2 * 31 + this.transformation.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.mayChangeSemantics);
        result2 = result2 * 31 + this.isApplicable.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Replacement)) {
            return false;
        }
        Replacement replacement = (Replacement)other;
        if (!Intrinsics.areEqual((Object)this.javaMethodFqName, (Object)replacement.javaMethodFqName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.kotlinFunctionFqName, (Object)replacement.kotlinFunctionFqName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.transformation, (Object)replacement.transformation)) {
            return false;
        }
        if (this.mayChangeSemantics != replacement.mayChangeSemantics) {
            return false;
        }
        return Intrinsics.areEqual(this.isApplicable, replacement.isApplicable);
    }

    private static final boolean _init_$lambda$0(KtCallExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }
}

