/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinNameSuggester;
import org.jetbrains.kotlin.idea.base.fe10.codeInsight.newDeclaration.Fe10KotlinNameSuggester;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.core.UtilsKt;
import org.jetbrains.kotlin.idea.quickfix.AddFunctionParametersFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeFunctionSignatureFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactoryWithDelegate;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeSignatureConfiguration;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeSignatureKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinMutableMethodDescriptor;
import org.jetbrains.kotlin.idea.util.QuickfixUtilKt;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001cB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\"\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J$\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r0\u0019H\u0004J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u000bH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionSignatureFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lcom/intellij/psi/PsiElement;", "element", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "<init>", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)V", "getFunctionDescriptor", "()Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getFamilyName", "", "startInWriteAction", "", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "getNewArgumentName", "argument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "validator", "Lkotlin/Function1;", "isSpecialName", "name", "Companion", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nChangeFunctionSignatureFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeFunctionSignatureFix.kt\norg/jetbrains/kotlin/idea/quickfix/ChangeFunctionSignatureFix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,167:1\n1734#2,3:168\n1#3:171\n*S KotlinDebug\n*F\n+ 1 ChangeFunctionSignatureFix.kt\norg/jetbrains/kotlin/idea/quickfix/ChangeFunctionSignatureFix\n*L\n48#1:168,3\n*E\n"})
public abstract class ChangeFunctionSignatureFix
extends KotlinQuickFixAction<PsiElement> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FunctionDescriptor functionDescriptor;
    @NotNull
    private static final String FAMILY_NAME = KotlinBundle.message((String)"fix.change.signature.family", (Object[])new Object[0]);

    public ChangeFunctionSignatureFix(@NotNull PsiElement element, @NotNull FunctionDescriptor functionDescriptor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"functionDescriptor");
        super(element);
        this.functionDescriptor = functionDescriptor;
    }

    @NotNull
    protected final FunctionDescriptor getFunctionDescriptor() {
        return this.functionDescriptor;
    }

    @NotNull
    public String getFamilyName() {
        return FAMILY_NAME;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Collection declarations2 = DescriptorToSourceUtilsIde.getAllDeclarations$default(DescriptorToSourceUtilsIde.INSTANCE, project, (DeclarationDescriptor)this.functionDescriptor, null, 4, null);
        if (declarations2.isEmpty()) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        Iterable $this$all$iv = declarations2;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            PsiElement it = (PsiElement)element$iv;
            boolean bl3 = false;
            if (!it.isValid()) return false;
            if (!KotlinRefactoringUtilKt.canRefactor(it)) return false;
            bl = true;
        } while (bl);
        return false;
    }

    @NotNull
    protected final String getNewArgumentName(@NotNull ValueArgument argument2, @NotNull Function1<? super String, Boolean> validator2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        Intrinsics.checkNotNullParameter(validator2, (String)"validator");
        KtExpression expression = KtPsiUtil.deparenthesize((KtExpression)argument2.getArgumentExpression());
        Object object = argument2.getArgumentName();
        if (object == null || (object = object.getAsName()) == null || (object = object.asString()) == null) {
            Object object2 = expression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)expression : null;
            if (object2 != null && (object2 = object2.getReferencedName()) != null) {
                Object object3;
                Object it = object3 = object2;
                boolean bl = false;
                object = !this.isSpecialName((String)it) ? object3 : null;
            } else {
                object = null;
            }
        }
        Object argumentName2 = object;
        Object object4 = argumentName2;
        if (object4 != null) {
            string = KotlinNameSuggester.Companion.suggestNameByName((String)object4, validator2);
        } else if (expression != null) {
            KotlinType type2;
            BindingContext bindingContext = ResolutionUtils.analyze((KtElement)expression, BodyResolveMode.PARTIAL);
            String expressionText = expression.getText();
            Intrinsics.checkNotNull((Object)expressionText);
            if (this.isSpecialName(expressionText) && (type2 = CallUtilKt.getType((KtExpression)expression, (BindingContext)bindingContext)) != null) {
                return (String)CollectionsKt.first(Fe10KotlinNameSuggester.INSTANCE.suggestNamesByType(type2, validator2, "param"));
            }
            string = (String)CollectionsKt.first((Iterable)Fe10KotlinNameSuggester.INSTANCE.suggestNamesByExpressionAndType(expression, null, bindingContext, validator2, "param"));
        } else {
            string = KotlinNameSuggester.Companion.suggestNameByName("param", validator2);
        }
        return string;
    }

    private final boolean isSpecialName(String name2) {
        return Intrinsics.areEqual((Object)name2, (Object)StandardNames.IMPLICIT_LAMBDA_PARAMETER_NAME.getIdentifier()) || Intrinsics.areEqual((Object)name2, (Object)"field");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u001bB\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\t\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0003H\u0014J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionSignatureFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactoryWithDelegate;", "Lorg/jetbrains/kotlin/psi/KtCallElement;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "<init>", "()V", "getElementOfInterest", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "extractFixData", "element", "createFix", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionSignatureFix;", "originalElement", "data", "FAMILY_NAME", "", "getFAMILY_NAME", "()Ljava/lang/String;", "runRemoveParameter", "", "parameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "context", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "RemoveParameterFix", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nChangeFunctionSignatureFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeFunctionSignatureFix.kt\norg/jetbrains/kotlin/idea/quickfix/ChangeFunctionSignatureFix$Companion\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,167:1\n213#2:168\n188#3,2:169\n190#3:174\n2632#4,3:171\n*S KotlinDebug\n*F\n+ 1 ChangeFunctionSignatureFix.kt\norg/jetbrains/kotlin/idea/quickfix/ChangeFunctionSignatureFix$Companion\n*L\n78#1:168\n105#1:169,2\n105#1:174\n112#1:171,3\n*E\n"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactoryWithDelegate<KtCallElement, CallableDescriptor> {
        private Companion() {
            super(null, 1, null);
        }

        @Override
        @Nullable
        public KtCallElement getElementOfInterest(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement $this$getStrictParentOfType$iv = diagnostic.getPsiElement();
            boolean $i$f$getStrictParentOfType = false;
            return (KtCallElement)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtCallElement.class, (boolean)true);
        }

        @Override
        @Nullable
        public CallableDescriptor extractFixData(@NotNull KtCallElement element, @NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            DiagnosticFactory[] diagnosticFactoryArray = new DiagnosticFactory[]{Errors.TOO_MANY_ARGUMENTS, Errors.NO_VALUE_FOR_PARAMETER};
            return (CallableDescriptor)((DiagnosticWithParameters1)DiagnosticFactory.Companion.cast((UnboundDiagnostic)diagnostic, diagnosticFactoryArray)).getA();
        }

        @Nullable
        protected ChangeFunctionSignatureFix createFix(@NotNull KtCallElement originalElement, @NotNull CallableDescriptor data) {
            FunctionDescriptor functionDescriptor;
            Intrinsics.checkNotNullParameter((Object)originalElement, (String)"originalElement");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            FunctionDescriptor functionDescriptor2 = data instanceof FunctionDescriptor ? (FunctionDescriptor)data : null;
            if (functionDescriptor2 == null) {
                ValueParameterDescriptor valueParameterDescriptor = data instanceof ValueParameterDescriptor ? (ValueParameterDescriptor)data : null;
                Object object = valueParameterDescriptor != null ? valueParameterDescriptor.getContainingDeclaration() : null;
                functionDescriptor2 = object instanceof FunctionDescriptor ? (FunctionDescriptor)object : null;
                if (functionDescriptor2 == null) {
                    return null;
                }
            }
            if ((functionDescriptor = functionDescriptor2).getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED) {
                return null;
            }
            if (data instanceof ValueParameterDescriptor) {
                return new RemoveParameterFix((PsiElement)originalElement, functionDescriptor, (ValueParameterDescriptor)data);
            }
            List list2 = functionDescriptor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueParameters(...)");
            List parameters2 = list2;
            List list3 = originalElement.getValueArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getValueArguments(...)");
            List arguments2 = list3;
            if (arguments2.size() > parameters2.size()) {
                boolean bl;
                block19: {
                    Map<ValueArgument, ValueParameterDescriptor> argumentToParameter;
                    if (functionDescriptor instanceof ConstructorDescriptor) {
                        ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = ((ConstructorDescriptor)functionDescriptor).getContainingDeclaration();
                        Intrinsics.checkNotNullExpressionValue((Object)classifierDescriptorWithTypeParameters, (String)"getContainingDeclaration(...)");
                        if (InlineClassesUtilsKt.isValueClass((DeclarationDescriptor)((DeclarationDescriptor)classifierDescriptorWithTypeParameters))) {
                            return null;
                        }
                    }
                    BindingContext bindingContext = ResolutionUtils.analyze$default((KtElement)originalElement, null, 1, null);
                    Call call2 = CallUtilKt.getCall((KtElement)((KtElement)originalElement), (BindingContext)bindingContext);
                    if (call2 == null) {
                        return null;
                    }
                    Call call3 = call2;
                    Map<ValueArgument, ValueParameterDescriptor> $this$any$iv = argumentToParameter = UtilsKt.mapArgumentsToParameters(call3, (CallableDescriptor)functionDescriptor);
                    boolean $i$f$any = false;
                    if ($this$any$iv.isEmpty()) {
                        bl = false;
                    } else {
                        Iterator<Map.Entry<ValueArgument, ValueParameterDescriptor>> iterator = $this$any$iv.entrySet().iterator();
                        while (iterator.hasNext()) {
                            boolean bl2;
                            block18: {
                                Collection argumentTypes;
                                Collection collection;
                                Map.Entry<ValueArgument, ValueParameterDescriptor> element$iv;
                                Map.Entry<ValueArgument, ValueParameterDescriptor> entry = element$iv = iterator.next();
                                boolean bl3 = false;
                                ValueArgument argument2 = entry.getKey();
                                ValueParameterDescriptor parameter = entry.getValue();
                                if (argument2.getArgumentExpression() != null) {
                                    KtExpression it;
                                    boolean bl4 = false;
                                    collection = QuickfixUtilKt.getDataFlowAwareTypes$default(it, bindingContext, null, 4, null);
                                } else {
                                    collection = null;
                                }
                                Collection collection2 = argumentTypes = collection;
                                if (collection2 != null) {
                                    Iterable $this$none$iv = collection2;
                                    boolean $i$f$none = false;
                                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                        bl2 = true;
                                    } else {
                                        for (Object element$iv2 : $this$none$iv) {
                                            KotlinType dataFlowAwareType = (KotlinType)element$iv2;
                                            boolean bl5 = false;
                                            if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(dataFlowAwareType, parameter.getType())) continue;
                                            bl2 = false;
                                            break block18;
                                        }
                                        bl2 = true;
                                    }
                                } else {
                                    bl2 = true;
                                }
                            }
                            if (!bl2) continue;
                            bl = true;
                            break block19;
                        }
                        bl = false;
                    }
                }
                boolean hasTypeMismatches = bl;
                AddFunctionParametersFix.Kind kind2 = hasTypeMismatches ? (AddFunctionParametersFix.Kind)AddFunctionParametersFix.Kind.ChangeSignature.INSTANCE : (AddFunctionParametersFix.Kind)AddFunctionParametersFix.Kind.AddParameterGeneric.INSTANCE;
                return new AddFunctionParametersFix(originalElement, functionDescriptor, kind2);
            }
            return null;
        }

        @NotNull
        public final String getFAMILY_NAME() {
            return FAMILY_NAME;
        }

        public final void runRemoveParameter(@NotNull ValueParameterDescriptor parameterDescriptor, @NotNull PsiElement context, @Nullable Editor editor) {
            Intrinsics.checkNotNullParameter((Object)parameterDescriptor, (String)"parameterDescriptor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            CallableDescriptor callableDescriptor = parameterDescriptor.getContainingDeclaration();
            Intrinsics.checkNotNull((Object)callableDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
            FunctionDescriptor functionDescriptor = (FunctionDescriptor)callableDescriptor;
            Project project = context.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Object[] objectArray = new Object[]{parameterDescriptor.getName().asString()};
            KotlinChangeSignatureKt.runChangeSignature(project, editor, (CallableDescriptor)functionDescriptor, new KotlinChangeSignatureConfiguration(parameterDescriptor){
                final /* synthetic */ ValueParameterDescriptor $parameterDescriptor;
                {
                    this.$parameterDescriptor = $parameterDescriptor;
                }

                public KotlinMethodDescriptor configure(KotlinMethodDescriptor originalDescriptor) {
                    Intrinsics.checkNotNullParameter((Object)originalDescriptor, (String)"originalDescriptor");
                    return KotlinChangeSignatureKt.modify(originalDescriptor, (Function1<? super KotlinMutableMethodDescriptor, Unit>)((Function1)arg_0 -> runRemoveParameter.1.configure$lambda$0(this.$parameterDescriptor, arg_0)));
                }

                public boolean isPerformSilently(Collection<? extends PsiElement> affectedFunctions) {
                    Intrinsics.checkNotNullParameter(affectedFunctions, (String)"affectedFunctions");
                    return true;
                }

                public boolean isForcePerformForSelectedFunctionOnly() {
                    return false;
                }

                private static final Unit configure$lambda$0(ValueParameterDescriptor $parameterDescriptor, KotlinMutableMethodDescriptor descriptor2) {
                    Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                    int index2 = descriptor2.getReceiver() != null ? $parameterDescriptor.getIndex() + 1 : $parameterDescriptor.getIndex();
                    descriptor2.removeParameter(index2);
                    return Unit.INSTANCE;
                }
            }, context, KotlinBundle.message((String)"fix.change.signature.remove.parameter.command", (Object[])objectArray));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J#\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0094\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionSignatureFix$Companion$RemoveParameterFix;", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionSignatureFix;", "element", "Lcom/intellij/psi/PsiElement;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "parameterToRemove", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "<init>", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;)V", "getText", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin.idea"})
        private static final class RemoveParameterFix
        extends ChangeFunctionSignatureFix {
            @NotNull
            private final ValueParameterDescriptor parameterToRemove;

            public RemoveParameterFix(@NotNull PsiElement element, @NotNull FunctionDescriptor functionDescriptor, @NotNull ValueParameterDescriptor parameterToRemove) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"functionDescriptor");
                Intrinsics.checkNotNullParameter((Object)parameterToRemove, (String)"parameterToRemove");
                super(element, functionDescriptor);
                this.parameterToRemove = parameterToRemove;
            }

            @NotNull
            public String getText() {
                Object[] objectArray = new Object[]{this.parameterToRemove.getName().asString()};
                return KotlinBundle.message((String)"fix.change.signature.remove.parameter", (Object[])objectArray);
            }

            @Override
            protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Object t = this.getElement();
                if (t == null) {
                    return;
                }
                Companion.runRemoveParameter(this.parameterToRemove, (PsiElement)t, editor);
            }
        }
    }
}

