/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.google.common.collect.ImmutableSet;
import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.quickfix.ReplaceCallFixKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\n\u001a\u00070\u0007\u00a2\u0006\u0002\b\u000bH\u0016J!\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0094\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ReplaceInfixOrOperatorCallFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "element", "notNullNeeded", "", "binaryOperatorName", "", "<init>", "(Lorg/jetbrains/kotlin/psi/KtExpression;ZLjava/lang/String;)V", "getFamilyName", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "invoke", "", "context", "Lcom/intellij/modcommand/ActionContext;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "kotlin.fir.frontend-independent"})
public final class ReplaceInfixOrOperatorCallFix
extends PsiUpdateModCommandAction<KtExpression> {
    private final boolean notNullNeeded;
    @NotNull
    private final String binaryOperatorName;

    public ReplaceInfixOrOperatorCallFix(@NotNull KtExpression element, boolean notNullNeeded, @NotNull String binaryOperatorName) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)binaryOperatorName, (String)"binaryOperatorName");
        super((PsiElement)element);
        this.notNullNeeded = notNullNeeded;
        this.binaryOperatorName = binaryOperatorName;
    }

    public /* synthetic */ ReplaceInfixOrOperatorCallFix(KtExpression ktExpression, boolean bl, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = "";
        }
        this(ktExpression, bl, string);
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"replace.with.safe.call", (Object[])new Object[0]);
    }

    protected void invoke(@NotNull ActionContext context, @NotNull KtExpression element, @NotNull ModPsiUpdater updater2) {
        block18: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
            Project project = context.project();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project(...)");
            KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
            String elvis = ReplaceCallFixKt.elvisOrEmpty(element, this.notNullNeeded);
            PsiElement replacement = null;
            KtExpression ktExpression = element;
            if (ktExpression instanceof KtArrayAccessExpression) {
                KtBinaryExpression assignment2;
                KtBinaryExpression ktBinaryExpression = assignment2 = KtPsiUtilKt.getAssignmentByLHS((KtExpression)element);
                KtExpression right = ktBinaryExpression != null ? ktBinaryExpression.getRight() : null;
                KtExpression ktExpression2 = ((KtArrayAccessExpression)element).getArrayExpression();
                if (ktExpression2 == null) {
                    return;
                }
                KtExpression arrayExpression = ktExpression2;
                if (assignment2 != null) {
                    if (right == null) {
                        return;
                    }
                    Object[] objectArray = new Object[3];
                    objectArray[0] = arrayExpression;
                    List list2 = ((KtArrayAccessExpression)element).getIndexExpressions();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getIndexExpressions(...)");
                    objectArray[1] = CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)", ", null, null, (int)0, null, ReplaceInfixOrOperatorCallFix::invoke$lambda$0, (int)30, null);
                    objectArray[2] = right;
                    KtExpression newExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"$0?.set($1, $2)", (Object[])objectArray, (boolean)false, (int)4, null);
                    assignment2.replace((PsiElement)newExpression);
                } else {
                    String string = "$0?.get($1)" + elvis;
                    Object[] objectArray = new Object[2];
                    objectArray[0] = arrayExpression;
                    List list3 = ((KtArrayAccessExpression)element).getIndexExpressions();
                    Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getIndexExpressions(...)");
                    objectArray[1] = CollectionsKt.joinToString$default((Iterable)list3, (CharSequence)", ", null, null, (int)0, null, ReplaceInfixOrOperatorCallFix::invoke$lambda$1, (int)30, null);
                    KtExpression newExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)string, (Object[])objectArray, (boolean)false, (int)4, null);
                    replacement = ((KtArrayAccessExpression)element).replace((PsiElement)newExpression);
                }
            } else if (ktExpression instanceof KtCallExpression) {
                KtExpression ktExpression3 = ((KtCallExpression)element).getCalleeExpression();
                if (ktExpression3 == null) {
                    return;
                }
                KtExpression calleeExpression = ktExpression3;
                Object object = ((KtCallExpression)element).getValueArgumentList();
                if (object == null || (object = object.getText()) == null) {
                    return;
                }
                Object valueArgumentList = object;
                PsiElement newExpression = ((KtCallExpression)element).getParent();
                KtQualifiedExpression parentQualified = newExpression instanceof KtQualifiedExpression ? (KtQualifiedExpression)newExpression : null;
                newExpression = CreateByPatternKt.buildExpression$default((KtPsiFactory)psiFactory, (boolean)false, arg_0 -> ReplaceInfixOrOperatorCallFix.invoke$lambda$6(parentQualified, calleeExpression, (String)valueArgumentList, elvis, arg_0), (int)1, null);
                KtQualifiedExpression ktQualifiedExpression = parentQualified;
                replacement = (ktQualifiedExpression != null ? (KtExpression)ktQualifiedExpression : element).replace(newExpression);
            } else if (ktExpression instanceof KtBinaryExpression) {
                KtExpression ktExpression4;
                KtExpression ktExpression5 = ((KtBinaryExpression)element).getLeft();
                if (ktExpression5 == null) {
                    return;
                }
                KtExpression left = ktExpression5;
                KtExpression ktExpression6 = ((KtBinaryExpression)element).getRight();
                if (ktExpression6 == null) {
                    return;
                }
                KtExpression right = ktExpression6;
                boolean isNormalAssignment = KtTokens.AUGMENTED_ASSIGNMENTS.contains(((KtBinaryExpression)element).getOperationToken()) && !((ImmutableSet)OperatorConventions.ASSIGNMENT_OPERATIONS.values()).contains((Object)Name.identifier((String)this.binaryOperatorName));
                boolean isContainsOperator = Intrinsics.areEqual((Object)((KtBinaryExpression)element).getOperationToken(), (Object)KtTokens.IN_KEYWORD);
                boolean isNotContainsOperator = Intrinsics.areEqual((Object)((KtBinaryExpression)element).getOperationToken(), (Object)KtTokens.NOT_IN);
                if (isContainsOperator || isNotContainsOperator) {
                    String booleanSuffix = isNotContainsOperator ? " != true" : " == true";
                    Object[] objectArray = new Object[]{left, this.binaryOperatorName, right};
                    ktExpression4 = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)("$2?.$1($0)" + booleanSuffix), (Object[])objectArray, (boolean)false, (int)4, null);
                } else if (isNormalAssignment) {
                    var14_24 = new Object[]{left, this.binaryOperatorName, right};
                    ktExpression4 = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"$0 = $0?.$1($2)", (Object[])var14_24, (boolean)false, (int)4, null);
                } else {
                    var14_24 = new Object[]{left, this.binaryOperatorName, right};
                    ktExpression4 = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)("$0?.$1($2)" + elvis), (Object[])var14_24, (boolean)false, (int)4, null);
                }
                KtExpression newExpression = ktExpression4;
                replacement = ((KtBinaryExpression)element).replace((PsiElement)newExpression);
            }
            if (!(((CharSequence)elvis).length() > 0)) break block18;
            PsiElement psiElement = replacement;
            if (psiElement != null) {
                Project project2 = context.project();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project(...)");
                ReplaceCallFixKt.moveCaretToEnd(psiElement, project2, updater2);
            }
        }
    }

    private static final CharSequence invoke$lambda$0(KtExpression it) {
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private static final CharSequence invoke$lambda$1(KtExpression it) {
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private static final boolean invoke$lambda$6$lambda$2(ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof PsiWhiteSpace || it instanceof PsiComment;
    }

    private static final CharSequence invoke$lambda$6$lambda$3(ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private static final boolean invoke$lambda$6$lambda$4(ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof PsiWhiteSpace || it instanceof PsiComment;
    }

    private static final CharSequence invoke$lambda$6$lambda$5(ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private static final Unit invoke$lambda$6(KtQualifiedExpression $parentQualified, KtExpression $calleeExpression, String $valueArgumentList, String $elvis, BuilderByPattern $this$buildExpression) {
        Intrinsics.checkNotNullParameter((Object)$this$buildExpression, (String)"$this$buildExpression");
        if ($parentQualified != null) {
            KtExpression receiver2 = $parentQualified.getReceiverExpression();
            ASTNode operationNode = $parentQualified.getOperationTokenNode();
            ASTNode aSTNode = receiver2.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
            String beforeOperationNode = SequencesKt.joinToString$default((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.siblings((ASTNode)aSTNode, (boolean)true), ReplaceInfixOrOperatorCallFix::invoke$lambda$6$lambda$2), (CharSequence)"", null, null, (int)0, null, ReplaceInfixOrOperatorCallFix::invoke$lambda$6$lambda$3, (int)30, null);
            String afterOperationNode = SequencesKt.joinToString$default((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.siblings((ASTNode)operationNode, (boolean)true), ReplaceInfixOrOperatorCallFix::invoke$lambda$6$lambda$4), (CharSequence)"", null, null, (int)0, null, ReplaceInfixOrOperatorCallFix::invoke$lambda$6$lambda$5, (int)30, null);
            $this$buildExpression.appendExpression(receiver2);
            $this$buildExpression.appendFixedText(beforeOperationNode);
            String string = KtTokens.SAFE_ACCESS.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            $this$buildExpression.appendFixedText(string);
            $this$buildExpression.appendFixedText(afterOperationNode);
        }
        $this$buildExpression.appendExpression($calleeExpression);
        String string = KtTokens.SAFE_ACCESS.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        $this$buildExpression.appendFixedText(string);
        $this$buildExpression.appendFixedText("invoke");
        $this$buildExpression.appendFixedText($valueArgumentList);
        $this$buildExpression.appendFixedText($elvis);
        return Unit.INSTANCE;
    }
}

