/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch;

import com.intellij.openapi.diagnostic.ControlFlowException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.ScratchUtilsKt;
import org.jetbrains.kotlin.idea.scratch.actions.RunScratchActionK2;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutput;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputHandler;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH&J\b\u0010\n\u001a\u00020\tH&J\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011J$\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0018R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u000b\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ScratchExecutor;", "", "file", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "<init>", "(Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;)V", "getFile", "()Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "execute", "", "stop", "handler", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExecutor$CompositeOutputHandler;", "getHandler", "()Lorg/jetbrains/kotlin/idea/scratch/ScratchExecutor$CompositeOutputHandler;", "addOutputHandler", "outputHandler", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutputHandler;", "errorOccurs", "message", "", "e", "", "isFatal", "", "CompositeOutputHandler", "kotlin.jvm"})
public abstract class ScratchExecutor {
    @NotNull
    private final ScratchFile file;
    @NotNull
    private final CompositeOutputHandler handler;

    public ScratchExecutor(@NotNull ScratchFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        this.handler = new CompositeOutputHandler();
    }

    @NotNull
    protected final ScratchFile getFile() {
        return this.file;
    }

    public abstract void execute();

    public abstract void stop();

    @NotNull
    protected final CompositeOutputHandler getHandler() {
        return this.handler;
    }

    public final void addOutputHandler(@NotNull ScratchOutputHandler outputHandler) {
        Intrinsics.checkNotNullParameter((Object)outputHandler, (String)"outputHandler");
        this.handler.add(outputHandler);
    }

    public final void errorOccurs(@NotNull String message2, @Nullable Throwable e, boolean isFatal) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.handler.error(this.file, message2);
        if (isFatal) {
            this.handler.onFinish(this.file);
        }
        if (e != null && !(e instanceof ControlFlowException)) {
            ScratchUtilsKt.getLOG().error(e);
        }
    }

    public static /* synthetic */ void errorOccurs$default(ScratchExecutor scratchExecutor, String string, Throwable throwable, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: errorOccurs");
        }
        if ((n & 2) != 0) {
            throwable = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        scratchExecutor.errorOccurs(string, throwable, bl);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001J\u000e\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J&\u0010\r\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\r\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ScratchExecutor$CompositeOutputHandler;", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutputHandler;", "<init>", "()V", "handlers", "", "add", "", "handler", "remove", "onStart", "file", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "handle", "explanations", "", "Lorg/jetbrains/kotlin/idea/scratch/actions/RunScratchActionK2$ExplainInfo;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "expression", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "output", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutput;", "error", "message", "", "onFinish", "clear", "kotlin.jvm"})
    @SourceDebugExtension(value={"SMAP\nScratchExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScratchExecutor.kt\norg/jetbrains/kotlin/idea/scratch/ScratchExecutor$CompositeOutputHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,395:1\n1863#2,2:396\n1863#2,2:398\n1863#2,2:400\n1863#2,2:402\n1863#2,2:404\n1863#2,2:406\n*S KotlinDebug\n*F\n+ 1 ScratchExecutor.kt\norg/jetbrains/kotlin/idea/scratch/ScratchExecutor$CompositeOutputHandler\n*L\n99#1:396,2\n103#1:398,2\n107#1:400,2\n111#1:402,2\n115#1:404,2\n119#1:406,2\n*E\n"})
    public static final class CompositeOutputHandler
    implements ScratchOutputHandler {
        @NotNull
        private final Set<ScratchOutputHandler> handlers = new LinkedHashSet();

        public final void add(@NotNull ScratchOutputHandler handler2) {
            Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
            this.handlers.add(handler2);
        }

        public final void remove(@NotNull ScratchOutputHandler handler2) {
            Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
            this.handlers.remove(handler2);
        }

        @Override
        public void onStart(@NotNull ScratchFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Iterable $this$forEach$iv = this.handlers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ScratchOutputHandler it = (ScratchOutputHandler)element$iv;
                boolean bl = false;
                it.onStart(file);
            }
        }

        @Override
        public void handle(@NotNull ScratchFile file, @NotNull List<RunScratchActionK2.ExplainInfo> explanations, @NotNull CoroutineScope scope) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter(explanations, (String)"explanations");
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Iterable $this$forEach$iv = this.handlers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ScratchOutputHandler it = (ScratchOutputHandler)element$iv;
                boolean bl = false;
                it.handle(file, explanations, scope);
            }
        }

        @Override
        public void handle(@NotNull ScratchFile file, @NotNull ScratchExpression expression, @NotNull ScratchOutput output) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Iterable $this$forEach$iv = this.handlers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ScratchOutputHandler it = (ScratchOutputHandler)element$iv;
                boolean bl = false;
                it.handle(file, expression, output);
            }
        }

        @Override
        public void error(@NotNull ScratchFile file, @NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            Iterable $this$forEach$iv = this.handlers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ScratchOutputHandler it = (ScratchOutputHandler)element$iv;
                boolean bl = false;
                it.error(file, message2);
            }
        }

        @Override
        public void onFinish(@NotNull ScratchFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Iterable $this$forEach$iv = this.handlers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ScratchOutputHandler it = (ScratchOutputHandler)element$iv;
                boolean bl = false;
                it.onFinish(file);
            }
        }

        @Override
        public void clear(@NotNull ScratchFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Iterable $this$forEach$iv = this.handlers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ScratchOutputHandler it = (ScratchOutputHandler)element$iv;
                boolean bl = false;
                it.clear(file);
            }
        }
    }
}

