/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;
import org.jetbrains.kotlin.idea.scratch.K2ScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.ScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.ScratchFileOptions;
import org.jetbrains.kotlin.idea.scratch.SequentialScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.ui.ScratchFileOptionsFile;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(J\b\u0010*\u001a\u0004\u0018\u00010+J\u0010\u00100\u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#J\"\u00101\u001a\u00020!2\u001a\u00102\u001a\u0016\u0012\u0004\u0012\u00020+\u0012\u0006\u0012\u0004\u0018\u00010#\u0012\u0004\u0012\u00020!03J\u001f\u00108\u001a\u00020!2\u0017\u00109\u001a\u0013\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u0002050:\u00a2\u0006\u0002\b;J\u0010\u0010<\u001a\u0004\u0018\u00010)2\u0006\u0010=\u001a\u00020>J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010?\u001a\u00020+H&J\b\u0010@\u001a\u00020AH'R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010$\u001a\u0004\u0018\u00010#2\b\u0010\"\u001a\u0004\u0018\u00010#@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0013\u0010,\u001a\u0004\u0018\u00010-8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0011\u00104\u001a\u0002058F\u00a2\u0006\u0006\u001a\u0004\b6\u00107\u00a8\u0006B"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "replScratchExecutor", "Lorg/jetbrains/kotlin/idea/scratch/SequentialScratchExecutor;", "getReplScratchExecutor", "()Lorg/jetbrains/kotlin/idea/scratch/SequentialScratchExecutor;", "setReplScratchExecutor", "(Lorg/jetbrains/kotlin/idea/scratch/SequentialScratchExecutor;)V", "compilingScratchExecutor", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExecutor;", "getCompilingScratchExecutor", "()Lorg/jetbrains/kotlin/idea/scratch/ScratchExecutor;", "setCompilingScratchExecutor", "(Lorg/jetbrains/kotlin/idea/scratch/ScratchExecutor;)V", "k2ScratchExecutor", "Lorg/jetbrains/kotlin/idea/scratch/K2ScratchExecutor;", "getK2ScratchExecutor", "()Lorg/jetbrains/kotlin/idea/scratch/K2ScratchExecutor;", "setK2ScratchExecutor", "(Lorg/jetbrains/kotlin/idea/scratch/K2ScratchExecutor;)V", "moduleListeners", "", "Lkotlin/Function0;", "", "value", "Lcom/intellij/openapi/module/Module;", "module", "getModule", "()Lcom/intellij/openapi/module/Module;", "getExpressions", "", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "getPsiFile", "Lcom/intellij/psi/PsiFile;", "ktScratchFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "getKtScratchFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "setModule", "addModuleListener", "f", "Lkotlin/Function2;", "options", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFileOptions;", "getOptions", "()Lorg/jetbrains/kotlin/idea/scratch/ScratchFileOptions;", "saveOptions", "update", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "getExpressionAtLine", "line", "", "psiFile", "hasErrors", "", "kotlin.jvm"})
@SourceDebugExtension(value={"SMAP\nScratchFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScratchFile.kt\norg/jetbrains/kotlin/idea/scratch/ScratchFile\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n123#2:95\n1863#3,2:96\n1#4:98\n*S KotlinDebug\n*F\n+ 1 ScratchFile.kt\norg/jetbrains/kotlin/idea/scratch/ScratchFile\n*L\n36#1:95\n40#1:96,2\n*E\n"})
public abstract class ScratchFile {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile file;
    @Nullable
    private SequentialScratchExecutor replScratchExecutor;
    @Nullable
    private ScratchExecutor compilingScratchExecutor;
    @Nullable
    private K2ScratchExecutor k2ScratchExecutor;
    @NotNull
    private final List<Function0<Unit>> moduleListeners;
    @Nullable
    private Module module;

    public ScratchFile(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.project = project;
        this.file = file;
        this.moduleListeners = new ArrayList();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    @Nullable
    public final SequentialScratchExecutor getReplScratchExecutor() {
        return this.replScratchExecutor;
    }

    public final void setReplScratchExecutor(@Nullable SequentialScratchExecutor sequentialScratchExecutor) {
        this.replScratchExecutor = sequentialScratchExecutor;
    }

    @Nullable
    public final ScratchExecutor getCompilingScratchExecutor() {
        return this.compilingScratchExecutor;
    }

    public final void setCompilingScratchExecutor(@Nullable ScratchExecutor scratchExecutor) {
        this.compilingScratchExecutor = scratchExecutor;
    }

    @Nullable
    public final K2ScratchExecutor getK2ScratchExecutor() {
        return this.k2ScratchExecutor;
    }

    public final void setK2ScratchExecutor(@Nullable K2ScratchExecutor k2ScratchExecutor) {
        this.k2ScratchExecutor = k2ScratchExecutor;
    }

    @Nullable
    public final Module getModule() {
        return this.module;
    }

    @NotNull
    public final List<ScratchExpression> getExpressions() {
        return (List)ActionsKt.runReadAction(() -> ScratchFile.getExpressions$lambda$1(this));
    }

    @Nullable
    public final PsiFile getPsiFile() {
        return (PsiFile)ActionsKt.runReadAction(() -> ScratchFile.getPsiFile$lambda$2(this));
    }

    @Nullable
    public final KtFile getKtScratchFile() {
        PsiFile $this$safeAs$iv = this.getPsiFile();
        boolean $i$f$safeAs = false;
        PsiFile psiFile = $this$safeAs$iv;
        if (!(psiFile instanceof KtFile)) {
            psiFile = null;
        }
        return (KtFile)psiFile;
    }

    public final void setModule(@Nullable Module value) {
        this.module = value;
        Iterable $this$forEach$iv = this.moduleListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
    }

    public final void addModuleListener(@NotNull Function2<? super PsiFile, ? super Module, Unit> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        this.moduleListeners.add((Function0<Unit>)((Function0)() -> ScratchFile.addModuleListener$lambda$4(this, f)));
    }

    @NotNull
    public final ScratchFileOptions getOptions() {
        Object object;
        block3: {
            block2: {
                object = this.getPsiFile();
                if (object == null || (object = object.getVirtualFile()) == null) break block2;
                Object it = object;
                boolean bl = false;
                ScratchFileOptions scratchFileOptions = ScratchFileOptionsFile.Companion.get(this.project, (VirtualFile)it);
                object = scratchFileOptions;
                if (scratchFileOptions != null) break block3;
            }
            object = new ScratchFileOptions(false, false, false, 7, null);
        }
        return object;
    }

    public final void saveOptions(@NotNull Function1<? super ScratchFileOptions, ScratchFileOptions> update2) {
        PsiFile virtualFile;
        Intrinsics.checkNotNullParameter(update2, (String)"update");
        PsiFile psiFile = this.getPsiFile();
        if (psiFile == null || (psiFile = psiFile.getVirtualFile()) == null) {
            return;
        }
        PsiFile $this$saveOptions_u24lambda_u246 = virtualFile = psiFile;
        boolean bl = false;
        ScratchFileOptions scratchFileOptions = ScratchFileOptionsFile.Companion.get(this.project, (VirtualFile)$this$saveOptions_u24lambda_u246);
        if (scratchFileOptions == null) {
            scratchFileOptions = new ScratchFileOptions(false, false, false, 7, null);
        }
        ScratchFileOptions configToUpdate = scratchFileOptions;
        ScratchFileOptionsFile.Companion.set(this.project, (VirtualFile)$this$saveOptions_u24lambda_u246, (ScratchFileOptions)update2.invoke((Object)configToUpdate));
    }

    @Nullable
    public final ScratchExpression getExpressionAtLine(int line) {
        Object v1;
        block1: {
            Iterable iterable = this.getExpressions();
            for (Object t : iterable) {
                ScratchExpression it = (ScratchExpression)t;
                boolean bl = false;
                int n = it.getLineStart();
                boolean bl2 = line <= it.getLineEnd() ? n <= line : false;
                if (!bl2) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    @NotNull
    public abstract List<ScratchExpression> getExpressions(@NotNull PsiFile var1);

    @RequiresBackgroundThread
    public abstract boolean hasErrors();

    private static final List getExpressions$lambda$1(ScratchFile this$0) {
        Object object;
        block3: {
            block2: {
                object = this$0.getPsiFile();
                if (object == null) break block2;
                PsiFile it = object;
                boolean bl = false;
                List<ScratchExpression> list2 = this$0.getExpressions(it);
                object = list2;
                if (list2 != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private static final PsiFile getPsiFile$lambda$2(ScratchFile this$0) {
        return PhysicalFileSystemUtilsKt.toPsiFile(this$0.file, this$0.project);
    }

    private static final Unit addModuleListener$lambda$4(ScratchFile this$0, Function2 $f) {
        Module selectedModule = this$0.module;
        PsiFile psiFile = this$0.getPsiFile();
        if (psiFile != null) {
            $f.invoke((Object)psiFile, (Object)selectedModule);
        }
        return Unit.INSTANCE;
    }
}

