/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.Topic;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.scratch.K2ScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.ScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.ScratchFileListener;
import org.jetbrains.kotlin.idea.scratch.SequentialScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.actions.ScratchCompilationSupport;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputHandlerAdapter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ)\u0010\f\u001a\u0002H\r\"\b\b\u0000\u0010\r*\u00020\u0001*\u00020\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010J\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0013H\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH$J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\b\u001a\u00020\u0005H$J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00132\u0006\u0010\b\u001a\u00020\u0005H$\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ScratchFileLanguageProvider;", "", "<init>", "()V", "newScratchFile", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "syncPublisherWithDisposeCheck", "L", "topic", "Lcom/intellij/util/messages/Topic;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/util/messages/Topic;)Ljava/lang/Object;", "addOutputHandlers", "", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExecutor;", "createFile", "createReplExecutor", "Lorg/jetbrains/kotlin/idea/scratch/SequentialScratchExecutor;", "createCompilingExecutor", "Companion", "kotlin.jvm"})
public abstract class ScratchFileLanguageProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final LanguageExtension<ScratchFileLanguageProvider> EXTENSION = new LanguageExtension("org.jetbrains.kotlin.scratchFileLanguageProvider");

    @Nullable
    public final ScratchFile newScratchFile(@NotNull Project project, @NotNull VirtualFile file, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        ScratchFile scratchFile2 = this.createFile(project, file);
        if (scratchFile2 == null) {
            return null;
        }
        ScratchFile scratchFile3 = scratchFile2;
        scratchFile3.setReplScratchExecutor(this.createReplExecutor(scratchFile3));
        scratchFile3.setCompilingScratchExecutor(this.createCompilingExecutor(scratchFile3));
        scratchFile3.setK2ScratchExecutor(new K2ScratchExecutor(scratchFile3, project, scope));
        SequentialScratchExecutor sequentialScratchExecutor = scratchFile3.getReplScratchExecutor();
        if (sequentialScratchExecutor != null) {
            this.addOutputHandlers(sequentialScratchExecutor);
        }
        ScratchExecutor scratchExecutor = scratchFile3.getCompilingScratchExecutor();
        if (scratchExecutor != null) {
            this.addOutputHandlers(scratchExecutor);
        }
        K2ScratchExecutor k2ScratchExecutor = scratchFile3.getK2ScratchExecutor();
        if (k2ScratchExecutor != null) {
            this.addOutputHandlers(k2ScratchExecutor);
        }
        this.syncPublisherWithDisposeCheck(scratchFile3.getProject(), ScratchFileListener.Companion.getTOPIC()).fileCreated(scratchFile3);
        return scratchFile3;
    }

    private final <L> L syncPublisherWithDisposeCheck(Project $this$syncPublisherWithDisposeCheck, Topic<L> topic) {
        if ($this$syncPublisherWithDisposeCheck.isDisposed()) {
            throw new ProcessCanceledException();
        }
        return (L)$this$syncPublisherWithDisposeCheck.getMessageBus().syncPublisher(topic);
    }

    private final void addOutputHandlers(ScratchExecutor $this$addOutputHandlers) {
        $this$addOutputHandlers.addOutputHandler(new ScratchOutputHandlerAdapter($this$addOutputHandlers){
            final /* synthetic */ ScratchExecutor $this_addOutputHandlers;
            {
                this.$this_addOutputHandlers = $receiver;
            }

            public void onStart(ScratchFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                ScratchCompilationSupport.INSTANCE.start(file, this.$this_addOutputHandlers);
            }

            public void onFinish(ScratchFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                ScratchCompilationSupport.INSTANCE.stop();
            }
        });
    }

    @Nullable
    protected abstract ScratchFile createFile(@NotNull Project var1, @NotNull VirtualFile var2);

    @Nullable
    protected abstract SequentialScratchExecutor createReplExecutor(@NotNull ScratchFile var1);

    @Nullable
    protected abstract ScratchExecutor createCompilingExecutor(@NotNull ScratchFile var1);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ScratchFileLanguageProvider$Companion;", "", "<init>", "()V", "EXTENSION", "Lcom/intellij/lang/LanguageExtension;", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFileLanguageProvider;", "get", "language", "Lcom/intellij/lang/Language;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "kotlin.jvm"})
    @SourceDebugExtension(value={"SMAP\nScratchFileLanguageProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScratchFileLanguageProvider.kt\norg/jetbrains/kotlin/idea/scratch/ScratchFileLanguageProvider$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n1#2:66\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ScratchFileLanguageProvider get(@NotNull Language language) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            return (ScratchFileLanguageProvider)EXTENSION.forLanguage(language);
        }

        @Nullable
        public final ScratchFileLanguageProvider get(@NotNull FileType fileType) {
            ScratchFileLanguageProvider scratchFileLanguageProvider;
            Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
            LanguageFileType languageFileType = fileType instanceof LanguageFileType ? (LanguageFileType)fileType : null;
            if (languageFileType != null && (languageFileType = languageFileType.getLanguage()) != null) {
                LanguageFileType it = languageFileType;
                boolean bl = false;
                scratchFileLanguageProvider = Companion.get((Language)it);
            } else {
                scratchFileLanguageProvider = null;
            }
            return scratchFileLanguageProvider;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

