/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.idea.scratch.ScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.SequentialScratchExecutor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000=\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006*\u0001\u0016\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J\b\u0010\n\u001a\u00020\u0007H$J\u001a\u0010\u000b\u001a\u00020\u00072\u0010\b\u0002\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\rH$J\b\u0010\u000e\u001a\u00020\u000fH$J\u0006\u0010\u0010\u001a\u00020\u0007J\b\u0010\u0011\u001a\u00020\u0007H\u0016J\u0006\u0010\u0012\u001a\u00020\u0007J\b\u0010\u0013\u001a\u00020\u0007H\u0016J\b\u0010\u0014\u001a\u0004\u0018\u00010\tJ\b\u0010\u001a\u001a\u00020\u000fH\u0002J\b\u0010\u001b\u001a\u00020\u0007H\u0002J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u0019H\u0002J\b\u0010\u001e\u001a\u00020\u0007H\u0007R\u0010\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/SequentialScratchExecutor;", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExecutor;", "file", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "<init>", "(Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;)V", "executeStatement", "", "expression", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "startExecution", "stopExecution", "callback", "Lkotlin/Function0;", "needProcessToStart", "", "start", "stop", "executeNew", "execute", "getFirstNewExpression", "listener", "org/jetbrains/kotlin/idea/scratch/SequentialScratchExecutor$listener$1", "Lorg/jetbrains/kotlin/idea/scratch/SequentialScratchExecutor$listener$1;", "lastExecuted", "", "needToRestartProcess", "resetLastExecutedIndex", "wasExpressionExecuted", "index", "stopAndWait", "kotlin.jvm"})
public abstract class SequentialScratchExecutor
extends ScratchExecutor {
    @NotNull
    private final listener.1 listener;
    private int lastExecuted;

    public SequentialScratchExecutor(@NotNull ScratchFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super(file);
        this.listener = new DocumentListener(this, file){
            final /* synthetic */ SequentialScratchExecutor this$0;
            final /* synthetic */ ScratchFile $file;
            {
                this.this$0 = $receiver;
                this.$file = $file;
            }

            public void documentChanged(DocumentEvent event) {
                Object object;
                Document document;
                block11: {
                    block10: {
                        VirtualFile virtualFile;
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        CharSequence charSequence = event.getNewFragment();
                        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNewFragment(...)");
                        if (StringsKt.isBlank((CharSequence)charSequence)) {
                            CharSequence charSequence2 = event.getOldFragment();
                            Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"getOldFragment(...)");
                            if (StringsKt.isBlank((CharSequence)charSequence2)) {
                                return;
                            }
                        }
                        if (!SequentialScratchExecutor.access$needToRestartProcess(this.this$0)) {
                            return;
                        }
                        Document document2 = event.getDocument();
                        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
                        document = document2;
                        object = FileDocumentManager.getInstance().getFile(document);
                        if (object == null) break block10;
                        VirtualFile it = virtualFile = object;
                        boolean bl = false;
                        object = it.isInLocalFileSystem() ? virtualFile : null;
                        if (object != null) break block11;
                    }
                    return;
                }
                VirtualFile virtualFile = object;
                if (!virtualFile.isValid()) {
                    return;
                }
                if (!Intrinsics.areEqual((Object)PsiManager.getInstance((Project)this.$file.getProject()).findFile(virtualFile), (Object)this.$file.getPsiFile())) {
                    return;
                }
                int changedLine = document.getLineNumber(event.getOffset());
                ScratchExpression scratchExpression = this.$file.getExpressionAtLine(changedLine);
                if (scratchExpression == null) {
                    return;
                }
                ScratchExpression changedExpression = scratchExpression;
                int changedExpressionIndex = this.$file.getExpressions().indexOf(changedExpression);
                if (SequentialScratchExecutor.access$wasExpressionExecuted(this.this$0, changedExpressionIndex)) {
                    SequentialScratchExecutor.access$resetLastExecutedIndex(this.this$0);
                    this.this$0.getHandler().clear(this.$file);
                    SequentialScratchExecutor.stopExecution$default(this.this$0, null, 1, null);
                }
            }
        };
        this.lastExecuted = -1;
    }

    public abstract void executeStatement(@NotNull ScratchExpression var1);

    protected abstract void startExecution();

    protected abstract void stopExecution(@Nullable Function0<Unit> var1);

    public static /* synthetic */ void stopExecution$default(SequentialScratchExecutor sequentialScratchExecutor, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: stopExecution");
        }
        if ((n & 1) != 0) {
            function0 = null;
        }
        sequentialScratchExecutor.stopExecution((Function0<Unit>)function0);
    }

    protected abstract boolean needProcessToStart();

    public final void start() {
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)this.listener, (Disposable)this.getFile().getProject().getMessageBus().connect());
        this.startExecution();
    }

    @Override
    public void stop() {
        EditorFactory.getInstance().getEventMulticaster().removeDocumentListener((DocumentListener)this.listener);
        SequentialScratchExecutor.stopExecution$default(this, null, 1, null);
    }

    public final void executeNew() {
        List<ScratchExpression> expressions = this.getFile().getExpressions();
        if (this.wasExpressionExecuted(expressions.size())) {
            return;
        }
        this.getHandler().onStart(this.getFile());
        Iterator iterator = ((Iterable)expressions).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index2 = n++;
            ScratchExpression expression = (ScratchExpression)iterator.next();
            if (this.wasExpressionExecuted(index2)) continue;
            this.executeStatement(expression);
            this.lastExecuted = index2;
        }
    }

    @Override
    public void execute() {
        if (this.needToRestartProcess()) {
            this.resetLastExecutedIndex();
            this.getHandler().clear(this.getFile());
            this.getHandler().onStart(this.getFile());
            this.stopExecution((Function0<Unit>)((Function0)() -> SequentialScratchExecutor.execute$lambda$1(this)));
        } else {
            this.executeNew();
        }
    }

    @Nullable
    public final ScratchExpression getFirstNewExpression() {
        List expressions = (List)ActionsKt.runReadAction(() -> SequentialScratchExecutor.getFirstNewExpression$lambda$2(this));
        int firstNewExpressionIndex = this.lastExecuted + 1;
        boolean bl = 0 <= firstNewExpressionIndex ? firstNewExpressionIndex < ((Collection)expressions).size() : false;
        if (bl) {
            return (ScratchExpression)expressions.get(firstNewExpressionIndex);
        }
        return null;
    }

    private final boolean needToRestartProcess() {
        return this.lastExecuted > -1;
    }

    private final void resetLastExecutedIndex() {
        this.lastExecuted = -1;
    }

    private final boolean wasExpressionExecuted(int index2) {
        return index2 <= this.lastExecuted;
    }

    @TestOnly
    public final void stopAndWait() {
        Semaphore lock = new Semaphore(1);
        lock.acquire();
        this.stopExecution((Function0<Unit>)((Function0)() -> SequentialScratchExecutor.stopAndWait$lambda$3(lock)));
        if (!lock.tryAcquire(2L, TimeUnit.SECONDS)) {
            boolean bl = false;
            String string = "Couldn't stop REPL process in 2 seconds";
            throw new IllegalStateException(string.toString());
        }
    }

    private static final void execute$lambda$1$lambda$0(SequentialScratchExecutor this$0) {
        this$0.executeNew();
    }

    private static final Unit execute$lambda$1(SequentialScratchExecutor this$0) {
        ApplicationManager.getApplication().invokeLater(() -> SequentialScratchExecutor.execute$lambda$1$lambda$0(this$0));
        return Unit.INSTANCE;
    }

    private static final List getFirstNewExpression$lambda$2(SequentialScratchExecutor this$0) {
        return this$0.getFile().getExpressions();
    }

    private static final Unit stopAndWait$lambda$3(Semaphore $lock) {
        $lock.release();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ boolean access$needToRestartProcess(SequentialScratchExecutor $this) {
        return $this.needToRestartProcess();
    }

    public static final /* synthetic */ boolean access$wasExpressionExecuted(SequentialScratchExecutor $this, int index2) {
        return $this.wasExpressionExecuted(index2);
    }

    public static final /* synthetic */ void access$resetLastExecutedIndex(SequentialScratchExecutor $this) {
        $this.resetLastExecutedIndex();
    }
}

