/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.util.KotlinScopeUtils;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0007\u001a\f\u0010\u0003\u001a\u00020\u0001*\u00020\u0002H\u0007\u001a!\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00070\nH\u0082\b\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\r\u001a\u0012\u0010\u000e\u001a\u00020\r*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\r\u001a\n\u0010\u0015\u001a\u00020\r*\u00020\u0011\u001a\n\u0010\u0016\u001a\u00020\r*\u00020\u0011\u001a&\u0010\u0017\u001a\u00020\u0018*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u00012\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001d\u001a\n\u0010\u001e\u001a\u00020\u0013*\u00020\u001f\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"allScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "Lcom/intellij/openapi/project/Project;", "projectScope", "parenthesisRegex", "Lkotlin/text/Regex;", "ifNotEmpty", "", "", "action", "Lkotlin/Function1;", "toHumanReadableString", "", "Lcom/intellij/psi/search/SearchScope;", "effectiveSearchScope", "Lcom/intellij/psi/search/searches/ReferencesSearch$SearchParameters;", "element", "Lcom/intellij/psi/PsiElement;", "isOnlyKotlinSearch", "", "searchScope", "codeUsageScopeRestrictedToProject", "codeUsageScopeRestrictedToKotlinSources", "isCheapEnoughToSearchConsideringOperators", "Lcom/intellij/psi/search/PsiSearchHelper$SearchCostResult;", "Lcom/intellij/psi/search/PsiSearchHelper;", "name", "scope", "fileToIgnoreOccurrencesIn", "Lcom/intellij/psi/PsiFile;", "isImportUsage", "Lcom/intellij/psi/PsiReference;", "kotlin.base.analysis"})
@SourceDebugExtension(value={"SMAP\nsearchUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 searchUtil.kt\norg/jetbrains/kotlin/idea/search/SearchUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,103:1\n45#1:105\n46#1:107\n1#2:104\n1#2:106\n12364#3,2:108\n217#4:110\n*S KotlinDebug\n*F\n+ 1 searchUtil.kt\norg/jetbrains/kotlin/idea/search/SearchUtilKt\n*L\n54#1:105\n54#1:107\n54#1:106\n80#1:108,2\n101#1:110\n*E\n"})
public final class SearchUtilKt {
    @NotNull
    private static final Regex parenthesisRegex = new Regex("( *\\( *)|( *\\) *)|( *, *(?![^\\[]*]))");

    @Deprecated(message="Use 'org.jetbrains.kotlin.idea.base.util.allScope' instead", replaceWith=@ReplaceWith(expression="this.allScope()", imports={"org.jetbrains.kotlin.idea.base.util.allScope"}), level=DeprecationLevel.ERROR)
    @NotNull
    public static final GlobalSearchScope allScope(@NotNull Project $this$allScope) {
        Intrinsics.checkNotNullParameter((Object)$this$allScope, (String)"<this>");
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)$this$allScope);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        return globalSearchScope;
    }

    @Deprecated(message="Use 'org.jetbrains.kotlin.idea.base.util.projectScope' instead", replaceWith=@ReplaceWith(expression="this.projectScope()", imports={"org.jetbrains.kotlin.idea.base.util.projectScope"}), level=DeprecationLevel.ERROR)
    @NotNull
    public static final GlobalSearchScope projectScope(@NotNull Project $this$projectScope) {
        Intrinsics.checkNotNullParameter((Object)$this$projectScope, (String)"<this>");
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)$this$projectScope);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
        return globalSearchScope;
    }

    private static final void ifNotEmpty(CharSequence $this$ifNotEmpty, Function1<? super CharSequence, Unit> action) {
        block0: {
            CharSequence charSequence;
            boolean $i$f$ifNotEmpty = false;
            CharSequence p0 = charSequence = $this$ifNotEmpty;
            boolean bl = false;
            CharSequence charSequence2 = !StringsKt.isBlank((CharSequence)p0) ? charSequence : null;
            if (charSequence2 == null) break block0;
            action.invoke((Object)charSequence2);
        }
    }

    @NotNull
    public static final String toHumanReadableString(@NotNull SearchScope $this$toHumanReadableString) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$toHumanReadableString, (String)"<this>");
        StringBuilder $this$toHumanReadableString_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String scopeText = $this$toHumanReadableString.toString();
        int currentIndent = 0;
        int lastIndex = 0;
        for (MatchResult parenthesis : Regex.findAll$default((Regex)parenthesisRegex, (CharSequence)scopeText, (int)0, (int)2, null)) {
            CharSequence charSequence;
            CharSequence subSequence;
            CharSequence $this$ifNotEmpty$iv = subSequence = scopeText.subSequence(lastIndex, parenthesis.getRange().getFirst());
            boolean $i$f$ifNotEmpty = false;
            CharSequence p0$iv = charSequence = $this$ifNotEmpty$iv;
            boolean bl2 = false;
            if ((!StringsKt.isBlank((CharSequence)p0$iv) ? charSequence : null) != null) {
                CharSequence it;
                it = it;
                boolean bl3 = false;
                $this$toHumanReadableString_u24lambda_u241.append(StringsKt.repeat((CharSequence)" ", (int)currentIndent));
                $this$toHumanReadableString_u24lambda_u241.append(it).append('\n');
            }
            String value = parenthesis.getValue();
            if (StringsKt.contains$default((CharSequence)value, (CharSequence)"(", (boolean)false, (int)2, null)) {
                currentIndent += 2;
            } else if (StringsKt.contains$default((CharSequence)value, (CharSequence)")", (boolean)false, (int)2, null)) {
                currentIndent -= 2;
            }
            lastIndex = parenthesis.getRange().getLast() + 1;
        }
        if (((CharSequence)$this$toHumanReadableString_u24lambda_u241).length() == 0) {
            $this$toHumanReadableString_u24lambda_u241.append(scopeText);
        }
        return stringBuilder.toString();
    }

    @NotNull
    public static final SearchScope effectiveSearchScope(@NotNull ReferencesSearch.SearchParameters $this$effectiveSearchScope, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)$this$effectiveSearchScope, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (Intrinsics.areEqual((Object)element, (Object)$this$effectiveSearchScope.getElementToSearch())) {
            SearchScope searchScope = $this$effectiveSearchScope.getEffectiveSearchScope();
            Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"getEffectiveSearchScope(...)");
            return searchScope;
        }
        if ($this$effectiveSearchScope.isIgnoreAccessScope()) {
            SearchScope searchScope = $this$effectiveSearchScope.getScopeDeterminedByUser();
            Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"getScopeDeterminedByUser(...)");
            return searchScope;
        }
        SearchScope accessScope = KotlinScopeUtils.useScope(element);
        SearchScope searchScope = $this$effectiveSearchScope.getScopeDeterminedByUser().intersectWith(accessScope);
        Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"intersectWith(...)");
        return searchScope;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isOnlyKotlinSearch(@NotNull SearchScope searchScope) {
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        if (!(searchScope instanceof LocalSearchScope)) return false;
        PsiElement[] psiElementArray = ((LocalSearchScope)searchScope).getScope();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getScope(...)");
        Object[] $this$all$iv = psiElementArray;
        boolean $i$f$all = false;
        int n = 0;
        int n2 = $this$all$iv.length;
        while (n < n2) {
            Object element$iv = $this$all$iv[n];
            PsiElement it = (PsiElement)element$iv;
            boolean bl = false;
            if (!(it.getContainingFile() instanceof KtFile)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @NotNull
    public static final SearchScope codeUsageScopeRestrictedToProject(@NotNull PsiElement $this$codeUsageScopeRestrictedToProject) {
        Intrinsics.checkNotNullParameter((Object)$this$codeUsageScopeRestrictedToProject, (String)"<this>");
        Project project = $this$codeUsageScopeRestrictedToProject.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        SearchScope searchScope = KotlinScopeUtils.projectScope(project).intersectWith(KotlinScopeUtils.codeUsageScope($this$codeUsageScopeRestrictedToProject));
        Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"intersectWith(...)");
        return searchScope;
    }

    @NotNull
    public static final SearchScope codeUsageScopeRestrictedToKotlinSources(@NotNull PsiElement $this$codeUsageScopeRestrictedToKotlinSources) {
        Intrinsics.checkNotNullParameter((Object)$this$codeUsageScopeRestrictedToKotlinSources, (String)"<this>");
        return KotlinScopeUtils.restrictToKotlinSources(KotlinScopeUtils.codeUsageScope($this$codeUsageScopeRestrictedToKotlinSources));
    }

    @NotNull
    public static final PsiSearchHelper.SearchCostResult isCheapEnoughToSearchConsideringOperators(@NotNull PsiSearchHelper $this$isCheapEnoughToSearchConsideringOperators, @NotNull String name2, @NotNull GlobalSearchScope scope, @Nullable PsiFile fileToIgnoreOccurrencesIn) {
        Intrinsics.checkNotNullParameter((Object)$this$isCheapEnoughToSearchConsideringOperators, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        if (OperatorConventions.isConventionName((Name)Name.identifier((String)name2))) {
            return PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
        }
        PsiSearchHelper.SearchCostResult searchCostResult = $this$isCheapEnoughToSearchConsideringOperators.isCheapEnoughToSearch(name2, scope, fileToIgnoreOccurrencesIn);
        Intrinsics.checkNotNullExpressionValue((Object)searchCostResult, (String)"isCheapEnoughToSearch(...)");
        return searchCostResult;
    }

    public static /* synthetic */ PsiSearchHelper.SearchCostResult isCheapEnoughToSearchConsideringOperators$default(PsiSearchHelper psiSearchHelper, String string, GlobalSearchScope globalSearchScope, PsiFile psiFile, int n, Object object) {
        if ((n & 4) != 0) {
            psiFile = null;
        }
        return SearchUtilKt.isCheapEnoughToSearchConsideringOperators(psiSearchHelper, string, globalSearchScope, psiFile);
    }

    public static final boolean isImportUsage(@NotNull PsiReference $this$isImportUsage) {
        Intrinsics.checkNotNullParameter((Object)$this$isImportUsage, (String)"<this>");
        PsiElement psiElement = $this$isImportUsage.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        PsiElement $this$getNonStrictParentOfType$iv = psiElement;
        boolean $i$f$getNonStrictParentOfType = false;
        return PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtImportDirective.class, (boolean)false) != null;
    }
}

