/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.slicer;

import com.intellij.ide.SelectInEditorManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.slicer.SliceAnalysisParams;
import com.intellij.slicer.SliceUsage;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.TextChunk;
import com.intellij.util.FontUtil;
import com.intellij.util.Processor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInsight.slicer.AbstractKotlinSliceUsage;
import org.jetbrains.kotlin.idea.codeInsight.slicer.KotlinSliceAnalysisMode;
import org.jetbrains.kotlin.idea.slicer.InflowSlicer;
import org.jetbrains.kotlin.idea.slicer.KotlinSliceUsageSuffix;
import org.jetbrains.kotlin.idea.slicer.OutflowSlicer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0001%B)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\n\u0010\u000eJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0013\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0013\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0016H\u0014\u00a2\u0006\u0002\u0010\u001aJ\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\tH\u0016J\b\u0010\u001e\u001a\u00020\u0012H\u0016J\b\u0010\u001f\u001a\u00020\u0000H\u0014J\b\u0010 \u001a\u00020\tH\u0016J \u0010!\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00032\u000e\u0010\"\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00050#H\u0016J \u0010$\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00032\u000e\u0010\"\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00050#H\u0016R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/slicer/KotlinSliceUsage;", "Lorg/jetbrains/kotlin/idea/codeInsight/slicer/AbstractKotlinSliceUsage;", "element", "Lcom/intellij/psi/PsiElement;", "parent", "Lcom/intellij/slicer/SliceUsage;", "mode", "Lorg/jetbrains/kotlin/idea/codeInsight/slicer/KotlinSliceAnalysisMode;", "forcedExpressionMode", "", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/slicer/SliceUsage;Lorg/jetbrains/kotlin/idea/codeInsight/slicer/KotlinSliceAnalysisMode;Z)V", "params", "Lcom/intellij/slicer/SliceAnalysisParams;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/slicer/SliceAnalysisParams;)V", "usageInfo", "Lorg/jetbrains/kotlin/idea/slicer/KotlinSliceUsage$AdaptedUsageInfo;", "initializeUsageInfo", "", "getUsageInfo", "Lcom/intellij/usageView/UsageInfo;", "getMergedInfos", "", "()[Lcom/intellij/usageView/UsageInfo;", "computeText", "Lcom/intellij/usages/TextChunk;", "()[Lcom/intellij/usages/TextChunk;", "openTextEditor", "Lcom/intellij/openapi/editor/Editor;", "focus", "highlightInEditor", "copy", "canBeLeaf", "processUsagesFlownDownTo", "uniqueProcessor", "Lcom/intellij/util/Processor;", "processUsagesFlownFromThe", "AdaptedUsageInfo", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKotlinSliceUsage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSliceUsage.kt\norg/jetbrains/kotlin/idea/slicer/KotlinSliceUsage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,203:1\n1#2:204\n37#3:205\n36#3,3:206\n*S KotlinDebug\n*F\n+ 1 KotlinSliceUsage.kt\norg/jetbrains/kotlin/idea/slicer/KotlinSliceUsage\n*L\n90#1:205\n90#1:206,3\n*E\n"})
public class KotlinSliceUsage
extends AbstractKotlinSliceUsage {
    @Nullable
    private AdaptedUsageInfo usageInfo;

    public KotlinSliceUsage(@NotNull PsiElement element, @NotNull SliceUsage parent2, @NotNull KotlinSliceAnalysisMode mode, boolean forcedExpressionMode) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        super(element, parent2, mode, forcedExpressionMode);
        this.initializeUsageInfo();
    }

    public KotlinSliceUsage(@NotNull PsiElement element, @NotNull SliceAnalysisParams params) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        super(element, params);
        this.initializeUsageInfo();
    }

    private final void initializeUsageInfo() {
        AdaptedUsageInfo adaptedUsageInfo;
        KotlinSliceUsage kotlinSliceUsage = this;
        PsiElement psiElement = this.getUsageInfo().getElement();
        if (psiElement != null) {
            PsiElement it = psiElement;
            KotlinSliceUsage kotlinSliceUsage2 = kotlinSliceUsage;
            boolean bl = false;
            adaptedUsageInfo = new AdaptedUsageInfo(it, this.getMode());
            kotlinSliceUsage = kotlinSliceUsage2;
        } else {
            adaptedUsageInfo = null;
        }
        kotlinSliceUsage.usageInfo = adaptedUsageInfo;
        this.resetCachedPresentation();
    }

    @NotNull
    public UsageInfo getUsageInfo() {
        UsageInfo usageInfo;
        AdaptedUsageInfo adaptedUsageInfo = this.usageInfo;
        if (adaptedUsageInfo != null) {
            usageInfo = adaptedUsageInfo;
        } else {
            UsageInfo usageInfo2 = super.getUsageInfo();
            usageInfo = usageInfo2;
            Intrinsics.checkNotNullExpressionValue((Object)usageInfo2, (String)"getUsageInfo(...)");
        }
        return usageInfo;
    }

    @NotNull
    public UsageInfo[] getMergedInfos() {
        UsageInfo[] usageInfoArray = new UsageInfo[]{this.getUsageInfo()};
        return usageInfoArray;
    }

    @NotNull
    protected TextChunk[] computeText() {
        TextChunk[] textChunkArray = super.computeText();
        Intrinsics.checkNotNullExpressionValue((Object)textChunkArray, (String)"computeText(...)");
        TextChunk[] text = textChunkArray;
        List result2 = new ArrayList();
        int n = text.length;
        for (int j = 0; j < n; ++j) {
            SimpleTextAttributes attributes;
            int i2 = j;
            TextChunk textChunk = text[j];
            Intrinsics.checkNotNullExpressionValue((Object)textChunk.getSimpleAttributesIgnoreBackground(), (String)"getSimpleAttributesIgnoreBackground(...)");
            if (this.isDereference()) {
                attributes = attributes.derive(attributes.getStyle(), (Color)JBColor.LIGHT_GRAY, attributes.getBgColor(), attributes.getWaveColor());
            }
            if (attributes.getFontStyle() == 1) {
                attributes = attributes.derive(attributes.getStyle() | 0x10, null, null, null);
            }
            result2.add(new TextChunk(attributes.toTextAttributes(), textChunk.getText()));
            if (i2 != 0) continue;
            result2.add(new TextChunk(new TextAttributes(), FontUtil.spaceAndThinSpace()));
        }
        for (KotlinSliceAnalysisMode.Behaviour behaviour : CollectionsKt.reversed((Iterable)this.getMode().getBehaviourStack())) {
            result2.add(new TextChunk(SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES.toTextAttributes(), behaviour.getSlicePresentationPrefix()));
        }
        String containerSuffix = KotlinSliceUsageSuffix.INSTANCE.containerSuffix(this);
        if (containerSuffix != null) {
            result2.add(new TextChunk(new TextAttributes(), " "));
            result2.add(new TextChunk(SimpleTextAttributes.GRAY_ATTRIBUTES.toTextAttributes(), containerSuffix));
        }
        Collection $this$toTypedArray$iv = result2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new TextChunk[0]);
    }

    @Nullable
    public Editor openTextEditor(boolean focus) {
        Project project = this.getUsageInfo().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project2, this.getFile(), this.getUsageInfo().getNavigationOffset());
        return FileEditorManager.getInstance((Project)project2).openTextEditor(descriptor2, focus);
    }

    public void highlightInEditor() {
        if (!this.isValid()) {
            return;
        }
        UsageInfo usageInfo = this.getUsageInfo();
        Segment segment = usageInfo.getNavigationRange();
        if (segment == null) {
            return;
        }
        Segment range2 = segment;
        SelectInEditorManager.getInstance((Project)this.getUsageInfo().getProject()).selectInEditor(this.getFile(), range2.getStartOffset(), range2.getEndOffset(), false, false);
        if (usageInfo.getNavigationOffset() != range2.getStartOffset()) {
            this.openTextEditor(false);
        }
    }

    @NotNull
    protected KotlinSliceUsage copy() {
        KotlinSliceUsage kotlinSliceUsage;
        PsiElement psiElement = this.getUsageInfo().getElement();
        if (psiElement == null) {
            throw new IllegalStateException("No more valid usageInfo.element".toString());
        }
        PsiElement element = psiElement;
        if (this.getParent() == null) {
            SliceAnalysisParams sliceAnalysisParams = this.params;
            Intrinsics.checkNotNullExpressionValue((Object)sliceAnalysisParams, (String)"params");
            kotlinSliceUsage = new KotlinSliceUsage(element, sliceAnalysisParams);
        } else {
            SliceUsage sliceUsage = this.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)sliceUsage, (String)"getParent(...)");
            kotlinSliceUsage = new KotlinSliceUsage(element, sliceUsage, this.getMode(), this.getForcedExpressionMode());
        }
        return kotlinSliceUsage;
    }

    public boolean canBeLeaf() {
        return this.getElement() != null && Intrinsics.areEqual((Object)this.getMode(), (Object)KotlinSliceAnalysisMode.Companion.getDefault());
    }

    public void processUsagesFlownDownTo(@NotNull PsiElement element, @NotNull Processor<? super SliceUsage> uniqueProcessor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(uniqueProcessor, (String)"uniqueProcessor");
        KtElement ktElement = element instanceof KtElement ? (KtElement)element : null;
        if (ktElement == null) {
            return;
        }
        KtElement ktElement2 = ktElement;
        KotlinSliceAnalysisMode.Behaviour behaviour = this.getMode().getCurrentBehaviour();
        if (behaviour != null) {
            behaviour.processUsages(ktElement2, this, uniqueProcessor);
        } else {
            new InflowSlicer(ktElement2, uniqueProcessor, this).processChildren(this.getForcedExpressionMode());
        }
    }

    public void processUsagesFlownFromThe(@NotNull PsiElement element, @NotNull Processor<? super SliceUsage> uniqueProcessor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(uniqueProcessor, (String)"uniqueProcessor");
        KtElement ktElement = element instanceof KtElement ? (KtElement)element : null;
        if (ktElement == null) {
            return;
        }
        KtElement ktElement2 = ktElement;
        KotlinSliceAnalysisMode.Behaviour behaviour = this.getMode().getCurrentBehaviour();
        if (behaviour != null) {
            behaviour.processUsages(ktElement2, this, uniqueProcessor);
        } else {
            new OutflowSlicer(ktElement2, uniqueProcessor, this).processChildren(this.getForcedExpressionMode());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0002J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/slicer/KotlinSliceUsage$AdaptedUsageInfo;", "Lcom/intellij/usageView/UsageInfo;", "element", "Lcom/intellij/psi/PsiElement;", "mode", "Lorg/jetbrains/kotlin/idea/codeInsight/slicer/KotlinSliceAnalysisMode;", "<init>", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/idea/codeInsight/slicer/KotlinSliceAnalysisMode;)V", "equals", "", "other", "", "getNavigationRange", "Lcom/intellij/openapi/util/Segment;", "getRangeInElement", "Lcom/intellij/openapi/util/ProperTextRange;", "getNavigationOffset", "", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nKotlinSliceUsage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSliceUsage.kt\norg/jetbrains/kotlin/idea/slicer/KotlinSliceUsage$AdaptedUsageInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,203:1\n1#2:204\n*E\n"})
    private static final class AdaptedUsageInfo
    extends UsageInfo {
        @NotNull
        private final KotlinSliceAnalysisMode mode;

        public AdaptedUsageInfo(@NotNull PsiElement element, @NotNull KotlinSliceAnalysisMode mode) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
            super(element);
            this.mode = mode;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof AdaptedUsageInfo && super.equals(other) && Intrinsics.areEqual((Object)this.mode, (Object)((AdaptedUsageInfo)((Object)other)).mode);
        }

        @Nullable
        public Segment getNavigationRange() {
            Segment segment;
            Segment segment2;
            PsiElement psiElement = this.getElement();
            if (psiElement == null) {
                return null;
            }
            PsiElement element = psiElement;
            PsiElement psiElement2 = element;
            if (psiElement2 instanceof KtParameter) {
                PsiElement psiElement3 = ((KtParameter)element).getNameIdentifier();
                if (psiElement3 == null || (psiElement3 = psiElement3.getTextRange()) == null) {
                    return super.getNavigationRange();
                }
                PsiElement nameRange = psiElement3;
                PsiElement psiElement4 = ((KtParameter)element).getValOrVarKeyword();
                int start2 = psiElement4 != null ? PsiUtilsKt.getStartOffset((PsiElement)psiElement4) : nameRange.getStartOffset();
                KtTypeReference ktTypeReference = ((KtParameter)element).getTypeReference();
                int end = ktTypeReference != null ? PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)ktTypeReference)) : nameRange.getEndOffset();
                segment2 = (Segment)new TextRange(start2, end);
            } else if (psiElement2 instanceof KtVariableDeclaration) {
                PsiElement psiElement5 = ((KtVariableDeclaration)element).getNameIdentifier();
                if (psiElement5 == null || (psiElement5 = psiElement5.getTextRange()) == null) {
                    return super.getNavigationRange();
                }
                PsiElement nameRange = psiElement5;
                PsiElement psiElement6 = ((KtVariableDeclaration)element).getValOrVarKeyword();
                int start3 = psiElement6 != null ? PsiUtilsKt.getStartOffset((PsiElement)psiElement6) : nameRange.getStartOffset();
                KtTypeReference ktTypeReference = ((KtVariableDeclaration)element).getTypeReference();
                int end = ktTypeReference != null ? PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)ktTypeReference)) : nameRange.getEndOffset();
                segment2 = (Segment)new TextRange(start3, end);
            } else if (psiElement2 instanceof KtNamedFunction) {
                TextRange textRange;
                PsiElement funKeyword = ((KtNamedFunction)element).getFunKeyword();
                KtParameterList parameterList = ((KtNamedFunction)element).getValueParameterList();
                KtTypeReference typeReference = ((KtNamedFunction)element).getTypeReference();
                if (funKeyword != null && parameterList != null) {
                    KtTypeReference ktTypeReference = typeReference;
                    textRange = new TextRange(PsiUtilsKt.getStartOffset((PsiElement)funKeyword), ktTypeReference != null ? PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)ktTypeReference)) : PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)parameterList)));
                } else {
                    textRange = null;
                }
                segment2 = (Segment)textRange;
            } else if (psiElement2 instanceof KtPrimaryConstructor) {
                TextRange textRange;
                PsiElement psiElement7;
                KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)element));
                if (ktClassOrObject != null && (psiElement7 = ktClassOrObject.getNameIdentifier()) != null) {
                    PsiElement it = psiElement7;
                    boolean bl = false;
                    textRange = new TextRange(PsiUtilsKt.getStartOffset((PsiElement)it), PsiUtilsKt.getEndOffset((PsiElement)element));
                } else {
                    textRange = null;
                }
                segment2 = (Segment)textRange;
            } else {
                segment2 = segment = null;
            }
            if (segment2 == null) {
                segment = (Segment)new TextRange(element.getTextOffset(), PsiUtilsKt.getEndOffset((PsiElement)element));
            }
            return segment;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Nullable
        public ProperTextRange getRangeInElement() {
            ProperTextRange properTextRange;
            PsiElement psiElement2 = this.getElement();
            psiElement2 = psiElement2;
            if (psiElement == null) return null;
            if ((psiElement2 = psiElement2.getTextRange()) == null) {
                return null;
            }
            PsiElement elementRange = psiElement2;
            Segment segment = this.getNavigationRange();
            if (segment != null) {
                Segment segment2;
                Segment segment3;
                Segment it = segment3 = segment;
                boolean bl = false;
                Object object = segment2 = elementRange.contains(it) ? segment3 : null;
                if (segment2 != null) {
                    Segment it2 = segment2;
                    boolean bl2 = false;
                    segment3 = new ProperTextRange(it2.getStartOffset(), it2.getEndOffset()).shiftRight(-elementRange.getStartOffset());
                    if (segment3 != null) {
                        properTextRange = segment3;
                        return properTextRange;
                    }
                }
            }
            properTextRange = super.getRangeInElement();
            return properTextRange;
        }

        public int getNavigationOffset() {
            PsiElement psiElement = this.getElement();
            return psiElement != null ? psiElement.getTextOffset() : -1;
        }
    }
}

