/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.suggestions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.FUSEventSource;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginSuggestion;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.suggestions.PluginEnablementChecker;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/suggestions/JupyterPluginSuggestion;", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginSuggestion;", "project", "Lcom/intellij/openapi/project/Project;", "checker", "Lorg/jetbrains/kotlin/idea/suggestions/PluginEnablementChecker;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/idea/suggestions/PluginEnablementChecker;)V", "pluginIds", "", "", "getPluginIds", "()Ljava/util/List;", "apply", "Lcom/intellij/ui/EditorNotificationPanel;", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "setupPluginSuggestion", "", "panel", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nJupyterNotebookSuggestionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterNotebookSuggestionProvider.kt\norg/jetbrains/kotlin/idea/suggestions/JupyterPluginSuggestion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,148:1\n1557#2:149\n1628#2,3:150\n*S KotlinDebug\n*F\n+ 1 JupyterNotebookSuggestionProvider.kt\norg/jetbrains/kotlin/idea/suggestions/JupyterPluginSuggestion\n*L\n116#1:149\n116#1:150,3\n*E\n"})
final class JupyterPluginSuggestion
implements PluginSuggestion {
    @NotNull
    private final Project project;
    @NotNull
    private final PluginEnablementChecker checker;
    @NotNull
    private final List<String> pluginIds;

    public JupyterPluginSuggestion(@NotNull Project project, @NotNull PluginEnablementChecker checker) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
        this.project = project;
        this.checker = checker;
        this.pluginIds = this.checker.getPluginIds();
    }

    @NotNull
    public List<String> getPluginIds() {
        return this.pluginIds;
    }

    @NotNull
    public EditorNotificationPanel apply(@NotNull FileEditor fileEditor) {
        Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
        EditorNotificationPanel.Status status = EditorNotificationPanel.Status.Info;
        EditorNotificationPanel panel = new EditorNotificationPanel(fileEditor, status);
        this.setupPluginSuggestion(panel);
        panel.createActionLabel(IdeBundle.message((String)"plugins.advertiser.action.ignore.ultimate", (Object[])new Object[0]), () -> JupyterPluginSuggestion.apply$lambda$0(this));
        return panel;
    }

    private final void setupPluginSuggestion(EditorNotificationPanel panel) {
        panel.setText(this.checker.getSuggestionText());
        panel.createActionLabel(this.checker.getSuggestionActionText(), () -> JupyterPluginSuggestion.setupPluginSuggestion$lambda$2(this));
    }

    private static final void apply$lambda$0(JupyterPluginSuggestion this$0) {
        FUSEventSource.EDITOR.logIgnoreExtension(this$0.project);
        this$0.checker.dismissSuggestion();
        EditorNotifications.getInstance((Project)this$0.project).updateAllNotifications();
    }

    private static final void setupPluginSuggestion$lambda$2$lambda$1(JupyterPluginSuggestion this$0) {
        EditorNotifications.getInstance((Project)this$0.project).updateAllNotifications();
    }

    /*
     * WARNING - void declaration
     */
    private static final void setupPluginSuggestion$lambda$2(JupyterPluginSuggestion this$0) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        FUSEventSource.EDITOR.logInstallPlugins(this$0.getPluginIds(), this$0.project);
        Iterable iterable = this$0.getPluginIds();
        Project project = this$0.project;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PluginId.getId((String)p0));
        }
        PluginsAdvertiser.installAndEnable$default((Project)project, (Set)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)), (boolean)true, (boolean)false, null, () -> JupyterPluginSuggestion.setupPluginSuggestion$lambda$2$lambda$1(this$0), (int)24, null);
        if (this$0.checker.getRequiresIdeRestart()) {
            PluginManagerConfigurable.shutdownOrRestartApp();
        }
    }
}

