/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.j2k.ConverterContext;
import org.jetbrains.kotlin.j2k.FileBasedPostProcessing;
import org.jetbrains.kotlin.j2k.InspectionLikeProcessing;
import org.jetbrains.kotlin.j2k.PostProcessingApplier;
import org.jetbrains.kotlin.nj2k.PsiUtilsKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\"#$B\u001f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u001d\b\u0016\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\t\"\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\nJ\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0006J0\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J0\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J(\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u00182\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u001a\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/j2k/InspectionLikeProcessingGroup;", "Lorg/jetbrains/kotlin/j2k/FileBasedPostProcessing;", "runSingleTime", "", "processings", "", "Lorg/jetbrains/kotlin/j2k/InspectionLikeProcessing;", "<init>", "(ZLjava/util/List;)V", "", "([Lorg/jetbrains/kotlin/j2k/InspectionLikeProcessing;)V", "processingsToPriorityMap", "", "", "priority", "processing", "runProcessing", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "allFiles", "rangeMarker", "Lcom/intellij/openapi/editor/RangeMarker;", "converterContext", "Lorg/jetbrains/kotlin/j2k/ConverterContext;", "computeApplier", "Lorg/jetbrains/kotlin/j2k/PostProcessingApplier;", "collectAvailableActions", "Lorg/jetbrains/kotlin/j2k/InspectionLikeProcessingGroup$ProcessingData;", "context", "rangeFilter", "Lorg/jetbrains/kotlin/j2k/InspectionLikeProcessingGroup$RangeFilterResult;", "element", "Lcom/intellij/psi/PsiElement;", "Applier", "RangeFilterResult", "ProcessingData", "kotlin.j2k.shared"})
@SourceDebugExtension(value={"SMAP\ninspectionLikePostProcessing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 inspectionLikePostProcessing.kt\norg/jetbrains/kotlin/j2k/InspectionLikeProcessingGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,162:1\n1010#2,2:163\n*S KotlinDebug\n*F\n+ 1 inspectionLikePostProcessing.kt\norg/jetbrains/kotlin/j2k/InspectionLikeProcessingGroup\n*L\n114#1:163,2\n*E\n"})
public final class InspectionLikeProcessingGroup
extends FileBasedPostProcessing {
    private final boolean runSingleTime;
    @NotNull
    private final List<InspectionLikeProcessing> processings;
    @NotNull
    private final Map<InspectionLikeProcessing, Integer> processingsToPriorityMap;

    public InspectionLikeProcessingGroup(boolean runSingleTime, @NotNull List<? extends InspectionLikeProcessing> processings) {
        Intrinsics.checkNotNullParameter(processings, (String)"processings");
        this.runSingleTime = runSingleTime;
        this.processings = processings;
        this.processingsToPriorityMap = CollectionsKt.mapToIndex((Iterable)this.processings);
    }

    public /* synthetic */ InspectionLikeProcessingGroup(boolean bl, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl, list2);
    }

    public InspectionLikeProcessingGroup(InspectionLikeProcessing ... processings) {
        Intrinsics.checkNotNullParameter((Object)processings, (String)"processings");
        this(false, ArraysKt.toList((Object[])processings));
    }

    public final int priority(@NotNull InspectionLikeProcessing processing) {
        Intrinsics.checkNotNullParameter((Object)processing, (String)"processing");
        return ((Number)MapsKt.getValue(this.processingsToPriorityMap, (Object)processing)).intValue();
    }

    @Override
    public void runProcessing(@NotNull KtFile file, @NotNull List<? extends KtFile> allFiles, @Nullable RangeMarker rangeMarker, @NotNull ConverterContext converterContext) {
        List elementToActions;
        long l;
        Long l2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(allFiles, (String)"allFiles");
        Intrinsics.checkNotNullParameter((Object)converterContext, (String)"converterContext");
        do {
            Long modificationStamp = (Long)ActionsKt.runReadAction(() -> InspectionLikeProcessingGroup.runProcessing$lambda$0(file));
            elementToActions = (List)ActionsKt.runReadAction(() -> InspectionLikeProcessingGroup.runProcessing$lambda$1(this, file, converterContext, rangeMarker));
            for (ProcessingData processingData : elementToActions) {
                InspectionLikeProcessing processing = processingData.component1();
                SmartPsiElementPointer<PsiElement> pointer = processingData.component2();
                PsiElement element = (PsiElement)ActionsKt.runReadAction(() -> InspectionLikeProcessingGroup.runProcessing$lambda$2(pointer));
                if (element == null) {
                    modificationStamp = null;
                    continue;
                }
                boolean needRun = (Boolean)ActionsKt.runReadAction(() -> InspectionLikeProcessingGroup.runProcessing$lambda$3(element, processing, converterContext));
                if (needRun) {
                    PsiUtilsKt.runUndoTransparentActionInEdt(processing.getWriteActionNeeded(), () -> InspectionLikeProcessingGroup.runProcessing$lambda$4(processing, element));
                    continue;
                }
                modificationStamp = null;
            }
            if (this.runSingleTime) break;
            l2 = modificationStamp;
            l = ((Number)ActionsKt.runReadAction(() -> InspectionLikeProcessingGroup.runProcessing$lambda$5(file))).longValue();
        } while ((l2 == null || l2 != l) && !((Collection)elementToActions).isEmpty());
    }

    @Override
    @NotNull
    public PostProcessingApplier computeApplier(@NotNull KtFile file, @NotNull List<? extends KtFile> allFiles, @Nullable RangeMarker rangeMarker, @NotNull ConverterContext converterContext) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(allFiles, (String)"allFiles");
        Intrinsics.checkNotNullParameter((Object)converterContext, (String)"converterContext");
        List<ProcessingData> processingDataList = this.collectAvailableActions(file, converterContext, rangeMarker);
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return new Applier(processingDataList, project);
    }

    private final List<ProcessingData> collectAvailableActions(KtFile file, ConverterContext context, RangeMarker rangeMarker) {
        ArrayList<ProcessingData> availableActions = new ArrayList<ProcessingData>();
        file.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(this, rangeMarker, context, availableActions){
            final /* synthetic */ InspectionLikeProcessingGroup this$0;
            final /* synthetic */ RangeMarker $rangeMarker;
            final /* synthetic */ ConverterContext $context;
            final /* synthetic */ ArrayList<ProcessingData> $availableActions;
            {
                this.this$0 = $receiver;
                this.$rangeMarker = $rangeMarker;
                this.$context = $context;
                this.$availableActions = $availableActions;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (!(element instanceof KtElement)) {
                    return;
                }
                RangeFilterResult rangeResult = InspectionLikeProcessingGroup.access$rangeFilter(this.this$0, element, this.$rangeMarker);
                if (rangeResult == RangeFilterResult.SKIP) {
                    return;
                }
                super.visitElement(element);
                if (rangeResult == RangeFilterResult.PROCESS) {
                    for (InspectionLikeProcessing processing : InspectionLikeProcessingGroup.access$getProcessings$p(this.this$0)) {
                        if (!processing.isApplicableToElement(element, this.$context.getConverter().getSettings())) continue;
                        this.$availableActions.add(new ProcessingData(processing, (SmartPsiElementPointer<PsiElement>)SmartPointersKt.createSmartPointer((PsiElement)element), this.this$0.priority(processing)));
                    }
                }
            }
        });
        List $this$sortBy$iv = availableActions;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            kotlin.collections.CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ProcessingData it = (ProcessingData)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getPriority());
                    it = (ProcessingData)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPriority()));
                }
            });
        }
        return availableActions;
    }

    private final RangeFilterResult rangeFilter(PsiElement element, RangeMarker rangeMarker) {
        if (rangeMarker == null) {
            return RangeFilterResult.PROCESS;
        }
        if (!rangeMarker.isValid()) {
            return RangeFilterResult.SKIP;
        }
        TextRange textRange = rangeMarker.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        TextRange range2 = textRange;
        TextRange elementRange = element.getTextRange();
        return range2.contains(elementRange) ? RangeFilterResult.PROCESS : (range2.intersects(elementRange) ? RangeFilterResult.GO_INSIDE : RangeFilterResult.SKIP);
    }

    private static final long runProcessing$lambda$0(KtFile $file) {
        return $file.getModificationStamp();
    }

    private static final List runProcessing$lambda$1(InspectionLikeProcessingGroup this$0, KtFile $file, ConverterContext $converterContext, RangeMarker $rangeMarker) {
        return this$0.collectAvailableActions($file, $converterContext, $rangeMarker);
    }

    private static final PsiElement runProcessing$lambda$2(SmartPsiElementPointer $pointer) {
        return $pointer.getElement();
    }

    private static final boolean runProcessing$lambda$3(PsiElement $element, InspectionLikeProcessing $processing, ConverterContext $converterContext) {
        return $element.isValid() && $processing.isApplicableToElement($element, $converterContext.getConverter().getSettings());
    }

    private static final Unit runProcessing$lambda$4(InspectionLikeProcessing $processing, PsiElement $element) {
        $processing.applyToElement($element);
        return Unit.INSTANCE;
    }

    private static final long runProcessing$lambda$5(KtFile $file) {
        return $file.getModificationStamp();
    }

    public static final /* synthetic */ RangeFilterResult access$rangeFilter(InspectionLikeProcessingGroup $this, PsiElement element, RangeMarker rangeMarker) {
        return $this.rangeFilter(element, rangeMarker);
    }

    public static final /* synthetic */ List access$getProcessings$p(InspectionLikeProcessingGroup $this) {
        return $this.processings;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/j2k/InspectionLikeProcessingGroup$Applier;", "Lorg/jetbrains/kotlin/j2k/PostProcessingApplier;", "processingDataList", "", "Lorg/jetbrains/kotlin/j2k/InspectionLikeProcessingGroup$ProcessingData;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Ljava/util/List;Lcom/intellij/openapi/project/Project;)V", "apply", "", "kotlin.j2k.shared"})
    private static final class Applier
    implements PostProcessingApplier {
        @NotNull
        private final List<ProcessingData> processingDataList;
        @NotNull
        private final Project project;

        public Applier(@NotNull List<ProcessingData> processingDataList, @NotNull Project project) {
            Intrinsics.checkNotNullParameter(processingDataList, (String)"processingDataList");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.processingDataList = processingDataList;
            this.project = project;
        }

        @Override
        public void apply() {
            CodeStyleManager.getInstance((Project)this.project).performActionWithFormatterDisabled(() -> Applier.apply$lambda$0(this));
        }

        private static final void apply$lambda$0(Applier this$0) {
            for (ProcessingData processingData : this$0.processingDataList) {
                PsiElement element;
                InspectionLikeProcessing processing = processingData.component1();
                SmartPsiElementPointer<PsiElement> pointer = processingData.component2();
                if (pointer.getElement() == null) continue;
                processing.applyToElement(element);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\bH\u00c6\u0003J-\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/j2k/InspectionLikeProcessingGroup$ProcessingData;", "", "processing", "Lorg/jetbrains/kotlin/j2k/InspectionLikeProcessing;", "pointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiElement;", "priority", "", "<init>", "(Lorg/jetbrains/kotlin/j2k/InspectionLikeProcessing;Lcom/intellij/psi/SmartPsiElementPointer;I)V", "getProcessing", "()Lorg/jetbrains/kotlin/j2k/InspectionLikeProcessing;", "getPointer", "()Lcom/intellij/psi/SmartPsiElementPointer;", "getPriority", "()I", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "kotlin.j2k.shared"})
    private static final class ProcessingData {
        @NotNull
        private final InspectionLikeProcessing processing;
        @NotNull
        private final SmartPsiElementPointer<PsiElement> pointer;
        private final int priority;

        public ProcessingData(@NotNull InspectionLikeProcessing processing, @NotNull SmartPsiElementPointer<PsiElement> pointer, int priority) {
            Intrinsics.checkNotNullParameter((Object)processing, (String)"processing");
            Intrinsics.checkNotNullParameter(pointer, (String)"pointer");
            this.processing = processing;
            this.pointer = pointer;
            this.priority = priority;
        }

        @NotNull
        public final InspectionLikeProcessing getProcessing() {
            return this.processing;
        }

        @NotNull
        public final SmartPsiElementPointer<PsiElement> getPointer() {
            return this.pointer;
        }

        public final int getPriority() {
            return this.priority;
        }

        @NotNull
        public final InspectionLikeProcessing component1() {
            return this.processing;
        }

        @NotNull
        public final SmartPsiElementPointer<PsiElement> component2() {
            return this.pointer;
        }

        public final int component3() {
            return this.priority;
        }

        @NotNull
        public final ProcessingData copy(@NotNull InspectionLikeProcessing processing, @NotNull SmartPsiElementPointer<PsiElement> pointer, int priority) {
            Intrinsics.checkNotNullParameter((Object)processing, (String)"processing");
            Intrinsics.checkNotNullParameter(pointer, (String)"pointer");
            return new ProcessingData(processing, pointer, priority);
        }

        public static /* synthetic */ ProcessingData copy$default(ProcessingData processingData, InspectionLikeProcessing inspectionLikeProcessing, SmartPsiElementPointer smartPsiElementPointer, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                inspectionLikeProcessing = processingData.processing;
            }
            if ((n2 & 2) != 0) {
                smartPsiElementPointer = processingData.pointer;
            }
            if ((n2 & 4) != 0) {
                n = processingData.priority;
            }
            return processingData.copy(inspectionLikeProcessing, smartPsiElementPointer, n);
        }

        @NotNull
        public String toString() {
            return "ProcessingData(processing=" + this.processing + ", pointer=" + this.pointer + ", priority=" + this.priority + ")";
        }

        public int hashCode() {
            int result2 = this.processing.hashCode();
            result2 = result2 * 31 + this.pointer.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.priority);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProcessingData)) {
                return false;
            }
            ProcessingData processingData = (ProcessingData)other;
            if (!Intrinsics.areEqual((Object)this.processing, (Object)processingData.processing)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.pointer, processingData.pointer)) {
                return false;
            }
            return this.priority == processingData.priority;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/j2k/InspectionLikeProcessingGroup$RangeFilterResult;", "", "<init>", "(Ljava/lang/String;I)V", "SKIP", "GO_INSIDE", "PROCESS", "kotlin.j2k.shared"})
    private static final class RangeFilterResult
    extends Enum<RangeFilterResult> {
        public static final /* enum */ RangeFilterResult SKIP = new RangeFilterResult();
        public static final /* enum */ RangeFilterResult GO_INSIDE = new RangeFilterResult();
        public static final /* enum */ RangeFilterResult PROCESS = new RangeFilterResult();
        private static final /* synthetic */ RangeFilterResult[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static RangeFilterResult[] values() {
            return (RangeFilterResult[])$VALUES.clone();
        }

        public static RangeFilterResult valueOf(String value) {
            return Enum.valueOf(RangeFilterResult.class, value);
        }

        @NotNull
        public static EnumEntries<RangeFilterResult> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = rangeFilterResultArray = new RangeFilterResult[]{RangeFilterResult.SKIP, RangeFilterResult.GO_INSIDE, RangeFilterResult.PROCESS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

