/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.j2k.Converter;
import org.jetbrains.kotlin.j2k.Nullability;
import org.jetbrains.kotlin.j2k.TypeConverter;
import org.jetbrains.kotlin.j2k.TypeVisitorKt;
import org.jetbrains.kotlin.j2k.UtilsKt;
import org.jetbrains.kotlin.j2k.ast.ArrayType;
import org.jetbrains.kotlin.j2k.ast.ClassType;
import org.jetbrains.kotlin.j2k.ast.Element;
import org.jetbrains.kotlin.j2k.ast.ElementKt;
import org.jetbrains.kotlin.j2k.ast.ErrorType;
import org.jetbrains.kotlin.j2k.ast.Identifier;
import org.jetbrains.kotlin.j2k.ast.InProjectionType;
import org.jetbrains.kotlin.j2k.ast.Mutability;
import org.jetbrains.kotlin.j2k.ast.NullType;
import org.jetbrains.kotlin.j2k.ast.OutProjectionType;
import org.jetbrains.kotlin.j2k.ast.PrimitiveType;
import org.jetbrains.kotlin.j2k.ast.ReferenceElement;
import org.jetbrains.kotlin.j2k.ast.StarProjectionType;
import org.jetbrains.kotlin.j2k.ast.Type;
import org.jetbrains.kotlin.j2k.ast.UnitType;
import org.jetbrains.kotlin.j2k.ast.VarArgType;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\bH\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00022\u0006\u0010%\u001a\u00020&H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/j2k/TypeVisitor;", "Lcom/intellij/psi/PsiTypeVisitor;", "Lorg/jetbrains/kotlin/j2k/ast/Type;", "converter", "Lorg/jetbrains/kotlin/j2k/Converter;", "topLevelType", "Lcom/intellij/psi/PsiType;", "topLevelTypeMutability", "Lorg/jetbrains/kotlin/j2k/ast/Mutability;", "inAnnotationType", "", "<init>", "(Lorg/jetbrains/kotlin/j2k/Converter;Lcom/intellij/psi/PsiType;Lorg/jetbrains/kotlin/j2k/ast/Mutability;Z)V", "typeConverter", "Lorg/jetbrains/kotlin/j2k/TypeConverter;", "visitType", "Lorg/jetbrains/kotlin/j2k/ast/ErrorType;", "type", "visitPrimitiveType", "primitiveType", "Lcom/intellij/psi/PsiPrimitiveType;", "visitArrayType", "arrayType", "Lcom/intellij/psi/PsiArrayType;", "visitClassType", "classType", "Lcom/intellij/psi/PsiClassType;", "constructReferenceElement", "Lorg/jetbrains/kotlin/j2k/ast/ReferenceElement;", "mutability", "convertTypeArgs", "", "createTypeArgsForRawTypeUsage", "visitWildcardType", "wildcardType", "Lcom/intellij/psi/PsiWildcardType;", "visitEllipsisType", "ellipsisType", "Lcom/intellij/psi/PsiEllipsisType;", "kotlin.j2k.k1.old"})
@SourceDebugExtension(value={"SMAP\nTypeVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeVisitor.kt\norg/jetbrains/kotlin/j2k/TypeVisitor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,101:1\n11158#2:102\n11493#2,3:103\n*S KotlinDebug\n*F\n+ 1 TypeVisitor.kt\norg/jetbrains/kotlin/j2k/TypeVisitor\n*L\n83#1:102\n83#1:103,3\n*E\n"})
public final class TypeVisitor
extends PsiTypeVisitor<Type> {
    @NotNull
    private final Converter converter;
    @NotNull
    private final PsiType topLevelType;
    @NotNull
    private final Mutability topLevelTypeMutability;
    private final boolean inAnnotationType;
    @NotNull
    private final TypeConverter typeConverter;

    public TypeVisitor(@NotNull Converter converter, @NotNull PsiType topLevelType, @NotNull Mutability topLevelTypeMutability, boolean inAnnotationType) {
        Intrinsics.checkNotNullParameter((Object)converter, (String)"converter");
        Intrinsics.checkNotNullParameter((Object)topLevelType, (String)"topLevelType");
        Intrinsics.checkNotNullParameter((Object)((Object)topLevelTypeMutability), (String)"topLevelTypeMutability");
        this.converter = converter;
        this.topLevelType = topLevelType;
        this.topLevelTypeMutability = topLevelTypeMutability;
        this.inAnnotationType = inAnnotationType;
        this.typeConverter = this.converter.getTypeConverter();
    }

    @NotNull
    public ErrorType visitType(@NotNull PsiType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        return new ErrorType();
    }

    @NotNull
    public Type visitPrimitiveType(@NotNull PsiPrimitiveType primitiveType) {
        Type type2;
        Intrinsics.checkNotNullParameter((Object)primitiveType, (String)"primitiveType");
        String string = primitiveType.getCanonicalText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalText(...)");
        String name2 = string;
        if (Intrinsics.areEqual((Object)name2, (Object)"void")) {
            type2 = new UnitType();
        } else if (TypeVisitorKt.access$getPRIMITIVE_TYPES_NAMES$p().contains(name2)) {
            String string2 = StringUtil.capitalize((String)name2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"capitalize(...)");
            type2 = new PrimitiveType(Identifier.Companion.withNoPrototype$default(Identifier.Companion, string2, false, false, null, 14, null));
        } else {
            type2 = Intrinsics.areEqual((Object)name2, (Object)"null") ? (Type)new NullType() : (Type)new PrimitiveType(Identifier.Companion.withNoPrototype$default(Identifier.Companion, name2, false, false, null, 14, null));
        }
        return type2;
    }

    @NotNull
    public Type visitArrayType(@NotNull PsiArrayType arrayType) {
        Intrinsics.checkNotNullParameter((Object)arrayType, (String)"arrayType");
        return new ArrayType(TypeConverter.convertType$default(this.typeConverter, arrayType.getComponentType(), null, null, this.inAnnotationType, 6, null), Nullability.Default, this.converter.getSettings());
    }

    @NotNull
    public Type visitClassType(@NotNull PsiClassType classType) {
        Intrinsics.checkNotNullParameter((Object)classType, (String)"classType");
        Mutability mutability = classType == this.topLevelType ? this.topLevelTypeMutability : Mutability.Default;
        ReferenceElement refElement = this.constructReferenceElement(classType, mutability);
        return new ClassType(refElement, Nullability.Default, this.converter.getSettings());
    }

    private final ReferenceElement constructReferenceElement(PsiClassType classType, Mutability mutability) {
        List<Type> typeArgs = this.convertTypeArgs(classType);
        PsiClass psiClass = classType.resolve();
        if (psiClass != null) {
            String javaClassName = psiClass.getQualifiedName();
            Identifier identifier = UtilsKt.convertToKotlinAnalogIdentifier(this.converter, javaClassName, mutability);
            if (identifier != null) {
                Identifier it = identifier;
                boolean bl = false;
                return (ReferenceElement)ElementKt.assignNoPrototype((Element)new ReferenceElement(it, typeArgs));
            }
            if (this.inAnnotationType && Intrinsics.areEqual((Object)javaClassName, (Object)"java.lang.Class")) {
                FqName fqName2 = new FqName("kotlin.reflect.KClass");
                String string = fqName2.shortName().getIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdentifier(...)");
                Identifier identifier2 = Identifier.Companion.withNoPrototype$default(Identifier.Companion, string, false, false, CollectionsKt.listOf((Object)fqName2), 6, null);
                return (ReferenceElement)ElementKt.assignNoPrototype((Element)new ReferenceElement(identifier2, typeArgs));
            }
        }
        if (classType instanceof PsiClassReferenceType) {
            PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = ((PsiClassReferenceType)classType).getReference();
            Intrinsics.checkNotNullExpressionValue((Object)psiJavaCodeReferenceElement, (String)"getReference(...)");
            return this.converter.convertCodeReferenceElement(psiJavaCodeReferenceElement, false, typeArgs);
        }
        String string = classType.getClassName();
        if (string == null) {
            string = "";
        }
        return (ReferenceElement)ElementKt.assignNoPrototype((Element)new ReferenceElement(Identifier.Companion.withNoPrototype$default(Identifier.Companion, string, false, false, null, 14, null), typeArgs));
    }

    private final List<Type> convertTypeArgs(PsiClassType classType) {
        List<Type> list2;
        if (classType.getParameterCount() == 0) {
            list2 = this.createTypeArgsForRawTypeUsage(classType);
        } else {
            PsiType[] psiTypeArray = classType.getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray, (String)"getParameters(...)");
            list2 = this.typeConverter.convertTypes(psiTypeArray);
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Type> createTypeArgsForRawTypeUsage(PsiClassType classType) {
        if (classType instanceof PsiClassReferenceType) {
            PsiClass targetClass;
            PsiElement psiElement = ((PsiClassReferenceType)classType).getReference().resolve();
            PsiClass psiClass = targetClass = psiElement instanceof PsiClass ? (PsiClass)psiElement : null;
            if (targetClass != null) {
                void $this$mapTo$iv$iv;
                PsiTypeParameter[] psiTypeParameterArray = targetClass.getTypeParameters();
                Intrinsics.checkNotNullExpressionValue((Object)psiTypeParameterArray, (String)"getTypeParameters(...)");
                Object[] $this$map$iv = psiTypeParameterArray;
                boolean $i$f$map = false;
                Object[] objectArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (void item$iv$iv : $this$mapTo$iv$iv) {
                    PsiTypeParameter psiTypeParameter = (PsiTypeParameter)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((StarProjectionType)ElementKt.assignNoPrototype((Element)new StarProjectionType()));
                }
                return (List)destination$iv$iv;
            }
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public Type visitWildcardType(@NotNull PsiWildcardType wildcardType) {
        Intrinsics.checkNotNullParameter((Object)wildcardType, (String)"wildcardType");
        return wildcardType.isExtends() ? (Type)new OutProjectionType(TypeConverter.convertType$default(this.typeConverter, wildcardType.getExtendsBound(), null, null, false, 14, null)) : (wildcardType.isSuper() ? (Type)new InProjectionType(TypeConverter.convertType$default(this.typeConverter, wildcardType.getSuperBound(), null, null, false, 14, null)) : (Type)new StarProjectionType());
    }

    @NotNull
    public Type visitEllipsisType(@NotNull PsiEllipsisType ellipsisType) {
        Intrinsics.checkNotNullParameter((Object)ellipsisType, (String)"ellipsisType");
        return new VarArgType(TypeConverter.convertType$default(this.typeConverter, ellipsisType.getComponentType(), null, null, this.inAnnotationType, 6, null));
    }
}

