/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k.ast;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.j2k.CodeBuilder;
import org.jetbrains.kotlin.j2k.ast.Annotations;
import org.jetbrains.kotlin.j2k.ast.Block;
import org.jetbrains.kotlin.j2k.ast.DeferredElement;
import org.jetbrains.kotlin.j2k.ast.FunctionLike;
import org.jetbrains.kotlin.j2k.ast.Identifier;
import org.jetbrains.kotlin.j2k.ast.Modifier;
import org.jetbrains.kotlin.j2k.ast.ModifierKt;
import org.jetbrains.kotlin.j2k.ast.Modifiers;
import org.jetbrains.kotlin.j2k.ast.ParameterList;
import org.jetbrains.kotlin.j2k.ast.Type;
import org.jetbrains.kotlin.j2k.ast.TypeParameterList;
import org.jetbrains.kotlin.j2k.ast.TypesKt;
import org.jetbrains.kotlin.j2k.ast.UtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\b\u0010\u001d\u001a\u00020\u0007H\u0014J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/j2k/ast/Function;", "Lorg/jetbrains/kotlin/j2k/ast/FunctionLike;", "name", "Lorg/jetbrains/kotlin/j2k/ast/Identifier;", "annotations", "Lorg/jetbrains/kotlin/j2k/ast/Annotations;", "modifiers", "Lorg/jetbrains/kotlin/j2k/ast/Modifiers;", "returnType", "Lorg/jetbrains/kotlin/j2k/ast/Type;", "typeParameterList", "Lorg/jetbrains/kotlin/j2k/ast/TypeParameterList;", "parameterList", "Lorg/jetbrains/kotlin/j2k/ast/ParameterList;", "body", "Lorg/jetbrains/kotlin/j2k/ast/DeferredElement;", "Lorg/jetbrains/kotlin/j2k/ast/Block;", "isInInterface", "", "<init>", "(Lorg/jetbrains/kotlin/j2k/ast/Identifier;Lorg/jetbrains/kotlin/j2k/ast/Annotations;Lorg/jetbrains/kotlin/j2k/ast/Modifiers;Lorg/jetbrains/kotlin/j2k/ast/Type;Lorg/jetbrains/kotlin/j2k/ast/TypeParameterList;Lorg/jetbrains/kotlin/j2k/ast/ParameterList;Lorg/jetbrains/kotlin/j2k/ast/DeferredElement;Z)V", "getName", "()Lorg/jetbrains/kotlin/j2k/ast/Identifier;", "getReturnType", "()Lorg/jetbrains/kotlin/j2k/ast/Type;", "getTypeParameterList", "()Lorg/jetbrains/kotlin/j2k/ast/TypeParameterList;", "getParameterList", "()Lorg/jetbrains/kotlin/j2k/ast/ParameterList;", "presentationModifiers", "generateCode", "", "builder", "Lorg/jetbrains/kotlin/j2k/CodeBuilder;", "kotlin.j2k.k1.old"})
public final class Function
extends FunctionLike {
    @NotNull
    private final Identifier name;
    @NotNull
    private final Type returnType;
    @NotNull
    private final TypeParameterList typeParameterList;
    private final boolean isInInterface;

    public Function(@NotNull Identifier name2, @NotNull Annotations annotations2, @NotNull Modifiers modifiers, @NotNull Type returnType, @NotNull TypeParameterList typeParameterList, @NotNull ParameterList parameterList, @Nullable DeferredElement<Block> body2, boolean isInInterface) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)annotations2, (String)"annotations");
        Intrinsics.checkNotNullParameter((Object)modifiers, (String)"modifiers");
        Intrinsics.checkNotNullParameter((Object)returnType, (String)"returnType");
        Intrinsics.checkNotNullParameter((Object)typeParameterList, (String)"typeParameterList");
        Intrinsics.checkNotNullParameter((Object)parameterList, (String)"parameterList");
        super(annotations2, modifiers, parameterList, body2);
        this.name = name2;
        this.returnType = returnType;
        this.typeParameterList = typeParameterList;
        this.isInInterface = isInInterface;
    }

    @NotNull
    public final Identifier getName() {
        return this.name;
    }

    @NotNull
    public final Type getReturnType() {
        return this.returnType;
    }

    @NotNull
    public final TypeParameterList getTypeParameterList() {
        return this.typeParameterList;
    }

    @Override
    @NotNull
    public ParameterList getParameterList() {
        ParameterList parameterList = super.getParameterList();
        Intrinsics.checkNotNull((Object)parameterList);
        return parameterList;
    }

    @Override
    @NotNull
    protected Modifiers presentationModifiers() {
        Modifiers modifiers = this.getModifiers();
        if (this.isInInterface) {
            modifiers = modifiers.without(Modifier.ABSTRACT);
        }
        if (modifiers.contains(Modifier.OVERRIDE)) {
            modifiers = ModifierKt.filter(modifiers, (Function1<? super Modifier, Boolean>)((Function1)Function::presentationModifiers$lambda$0));
        }
        return modifiers;
    }

    @Override
    public void generateCode(@NotNull CodeBuilder builder2) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        UtilKt.appendWithSuffix(ModifierKt.appendWithSpaceAfter(builder2.append(this.getAnnotations()), this.presentationModifiers()).append("fun "), this.typeParameterList, " ").append(this.name).append(this.getParameterList());
        if (!TypesKt.isUnit(this.returnType)) {
            builder2.append(":").append(this.returnType);
        }
        this.typeParameterList.appendWhere(builder2);
        if (this.getBody() != null) {
            builder2.append(" ").append(this.getBody());
        }
    }

    private static final boolean presentationModifiers$lambda$0(Modifier it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return it != Modifier.OPEN;
    }
}

