/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k.usageProcessing;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.j2k.AccessorKind;
import org.jetbrains.kotlin.j2k.usageProcessing.ExternalCodeProcessor;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\fJ1\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t*\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u0012J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0002J\u001a\u0010\u0015\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/j2k/usageProcessing/UseAccessorsJavaCodeProcessor;", "Lorg/jetbrains/kotlin/j2k/usageProcessing/ExternalCodeProcessor;", "factory", "Lcom/intellij/psi/PsiElementFactory;", "propertyName", "", "<init>", "(Lcom/intellij/psi/PsiElementFactory;Ljava/lang/String;)V", "processUsage", "", "Lcom/intellij/psi/PsiReference;", "reference", "(Lcom/intellij/psi/PsiReference;)[Lcom/intellij/psi/PsiReference;", "replaceWithModificationCalls", "Lcom/intellij/psi/PsiExpression;", "qualifier", "op", "value", "(Lcom/intellij/psi/PsiExpression;Lcom/intellij/psi/PsiExpression;Ljava/lang/String;Lcom/intellij/psi/PsiExpression;)[Lcom/intellij/psi/PsiReference;", "generateGetterCall", "Lcom/intellij/psi/PsiMethodCallExpression;", "generateSetterCall", "accessorName", "kind", "Lorg/jetbrains/kotlin/j2k/AccessorKind;", "kotlin.j2k.k1.old"})
public final class UseAccessorsJavaCodeProcessor
implements ExternalCodeProcessor {
    @NotNull
    private final PsiElementFactory factory;
    @NotNull
    private final String propertyName;

    public UseAccessorsJavaCodeProcessor(@NotNull PsiElementFactory factory2, @NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)factory2, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        this.factory = factory2;
        this.propertyName = propertyName;
    }

    @Override
    @Nullable
    public PsiReference[] processUsage(@NotNull PsiReference reference2) {
        Intrinsics.checkNotNullParameter((Object)reference2, (String)"reference");
        PsiElement psiElement = reference2.getElement();
        PsiReferenceExpression psiReferenceExpression = psiElement instanceof PsiReferenceExpression ? (PsiReferenceExpression)psiElement : null;
        if (psiReferenceExpression == null) {
            return null;
        }
        PsiReferenceExpression refExpr = psiReferenceExpression;
        PsiExpression qualifier2 = refExpr.getQualifierExpression();
        PsiElement parent2 = refExpr.getParent();
        if (parent2 instanceof PsiAssignmentExpression) {
            if (Intrinsics.areEqual((Object)refExpr, (Object)((PsiAssignmentExpression)parent2).getLExpression())) {
                if (Intrinsics.areEqual((Object)((PsiAssignmentExpression)parent2).getOperationTokenType(), (Object)JavaTokenType.EQ)) {
                    PsiExpression psiExpression = ((PsiAssignmentExpression)parent2).getRExpression();
                    if (psiExpression == null) {
                        return null;
                    }
                    PsiElement psiElement2 = ((PsiAssignmentExpression)parent2).replace((PsiElement)this.generateSetterCall(qualifier2, psiExpression));
                    Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type com.intellij.psi.PsiMethodCallExpression");
                    PsiMethodCallExpression callExpr = (PsiMethodCallExpression)psiElement2;
                    PsiReference[] psiReferenceArray = new PsiReference[]{callExpr.getMethodExpression()};
                    return psiReferenceArray;
                }
                String assignmentOpText = ((PsiAssignmentExpression)parent2).getOperationSign().getText();
                Intrinsics.checkNotNull((Object)assignmentOpText);
                boolean bl = StringsKt.endsWith$default((String)assignmentOpText, (String)"=", (boolean)false, (int)2, null);
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                String string = assignmentOpText.substring(0, assignmentOpText.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String opText = string;
                PsiExpression psiExpression = ((PsiAssignmentExpression)parent2).getRExpression();
                if (psiExpression == null) {
                    return null;
                }
                return this.replaceWithModificationCalls((PsiExpression)parent2, qualifier2, opText, psiExpression);
            }
        } else if (parent2 instanceof PsiPrefixExpression || parent2 instanceof PsiPostfixExpression) {
            String opText;
            PsiPrefixExpression operationType;
            PsiElement psiElement3 = parent2;
            PsiPrefixExpression psiPrefixExpression = psiElement3 instanceof PsiPrefixExpression ? (PsiPrefixExpression)psiElement3 : null;
            if (psiPrefixExpression == null || (psiPrefixExpression = psiPrefixExpression.getOperationTokenType()) == null) {
                IElementType iElementType = ((PsiPostfixExpression)parent2).getOperationTokenType();
                psiPrefixExpression = iElementType;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getOperationTokenType(...)");
            }
            String string = Intrinsics.areEqual((Object)(psiElement3 = (operationType = psiPrefixExpression)), (Object)JavaTokenType.PLUSPLUS) ? "+" : (opText = Intrinsics.areEqual((Object)psiElement3, (Object)JavaTokenType.MINUSMINUS) ? "-" : null);
            if (opText != null) {
                PsiExpression psiExpression = (PsiExpression)parent2;
                PsiExpression psiExpression2 = this.factory.createExpressionFromText("1", null);
                Intrinsics.checkNotNullExpressionValue((Object)psiExpression2, (String)"createExpressionFromText(...)");
                return this.replaceWithModificationCalls(psiExpression, qualifier2, opText, psiExpression2);
            }
        }
        PsiElement psiElement4 = refExpr.replace((PsiElement)this.generateGetterCall(qualifier2));
        Intrinsics.checkNotNull((Object)psiElement4, (String)"null cannot be cast to non-null type com.intellij.psi.PsiMethodCallExpression");
        PsiMethodCallExpression callExpr = (PsiMethodCallExpression)psiElement4;
        PsiReference[] psiReferenceArray = new PsiReference[]{callExpr.getMethodExpression()};
        return psiReferenceArray;
    }

    private final PsiReference[] replaceWithModificationCalls(PsiExpression $this$replaceWithModificationCalls, PsiExpression qualifier2, String op, PsiExpression value) {
        PsiMethodCallExpression getCall = this.generateGetterCall(qualifier2);
        PsiExpression psiExpression = this.factory.createExpressionFromText("x " + op + " y", null);
        Intrinsics.checkNotNull((Object)psiExpression, (String)"null cannot be cast to non-null type com.intellij.psi.PsiBinaryExpression");
        PsiBinaryExpression binary = (PsiBinaryExpression)psiExpression;
        binary.getLOperand().replace((PsiElement)getCall);
        PsiExpression psiExpression2 = binary.getROperand();
        Intrinsics.checkNotNull((Object)psiExpression2);
        psiExpression2.replace((PsiElement)value);
        PsiExpression psiExpression3 = this.generateSetterCall(qualifier2, (PsiExpression)binary);
        Intrinsics.checkNotNull((Object)psiExpression3, (String)"null cannot be cast to non-null type com.intellij.psi.PsiMethodCallExpression");
        PsiMethodCallExpression setCall = (PsiMethodCallExpression)psiExpression3;
        PsiElement psiElement = $this$replaceWithModificationCalls.replace((PsiElement)setCall);
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.PsiMethodCallExpression");
        setCall = (PsiMethodCallExpression)psiElement;
        PsiExpression[] psiExpressionArray = setCall.getArgumentList().getExpressions();
        Intrinsics.checkNotNullExpressionValue((Object)psiExpressionArray, (String)"getExpressions(...)");
        Object object = ArraysKt.single((Object[])psiExpressionArray);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.psi.PsiBinaryExpression");
        binary = (PsiBinaryExpression)object;
        PsiExpression psiExpression4 = binary.getLOperand();
        Intrinsics.checkNotNull((Object)psiExpression4, (String)"null cannot be cast to non-null type com.intellij.psi.PsiMethodCallExpression");
        getCall = (PsiMethodCallExpression)psiExpression4;
        PsiReference[] psiReferenceArray = new PsiReference[]{getCall.getMethodExpression(), setCall.getMethodExpression()};
        return psiReferenceArray;
    }

    private final PsiMethodCallExpression generateGetterCall(PsiExpression qualifier2) {
        String text = this.accessorName(AccessorKind.GETTER) + "()";
        String expressionText = qualifier2 != null ? qualifier2.getText() + "." + text : text;
        PsiExpression psiExpression = this.factory.createExpressionFromText(expressionText, null);
        Intrinsics.checkNotNull((Object)psiExpression, (String)"null cannot be cast to non-null type com.intellij.psi.PsiMethodCallExpression");
        return (PsiMethodCallExpression)psiExpression;
    }

    private final PsiExpression generateSetterCall(PsiExpression qualifier2, PsiExpression value) {
        String text = this.accessorName(AccessorKind.SETTER) + "(" + value.getText() + ")";
        String expressionText = qualifier2 != null ? qualifier2.getText() + "." + text : text;
        PsiExpression psiExpression = this.factory.createExpressionFromText(expressionText, null);
        Intrinsics.checkNotNullExpressionValue((Object)psiExpression, (String)"createExpressionFromText(...)");
        return psiExpression;
    }

    private final String accessorName(AccessorKind kind2) {
        return (kind2 == AccessorKind.GETTER ? "get" : "set") + CapitalizeDecapitalizeKt.capitalizeAsciiOnly((String)this.propertyName);
    }
}

