/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k.symbols;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.idea.base.psi.JavaPsiUtils;
import org.jetbrains.kotlin.j2k.Nullability;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.nj2k.JKSymbolProvider;
import org.jetbrains.kotlin.nj2k.symbols.JKClassSymbol;
import org.jetbrains.kotlin.nj2k.symbols.JKMethodSymbol;
import org.jetbrains.kotlin.nj2k.symbols.JKMultiverseSymbol;
import org.jetbrains.kotlin.nj2k.symbols.JKSymbol;
import org.jetbrains.kotlin.nj2k.types.JKClassType;
import org.jetbrains.kotlin.nj2k.types.JKType;
import org.jetbrains.kotlin.nj2k.types.JKTypeFactory;
import org.jetbrains.kotlin.nj2k.types.TypesUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e8VX\u0096\u0004b\u00020\u000f\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00138VX\u0096\u0004b\u00020\u000f\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0016\u001a\u00020\u000e8VX\u0096\u0004b\u00020\u000f\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/nj2k/symbols/JKMultiverseMethodSymbol;", "Lorg/jetbrains/kotlin/nj2k/symbols/JKMethodSymbol;", "Lorg/jetbrains/kotlin/nj2k/symbols/JKMultiverseSymbol;", "Lcom/intellij/psi/PsiMethod;", "target", "typeFactory", "Lorg/jetbrains/kotlin/nj2k/types/JKTypeFactory;", "<init>", "(Lcom/intellij/psi/PsiMethod;Lorg/jetbrains/kotlin/nj2k/types/JKTypeFactory;)V", "getTarget", "()Lcom/intellij/psi/PsiMethod;", "getTypeFactory", "()Lorg/jetbrains/kotlin/nj2k/types/JKTypeFactory;", "receiverType", "Lorg/jetbrains/kotlin/nj2k/types/JKType;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "getReceiverType", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;)Lorg/jetbrains/kotlin/nj2k/types/JKType;", "parameterTypes", "", "getParameterTypes", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;)Ljava/util/List;", "returnType", "getReturnType", "fqName", "", "getFqName", "()Ljava/lang/String;", "kotlin.j2k.shared"})
@SourceDebugExtension(value={"SMAP\nJKMethodSymbol.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JKMethodSymbol.kt\norg/jetbrains/kotlin/nj2k/symbols/JKMultiverseMethodSymbol\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,135:1\n11158#2:136\n11493#2,3:137\n1#3:140\n*S KotlinDebug\n*F\n+ 1 JKMethodSymbol.kt\norg/jetbrains/kotlin/nj2k/symbols/JKMultiverseMethodSymbol\n*L\n60#1:136\n60#1:137,3\n*E\n"})
public final class JKMultiverseMethodSymbol
extends JKMethodSymbol
implements JKMultiverseSymbol<PsiMethod> {
    @NotNull
    private final PsiMethod target;
    @NotNull
    private final JKTypeFactory typeFactory;

    public JKMultiverseMethodSymbol(@NotNull PsiMethod target, @NotNull JKTypeFactory typeFactory) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)typeFactory, (String)"typeFactory");
        super(null);
        this.target = target;
        this.typeFactory = typeFactory;
    }

    @Override
    @NotNull
    public PsiMethod getTarget() {
        return this.target;
    }

    @Override
    @NotNull
    public JKTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    @Override
    @Nullable
    public JKType getReceiverType(@NotNull KaSession $context_receiver_0) {
        JKClassType jKClassType;
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        PsiClass psiClass = this.getTarget().getContainingClass();
        if (psiClass != null) {
            PsiClass it = psiClass;
            boolean bl = false;
            JKSymbol jKSymbol = this.getSymbolProvider().provideDirectSymbol((PsiElement)it);
            Intrinsics.checkNotNull((Object)jKSymbol, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.nj2k.symbols.JKClassSymbol");
            jKClassType = new JKClassType((JKClassSymbol)jKSymbol, null, null, 6, null);
        } else {
            jKClassType = null;
        }
        return jKClassType;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<JKType> getParameterTypes(@NotNull KaSession $context_receiver_0) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        PsiParameter[] psiParameterArray = this.getTarget().getParameterList().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
        Object[] $this$map$iv = psiParameterArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiParameter psiParameter = (PsiParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            JKTypeFactory jKTypeFactory = this.getTypeFactory();
            PsiType psiType = it.getType();
            Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getType(...)");
            collection.add(jKTypeFactory.fromPsiType(psiType));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public JKType getReturnType(@NotNull KaSession $context_receiver_0) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
                object = this.getTarget().getReturnType();
                if (object == null) break block2;
                PsiType it = object;
                boolean bl = false;
                JKType jKType = this.getTypeFactory().fromPsiType(it);
                object = jKType;
                if (jKType != null) break block3;
            }
            JKSymbolProvider jKSymbolProvider = this.getSymbolProvider();
            FqName fqName2 = JavaPsiUtils.getKotlinFqName((PsiElement)this.getTarget());
            Intrinsics.checkNotNull((Object)fqName2);
            object = TypesUtilsKt.asType(jKSymbolProvider.provideClassSymbol(fqName2), Nullability.NotNull);
        }
        return object;
    }

    @Override
    @NotNull
    public String getFqName() {
        String kotlinFqName = JKMultiverseSymbol.super.getFqName();
        return this.getTarget() instanceof KtLightMethod ? kotlinFqName + "." + this.getName() : kotlinFqName;
    }
}

