/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.CustomTaskState;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.impl.BaseRepositoryImpl;
import com.intellij.tasks.impl.gson.TaskGsonUtil;
import com.intellij.tasks.jira.JiraRemoteApi;
import com.intellij.tasks.jira.JiraRepositoryType;
import com.intellij.tasks.jira.rest.JiraRestApi;
import com.intellij.tasks.jira.rest.api2.JiraRestApi2;
import com.intellij.tasks.jira.rest.api3.JiraRestApiCloud3;
import com.intellij.tasks.jira.soap.JiraLegacyApi;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.xmlrpc.CommonsXmlRpcTransport;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="JIRA")
public final class JiraRepository
extends BaseRepositoryImpl {
    public static final Gson GSON = TaskGsonUtil.createDefaultBuilder().create();
    private static final Logger LOG = Logger.getInstance(JiraRepository.class);
    public static final String REST_API_PATH = "/rest/api/latest";
    private static final boolean LEGACY_API_ONLY = Boolean.getBoolean("tasks.jira.legacy.api.only");
    private static final boolean BASIC_AUTH_ONLY = Boolean.getBoolean("tasks.jira.basic.auth.only");
    private static final boolean REDISCOVER_API = Boolean.getBoolean("tasks.jira.rediscover.api");
    public static final Pattern JIRA_ID_PATTERN = Pattern.compile("\\p{javaUpperCase}+-\\d+");
    public static final String AUTH_COOKIE_NAME = "JSESSIONID";
    private String mySearchQuery = TaskBundle.message((String)"jira.default.query", (Object[])new Object[0]);
    private JiraRemoteApi myApiVersion;
    private String myJiraVersion;
    private boolean myInCloud = false;
    private boolean myUseBearerTokenAuthentication;

    public JiraRepository() {
        this.setUseHttpAuthentication(true);
    }

    public JiraRepository(JiraRepositoryType type) {
        super(type);
        this.setUseHttpAuthentication(true);
    }

    private JiraRepository(JiraRepository other) {
        super(other);
        this.mySearchQuery = other.mySearchQuery;
        this.myJiraVersion = other.myJiraVersion;
        this.myInCloud = other.myInCloud;
        this.myUseBearerTokenAuthentication = other.myUseBearerTokenAuthentication;
        if (other.myApiVersion != null) {
            this.myApiVersion = other.myApiVersion.getType().createApi(this);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof JiraRepository)) {
            return false;
        }
        JiraRepository repository = (JiraRepository)((Object)o);
        if (!Objects.equals(this.mySearchQuery, repository.getSearchQuery())) {
            return false;
        }
        if (!Objects.equals(this.myJiraVersion, repository.getJiraVersion())) {
            return false;
        }
        if (!Comparing.equal((Object)this.myInCloud, (Object)repository.isInCloud())) {
            return false;
        }
        return Comparing.equal((Object)this.myUseBearerTokenAuthentication, (Object)repository.isUseBearerTokenAuthentication());
    }

    @Override
    @NotNull
    public JiraRepository clone() {
        return new JiraRepository(this);
    }

    public Task[] getIssues(@Nullable String query, int max, long since) throws Exception {
        Task task;
        this.ensureApiVersionDiscovered();
        Object resultQuery = StringUtil.notNullize((String)query);
        if (this.isJqlSupported()) {
            resultQuery = StringUtil.isNotEmpty((String)this.mySearchQuery) && StringUtil.isNotEmpty((String)query) ? String.format("summary ~ '%s' and ", query) + this.mySearchQuery : (StringUtil.isNotEmpty((String)query) ? String.format("summary ~ '%s'", query) : this.mySearchQuery);
        }
        List tasksFound = this.myApiVersion.findTasks((String)resultQuery, max);
        if (query != null && JIRA_ID_PATTERN.matcher(query.trim()).matches() && (task = this.findTask(query)) != null) {
            tasksFound = ContainerUtil.append(tasksFound, (Object[])new Task[]{task});
        }
        return tasksFound.toArray(Task.EMPTY_ARRAY);
    }

    @Nullable
    public Task findTask(@NotNull String id) throws Exception {
        if (id == null) {
            JiraRepository.$$$reportNull$$$0(0);
        }
        this.ensureApiVersionDiscovered();
        return this.myApiVersion.findTask(id);
    }

    public void updateTimeSpent(@NotNull LocalTask task, @NotNull String timeSpent, @NotNull String comment) throws Exception {
        if (task == null) {
            JiraRepository.$$$reportNull$$$0(1);
        }
        if (timeSpent == null) {
            JiraRepository.$$$reportNull$$$0(2);
        }
        if (comment == null) {
            JiraRepository.$$$reportNull$$$0(3);
        }
        this.myApiVersion.updateTimeSpend(task, timeSpent, comment);
    }

    @Nullable
    public TaskRepository.CancellableConnection createCancellableConnection() {
        this.clearCookies();
        return new TaskRepository.CancellableConnection(){

            protected void doTest() throws Exception {
                JiraRepository.this.ensureApiVersionDiscovered();
                JiraRepository.this.myApiVersion.findTasks(JiraRepository.this.mySearchQuery, 1);
            }

            public void cancel() {
            }
        };
    }

    @NotNull
    public JiraRemoteApi discoverApiVersion() throws Exception {
        String providedRestApiVersion;
        String responseBody;
        if (LEGACY_API_ONLY) {
            LOG.info("Intentionally using only legacy JIRA API");
            JiraLegacyApi jiraLegacyApi = this.createLegacyApi();
            if (jiraLegacyApi == null) {
                JiraRepository.$$$reportNull$$$0(4);
            }
            return jiraLegacyApi;
        }
        GetMethod method = new GetMethod(this.getRestUrl("serverInfo"));
        try {
            responseBody = this.executeMethod(method);
        }
        catch (Exception e) {
            StatusLine status = method.getStatusLine();
            if (status != null && status.getStatusCode() == 404) {
                JiraLegacyApi jiraLegacyApi = this.createLegacyApi();
                if (jiraLegacyApi == null) {
                    JiraRepository.$$$reportNull$$$0(5);
                }
                return jiraLegacyApi;
            }
            throw e;
        }
        JsonObject serverInfo = (JsonObject)GSON.fromJson(responseBody, JsonObject.class);
        this.myJiraVersion = serverInfo.get("version").getAsString();
        this.myInCloud = JiraRepository.isHostedInCloud(serverInfo);
        LOG.info("JIRA version (from serverInfo): " + this.getPresentableVersion());
        if (this.isInCloud()) {
            LOG.info("Connecting to JIRA Cloud. Cookie authentication is enabled unless 'tasks.jira.basic.auth.only' VM flag is used.");
        }
        if ("3".equals(providedRestApiVersion = Registry.stringValue((String)"tasks.jira.use.rest.api.version"))) {
            return new JiraRestApiCloud3(this);
        }
        if ("2".equals(providedRestApiVersion)) {
            return new JiraRestApi2(this);
        }
        JiraRestApi restApi = JiraRestApi.fromJiraVersion(this.myJiraVersion, this);
        if (restApi == null) {
            throw new Exception(TaskBundle.message((String)"jira.failure.no.REST", (Object[])new Object[0]));
        }
        JiraRestApi jiraRestApi = restApi;
        if (jiraRestApi == null) {
            JiraRepository.$$$reportNull$$$0(6);
        }
        return jiraRestApi;
    }

    private static boolean isHostedInCloud(@NotNull JsonObject serverInfo) {
        JsonElement deploymentType;
        if (serverInfo == null) {
            JiraRepository.$$$reportNull$$$0(7);
        }
        if ((deploymentType = serverInfo.get("deploymentType")) != null) {
            return deploymentType.getAsString().equals("Cloud");
        }
        boolean atlassianSubDomain = JiraRepository.isAtlassianNetSubDomain(serverInfo.get("baseUrl").getAsString());
        if (atlassianSubDomain) {
            return true;
        }
        return serverInfo.get("version").getAsString().contains("OD");
    }

    private static boolean isAtlassianNetSubDomain(@NotNull String url) {
        if (url == null) {
            JiraRepository.$$$reportNull$$$0(8);
        }
        return JiraRepository.hostEndsWith(url, ".atlassian.net");
    }

    private static boolean hostEndsWith(@NotNull String url, @NotNull String suffix) {
        if (url == null) {
            JiraRepository.$$$reportNull$$$0(9);
        }
        if (suffix == null) {
            JiraRepository.$$$reportNull$$$0(10);
        }
        try {
            URL parsed = new URL(url);
            return parsed.getHost().endsWith(suffix);
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    private JiraLegacyApi createLegacyApi() {
        try {
            XmlRpcClient client = new XmlRpcClient(this.getUrl());
            Vector<String> parameters = new Vector<String>(Collections.singletonList(""));
            XmlRpcRequest request = new XmlRpcRequest("jira1.getServerInfo", parameters);
            Hashtable response = (Hashtable)client.execute(request, new CommonsXmlRpcTransport(new URL(this.getUrl()), this.getHttpClient()));
            if (response != null) {
                this.myJiraVersion = (String)response.get("version");
            }
        }
        catch (Exception e) {
            LOG.error("Cannot find out JIRA version via XML-RPC", (Throwable)e);
        }
        return new JiraLegacyApi(this);
    }

    private void ensureApiVersionDiscovered() throws Exception {
        if (this.myApiVersion == null || LEGACY_API_ONLY || REDISCOVER_API) {
            this.myApiVersion = this.discoverApiVersion();
        }
    }

    @NotNull
    public String executeMethod(@NotNull HttpMethod method) throws Exception {
        JsonObject object;
        Header header;
        if (method == null) {
            JiraRepository.$$$reportNull$$$0(11);
        }
        LOG.debug("URI: " + String.valueOf(method.getURI()));
        HttpClient client = this.getHttpClient();
        if (BASIC_AUTH_ONLY) {
            this.setUseHttpAuthentication(true);
        } else if (!this.isInCloud()) {
            if (this.isUseBearerTokenAuthentication()) {
                this.setUseHttpAuthentication(false);
                method.addRequestHeader(new Header("Authorization", "Bearer " + this.getPassword()));
            } else {
                this.setUseHttpAuthentication(true);
            }
        } else {
            boolean enableBasicAuthentication;
            boolean bl = enableBasicAuthentication = !this.isRestApiSupported() || !JiraRepository.containsCookie(client, AUTH_COOKIE_NAME);
            if (enableBasicAuthentication != this.isUseHttpAuthentication()) {
                LOG.info("Basic authentication for subsequent requests was " + (enableBasicAuthentication ? "enabled" : "disabled"));
            }
            this.setUseHttpAuthentication(enableBasicAuthentication);
        }
        int statusCode = client.executeMethod(method);
        LOG.debug("Status code: " + statusCode);
        InputStream stream = method.getResponseBodyAsStream();
        String entityContent = "";
        if (stream != null) {
            try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                entityContent = StreamUtil.readText((Reader)reader);
            }
        }
        if (statusCode >= 200 && statusCode < 300) {
            String string = entityContent;
            if (string == null) {
                JiraRepository.$$$reportNull$$$0(12);
            }
            return string;
        }
        this.clearCookies();
        if (method.getResponseHeader("Content-Type") != null && (header = method.getResponseHeader("Content-Type")).getValue().startsWith("application/json") && (object = (JsonObject)GSON.fromJson(entityContent, JsonObject.class)).has("errorMessages")) {
            String reason = StringUtil.join((Iterable)object.getAsJsonArray("errorMessages"), (String)" ");
            LOG.warn(reason);
            if (statusCode == 400 && reason.contains("cannot be viewed by anonymous users")) {
                throw new Exception(this.isInCloud() ? TaskBundle.message((String)"jira.failure.email.address", (Object[])new Object[0]) : TaskBundle.message((String)"failure.login", (Object[])new Object[0]));
            }
            throw new Exception(TaskBundle.message((String)"failure.server.message", (Object[])new Object[]{reason}));
        }
        if (method.getResponseHeader("X-Authentication-Denied-Reason") != null && (header = method.getResponseHeader("X-Authentication-Denied-Reason")).getValue().startsWith("CAPTCHA_CHALLENGE")) {
            throw new Exception(TaskBundle.message((String)"jira.failure.captcha", (Object[])new Object[0]));
        }
        if (statusCode == 401) {
            throw new Exception(TaskBundle.message((String)"failure.login", (Object[])new Object[0]));
        }
        String statusText = HttpStatus.getStatusText(method.getStatusCode());
        throw new Exception(TaskBundle.message((String)"failure.http.error", (Object[])new Object[]{statusCode, statusText}));
    }

    public boolean isInCloud() {
        return this.myInCloud;
    }

    public boolean isUseBearerTokenAuthentication() {
        return this.myUseBearerTokenAuthentication;
    }

    public void setUseBearerTokenAuthentication(boolean useBearerTokenAuthentication) {
        if (useBearerTokenAuthentication != this.isUseBearerTokenAuthentication()) {
            this.myUseBearerTokenAuthentication = useBearerTokenAuthentication;
            this.reconfigureClient();
        }
    }

    @NotNull
    String getPresentableVersion() {
        String string = StringUtil.notNullize((String)this.myJiraVersion, (String)"unknown") + (this.myInCloud ? " (Cloud)" : "");
        if (string == null) {
            JiraRepository.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static boolean containsCookie(@NotNull HttpClient client, @NotNull String cookieName) {
        if (client == null) {
            JiraRepository.$$$reportNull$$$0(14);
        }
        if (cookieName == null) {
            JiraRepository.$$$reportNull$$$0(15);
        }
        for (Cookie cookie : client.getState().getCookies()) {
            if (!cookie.getName().equals(cookieName) || cookie.isExpired()) continue;
            return true;
        }
        return false;
    }

    private void clearCookies() {
        this.getHttpClient().getState().clearCookies();
    }

    @Override
    public HttpClient getHttpClient() {
        return super.getHttpClient();
    }

    @Override
    protected void configureHttpClient(HttpClient client) {
        super.configureHttpClient(client);
        if (this.isUseBearerTokenAuthentication()) {
            client.getParams().setAuthenticationPreemptive(true);
            client.getState().clearCredentials();
        }
        client.getParams().setCookiePolicy("compatibility");
    }

    protected int getFeatures() {
        int features = super.getFeatures();
        if (this.isRestApiSupported()) {
            return features | 4 | 8;
        }
        return features & 0xFFFFFFEF & 0xFFFFFFF7 & 0xFFFFFFFB;
    }

    private boolean isRestApiSupported() {
        return this.myApiVersion == null || this.myApiVersion.getType() != JiraRemoteApi.ApiType.LEGACY;
    }

    public boolean isJqlSupported() {
        return this.isRestApiSupported();
    }

    public String getSearchQuery() {
        return this.mySearchQuery;
    }

    public void setTaskState(@NotNull Task task, @NotNull CustomTaskState state) throws Exception {
        if (task == null) {
            JiraRepository.$$$reportNull$$$0(16);
        }
        if (state == null) {
            JiraRepository.$$$reportNull$$$0(17);
        }
        this.myApiVersion.setTaskState(task, state);
    }

    @NotNull
    public Set<CustomTaskState> getAvailableTaskStates(@NotNull Task task) throws Exception {
        if (task == null) {
            JiraRepository.$$$reportNull$$$0(18);
        }
        Set<CustomTaskState> set = this.myApiVersion.getAvailableTaskStates(task);
        if (set == null) {
            JiraRepository.$$$reportNull$$$0(19);
        }
        return set;
    }

    public void setSearchQuery(String searchQuery) {
        this.mySearchQuery = searchQuery;
    }

    @Override
    public void setUrl(String url) {
        String oldUrl = this.getUrl();
        super.setUrl(url);
        if (!this.getUrl().equals(oldUrl)) {
            this.myApiVersion = null;
            this.myInCloud = JiraRepository.isAtlassianNetSubDomain(this.getUrl());
        }
    }

    @Nullable
    public String getJiraVersion() {
        return this.myJiraVersion;
    }

    public void setJiraVersion(@Nullable String jiraVersion) {
        this.myJiraVersion = jiraVersion;
    }

    public String getRestUrl(String ... parts) {
        return this.getUrl() + "/rest/api/latest/" + StringUtil.join((String[])parts, (String)"/");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 12, 13, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeSpent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/jira/JiraRepository";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverInfo";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cookieName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/jira/JiraRepository";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "discoverApiVersion";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "executeMethod";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableVersion";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableTaskStates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findTask";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateTimeSpent";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 19: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isHostedInCloud";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAtlassianNetSubDomain";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hostEndsWith";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "executeMethod";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "containsCookie";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setTaskState";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableTaskStates";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 12, 13, 19 -> new IllegalStateException(string);
        };
    }
}

