/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.compiler.plugins.kotlin.inference;

import androidx.compose.compiler.plugins.kotlin.inference.ItemKind;
import androidx.compose.compiler.plugins.kotlin.inference.SchemeKt;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u0007J\u0006\u0010\u000f\u001a\u00020\u0003J\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Landroidx/compose/compiler/plugins/kotlin/inference/SchemeStringSerializationReader;", "", "value", "", "<init>", "(Ljava/lang/String;)V", "current", "", "kind", "Landroidx/compose/compiler/plugins/kotlin/inference/ItemKind;", "getKind", "()Landroidx/compose/compiler/plugins/kotlin/inference/ItemKind;", "end", "", "number", "token", "expect", "ch", "", "getCh", "()C", "kotlin-compose-compiler-plugin"})
@SourceDebugExtension(value={"SMAP\nScheme.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Scheme.kt\nandroidx/compose/compiler/plugins/kotlin/inference/SchemeStringSerializationReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,460:1\n1#2:461\n*E\n"})
final class SchemeStringSerializationReader {
    @NotNull
    private final String value;
    private int current;

    public SchemeStringSerializationReader(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
    }

    @NotNull
    public final ItemKind getKind() {
        ItemKind itemKind;
        char ch = this.getCh();
        switch (ch) {
            case '_': {
                itemKind = ItemKind.Number;
                break;
            }
            case '[': {
                itemKind = ItemKind.Open;
                break;
            }
            case ']': {
                itemKind = ItemKind.Close;
                break;
            }
            case ':': {
                itemKind = ItemKind.ResultPrefix;
                break;
            }
            case '*': {
                itemKind = ItemKind.AnyParameters;
                break;
            }
            case '\"': {
                itemKind = ItemKind.Token;
                break;
            }
            default: {
                itemKind = Character.isLetter(ch) ? ItemKind.Token : (Character.isDigit(ch) ? ItemKind.Number : (ch == '\u0000' ? ItemKind.End : ItemKind.Invalid));
            }
        }
        return itemKind;
    }

    public final void end() {
        if (this.getKind() != ItemKind.End) {
            SchemeKt.access$schemeParseError();
            throw new KotlinNothingValueException();
        }
    }

    public final int number() {
        int n;
        if (this.getCh() == '_') {
            int n2 = this.current;
            this.current = n2 + 1;
            return -1;
        }
        int start = this.current;
        while (Character.isDigit(this.getCh())) {
            n = this.current;
            this.current = n + 1;
        }
        try {
            String string = this.value.substring(start, this.current);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            n = Integer.parseUnsignedInt(string, 10);
        }
        catch (NumberFormatException numberFormatException) {
            SchemeKt.access$schemeParseError();
            throw new KotlinNothingValueException();
        }
        return n;
    }

    @NotNull
    public final String token() {
        int start = this.current;
        int end = 0;
        String prefix = "";
        if (this.getCh() == '\"') {
            int n = this.current;
            start = this.current = n + 1;
            while (this.getCh() != '\"' && this.getCh() != '\u0000') {
                if (this.getCh() == '\\') {
                    prefix = prefix + this.value.subSequence(start, this.current);
                    n = this.current;
                    start = this.current = n + 1;
                    if (this.getCh() == '\"' || this.getCh() == '\\') {
                        n = this.current;
                        this.current = n + 1;
                        continue;
                    }
                    SchemeKt.access$schemeParseError();
                    throw new KotlinNothingValueException();
                }
                n = this.current;
                this.current = n + 1;
            }
            end = this.current;
            n = this.current;
            this.current = n + 1;
        } else {
            while (true) {
                SchemeStringSerializationReader $this$token_u24lambda_u240 = this;
                boolean bl = false;
                char ch = $this$token_u24lambda_u240.getCh();
                if (!(ch == '.' || Character.isLetter(ch))) break;
                int n = this.current;
                this.current = n + 1;
            }
            end = this.current;
        }
        return prefix + this.value.subSequence(start, end);
    }

    public final void expect(@NotNull ItemKind kind) {
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        if (kind != ItemKind.Invalid) {
            if (this.getKind() != kind) {
                SchemeKt.access$schemeParseError();
                throw new KotlinNothingValueException();
            }
            switch (WhenMappings.$EnumSwitchMapping$0[this.getKind().ordinal()]) {
                case 1: {
                    this.expect('[');
                    break;
                }
                case 2: {
                    this.expect(']');
                    break;
                }
                case 3: {
                    this.expect(':');
                    break;
                }
                case 4: {
                    this.expect('*');
                    break;
                }
                case 5: {
                    this.token();
                    break;
                }
                case 6: {
                    this.number();
                    break;
                }
                case 7: {
                    this.end();
                    break;
                }
                default: {
                    SchemeKt.access$schemeParseError();
                    throw new KotlinNothingValueException();
                }
            }
        }
    }

    private final char getCh() {
        return this.current < this.value.length() ? this.value.charAt(this.current) : (char)'\u0000';
    }

    private final void expect(char ch) {
        if (this.current >= this.value.length() || this.value.charAt(this.current) != ch) {
            SchemeKt.access$schemeParseError();
            throw new KotlinNothingValueException();
        }
        int n = this.current;
        this.current = n + 1;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ItemKind.values().length];
            try {
                nArray[ItemKind.Open.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ItemKind.Close.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ItemKind.ResultPrefix.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ItemKind.AnyParameters.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ItemKind.Token.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ItemKind.Number.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ItemKind.End.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

