/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.async.extractor;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Platform;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.profiler.ultimate.async.IdeaAsyncProfilerBundleKt;
import com.intellij.profiler.ultimate.async.extractor.AbstractLazyCachingExtractor;
import com.intellij.profiler.ultimate.async.extractor.AgentPlatform;
import com.intellij.profiler.ultimate.async.extractor.AsyncProfilerExtractorKt;
import com.intellij.profiler.ultimate.async.extractor.AsyncProfilerLibrary;
import com.intellij.profiler.ultimate.async.extractor.LazyCachingExtractorFromFile;
import com.intellij.profiler.ultimate.async.extractor.LazyCachingExtractorFromJar;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import one.profiler.AsyncProfiler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001&B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0006\u0010\u0014\u001a\u00020\u0006J\u0006\u0010\u0015\u001a\u00020\u0006J\u0006\u0010\u0016\u001a\u00020\u0006J\u0012\u0010\u0017\u001a\u00020\u00062\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0006H\u0007J\u0018\u0010\u0019\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002JR\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u000b2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001c2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u000b2\u0016\b\u0002\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\"\u0018\u00010!H\u0002J\u001c\u0010#\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\u001c\u0010$\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u001a\u0010%\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/profiler/ultimate/async/extractor/AsyncProfilerExtractor;", "", "<init>", "()V", "agentExtractors", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/profiler/ultimate/async/extractor/AbstractLazyCachingExtractor;", "getAsyncProfilerInstance", "Lone/profiler/AsyncProfiler;", "getLibraryForLocal", "Lcom/intellij/profiler/ultimate/async/extractor/AsyncProfilerExtractor$LibraryInfo;", "library", "Lcom/intellij/profiler/ultimate/async/extractor/AsyncProfilerLibrary;", "getLibrary", "agentPlatform", "Lcom/intellij/profiler/ultimate/async/extractor/AgentPlatform;", "fileNameWithExtension", "platform", "Lcom/intellij/execution/Platform;", "getJattachPath", "getLibDbghelpPath", "getLibJniSymbolsResolver", "getNativeAgentPath", "dbgHelpOption", "binaryRelativePathInJar", "createExtractor", "file", "Ljava/io/File;", "libraryInfo", "extraFile", "extraLibraryInfo", "postProcessor", "Lkotlin/Function1;", "", "getExtractor", "getLibraryPath", "findFileInLib", "LibraryInfo", "intellij.profiler.ultimate.ideaAsyncProfiler"})
@SourceDebugExtension(value={"SMAP\nAsyncProfilerExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AsyncProfilerExtractor.kt\ncom/intellij/profiler/ultimate/async/extractor/AsyncProfilerExtractor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,231:1\n1#2:232\n*E\n"})
public final class AsyncProfilerExtractor {
    @NotNull
    public static final AsyncProfilerExtractor INSTANCE = new AsyncProfilerExtractor();
    @NotNull
    private static final ConcurrentHashMap<String, AbstractLazyCachingExtractor<?>> agentExtractors = new ConcurrentHashMap();

    private AsyncProfilerExtractor() {
    }

    @Nullable
    public final AsyncProfiler getAsyncProfilerInstance() {
        if (AsyncProfilerExtractorKt.isProfilerStartedAtVmStart()) {
            return AsyncProfiler.getInstance();
        }
        AgentPlatform platform = AgentPlatform.Companion.local();
        if (!AsyncProfilerLibrary.ASYNC_PROFILER.getAvailablePlatforms$intellij_profiler_ultimate_ideaAsyncProfiler().contains((Object)platform)) {
            return null;
        }
        return AsyncProfiler.getInstance((String)AsyncProfilerExtractor.getNativeAgentPath$default(this, null, 1, null));
    }

    @NotNull
    public final LibraryInfo getLibraryForLocal(@NotNull AsyncProfilerLibrary library) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)((Object)library), (String)"library");
        return this.getLibrary(library, AgentPlatform.Companion.local());
    }

    private final LibraryInfo getLibrary(AsyncProfilerLibrary library, AgentPlatform agentPlatform) throws ExecutionException {
        if (!library.getAvailablePlatforms$intellij_profiler_ultimate_ideaAsyncProfiler().contains((Object)agentPlatform)) {
            Object[] objectArray = new Object[]{library.getLibraryName$intellij_profiler_ultimate_ideaAsyncProfiler(), agentPlatform.getReadableName()};
            throw new ExecutionException(IdeaAsyncProfilerBundleKt.ideaAsyncProfilerMessage("idea.platform.unsupported.for.library.error.message", objectArray));
        }
        String pathInJar = this.binaryRelativePathInJar(library, agentPlatform);
        Class<AsyncProfiler> classFromJar = AsyncProfiler.class;
        return new LibraryInfo(pathInJar, classFromJar);
    }

    @NotNull
    public final String fileNameWithExtension(@NotNull AsyncProfilerLibrary library, @Nullable Platform platform) {
        Intrinsics.checkNotNullParameter((Object)((Object)library), (String)"library");
        return AsyncProfilerExtractorKt.access$fileNameWithExtension(library, AgentPlatform.Companion.from(platform));
    }

    @NotNull
    public final String getJattachPath() {
        return AsyncProfilerExtractor.getLibraryPath$default(this, AsyncProfilerLibrary.JATTACH, null, 2, null);
    }

    @NotNull
    public final String getLibDbghelpPath() {
        return AsyncProfilerExtractor.getLibraryPath$default(this, AsyncProfilerLibrary.DBGHELP, null, 2, null);
    }

    @NotNull
    public final String getLibJniSymbolsResolver() {
        return AsyncProfilerExtractor.getLibraryPath$default(this, AsyncProfilerLibrary.JNI_SYMBOLS_RESOLVER, null, 2, null);
    }

    @NotNull
    public final String getNativeAgentPath(@Nullable Platform platform) {
        return this.getLibraryPath(AsyncProfilerLibrary.ASYNC_PROFILER, platform);
    }

    public static /* synthetic */ String getNativeAgentPath$default(AsyncProfilerExtractor asyncProfilerExtractor, Platform platform, int n, Object object) {
        if ((n & 1) != 0) {
            platform = null;
        }
        return asyncProfilerExtractor.getNativeAgentPath(platform);
    }

    @JvmStatic
    @Nullable
    public static final String dbgHelpOption() {
        return SystemInfo.isWindows ? "dbghelppath=" + INSTANCE.getLibDbghelpPath() : null;
    }

    private final String binaryRelativePathInJar(AsyncProfilerLibrary library, AgentPlatform agentPlatform) {
        String osPart = agentPlatform.getPlatformName();
        return "/binaries/" + osPart + "/" + AsyncProfilerExtractorKt.access$fileNameWithExtension(library, agentPlatform);
    }

    private final AbstractLazyCachingExtractor<? extends Object> createExtractor(File file, LibraryInfo libraryInfo, File extraFile, LibraryInfo extraLibraryInfo, Function1<? super File, Unit> postProcessor) {
        return file != null ? (AbstractLazyCachingExtractor)new LazyCachingExtractorFromFile(file, extraFile, postProcessor) : (AbstractLazyCachingExtractor)new LazyCachingExtractorFromJar(libraryInfo, extraLibraryInfo, postProcessor);
    }

    static /* synthetic */ AbstractLazyCachingExtractor createExtractor$default(AsyncProfilerExtractor asyncProfilerExtractor, File file, LibraryInfo libraryInfo, File file2, LibraryInfo libraryInfo2, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            file2 = null;
        }
        if ((n & 8) != 0) {
            libraryInfo2 = null;
        }
        if ((n & 0x10) != 0) {
            function1 = null;
        }
        return asyncProfilerExtractor.createExtractor(file, libraryInfo, file2, libraryInfo2, (Function1<? super File, Unit>)function1);
    }

    private final AbstractLazyCachingExtractor<?> getExtractor(AsyncProfilerLibrary library, AgentPlatform platform) {
        AbstractLazyCachingExtractor abstractLazyCachingExtractor = agentExtractors.computeIfAbsent(library.getLibraryName$intellij_profiler_ultimate_ideaAsyncProfiler() + "-" + platform.getPlatformName(), arg_0 -> AsyncProfilerExtractor.getExtractor$lambda$2(arg_0 -> AsyncProfilerExtractor.getExtractor$lambda$1(library, platform, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)abstractLazyCachingExtractor, (String)"computeIfAbsent(...)");
        return abstractLazyCachingExtractor;
    }

    private final String getLibraryPath(AsyncProfilerLibrary library, Platform platform) {
        String propertyPath;
        String string = AsyncProfilerExtractorKt.access$getPathProperty(library);
        if (string != null) {
            String it = string;
            boolean bl = false;
            v1 = System.getProperty(it);
        } else {
            v1 = propertyPath = null;
        }
        if (propertyPath != null) {
            return propertyPath;
        }
        String string2 = this.getExtractor(library, AgentPlatform.Companion.from(platform)).getFile().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
        return string2;
    }

    static /* synthetic */ String getLibraryPath$default(AsyncProfilerExtractor asyncProfilerExtractor, AsyncProfilerLibrary asyncProfilerLibrary, Platform platform, int n, Object object) {
        if ((n & 2) != 0) {
            platform = null;
        }
        return asyncProfilerExtractor.getLibraryPath(asyncProfilerLibrary, platform);
    }

    private final File findFileInLib(AsyncProfilerLibrary library, AgentPlatform agentPlatform) {
        String string = AsyncProfilerExtractorKt.access$getLibPath();
        if (string == null) {
            return null;
        }
        String libPath = string;
        String archName = AsyncProfilerExtractorKt.access$getArchNameInLib(agentPlatform);
        String libraryName = AsyncProfilerExtractorKt.access$fileNameWithExtension(library, agentPlatform);
        Object object = new String[]{"async-profiler", archName, libraryName};
        Object it = object = Path.of(libPath, (String[])object);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        Object object2 = Files.exists((Path)it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? object : null;
        if (object2 == null) {
            return null;
        }
        Object path = object2;
        return path.toFile();
    }

    private static final Unit getExtractor$lambda$1$lambda$0(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setExecutable(true);
        return Unit.INSTANCE;
    }

    private static final AbstractLazyCachingExtractor getExtractor$lambda$1(AsyncProfilerLibrary $library, AgentPlatform $platform, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        File file = INSTANCE.findFileInLib($library, $platform);
        LibraryInfo libraryInfo = INSTANCE.getLibrary($library, $platform);
        return switch (WhenMappings.$EnumSwitchMapping$0[$library.ordinal()]) {
            case 1, 2 -> AsyncProfilerExtractor.createExtractor$default(INSTANCE, file, libraryInfo, null, null, null, 28, null);
            case 3 -> AsyncProfilerExtractor.createExtractor$default(INSTANCE, file, libraryInfo, null, null, AsyncProfilerExtractor::getExtractor$lambda$1$lambda$0, 12, null);
            case 4 -> AsyncProfilerExtractor.createExtractor$default(INSTANCE, file, libraryInfo, INSTANCE.findFileInLib(AsyncProfilerLibrary.SYMSRV, $platform), INSTANCE.getLibrary(AsyncProfilerLibrary.SYMSRV, $platform), null, 16, null);
            case 5 -> throw new IllegalStateException(("No extractor for " + $library.getLibraryName$intellij_profiler_ultimate_ideaAsyncProfiler()).toString());
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final AbstractLazyCachingExtractor getExtractor$lambda$2(Function1 $tmp0, Object p0) {
        return (AbstractLazyCachingExtractor)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u0011\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0005H\u00c6\u0003J%\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0019\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/profiler/ultimate/async/extractor/AsyncProfilerExtractor$LibraryInfo;", "", "pathInJar", "", "classFromJar", "Ljava/lang/Class;", "<init>", "(Ljava/lang/String;Ljava/lang/Class;)V", "getPathInJar", "()Ljava/lang/String;", "getClassFromJar", "()Ljava/lang/Class;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.profiler.ultimate.ideaAsyncProfiler"})
    public static final class LibraryInfo {
        @NotNull
        private final String pathInJar;
        @NotNull
        private final Class<? extends Object> classFromJar;

        public LibraryInfo(@NotNull String pathInJar, @NotNull Class<? extends Object> classFromJar) {
            Intrinsics.checkNotNullParameter((Object)pathInJar, (String)"pathInJar");
            Intrinsics.checkNotNullParameter(classFromJar, (String)"classFromJar");
            this.pathInJar = pathInJar;
            this.classFromJar = classFromJar;
        }

        @NotNull
        public final String getPathInJar() {
            return this.pathInJar;
        }

        @NotNull
        public final Class<? extends Object> getClassFromJar() {
            return this.classFromJar;
        }

        @NotNull
        public final String component1() {
            return this.pathInJar;
        }

        @NotNull
        public final Class<? extends Object> component2() {
            return this.classFromJar;
        }

        @NotNull
        public final LibraryInfo copy(@NotNull String pathInJar, @NotNull Class<? extends Object> classFromJar) {
            Intrinsics.checkNotNullParameter((Object)pathInJar, (String)"pathInJar");
            Intrinsics.checkNotNullParameter(classFromJar, (String)"classFromJar");
            return new LibraryInfo(pathInJar, classFromJar);
        }

        public static /* synthetic */ LibraryInfo copy$default(LibraryInfo libraryInfo, String string, Class clazz, int n, Object object) {
            if ((n & 1) != 0) {
                string = libraryInfo.pathInJar;
            }
            if ((n & 2) != 0) {
                clazz = libraryInfo.classFromJar;
            }
            return libraryInfo.copy(string, clazz);
        }

        @NotNull
        public String toString() {
            return "LibraryInfo(pathInJar=" + this.pathInJar + ", classFromJar=" + this.classFromJar + ")";
        }

        public int hashCode() {
            int result2 = this.pathInJar.hashCode();
            result2 = result2 * 31 + this.classFromJar.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LibraryInfo)) {
                return false;
            }
            LibraryInfo libraryInfo = (LibraryInfo)other;
            if (!Intrinsics.areEqual((Object)this.pathInJar, (Object)libraryInfo.pathInJar)) {
                return false;
            }
            return Intrinsics.areEqual(this.classFromJar, libraryInfo.classFromJar);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AsyncProfilerLibrary.values().length];
            try {
                nArray[AsyncProfilerLibrary.ASYNC_PROFILER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AsyncProfilerLibrary.JNI_SYMBOLS_RESOLVER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AsyncProfilerLibrary.JATTACH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AsyncProfilerLibrary.DBGHELP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AsyncProfilerLibrary.SYMSRV.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

