/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.core.ui.impl;

import com.intellij.debugger.streams.core.trace.CollectionTreeBuilder;
import com.intellij.debugger.streams.core.trace.DebuggerCommandLauncher;
import com.intellij.debugger.streams.core.trace.TraceElement;
import com.intellij.debugger.streams.core.trace.Value;
import com.intellij.debugger.streams.core.ui.PaintingListener;
import com.intellij.debugger.streams.core.ui.TraceContainer;
import com.intellij.debugger.streams.core.ui.ValuesSelectionListener;
import com.intellij.debugger.streams.core.ui.impl.IntermediateTree;
import com.intellij.debugger.streams.core.ui.impl.TerminationTree;
import com.intellij.ui.JBColor;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CollectionTree
extends XDebuggerTree
implements TraceContainer {
    private static final Map<Integer, Color> COLORS_CACHE = new HashMap<Integer, Color>();
    protected final Map<TraceElement, TreePath> myValue2Path;
    protected final Map<TreePath, TraceElement> myPath2Value;
    private final String myDebugName;
    private Set<TreePath> myHighlighted;
    private final EventDispatcher<ValuesSelectionListener> mySelectionDispatcher;
    private final EventDispatcher<PaintingListener> myPaintingDispatcher;
    private boolean myIgnoreInternalSelectionEvents;
    private boolean myIgnoreExternalSelectionEvents;

    protected CollectionTree(@NotNull List<TraceElement> traceElements, @NotNull DebuggerCommandLauncher launcher, @NotNull CollectionTreeBuilder collectionTreeBuilder, @NotNull String debugName) {
        if (traceElements == null) {
            CollectionTree.$$$reportNull$$$0(0);
        }
        if (launcher == null) {
            CollectionTree.$$$reportNull$$$0(1);
        }
        if (collectionTreeBuilder == null) {
            CollectionTree.$$$reportNull$$$0(2);
        }
        if (debugName == null) {
            CollectionTree.$$$reportNull$$$0(3);
        }
        super(launcher.getProject(), collectionTreeBuilder.getEditorsProvider(), null, "XDebugger.Inspect.Tree.Popup", null);
        this.myValue2Path = new HashMap<TraceElement, TreePath>();
        this.myPath2Value = new HashMap<TreePath, TraceElement>();
        this.myHighlighted = Collections.emptySet();
        this.mySelectionDispatcher = EventDispatcher.create(ValuesSelectionListener.class);
        this.myPaintingDispatcher = EventDispatcher.create(PaintingListener.class);
        this.myIgnoreInternalSelectionEvents = false;
        this.myIgnoreExternalSelectionEvents = false;
        this.myDebugName = debugName;
        this.addTreeSelectionListener(e -> {
            if (this.myIgnoreInternalSelectionEvents) {
                return;
            }
            List<TraceElement> selectedItems = TreeUtil.collectSelectedPaths((JTree)((Object)this)).stream().map(this::getTopPath).map(this.myPath2Value::get).filter(Objects::nonNull).collect(Collectors.toList());
            this.fireSelectionChanged(selectedItems);
        });
        this.setSelectionRow(0);
        this.expandNodesOnLoad(node -> node == this.getRoot());
    }

    public static CollectionTree create(@Nullable Value streamResult, @NotNull List<TraceElement> traceElements, @NotNull DebuggerCommandLauncher debuggerCommandLauncher, @NotNull CollectionTreeBuilder collectionTreeBuilder, @NotNull String debugName) {
        if (traceElements == null) {
            CollectionTree.$$$reportNull$$$0(4);
        }
        if (debuggerCommandLauncher == null) {
            CollectionTree.$$$reportNull$$$0(5);
        }
        if (collectionTreeBuilder == null) {
            CollectionTree.$$$reportNull$$$0(6);
        }
        if (debugName == null) {
            CollectionTree.$$$reportNull$$$0(7);
        }
        if (streamResult == null) {
            return new IntermediateTree((List<? extends TraceElement>)traceElements, debuggerCommandLauncher, collectionTreeBuilder, debugName);
        }
        return new TerminationTree(streamResult, traceElements, debuggerCommandLauncher, collectionTreeBuilder, debugName);
    }

    public boolean isFileColorsEnabled() {
        return true;
    }

    @Nullable
    public Color getFileColorForPath(@NotNull TreePath path) {
        if (path == null) {
            CollectionTree.$$$reportNull$$$0(8);
        }
        if (this.isPathHighlighted(path)) {
            Color background = UIUtil.getTreeSelectionBackground((boolean)true);
            return COLORS_CACHE.computeIfAbsent(background.getRGB(), rgb -> new JBColor(new Color(background.getRed(), background.getGreen(), background.getBlue(), 75), new Color(background.getRed(), background.getGreen(), background.getBlue(), 100)));
        }
        return UIUtil.getTreeBackground();
    }

    public void clearSelection() {
        this.myIgnoreInternalSelectionEvents = true;
        super.clearSelection();
        this.myIgnoreInternalSelectionEvents = false;
    }

    @Nullable
    public Rectangle getRectByValue(@NotNull TraceElement element) {
        TreePath path;
        if (element == null) {
            CollectionTree.$$$reportNull$$$0(9);
        }
        return (path = this.myValue2Path.get(element)) == null ? null : this.getPathBounds(path);
    }

    @Override
    public void highlight(@NotNull List<TraceElement> elements) {
        if (elements == null) {
            CollectionTree.$$$reportNull$$$0(10);
        }
        this.clearSelection();
        this.highlightValues(elements);
        this.tryScrollTo(elements);
        this.updatePresentation();
    }

    @Override
    public void select(@NotNull List<TraceElement> elements) {
        if (elements == null) {
            CollectionTree.$$$reportNull$$$0(11);
        }
        TreePath[] paths = (TreePath[])elements.stream().map(this.myValue2Path::get).toArray(TreePath[]::new);
        this.select(paths);
        this.highlightValues(elements);
        if (paths.length > 0) {
            this.scrollPathToVisible(paths[0]);
        }
        this.updatePresentation();
    }

    @Override
    public void addSelectionListener(@NotNull ValuesSelectionListener listener) {
        if (listener == null) {
            CollectionTree.$$$reportNull$$$0(12);
        }
        this.mySelectionDispatcher.addListener((EventListener)listener);
    }

    @Override
    public boolean highlightedExists() {
        return !this.isSelectionEmpty() || !this.myHighlighted.isEmpty();
    }

    public abstract int getItemsCount();

    public void addPaintingListener(@NotNull PaintingListener listener) {
        if (listener == null) {
            CollectionTree.$$$reportNull$$$0(13);
        }
        this.myPaintingDispatcher.addListener((EventListener)listener);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        ((PaintingListener)this.myPaintingDispatcher.getMulticaster()).componentPainted();
    }

    private void select(TreePath @NotNull [] paths) {
        if (paths == null) {
            CollectionTree.$$$reportNull$$$0(14);
        }
        if (this.myIgnoreExternalSelectionEvents) {
            return;
        }
        this.myIgnoreInternalSelectionEvents = true;
        this.getSelectionModel().setSelectionPaths(paths);
        this.myIgnoreInternalSelectionEvents = false;
    }

    private void fireSelectionChanged(List<TraceElement> selectedItems) {
        this.myIgnoreExternalSelectionEvents = true;
        ((ValuesSelectionListener)this.mySelectionDispatcher.getMulticaster()).selectionChanged(selectedItems);
        this.myIgnoreExternalSelectionEvents = false;
    }

    private void tryScrollTo(@NotNull List<TraceElement> elements) {
        if (elements == null) {
            CollectionTree.$$$reportNull$$$0(15);
        }
        int[] rows = elements.stream().map(this.myValue2Path::get).filter(Objects::nonNull).mapToInt(arg_0 -> this.getRowForPath(arg_0)).sorted().toArray();
        if (rows.length == 0) {
            return;
        }
        if (this.isShowing()) {
            Rectangle bestVisibleArea = this.optimizeRowsCountInVisibleRect(rows);
            Rectangle visibleRect = this.getVisibleRect();
            boolean notVisibleHighlightedRowExists = Arrays.stream(rows).anyMatch(x -> !visibleRect.intersects(this.getRowBounds(x)));
            if (notVisibleHighlightedRowExists) {
                this.scrollRectToVisible(bestVisibleArea);
            }
        } else {
            this.scrollPathToVisible(this.getPathForRow(rows[0]));
        }
    }

    @NotNull
    private Rectangle optimizeRowsCountInVisibleRect(int @NotNull [] rows) {
        if (rows == null) {
            CollectionTree.$$$reportNull$$$0(16);
        }
        Rectangle visibleRect = this.getVisibleRect();
        int height = visibleRect.height;
        int topIndex = 0;
        Rectangle rowBounds = this.getRowBounds(rows[topIndex]);
        if (rowBounds == null) {
            Rectangle rectangle = visibleRect;
            if (rectangle == null) {
                CollectionTree.$$$reportNull$$$0(17);
            }
            return rectangle;
        }
        int topY = rowBounds.y;
        class Result {
            private int top = 0;
            private int bot = 0;

            Result() {
            }

            @Contract(pure=true)
            private int count() {
                return this.bot - this.top;
            }
        }
        Result result = new Result();
        for (int bottomIndex = 1; bottomIndex < rows.length; ++bottomIndex) {
            int nextY = this.getRowBounds((int)rows[bottomIndex]).y;
            while (nextY - topY > height) {
                if ((rowBounds = this.getRowBounds(rows[++topIndex])) == null) {
                    Rectangle rectangle = visibleRect;
                    if (rectangle == null) {
                        CollectionTree.$$$reportNull$$$0(18);
                    }
                    return rectangle;
                }
                topY = rowBounds.y;
            }
            if (bottomIndex - topIndex <= result.count()) continue;
            result.top = topIndex;
            result.bot = bottomIndex;
        }
        int y = this.getRowBounds((int)rows[result.top]).y;
        if (y > visibleRect.y) {
            Rectangle botBounds = this.getRowBounds(rows[result.bot]);
            y = botBounds.y + botBounds.height - visibleRect.height;
        }
        return new Rectangle(visibleRect.x, y, visibleRect.width, height);
    }

    private void highlightValues(@NotNull List<TraceElement> elements) {
        if (elements == null) {
            CollectionTree.$$$reportNull$$$0(19);
        }
        this.myHighlighted = elements.stream().map(this.myValue2Path::get).collect(Collectors.toSet());
    }

    private void updatePresentation() {
        this.revalidate();
        this.repaint();
    }

    public boolean isHighlighted(@NotNull TraceElement traceElement) {
        TreePath path;
        if (traceElement == null) {
            CollectionTree.$$$reportNull$$$0(20);
        }
        return (path = this.myValue2Path.get(traceElement)) != null && this.isPathHighlighted(path);
    }

    private boolean isPathHighlighted(@NotNull TreePath path) {
        if (path == null) {
            CollectionTree.$$$reportNull$$$0(21);
        }
        return this.myHighlighted.contains(path) || this.isPathSelected(path);
    }

    @NotNull
    private TreePath getTopPath(@NotNull TreePath path) {
        TreePath current;
        if (path == null) {
            CollectionTree.$$$reportNull$$$0(22);
        }
        for (current = path; current != null && !this.myPath2Value.containsKey(current); current = current.getParentPath()) {
        }
        TreePath treePath = current != null ? current : path;
        if (treePath == null) {
            CollectionTree.$$$reportNull$$$0(23);
        }
        return treePath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 17, 18, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traceElements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcher";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectionTreeBuilder";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerCommandLauncher";
                break;
            }
            case 8: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 11: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 17: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/streams/core/ui/impl/CollectionTree";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traceElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/streams/core/ui/impl/CollectionTree";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "optimizeRowsCountInVisibleRect";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFileColorForPath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRectByValue";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "highlight";
                break;
            }
            case 11: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addSelectionListener";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addPaintingListener";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "tryScrollTo";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "optimizeRowsCountInVisibleRect";
                break;
            }
            case 17: 
            case 18: 
            case 23: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "highlightValues";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isHighlighted";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isPathHighlighted";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getTopPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 17, 18, 23 -> new IllegalStateException(string);
        };
    }
}

