/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInspection.AnalysisUastUtilKt;
import com.intellij.codeInspection.AnnotatedApiUsageUtil;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.apiUsage.ApiUsageProcessor;
import com.intellij.codeInspection.apiUsage.ApiUsageUastVisitor;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtilCore;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/codeInspection/OverrideOnlyInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "OverrideOnlyProcessor", "intellij.jvm.analysis.impl"})
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nOverrideOnlyInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OverrideOnlyInspection.kt\ncom/intellij/codeInspection/OverrideOnlyInspection\n+ 2 OverrideOnlyInspection.kt\ncom/intellij/codeInspection/OverrideOnlyInspectionKt\n*L\n1#1,81:1\n22#2:82\n*S KotlinDebug\n*F\n+ 1 OverrideOnlyInspection.kt\ncom/intellij/codeInspection/OverrideOnlyInspection\n*L\n31#1:82\n*E\n"})
public final class OverrideOnlyInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiElementVisitor psiElementVisitor;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        boolean $i$f$getANNOTATION_NAME = false;
        String string = ApiStatus.OverrideOnly.class.getCanonicalName();
        Intrinsics.checkNotNull((Object)string);
        PsiFile psiFile = holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        if (AnnotatedApiUsageUtil.INSTANCE.canAnnotationBeUsedInFile(string, psiFile)) {
            psiElementVisitor = ApiUsageUastVisitor.Companion.createPsiElementVisitor((ApiUsageProcessor)new OverrideOnlyProcessor(holder));
        } else {
            PsiElementVisitor psiElementVisitor2 = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNull((Object)psiElementVisitor2);
            psiElementVisitor = psiElementVisitor2;
        }
        return psiElementVisitor;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\u0006\u001a\u00020\u0007*\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\bH\u0002J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\bH\u0002J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u0012\u0010\u0010\u001a\u00020\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u001a\u0010\u0013\u001a\u00020\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\bH\u0002J\"\u0010\u0014\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\"\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00172\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/codeInspection/OverrideOnlyInspection$OverrideOnlyProcessor;", "Lcom/intellij/codeInspection/apiUsage/ApiUsageProcessor;", "problemsHolder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;)V", "isOverridable", "", "Lcom/intellij/psi/PsiMethod;", "isLibraryElement", "method", "isOverrideOnlyMethod", "isInsideOverridenOnlyMethod", "sourceNode", "Lorg/jetbrains/uast/UElement;", "target", "isSuperCall", "qualifier", "Lorg/jetbrains/uast/UExpression;", "isDelegateCall", "isSuperOrDelegateCall", "processReference", "", "Lcom/intellij/psi/PsiModifierListOwner;", "intellij.jvm.analysis.impl"})
    @SourceDebugExtension(value={"SMAP\nOverrideOnlyInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OverrideOnlyInspection.kt\ncom/intellij/codeInspection/OverrideOnlyInspection$OverrideOnlyProcessor\n+ 2 OverrideOnlyInspection.kt\ncom/intellij/codeInspection/OverrideOnlyInspectionKt\n*L\n1#1,81:1\n22#2:82\n*S KotlinDebug\n*F\n+ 1 OverrideOnlyInspection.kt\ncom/intellij/codeInspection/OverrideOnlyInspection$OverrideOnlyProcessor\n*L\n49#1:82\n*E\n"})
    private static final class OverrideOnlyProcessor
    implements ApiUsageProcessor {
        @NotNull
        private final ProblemsHolder problemsHolder;

        public OverrideOnlyProcessor(@NotNull ProblemsHolder problemsHolder) {
            Intrinsics.checkNotNullParameter((Object)problemsHolder, (String)"problemsHolder");
            this.problemsHolder = problemsHolder;
        }

        private final boolean isOverridable(PsiMethod $this$isOverridable) {
            return !$this$isOverridable.hasModifier(JvmModifier.PRIVATE) && !$this$isOverridable.hasModifier(JvmModifier.FINAL) && !$this$isOverridable.hasModifier(JvmModifier.STATIC);
        }

        private final boolean isLibraryElement(PsiMethod method) {
            VirtualFile containingVirtualFile = PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)method));
            return containingVirtualFile != null && ProjectFileIndex.getInstance((Project)method.getProject()).isInLibraryClasses(containingVirtualFile);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isOverrideOnlyMethod(PsiMethod method) {
            boolean $i$f$getANNOTATION_NAME = false;
            String string = ApiStatus.OverrideOnly.class.getCanonicalName();
            Intrinsics.checkNotNull((Object)string);
            if (method.hasAnnotation(string)) return true;
            PsiClass psiClass = method.getContainingClass();
            if (psiClass == null) return false;
            boolean $i$f$getANNOTATION_NAME2 = false;
            String string2 = ApiStatus.OverrideOnly.class.getCanonicalName();
            Intrinsics.checkNotNull((Object)string2);
            if (!psiClass.hasAnnotation(string2)) return false;
            return true;
        }

        private final boolean isInsideOverridenOnlyMethod(UElement sourceNode, PsiMethod target) {
            boolean bl;
            UMethod uMethod = UastUtils.getContainingUMethod((UElement)sourceNode);
            if (uMethod != null) {
                UMethod it = uMethod;
                boolean bl2 = false;
                bl = MethodSignatureUtil.areSignaturesEqual((PsiMethod)it.getJavaPsi(), (PsiMethod)target);
            } else {
                bl = false;
            }
            return bl;
        }

        private final boolean isSuperCall(UExpression qualifier) {
            return qualifier instanceof USuperExpression;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isDelegateCall(UExpression qualifier, PsiMethod target) {
            Boolean bl;
            UExpression uExpression = qualifier;
            Object object = uExpression;
            if (uExpression == null) return false;
            UExpression it = object;
            boolean bl2 = false;
            Object object2 = target.getContainingClass();
            if (object2 == null || (object2 = object2.getQualifiedName()) == null) {
                bl = false;
            } else {
                Object object3 = object2;
                PsiType psiType = it.getExpressionType();
                if (psiType == null) return false;
                String[] stringArray = new String[]{object3};
                bl = AnalysisUastUtilKt.isInheritorOf((PsiType)psiType, (String[])stringArray);
            }
            object = bl;
            if (bl == null) return false;
            boolean bl3 = (Boolean)object;
            return bl3;
        }

        private final boolean isSuperOrDelegateCall(UElement sourceNode, PsiMethod target, UExpression qualifier) {
            if (!this.isInsideOverridenOnlyMethod(sourceNode, target)) {
                return false;
            }
            return this.isSuperCall(qualifier) || this.isDelegateCall(qualifier, target);
        }

        public void processReference(@NotNull UElement sourceNode, @NotNull PsiModifierListOwner target, @Nullable UExpression qualifier) {
            Intrinsics.checkNotNullParameter((Object)sourceNode, (String)"sourceNode");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            if (target instanceof PsiMethod && this.isOverridable((PsiMethod)target) && this.isLibraryElement((PsiMethod)target) && this.isOverrideOnlyMethod((PsiMethod)target) && !this.isSuperOrDelegateCall(sourceNode, (PsiMethod)target, qualifier)) {
                PsiElement psiElement = sourceNode.getSourcePsi();
                if (psiElement == null) {
                    return;
                }
                PsiElement elementToHighlight = psiElement;
                String string = HighlightMessageUtil.getSymbolName((PsiElement)((PsiElement)target));
                if (string == null) {
                    return;
                }
                String methodName = string;
                Object[] objectArray = new Object[]{methodName};
                String description = JvmAnalysisBundle.message("jvm.inspections.api.override.only.description", objectArray);
                this.problemsHolder.registerProblem(elementToHighlight, description, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            }
        }
    }
}

