/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleDeclarativeBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleDeclarativeSettingsModel;
import com.android.tools.idea.gradle.dsl.api.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.api.GradleVersionCatalogsModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.model.BuildModelContext;
import com.android.tools.idea.gradle.dsl.model.GradleDeclarativeBuildModelImpl;
import com.android.tools.idea.gradle.dsl.model.GradleDeclarativeSettingsModelImpl;
import com.android.tools.idea.gradle.dsl.model.GradleModelFactory;
import com.android.tools.idea.gradle.dsl.model.GradleSettingsModelImpl;
import com.android.tools.idea.gradle.dsl.model.GradleVersionCatalogsModelImpl;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementImpl;
import com.android.tools.idea.gradle.dsl.parser.files.GradleBuildFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleVersionCatalogFile;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectBuildModelImpl
implements ProjectBuildModel {
    @NotNull
    private final BuildModelContext myBuildModelContext;
    @Nullable
    private final GradleBuildFile myProjectBuildFile;

    public ProjectBuildModelImpl(@NotNull Project project, @Nullable VirtualFile file, @NotNull BuildModelContext buildModelContext) {
        if (project == null) {
            ProjectBuildModelImpl.$$$reportNull$$$0(0);
        }
        if (buildModelContext == null) {
            ProjectBuildModelImpl.$$$reportNull$$$0(1);
        }
        this.myBuildModelContext = buildModelContext;
        this.myProjectBuildFile = this.myBuildModelContext.initializeContext(project, file);
    }

    @Override
    @NotNull
    public BuildModelContext getContext() {
        BuildModelContext buildModelContext = this.myBuildModelContext;
        if (buildModelContext == null) {
            ProjectBuildModelImpl.$$$reportNull$$$0(2);
        }
        return buildModelContext;
    }

    @Override
    @Nullable
    public GradleBuildModel getProjectBuildModel() {
        return this.myProjectBuildFile == null ? null : GradleModelFactory.createGradleBuildModel(this.myProjectBuildFile);
    }

    @Override
    @Nullable
    public GradleBuildModel getModuleBuildModel(@NotNull Module module) {
        VirtualFile file;
        if (module == null) {
            ProjectBuildModelImpl.$$$reportNull$$$0(3);
        }
        return (file = this.myBuildModelContext.getGradleBuildFile(module)) == null ? null : this.getModuleBuildModel(file);
    }

    @Override
    @Nullable
    public GradleBuildModel getModuleBuildModel(@NotNull File modulePath) {
        VirtualFile file;
        if (modulePath == null) {
            ProjectBuildModelImpl.$$$reportNull$$$0(4);
        }
        return (file = this.myBuildModelContext.getGradleBuildFile(modulePath)) == null ? null : this.getModuleBuildModel(file);
    }

    private static boolean isDeclarativeStudioSupportEnabled() {
        return Registry.get((String)"gradle.declarative.studio.support").asBoolean();
    }

    @Override
    @Nullable
    public GradleDeclarativeBuildModel getDeclarativeModuleBuildModel(@NotNull Module module) {
        if (module == null) {
            ProjectBuildModelImpl.$$$reportNull$$$0(5);
        }
        if (!ProjectBuildModelImpl.isDeclarativeStudioSupportEnabled()) {
            return null;
        }
        VirtualFile file = this.myBuildModelContext.getGradleBuildFile(module);
        return file == null ? null : this.getDeclarativeModuleBuildModel(file);
    }

    @Override
    @Nullable
    public GradleDeclarativeBuildModel getDeclarativeModuleBuildModel(@NotNull File modulePath) {
        if (modulePath == null) {
            ProjectBuildModelImpl.$$$reportNull$$$0(6);
        }
        if (!ProjectBuildModelImpl.isDeclarativeStudioSupportEnabled()) {
            return null;
        }
        VirtualFile file = this.myBuildModelContext.getGradleBuildFile(modulePath);
        return file == null ? null : this.getDeclarativeModuleBuildModel(file);
    }

    @Override
    @Nullable
    public GradleDeclarativeBuildModel getDeclarativeModuleBuildModel(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectBuildModelImpl.$$$reportNull$$$0(7);
        }
        if (!ProjectBuildModelImpl.isDeclarativeStudioSupportEnabled()) {
            return null;
        }
        if (!file.getName().equals("build.gradle.dcl")) {
            return null;
        }
        GradleBuildFile dslFile = this.myBuildModelContext.getOrCreateBuildFile(file, false);
        return new GradleDeclarativeBuildModelImpl(dslFile);
    }

    @Override
    @NotNull
    public GradleBuildModel getModuleBuildModel(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectBuildModelImpl.$$$reportNull$$$0(8);
        }
        GradleBuildFile dslFile = this.myBuildModelContext.getOrCreateBuildFile(file, false);
        GradleBuildModel gradleBuildModel = GradleModelFactory.createGradleBuildModel(dslFile);
        if (gradleBuildModel == null) {
            ProjectBuildModelImpl.$$$reportNull$$$0(9);
        }
        return gradleBuildModel;
    }

    @Override
    @Nullable
    public GradleSettingsModel getProjectSettingsModel() {
        VirtualFile virtualFile = this.getProjectSettingsFile();
        if (virtualFile == null) {
            return null;
        }
        GradleSettingsFile settingsFile = this.myBuildModelContext.getOrCreateSettingsFile(virtualFile);
        return new GradleSettingsModelImpl(settingsFile);
    }

    @Override
    @Nullable
    public GradleDeclarativeSettingsModel getDeclarativeSettingsModel() {
        if (!ProjectBuildModelImpl.isDeclarativeStudioSupportEnabled()) {
            return null;
        }
        VirtualFile virtualFile = this.getProjectSettingsFile();
        if (virtualFile == null) {
            return null;
        }
        if (!virtualFile.getName().equals("settings.gradle.dcl")) {
            return null;
        }
        GradleSettingsFile settingsFile = this.myBuildModelContext.getOrCreateSettingsFile(virtualFile);
        return new GradleDeclarativeSettingsModelImpl(settingsFile);
    }

    @Nullable
    private VirtualFile getProjectSettingsFile() {
        VirtualFile virtualFile = this.myProjectBuildFile == null ? this.myBuildModelContext.getProjectSettingsFile() : this.myProjectBuildFile.tryToFindSettingsFile();
        if (virtualFile == null) {
            return null;
        }
        return virtualFile;
    }

    @Override
    public void applyChanges() {
        PostprocessReformattingAspect.getInstance((Project)this.myBuildModelContext.getProject()).postponeFormattingInside(() -> this.runOverProjectTree(file -> {
            file.applyChanges();
            file.saveAllChanges();
        }));
    }

    @Override
    public void resetState() {
        this.runOverProjectTree(GradleDslElementImpl::resetState);
    }

    @Override
    public void reparse() {
        List<GradleDslFile> files = this.myBuildModelContext.getAllRequestedFiles();
        files.forEach(GradleDslFile::reparse);
    }

    @Override
    @NotNull
    public List<GradleBuildModel> getAllIncludedBuildModels() {
        List<GradleBuildModel> list = this.getAllIncludedBuildModels((i, j) -> {});
        if (list == null) {
            ProjectBuildModelImpl.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Override
    @NotNull
    public List<GradleBuildModel> getAllIncludedBuildModels(@NotNull BiConsumer<Integer, Integer> func) {
        GradleSettingsModel settingsModel;
        File buildSrc;
        VirtualFile buildSrcVirtualFile;
        if (func == null) {
            ProjectBuildModelImpl.$$$reportNull$$$0(11);
        }
        Integer[] nModelsSeen = new Integer[]{0};
        ArrayList<GradleBuildModel> allModels = new ArrayList<GradleBuildModel>();
        if (this.myProjectBuildFile != null) {
            allModels.add(GradleModelFactory.createGradleBuildModel(this.myProjectBuildFile));
            nModelsSeen[0] = nModelsSeen[0] + 1;
            func.accept(nModelsSeen[0], null);
        }
        if ((buildSrcVirtualFile = this.myBuildModelContext.getGradleBuildFile(buildSrc = new File(FileUtil.toCanonicalPath((String)Optional.ofNullable(this.myBuildModelContext.getProject().getBasePath()).orElse("")), "buildSrc"))) != null) {
            allModels.add(this.getModuleBuildModel(buildSrcVirtualFile));
            nModelsSeen[0] = nModelsSeen[0] + 1;
            func.accept(nModelsSeen[0], null);
        }
        if ((settingsModel = this.getProjectSettingsModel()) == null) {
            ArrayList<GradleBuildModel> arrayList = allModels;
            if (arrayList == null) {
                ProjectBuildModelImpl.$$$reportNull$$$0(12);
            }
            return arrayList;
        }
        Set<String> modulePaths = settingsModel.modulePaths();
        Integer nModelsToConsider = nModelsSeen[0] + modulePaths.size();
        allModels.addAll(modulePaths.stream().map(modulePath -> {
            VirtualFile file;
            File moduleDir;
            GradleBuildModel model = null;
            if (!modulePath.equals(":") && (moduleDir = settingsModel.moduleDirectory((String)modulePath)) != null && (file = this.myBuildModelContext.getGradleBuildFile(moduleDir)) != null) {
                model = this.getModuleBuildModel(file);
            }
            nModelsSeen[0] = nModelsSeen[0] + 1;
            func.accept(nModelsSeen[0], nModelsToConsider);
            return model;
        }).filter(Objects::nonNull).collect(Collectors.toList()));
        ArrayList<GradleBuildModel> arrayList = allModels;
        if (arrayList == null) {
            ProjectBuildModelImpl.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public GradleVersionCatalogsModel getVersionCatalogsModel() {
        Set<GradleVersionCatalogFile> files = this.getContext().getVersionCatalogFiles();
        return new GradleVersionCatalogsModelImpl(files);
    }

    private void runOverProjectTree(@NotNull Consumer<GradleDslFile> func) {
        if (func == null) {
            ProjectBuildModelImpl.$$$reportNull$$$0(14);
        }
        this.myBuildModelContext.getAllRequestedFiles().forEach(func);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 9, 10, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildModelContext";
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/model/ProjectBuildModelImpl";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePath";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "func";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/ProjectBuildModelImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleBuildModel";
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllIncludedBuildModels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getModuleBuildModel";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarativeModuleBuildModel";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAllIncludedBuildModels";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "runOverProjectTree";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 9, 10, 12, 13 -> new IllegalStateException(string);
        };
    }
}

