/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.codeInsight.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightFixUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureDialog;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.JavaFXBundle;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;

public final class JavaFxEventHandlerInspection
extends XmlSuppressableInspectionTool {
    public boolean myDetectNonVoidReturnType;

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JavaFxEventHandlerInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JavaFxEventHandlerInspection.$$$reportNull$$$0(1);
        }
        if (!JavaFxFileTypeFactory.isFxml(session.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                JavaFxEventHandlerInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        return new XmlElementVisitor(){

            public void visitXmlAttributeValue(@NotNull XmlAttributeValue xmlAttributeValue) {
                PsiClassType declaredType;
                if (xmlAttributeValue == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitXmlAttributeValue(xmlAttributeValue);
                PsiElement valueParent = xmlAttributeValue.getParent();
                if (!(valueParent instanceof XmlAttribute)) {
                    return;
                }
                XmlAttribute attribute = (XmlAttribute)valueParent;
                List<PsiMethod> eventHandlerMethods = JavaFxEventHandlerInspection.getEventHandlerMethods(attribute);
                if (eventHandlerMethods.isEmpty()) {
                    return;
                }
                if (eventHandlerMethods.size() != 1) {
                    holder.registerProblem((PsiElement)xmlAttributeValue, JavaFXBundle.message("inspection.javafx.event.handler.ambiguous.problem", new Object[0]), new LocalQuickFix[0]);
                }
                if (JavaFxEventHandlerInspection.this.myDetectNonVoidReturnType) {
                    eventHandlerMethods.stream().map(PsiMethod::getReturnType).filter(returnType -> !PsiTypes.voidType().equals(returnType)).findAny().ifPresent(ignored -> holder.registerProblem((PsiElement)xmlAttributeValue, JavaFXBundle.message("inspection.javafx.event.handler.return.type.problem", new Object[0]), new LocalQuickFix[0]));
                }
                if ((declaredType = JavaFxPsiUtil.getDeclaredEventType(attribute)) == null) {
                    return;
                }
                for (PsiMethod method : eventHandlerMethods) {
                    PsiClassType expectedRawType;
                    PsiType actualType;
                    PsiParameter[] parameters = method.getParameterList().getParameters();
                    if (parameters.length != 1 || !((actualType = parameters[0].getType()) instanceof PsiClassType) || actualType.isAssignableFrom((PsiType)declaredType)) continue;
                    ChangeParameterTypeQuickFix parameterTypeFix = new ChangeParameterTypeQuickFix(attribute, method, (PsiType)declaredType);
                    PsiClassType actualRawType = ((PsiClassType)actualType).rawType();
                    if (actualRawType.isAssignableFrom((PsiType)(expectedRawType = declaredType.rawType()))) {
                        ArrayList<LocalQuickFix> quickFixes = new ArrayList<LocalQuickFix>();
                        quickFixes.add((LocalQuickFix)parameterTypeFix);
                        JavaFxEventHandlerInspection.collectFieldTypeFixes(attribute, (PsiClassType)actualType, quickFixes);
                        holder.registerProblem((PsiElement)xmlAttributeValue, JavaFXBundle.message("inspection.javafx.event.handler.incompatible.generic.parameter.problem", actualType.getCanonicalText(), declaredType.getCanonicalText()), quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                        continue;
                    }
                    holder.registerProblem((PsiElement)xmlAttributeValue, JavaFXBundle.message("inspection.javafx.event.handler.incompatible.handler.argument", actualRawType.getCanonicalText(), expectedRawType.getCanonicalText()), new LocalQuickFix[]{parameterTypeFix});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlAttributeValue", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxEventHandlerInspection$1", "visitXmlAttributeValue"));
            }
        };
    }

    @NotNull
    private static List<PsiMethod> getEventHandlerMethods(@NotNull XmlAttribute attribute) {
        PsiClass controllerClass;
        if (attribute == null) {
            JavaFxEventHandlerInspection.$$$reportNull$$$0(3);
        }
        if ((controllerClass = JavaFxPsiUtil.getControllerClass(attribute.getContainingFile())) == null) {
            List<PsiMethod> list = Collections.emptyList();
            if (list == null) {
                JavaFxEventHandlerInspection.$$$reportNull$$$0(4);
            }
            return list;
        }
        String valueText = attribute.getValue();
        if (valueText == null || !valueText.startsWith("#")) {
            List<PsiMethod> list = Collections.emptyList();
            if (list == null) {
                JavaFxEventHandlerInspection.$$$reportNull$$$0(5);
            }
            return list;
        }
        String eventHandlerMethodName = valueText.substring(1);
        List<PsiMethod> list = Arrays.stream(controllerClass.findMethodsByName(eventHandlerMethodName, true)).filter(method -> !method.hasModifierProperty("static") && JavaFxPsiUtil.isVisibleInFxml((PsiMember)method)).filter(JavaFxEventHandlerInspection::hasEventArgument).collect(Collectors.toList());
        if (list == null) {
            JavaFxEventHandlerInspection.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static boolean hasEventArgument(@NotNull PsiMethod method) {
        PsiParameter[] parameters;
        if (method == null) {
            JavaFxEventHandlerInspection.$$$reportNull$$$0(7);
        }
        return (parameters = method.getParameterList().getParameters()).length == 0 || parameters.length == 1 && InheritanceUtil.isInheritor((PsiType)parameters[0].getType(), (String)"javafx.event.Event");
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"myDetectNonVoidReturnType", (String)JavaFXBundle.message("inspection.javafx.event.handler.create.options.panel", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            JavaFxEventHandlerInspection.$$$reportNull$$$0(8);
        }
        return optPane;
    }

    private static void collectFieldTypeFixes(@NotNull XmlAttribute attribute, @NotNull PsiClassType eventType, @NotNull List<LocalQuickFix> quickFixes) {
        XmlTag xmlTag;
        if (attribute == null) {
            JavaFxEventHandlerInspection.$$$reportNull$$$0(9);
        }
        if (eventType == null) {
            JavaFxEventHandlerInspection.$$$reportNull$$$0(10);
        }
        if (quickFixes == null) {
            JavaFxEventHandlerInspection.$$$reportNull$$$0(11);
        }
        if ((xmlTag = attribute.getParent()) == null) {
            return;
        }
        XmlAttribute idAttribute = xmlTag.getAttribute("fx:id");
        if (idAttribute == null) {
            return;
        }
        XmlAttributeValue idValue = idAttribute.getValueElement();
        if (idValue == null) {
            return;
        }
        PsiReference reference = idValue.getReference();
        if (reference == null) {
            return;
        }
        PsiElement element = reference.resolve();
        if (!(element instanceof PsiField)) {
            return;
        }
        PsiField tagField = (PsiField)element;
        if (tagField.hasModifierProperty("static") || !JavaFxPsiUtil.isVisibleInFxml((PsiMember)tagField)) {
            return;
        }
        PsiType tagFieldType = tagField.getType();
        if (!(tagFieldType instanceof PsiClassType)) {
            return;
        }
        PsiClassType rawFieldType = ((PsiClassType)tagFieldType).rawType();
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)eventType);
        PsiClass eventClass = resolveResult.getElement();
        if (eventClass == null) {
            return;
        }
        PsiSubstitutor eventSubstitutor = resolveResult.getSubstitutor();
        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)eventClass)) {
            PsiType eventTypeArgument = eventSubstitutor.substitute(typeParameter);
            PsiClassType rawEventArgument = eventTypeArgument instanceof PsiClassType ? ((PsiClassType)eventTypeArgument).rawType() : null;
            if (!rawFieldType.equals((Object)rawEventArgument)) continue;
            List fixes = HighlightFixUtil.getChangeVariableTypeFixes((PsiVariable)tagField, (PsiType)eventTypeArgument);
            for (IntentionAction action : fixes) {
                if (!(action instanceof LocalQuickFix)) continue;
                quickFixes.add((LocalQuickFix)action);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxEventHandlerInspection";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxEventHandlerInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventHandlerMethods";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getEventHandlerMethods";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasEventArgument";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectFieldTypeFixes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 6, 8 -> new IllegalStateException(string);
        };
    }

    private static final class ChangeParameterTypeQuickFix
    extends LocalQuickFixOnPsiElement {
        @IntentionName
        final String myText;

        ChangeParameterTypeQuickFix(@NotNull XmlAttribute attribute, @NotNull PsiMethod method, @NotNull PsiType suggestedParameterType) {
            if (attribute == null) {
                ChangeParameterTypeQuickFix.$$$reportNull$$$0(0);
            }
            if (method == null) {
                ChangeParameterTypeQuickFix.$$$reportNull$$$0(1);
            }
            if (suggestedParameterType == null) {
                ChangeParameterTypeQuickFix.$$$reportNull$$$0(2);
            }
            super((PsiElement)attribute);
            this.myText = JavaFXBundle.message("intention.name.change.parameter.type.to", JavaHighlightUtil.formatMethod((PsiMethod)method), suggestedParameterType.getPresentableText());
        }

        public boolean startInWriteAction() {
            return false;
        }

        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                ChangeParameterTypeQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaFXBundle.message("inspection.javafx.event.handler.change.parameter.type", new Object[0]);
            if (string == null) {
                ChangeParameterTypeQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                ChangeParameterTypeQuickFix.$$$reportNull$$$0(5);
            }
            if (file == null) {
                ChangeParameterTypeQuickFix.$$$reportNull$$$0(6);
            }
            if (startElement == null) {
                ChangeParameterTypeQuickFix.$$$reportNull$$$0(7);
            }
            if (endElement == null) {
                ChangeParameterTypeQuickFix.$$$reportNull$$$0(8);
            }
            return startElement instanceof XmlAttribute;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                ChangeParameterTypeQuickFix.$$$reportNull$$$0(9);
            }
            if (file == null) {
                ChangeParameterTypeQuickFix.$$$reportNull$$$0(10);
            }
            if (startElement == null) {
                ChangeParameterTypeQuickFix.$$$reportNull$$$0(11);
            }
            if (endElement == null) {
                ChangeParameterTypeQuickFix.$$$reportNull$$$0(12);
            }
            if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
                return;
            }
            if (!(startElement instanceof XmlAttribute)) {
                return;
            }
            XmlAttribute attribute = (XmlAttribute)startElement;
            List<PsiMethod> eventHandlerMethods = JavaFxEventHandlerInspection.getEventHandlerMethods(attribute);
            if (eventHandlerMethods.size() != 1) {
                return;
            }
            PsiMethod method = eventHandlerMethods.get(0);
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if (parameters.length != 1) {
                return;
            }
            String parameterName = parameters[0].getName();
            PsiClassType declaredType = JavaFxPsiUtil.getDeclaredEventType(attribute);
            if (declaredType == null) {
                return;
            }
            ParameterInfoImpl parameterInfo = ParameterInfoImpl.create((int)0).withName(parameterName).withType((PsiType)declaredType);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                ChangeSignatureProcessor processor = new ChangeSignatureProcessor(project, method, false, null, method.getName(), method.getReturnType(), new ParameterInfoImpl[]{parameterInfo});
                processor.run();
            } else {
                List<ParameterInfoImpl> parameterInfos = Collections.singletonList(parameterInfo);
                JavaChangeSignatureDialog dialog = JavaChangeSignatureDialog.createAndPreselectNew((Project)project, (PsiMethod)method, parameterInfos, (boolean)false, null);
                dialog.setParameterInfos(parameterInfos);
                dialog.show();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attribute";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suggestedParameterType";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxEventHandlerInspection$ChangeParameterTypeQuickFix";
                    break;
                }
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 7: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 8: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxEventHandlerInspection$ChangeParameterTypeQuickFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

